/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaTableTypeBuilder
implements TypeBuilder.TABLE {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private final Types types;
    private TypeSymbol rowType;
    private final List<TypeSymbol> keyTypes = new ArrayList<TypeSymbol>();
    private final List<String> fieldNames = new ArrayList<String>();

    public BallerinaTableTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
    }

    @Override
    public TypeBuilder.TABLE withRowType(TypeSymbol rowType) {
        if (rowType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.withRowType(((TypeReferenceTypeSymbol)rowType).typeDescriptor());
        }
        this.rowType = rowType;
        return this;
    }

    @Override
    public TypeBuilder.TABLE withKeyConstraints(TypeSymbol ... keyTypes) {
        this.keyTypes.clear();
        this.keyTypes.addAll(Arrays.asList(keyTypes));
        return this;
    }

    @Override
    public TypeBuilder.TABLE withKeySpecifiers(String ... fieldNames) {
        this.fieldNames.clear();
        this.fieldNames.addAll(Arrays.asList(fieldNames));
        return this;
    }

    @Override
    public TableTypeSymbol build() {
        BType rowBType = this.getRowBType(this.rowType, this.keyTypes.isEmpty() && this.fieldNames.isEmpty() || this.keyTypes.stream().allMatch(typeSymbol -> typeSymbol.typeKind() == TypeDescKind.NEVER));
        BTypeSymbol tableSymbol = Symbols.createTypeSymbol(12L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, this.symTable.rootPkgSymbol.origin);
        BTableType tableType = new BTableType(this.symTable.typeEnv(), rowBType, tableSymbol);
        tableSymbol.type = tableType;
        if (!this.keyTypes.isEmpty()) {
            tableType.keyTypeConstraint = this.getKeyConstraintBType(this.keyTypes, this.rowType);
        } else if (!this.fieldNames.isEmpty() && this.isValidFieldNameList(this.fieldNames, this.rowType)) {
            tableType.fieldNameList = new ArrayList<String>(this.fieldNames);
        }
        TableTypeSymbol tableTypeSymbol = (TableTypeSymbol)this.typesFactory.getTypeDescriptor(tableType);
        this.rowType = null;
        this.keyTypes.clear();
        this.fieldNames.clear();
        return tableTypeSymbol;
    }

    private boolean isValidFieldNameList(List<String> fieldNames, TypeSymbol rowType) {
        if (rowType instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)rowType;
            Map<String, RecordFieldSymbol> fieldDescriptors = recordTypeSymbol.fieldDescriptors();
            for (String fieldName : fieldNames) {
                if (!fieldDescriptors.containsKey(fieldName)) {
                    return false;
                }
                RecordFieldSymbol recordField = fieldDescriptors.get(fieldName);
                if (!recordField.isOptional() && this.isReadOnlyField(recordField)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isReadOnlyField(RecordFieldSymbol recordField) {
        TypeSymbol typeDescriptor = recordField.typeDescriptor();
        if (typeDescriptor instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeDescriptor;
            BType bType = abstractTypeSymbol.getBType();
            return Symbols.isFlagOn(bType.getFlags(), 32L);
        }
        return false;
    }

    private BType getKeyConstraintBType(List<TypeSymbol> keyTypes, TypeSymbol rowType) {
        if (keyTypes.size() == 1) {
            return this.checkKeyConstraintBType(keyTypes.get(0), rowType);
        }
        ArrayList<BTupleMember> tupleMembers = new ArrayList<BTupleMember>();
        for (TypeSymbol keyType : keyTypes) {
            BType constraintType = this.checkKeyConstraintBType(keyType, rowType);
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(constraintType);
            tupleMembers.add(new BTupleMember(constraintType, varSymbol));
        }
        return new BTupleType(this.symTable.typeEnv(), tupleMembers);
    }

    private BType checkKeyConstraintBType(TypeSymbol keyType, TypeSymbol rowType) {
        BType keyBType = this.getKeyBType(keyType);
        if (rowType.typeKind() == TypeDescKind.MAP) {
            TypeSymbol typeParam = ((MapTypeSymbol)rowType).typeParam();
            if (typeParam.subtypeOf(keyType)) {
                return keyBType;
            }
        } else if (rowType.typeKind() == TypeDescKind.RECORD) {
            Map<String, RecordFieldSymbol> recordFields = ((RecordTypeSymbol)rowType).fieldDescriptors();
            for (RecordFieldSymbol recordFieldSymbol : recordFields.values()) {
                if (recordFieldSymbol.isOptional() || !this.isValidKeyConstraintType(recordFieldSymbol.typeDescriptor(), keyType)) continue;
                return keyBType;
            }
        }
        throw new IllegalArgumentException("Invalid key type provided");
    }

    private boolean isValidKeyConstraintType(TypeSymbol fieldType, TypeSymbol keyType) {
        if ((fieldType.typeKind() == keyType.typeKind() || keyType.subtypeOf(fieldType)) && fieldType instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)fieldType;
            return Symbols.isFlagOn(abstractTypeSymbol.getBType().getFlags(), 32L);
        }
        return false;
    }

    private BType getKeyBType(TypeSymbol typeSymbol) {
        if (typeSymbol instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
            return abstractTypeSymbol.getBType();
        }
        throw new IllegalArgumentException("Invalid key type parameter provided");
    }

    private BType getRowBType(TypeSymbol rowType, boolean isKeyless) {
        if (rowType == null) {
            throw new IllegalArgumentException("Row type parameter can not be null");
        }
        BType rowBType = this.getBType(rowType);
        if (this.types.isAssignable(rowBType, this.symTable.mapType)) {
            BMapType rowMapType;
            BType mapTypeConstraint;
            if (rowBType instanceof BRecordType) {
                BRecordType bRecordType = (BRecordType)rowBType;
                if (isKeyless || this.isValidRowRecordType(bRecordType)) {
                    return rowBType;
                }
            } else if (rowBType instanceof BMapType && this.types.isAssignable(mapTypeConstraint = (rowMapType = (BMapType)rowBType).getConstraint(), this.symTable.pureType)) {
                return rowBType;
            }
        }
        throw new IllegalArgumentException("Invalid row type parameter provided");
    }

    private boolean isValidRowRecordType(BRecordType rowBType) {
        for (BField field : rowBType.getFields().values()) {
            if (!this.types.isAssignable(field.type, this.symTable.anydataType) || field.symbol == null || !Symbols.isFlagOn(field.symbol.flags, 32L) || Symbols.isFlagOn(field.symbol.flags, 4096L)) continue;
            return true;
        }
        return false;
    }

    private BType getBType(TypeSymbol typeSymbol) {
        if (typeSymbol != null) {
            if (typeSymbol instanceof AbstractTypeSymbol) {
                AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)typeSymbol;
                if (typeSymbol.subtypeOf(this.typesFactory.getTypeDescriptor(this.symTable.anyType))) {
                    return abstractTypeSymbol.getBType();
                }
            }
            throw new IllegalArgumentException("Invalid type parameter provided");
        }
        return null;
    }
}

