/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.api.impl.type.builders;

import io.ballerina.compiler.api.TypeBuilder;
import io.ballerina.compiler.api.impl.symbols.AbstractTypeSymbol;
import io.ballerina.compiler.api.impl.symbols.TypesFactory;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Names;

public class BallerinaTupleTypeBuilder
implements TypeBuilder.TUPLE {
    private final TypesFactory typesFactory;
    private final SymbolTable symTable;
    private final List<TypeSymbol> memberTypes = new ArrayList<TypeSymbol>();
    private TypeSymbol restType;

    public BallerinaTupleTypeBuilder(CompilerContext context) {
        this.typesFactory = TypesFactory.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
    }

    @Override
    public TypeBuilder.TUPLE withMemberType(TypeSymbol memberType) {
        this.memberTypes.add(memberType);
        return this;
    }

    @Override
    public TypeBuilder.TUPLE withRestType(TypeSymbol restType) {
        this.restType = restType;
        return this;
    }

    @Override
    public TupleTypeSymbol build() {
        ArrayList<BTupleMember> memberTypes = new ArrayList<BTupleMember>();
        for (TypeSymbol memberType : this.memberTypes) {
            BType type = this.getMemberType(memberType);
            BVarSymbol varSymbol = Symbols.createVarSymbolForTupleMember(type);
            memberTypes.add(new BTupleMember(type, varSymbol));
        }
        BTypeSymbol tupleSymbol = Symbols.createTypeSymbol(4227100L, 1L, Names.EMPTY, this.symTable.rootPkgSymbol.pkgID, null, this.symTable.rootPkgSymbol, this.symTable.builtinPos, SymbolOrigin.COMPILED_SOURCE);
        BTupleType tupleType = new BTupleType(this.symTable.typeEnv(), tupleSymbol, memberTypes);
        tupleSymbol.type = tupleType;
        BType restBType = this.getRestType(this.restType);
        if (restBType != null) {
            tupleType.restType = restBType;
        }
        TupleTypeSymbol tupleTypeSymbol = (TupleTypeSymbol)this.typesFactory.getTypeDescriptor(tupleType);
        this.memberTypes.clear();
        this.restType = null;
        return tupleTypeSymbol;
    }

    private BType getMemberType(TypeSymbol memberType) {
        if (memberType == null) {
            throw new IllegalArgumentException("Member type provided to the Tuple type descriptor can not be null.");
        }
        if (memberType instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)memberType;
            return abstractTypeSymbol.getBType();
        }
        return this.symTable.noType;
    }

    private BType getRestType(TypeSymbol restType) {
        BType bType;
        if (restType instanceof AbstractTypeSymbol) {
            AbstractTypeSymbol abstractTypeSymbol = (AbstractTypeSymbol)restType;
            bType = abstractTypeSymbol.getBType();
        } else {
            bType = null;
        }
        return bType;
    }
}

