/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class BalToolsManifest {
    private final Map<String, Map<String, Map<String, Tool>>> tools;

    private BalToolsManifest(Map<String, Map<String, Map<String, Tool>>> tools) {
        this.tools = tools;
    }

    public static BalToolsManifest from() {
        return new BalToolsManifest(new HashMap<String, Map<String, Map<String, Tool>>>());
    }

    public static BalToolsManifest from(Map<String, Map<String, Map<String, Tool>>> tools) {
        return new BalToolsManifest(tools);
    }

    public Map<String, Map<String, Map<String, Tool>>> tools() {
        return this.tools;
    }

    public void addTool(String id, String org, String name, String version, Boolean active, String repository) {
        if (!this.tools.containsKey(id)) {
            this.tools.put(id, new HashMap());
        }
        if (!this.tools.get(id).containsKey(version)) {
            this.tools.get(id).put(version, new HashMap());
        }
        if (active.booleanValue()) {
            this.flipCurrentActiveToolVersion(id);
        }
        this.tools.get(id).get(version).put(repository, new Tool(id, org, name, version, active, repository));
    }

    public Optional<Tool> getTool(String id, String version, String repository) {
        if (this.tools.containsKey(id) && this.tools.get(id).containsKey(version)) {
            return Optional.ofNullable(this.tools.get(id).get(version).get(repository));
        }
        return Optional.empty();
    }

    public Optional<Tool> getActiveTool(String id) {
        if (this.tools.containsKey(id)) {
            return this.tools.get(id).values().stream().flatMap(v -> v.values().stream()).filter(Tool::active).findFirst();
        }
        return Optional.empty();
    }

    public void setActiveToolVersion(String id, String version, String repository) {
        if (this.tools.containsKey(id)) {
            this.flipCurrentActiveToolVersion(id);
            this.tools.get(id).get(version).get(repository).setActive(true);
        }
    }

    public void removeTool(String id) {
        if (!this.tools.containsKey(id)) {
            return;
        }
        this.tools.remove(id);
    }

    public void removeToolVersion(String id, String version, String repository) {
        if (this.tools.containsKey(id) && this.tools.get(id).containsKey(version)) {
            this.tools.get(id).get(version).remove(repository);
        }
    }

    private void flipCurrentActiveToolVersion(String id) {
        this.tools.get(id).forEach((k, v) -> v.forEach((k1, v1) -> v1.setActive(false)));
    }

    public static class Tool {
        private final String id;
        private final String org;
        private final String name;
        private final String version;
        private Boolean active;
        private final String repository;

        public Tool(String id, String org, String name, String version, Boolean active, String repository) {
            this.id = id;
            this.org = org;
            this.name = name;
            this.version = version;
            this.active = active;
            this.repository = repository;
        }

        public String id() {
            return this.id;
        }

        public String org() {
            return this.org;
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public Boolean active() {
            return this.active;
        }

        public String repository() {
            return this.repository;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }
}

