/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Package;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.TomlDocumentContext;
import io.ballerina.toml.semantic.ast.TomlTableNode;

public class BallerinaToml {
    private final TomlDocumentContext ballerinaTomlContext;
    private final Package packageInstance;

    private BallerinaToml(Package aPackage, TomlDocumentContext ballerinaTomlContext) {
        this.packageInstance = aPackage;
        this.ballerinaTomlContext = ballerinaTomlContext;
    }

    public static BallerinaToml from(TomlDocumentContext ballerinaTomlContext, Package pkg) {
        return new BallerinaToml(pkg, ballerinaTomlContext);
    }

    TomlDocumentContext ballerinaTomlContext() {
        return this.ballerinaTomlContext;
    }

    public Package packageInstance() {
        return this.packageInstance;
    }

    public String name() {
        return "Ballerina.toml";
    }

    public TomlTableNode tomlAstNode() {
        return this.tomlDocument().toml().rootNode();
    }

    public TomlDocument tomlDocument() {
        return this.ballerinaTomlContext.tomlDocument();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private TomlDocument tomlDocument;
        private final Package oldPackage;

        private Modifier(BallerinaToml oldDocument) {
            this.tomlDocument = oldDocument.tomlDocument();
            this.oldPackage = oldDocument.packageInstance();
        }

        public Modifier withContent(String content) {
            this.tomlDocument = TomlDocument.from("Ballerina.toml", content);
            return this;
        }

        public BallerinaToml apply() {
            BallerinaToml ballerinaToml = BallerinaToml.from(TomlDocumentContext.from(this.tomlDocument), this.oldPackage);
            Package newPackage = this.oldPackage.modify().updateBallerinaToml(ballerinaToml).apply();
            return newPackage.ballerinaToml().get();
        }
    }
}

