/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.BuildToolId;
import io.ballerina.projects.DependencyManifest;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.buildtools.CodeGeneratorTool;
import io.ballerina.projects.buildtools.ToolContext;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.environment.ToolResolutionRequest;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.BuildToolUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.model.ToolResolutionCentralRequest;
import org.ballerinalang.central.client.model.ToolResolutionCentralResponse;
import org.wso2.ballerinalang.util.RepoUtils;

public class BuildToolResolution {
    private static final String PACKAGE_NAME_PREFIX = "tool_";
    private final PackageContext packageContext;
    private final List<BuildTool> resolvedTools = new ArrayList<BuildTool>();
    private final List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();

    private BuildToolResolution(PackageContext packageContext) {
        this.packageContext = packageContext;
        this.resolveToolDependencies();
    }

    static BuildToolResolution from(PackageContext packageContext) {
        return new BuildToolResolution(packageContext);
    }

    public List<Diagnostic> getDiagnosticList() {
        return this.diagnosticList;
    }

    public List<BuildTool> getResolvedTools() {
        return this.resolvedTools;
    }

    private void resolveToolDependencies() {
        Project currentProject = this.packageContext.project();
        Map<PackageManifest.Tool.Field, ToolContext> toolContextMap = currentProject.getToolContextMap();
        if (toolContextMap == null || toolContextMap.isEmpty()) {
            return;
        }
        ArrayList<BuildTool> buildTools = new ArrayList<BuildTool>();
        HashSet<String> toolIds = new HashSet<String>();
        for (ToolContext toolContext : toolContextMap.values()) {
            BuildToolId toolId = BuildToolId.from(toolContext.type().split("\\.")[0]);
            TomlNodeLocation location = BuildToolUtils.getFirstToolEntryLocation(toolId.value(), this.packageContext.packageManifest().tools());
            if (!toolIds.add(toolId.value())) continue;
            buildTools.add(BuildTool.from(toolId, null, null, null, location));
        }
        ClassLoader toolClassLoader = this.getClass().getClassLoader();
        ServiceLoader<CodeGeneratorTool> toolServiceLoader = ServiceLoader.load(CodeGeneratorTool.class, toolClassLoader);
        ArrayList<BuildTool> resolutionRequiredTools = new ArrayList<BuildTool>();
        for (BuildTool tool : buildTools) {
            Optional<CodeGeneratorTool> targetTool = BuildToolUtils.getTargetTool(tool.id().value(), toolServiceLoader);
            if (targetTool.isEmpty()) {
                resolutionRequiredTools.add(tool);
                continue;
            }
            tool.setVersion(PackageVersion.from("0.0.0"));
            tool.setOrg(PackageOrg.BALLERINA_ORG);
            tool.setName(PackageName.from(PACKAGE_NAME_PREFIX + String.valueOf(tool.id())));
            this.resolvedTools.add(tool);
        }
        if (resolutionRequiredTools.isEmpty()) {
            return;
        }
        PackageLockingMode packageLockingMode = this.getPackageLockingMode(currentProject);
        this.updateLockedToolDependencyVersions(resolutionRequiredTools, currentProject);
        try {
            this.resolvedTools.addAll(this.resolveToolVersions(packageLockingMode, currentProject.buildOptions().offlineBuild(), resolutionRequiredTools));
        }
        catch (CentralClientException e) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CENTRAL_CONNECTION_ERROR.diagnosticId(), "connection to central failed. Continuing the tool resolution offline, reason: '" + e.getMessage() + "'", DiagnosticSeverity.WARNING);
            PackageDiagnostic diagnostic = new PackageDiagnostic(diagnosticInfo, currentProject.currentPackage().descriptor().name().toString());
            this.diagnosticList.add(diagnostic);
            this.resolvedTools.addAll(this.getToolResolutionResponseOffline(resolutionRequiredTools, packageLockingMode));
        }
    }

    private List<BuildTool> resolveToolVersions(PackageLockingMode packageLockingMode, boolean offline, List<BuildTool> unresolvedTools) throws CentralClientException {
        if (offline) {
            return this.getToolResolutionResponseOffline(unresolvedTools, packageLockingMode);
        }
        Set<ToolResolutionRequest> resolutionRequests = this.getToolResolutionRequests(unresolvedTools, packageLockingMode);
        ToolResolutionCentralRequest toolResolutionRequest = this.createToolResolutionRequests(resolutionRequests);
        return this.getToolResolutionResponse(toolResolutionRequest);
    }

    private PackageLockingMode getPackageLockingMode(Project project) {
        boolean sticky = ProjectUtils.getSticky(project);
        if (project.currentPackage().dependenciesToml().isEmpty()) {
            if (sticky) {
                return PackageLockingMode.MEDIUM;
            }
            return PackageLockingMode.SOFT;
        }
        if (sticky) {
            return PackageLockingMode.HARD;
        }
        SemanticVersion prevDistributionVersion = project.currentPackage().dependencyManifest().distributionVersion();
        SemanticVersion currentDistributionVersion = SemanticVersion.from(RepoUtils.getBallerinaShortVersion());
        if (prevDistributionVersion == null || currentDistributionVersion.greaterThan(prevDistributionVersion)) {
            return PackageLockingMode.SOFT;
        }
        return PackageLockingMode.MEDIUM;
    }

    private List<BuildTool> getToolResolutionResponseOffline(List<BuildTool> unresolvedTools, PackageLockingMode packageLockingMode) {
        ArrayList<BuildTool> resolvedTools = new ArrayList<BuildTool>();
        for (BuildTool tool : unresolvedTools) {
            String id = tool.id().toString();
            PackageVersion version = tool.version();
            Optional<BalToolsManifest.Tool> latestCompatibleVersion = BuildToolUtils.getCompatibleToolVersionsAvailableLocally(tool, version, packageLockingMode);
            if (latestCompatibleVersion.isEmpty()) {
                String toolIdAndVersionOpt = id + (String)(version == null ? "" : ":" + tool.version().toString());
                TomlDiagnostic diagnostic = BuildToolUtils.getCannotResolveBuildToolDiagnostic(toolIdAndVersionOpt, tool.location());
                this.diagnosticList.add((Diagnostic)diagnostic);
                continue;
            }
            BalToolsManifest.Tool latestTool = latestCompatibleVersion.get();
            if (!BuildToolUtils.isToolAvailableLocally(latestTool.org(), latestTool.name(), latestTool.version(), "central.ballerina.io")) {
                String toolIdAndVersionOpt = id + ":" + version.toString();
                TomlDiagnostic diagnostic = BuildToolUtils.getCannotResolveBuildToolDiagnostic(toolIdAndVersionOpt, tool.location());
                this.diagnosticList.add((Diagnostic)diagnostic);
                continue;
            }
            resolvedTools.add(BuildTool.from(tool.id(), PackageOrg.from(latestTool.org()), PackageName.from(latestTool.name()), PackageVersion.from(latestTool.version()), tool.location()));
        }
        return resolvedTools;
    }

    private Set<ToolResolutionRequest> getToolResolutionRequests(List<BuildTool> unresolvedTools, PackageLockingMode packageLockingMode) {
        HashSet<ToolResolutionRequest> resolutionRequests = new HashSet<ToolResolutionRequest>();
        for (BuildTool tool : unresolvedTools) {
            resolutionRequests.add(ToolResolutionRequest.from(tool, packageLockingMode));
        }
        return resolutionRequests;
    }

    private ToolResolutionCentralRequest createToolResolutionRequests(Set<ToolResolutionRequest> resolutionRequests) {
        ToolResolutionCentralRequest toolResolutionRequest = new ToolResolutionCentralRequest();
        for (ToolResolutionRequest resolutionRequest : resolutionRequests) {
            ToolResolutionCentralRequest.Mode mode = switch (resolutionRequest.packageLockingMode()) {
                default -> throw new MatchException(null, null);
                case PackageLockingMode.HARD -> ToolResolutionCentralRequest.Mode.HARD;
                case PackageLockingMode.MEDIUM -> ToolResolutionCentralRequest.Mode.MEDIUM;
                case PackageLockingMode.SOFT -> ToolResolutionCentralRequest.Mode.SOFT;
            };
            String version = resolutionRequest.version().map(v -> v.value().toString()).orElse("");
            toolResolutionRequest.addTool(resolutionRequest.id().toString(), version, mode);
        }
        return toolResolutionRequest;
    }

    private List<BuildTool> getToolResolutionResponse(ToolResolutionCentralRequest toolResolutionRequest) throws CentralClientException {
        Settings settings = RepoUtils.readSettings();
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy(settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI(settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        ToolResolutionCentralResponse packageResolutionResponse = client.resolveToolDependencies(toolResolutionRequest, supportedPlatform, RepoUtils.getBallerinaVersion());
        List resolved = packageResolutionResponse.resolved();
        List unresolved = packageResolutionResponse.unresolved();
        for (ToolResolutionCentralResponse.UnresolvedTool tool : unresolved) {
            TomlNodeLocation location = BuildToolUtils.getFirstToolEntryLocation(tool.id(), this.packageContext.packageManifest().tools());
            TomlDiagnostic diagnostic = BuildToolUtils.getCannotResolveBuildToolDiagnostic(tool.id(), location);
            this.diagnosticList.add((Diagnostic)diagnostic);
        }
        ArrayList<BuildTool> resolvedTools = new ArrayList<BuildTool>();
        for (ToolResolutionCentralResponse.ResolvedTool tool : resolved) {
            TomlNodeLocation location = BuildToolUtils.getFirstToolEntryLocation(tool.id(), this.packageContext.packageManifest().tools());
            if (tool.version() == null || tool.name() == null || tool.org() == null) {
                TomlDiagnostic diagnostic = BuildToolUtils.getCannotResolveBuildToolDiagnostic(tool.id(), location);
                this.diagnosticList.add((Diagnostic)diagnostic);
                continue;
            }
            try {
                PackageVersion.from(tool.version());
            }
            catch (ProjectException ignore) {
                TomlDiagnostic diagnostic = BuildToolUtils.getCannotResolveBuildToolDiagnostic(tool.id(), location);
                this.diagnosticList.add((Diagnostic)diagnostic);
                continue;
            }
            BuildTool buildTool = BuildTool.from(BuildToolId.from(tool.id()), PackageOrg.from(tool.org()), PackageName.from(tool.name()), PackageVersion.from(tool.version()), location);
            resolvedTools.add(buildTool);
            BuildToolUtils.addToolToBalToolsToml(buildTool);
        }
        return resolvedTools;
    }

    private void updateLockedToolDependencyVersions(List<BuildTool> unresolvedTools, Project project) {
        DependencyManifest dependencyManifest = project.currentPackage().dependencyManifest();
        if (dependencyManifest == null || dependencyManifest.tools() == null) {
            return;
        }
        block0: for (BuildTool tool : unresolvedTools) {
            for (DependencyManifest.Tool toolDependency : dependencyManifest.tools()) {
                if (!toolDependency.id().equals(tool.id())) continue;
                tool.setOrg(toolDependency.org());
                tool.setName(toolDependency.name());
                tool.setVersion(toolDependency.version());
                continue block0;
            }
        }
    }
}

