/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.CodeActionResult;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionException;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CodeActionManager {
    private final Map<String, List<CodeActionDescriptor>> codeActionsMap = new HashMap<String, List<CodeActionDescriptor>>();

    private CodeActionManager(List<CompilerPluginContextIml> compilerPluginContexts) {
        compilerPluginContexts.forEach(compilerPluginContext -> compilerPluginContext.codeActions().forEach(codeAction -> codeAction.supportedDiagnosticCodes().forEach(diagnosticCode -> {
            List codeActions = this.codeActionsMap.computeIfAbsent((String)diagnosticCode, k -> new ArrayList());
            codeActions.add(new CodeActionDescriptor((CodeAction)codeAction, compilerPluginContext.compilerPluginInfo()));
        })));
    }

    public CodeActionResult codeActions(CodeActionContext context) {
        CodeActionResult result = new CodeActionResult();
        this.codeActionsMap.getOrDefault(context.diagnostic().diagnosticInfo().code(), Collections.emptyList()).forEach(codeActionDescriptor -> {
            String codeActionName = CodeActionManager.getModifiedCodeActionName(context.diagnostic().diagnosticInfo().code(), codeActionDescriptor.compilerPluginInfo(), codeActionDescriptor.codeAction().name());
            try {
                codeActionDescriptor.codeAction().codeActionInfo(context).stream().peek(codeActionInfo -> {
                    codeActionInfo.setProviderName(codeActionName);
                    codeActionInfo.setArguments(codeActionInfo.getArguments());
                }).forEach(result::addCodeAction);
            }
            catch (Throwable t) {
                CodeActionException ex = new CodeActionException(codeActionName, t);
                result.addError(ex);
            }
        });
        return result;
    }

    public List<DocumentEdit> executeCodeAction(String codeActionName, CodeActionExecutionContext context) {
        String[] parts = codeActionName.split("/");
        if (parts.length < 2) {
            return Collections.emptyList();
        }
        String diagnosticCode = parts[0];
        CompilerPluginKind compilerPluginKind = null;
        compilerPluginKind = parts.length >= 4 ? CompilerPluginKind.PACKAGE_PROVIDED : CompilerPluginKind.BUILT_IN;
        if (!this.codeActionsMap.containsKey(diagnosticCode)) {
            return Collections.emptyList();
        }
        CodeAction codeAction = null;
        for (CodeActionDescriptor descriptor : this.codeActionsMap.get(diagnosticCode)) {
            if (descriptor.compilerPluginInfo().kind() != compilerPluginKind || !codeActionName.equals(CodeActionManager.getModifiedCodeActionName(diagnosticCode, descriptor.compilerPluginInfo(), descriptor.codeAction().name()))) continue;
            codeAction = descriptor.codeAction();
            break;
        }
        if (codeAction == null) {
            return Collections.emptyList();
        }
        return codeAction.execute(context);
    }

    static CodeActionManager from(List<CompilerPluginContextIml> compilerPluginContexts) {
        return new CodeActionManager(compilerPluginContexts);
    }

    private static String getProviderPrefix(String diagnosticCode, CompilerPluginInfo compilerPluginInfo) {
        if (compilerPluginInfo.kind() == CompilerPluginKind.PACKAGE_PROVIDED) {
            PackageDescriptor descriptor = ((PackageProvidedCompilerPluginInfo)compilerPluginInfo).packageDesc();
            return String.format("%s/%s/%s", diagnosticCode, descriptor.org().value(), descriptor.name().value());
        }
        return diagnosticCode;
    }

    private static String getModifiedCodeActionName(String diagnosticCode, CompilerPluginInfo compilerPluginInfo, String codeActionName) {
        return CodeActionManager.getProviderPrefix(diagnosticCode, compilerPluginInfo) + "/" + codeActionName;
    }

    static class CodeActionDescriptor {
        private final CodeAction codeAction;
        private final CompilerPluginInfo compilerPluginInfo;

        public CodeActionDescriptor(CodeAction codeAction, CompilerPluginInfo compilerPluginInfo) {
            this.codeAction = codeAction;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        public CodeAction codeAction() {
            return this.codeAction;
        }

        public CompilerPluginInfo compilerPluginInfo() {
            return this.compilerPluginInfo;
        }
    }
}

