/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CodeModifierResult;
import io.ballerina.projects.CompilationOptions;
import io.ballerina.projects.CompilerPluginContextIml;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.CompilerPluginKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageProvidedCompilerPluginInfo;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SyntaxNodeAnalysisTask;
import io.ballerina.projects.SyntaxNodeAnalysisTaskRunner;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CodeModifier;
import io.ballerina.projects.plugins.CodeModifierContext;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class CodeModifierManager {
    private Package currentPackage;
    private PackageCompilation compilation;
    private final CodeModifierTasks codeModifierTasks;

    private CodeModifierManager(PackageCompilation compilation, CodeModifierTasks codeModifierTasks) {
        this.currentPackage = compilation.packageContext().project().currentPackage();
        this.compilation = compilation;
        this.codeModifierTasks = codeModifierTasks;
    }

    static CodeModifierManager from(PackageCompilation compilation, List<CompilerPluginContextIml> compilerPluginContexts) {
        CodeModifierTasks codeModifierTasks = CodeModifierManager.initCodeModifiers(compilerPluginContexts);
        return new CodeModifierManager(compilation, codeModifierTasks);
    }

    CodeModifierResult runCodeModifiers(Package currentPackage) {
        this.currentPackage = currentPackage;
        CodeModifyTaskResult codeModifyTaskResult = this.getCodeModifyTaskResult();
        return new CodeModifierResult(this.currentPackage, codeModifyTaskResult.reportedDiagnostics());
    }

    private static CodeModifierTasks initCodeModifiers(List<CompilerPluginContextIml> compilerPluginContexts) {
        CodeModifierTasks codeModifierTasks = new CodeModifierTasks();
        for (CompilerPluginContextIml compilerPluginContext : compilerPluginContexts) {
            for (CodeModifierInfo codeModifierInfo : compilerPluginContext.codeModifiers()) {
                CodeModifierContextImpl codeGeneratorContext = new CodeModifierContextImpl(codeModifierInfo, codeModifierTasks);
                codeModifierInfo.codeModifier().init(codeGeneratorContext);
            }
        }
        return codeModifierTasks;
    }

    private CodeModifyTaskResult getCodeModifyTaskResult() {
        Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> inBuiltSyntaxNodeAnalysisTaskMap = this.populateInBuiltSyntaxNodeTaskMap();
        List<Diagnostic> reportedDiagnostics = this.runSyntaxNodeAnalysisTasks(inBuiltSyntaxNodeAnalysisTaskMap);
        CodeModifierTaskResultBuilder resultBuilder = new CodeModifierTaskResultBuilder();
        resultBuilder.addDiagnostics(reportedDiagnostics);
        this.runSourceModifierTasks(resultBuilder);
        return resultBuilder.build();
    }

    private Map<PackageDescriptor, List<SourceModifierTask>> getSourceModifierTaskByPackage() {
        HashMap<PackageDescriptor, List<SourceModifierTask>> descriptorListMap = new HashMap<PackageDescriptor, List<SourceModifierTask>>();
        for (Map.Entry<CodeModifierInfo, List<SourceModifierTask>> codeModifierListEntry : this.codeModifierTasks.sourceModTaskMap.entrySet()) {
            for (SourceModifierTask sourceModifierTask : codeModifierListEntry.getValue()) {
                if (!sourceModifierTask.compilerPluginInfo.kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED)) continue;
                PackageProvidedCompilerPluginInfo compilerPluginInfo = (PackageProvidedCompilerPluginInfo)sourceModifierTask.compilerPluginInfo;
                if (!descriptorListMap.containsKey(compilerPluginInfo.packageDesc())) {
                    descriptorListMap.put(compilerPluginInfo.packageDesc(), new ArrayList());
                }
                ((List)descriptorListMap.get(compilerPluginInfo.packageDesc())).add(sourceModifierTask);
            }
        }
        return descriptorListMap;
    }

    private List<SourceModifierTask> getInBuiltSourceModifierTask() {
        ArrayList<SourceModifierTask> inBuiltSourceModifierTasks = new ArrayList<SourceModifierTask>();
        for (Map.Entry<CodeModifierInfo, List<SourceModifierTask>> codeModifierListEntry : this.codeModifierTasks.sourceModTaskMap.entrySet()) {
            for (SourceModifierTask sourceModifierTask : codeModifierListEntry.getValue()) {
                if (!sourceModifierTask.compilerPluginInfo.kind().equals((Object)CompilerPluginKind.BUILT_IN)) continue;
                inBuiltSourceModifierTasks.add(sourceModifierTask);
            }
        }
        return inBuiltSourceModifierTasks;
    }

    private void runSourceModifierTasks(CodeModifierTaskResultBuilder resultBuilder) {
        this.runSourceModifierTask(this.getInBuiltSourceModifierTask(), resultBuilder);
        Map<PackageDescriptor, List<SourceModifierTask>> sourceModifierTaskByPackage = this.getSourceModifierTaskByPackage();
        for (Map.Entry<PackageDescriptor, List<SourceModifierTask>> packageDescriptorListEntry : sourceModifierTaskByPackage.entrySet()) {
            Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> pkgSyntaxNodeAnalysisTaskMap = this.populatePkgSyntaxNodeTaskMap(packageDescriptorListEntry.getKey());
            List<Diagnostic> analysisTaskDiagnostics = this.runSyntaxNodeAnalysisTasks(pkgSyntaxNodeAnalysisTaskMap);
            resultBuilder.addDiagnostics(analysisTaskDiagnostics);
            this.runSourceModifierTask(packageDescriptorListEntry.getValue(), resultBuilder);
        }
    }

    private void runSourceModifierTask(List<SourceModifierTask> sourceModifierTasks, CodeModifierTaskResultBuilder resultBuilder) {
        for (SourceModifierTask sourceModifierTask : sourceModifierTasks) {
            SourceModifierContextImpl sourceModifyContext = new SourceModifierContextImpl(this.currentPackage, this.compilation);
            sourceModifierTask.perform(sourceModifyContext);
            resultBuilder.addDiagnostics(sourceModifyContext.reportedDiagnostics());
            resultBuilder.addSourceFiles(sourceModifyContext.modifiedSourceFiles());
            resultBuilder.addTestSourceFiles(sourceModifyContext.modifiedTestSourceFiles());
            CodeModifyTaskResult codeModifyTaskResult = resultBuilder.build();
            if (!codeModifyTaskResult.containsSourceFile() && !codeModifyTaskResult.containsTestSourceFile()) continue;
            this.currentPackage = new PackageModifier().modifyPackage(this.currentPackage, codeModifyTaskResult);
            CompilationOptions compOptions = CompilationOptions.builder().withCodeModifiers(true).build();
            this.compilation = this.currentPackage.getCompilation(compOptions);
        }
    }

    private List<Diagnostic> runSyntaxNodeAnalysisTasks(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap) {
        ArrayList<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>();
        if (syntaxNodeAnalysisTaskMap.isEmpty()) {
            return reportedDiagnostics;
        }
        SyntaxNodeAnalysisTaskRunner taskRunner = new SyntaxNodeAnalysisTaskRunner(syntaxNodeAnalysisTaskMap, this.currentPackage, this.compilation);
        reportedDiagnostics.addAll(taskRunner.runTasks());
        return reportedDiagnostics;
    }

    private Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> populatePkgSyntaxNodeTaskMap(PackageDescriptor packageDesc) {
        HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>>();
        for (List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks : this.codeModifierTasks.syntaxNodeAnalysisTaskMap.values()) {
            for (SyntaxNodeAnalysisTask syntaxNodeTask : syntaxNodeAnalysisTasks) {
                PackageProvidedCompilerPluginInfo compilerPluginInfo;
                if (!syntaxNodeTask.getCompilerPluginInfo().kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED) || !(compilerPluginInfo = (PackageProvidedCompilerPluginInfo)syntaxNodeTask.getCompilerPluginInfo()).packageDesc().equals(packageDesc)) continue;
                this.populateSyntaxNodeTaskMap(syntaxNodeAnalysisTaskMap, syntaxNodeTask);
            }
        }
        return syntaxNodeAnalysisTaskMap;
    }

    private Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> populateInBuiltSyntaxNodeTaskMap() {
        HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<SyntaxKind, List<SyntaxNodeAnalysisTask>>();
        for (List<SyntaxNodeAnalysisTask> syntaxNodeAnalysisTasks : this.codeModifierTasks.syntaxNodeAnalysisTaskMap.values()) {
            for (SyntaxNodeAnalysisTask syntaxNodeTask : syntaxNodeAnalysisTasks) {
                if (!syntaxNodeTask.getCompilerPluginInfo().kind().equals((Object)CompilerPluginKind.BUILT_IN)) continue;
                this.populateSyntaxNodeTaskMap(syntaxNodeAnalysisTaskMap, syntaxNodeTask);
            }
        }
        return syntaxNodeAnalysisTaskMap;
    }

    private void populateSyntaxNodeTaskMap(Map<SyntaxKind, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap, SyntaxNodeAnalysisTask syntaxNodeAnalysisTask) {
        for (SyntaxKind syntaxKind : syntaxNodeAnalysisTask.syntaxKinds()) {
            List syntaxNodeAnalysisTasks = syntaxNodeAnalysisTaskMap.computeIfAbsent(syntaxKind, syntaxKind1 -> new ArrayList());
            syntaxNodeAnalysisTasks.add(syntaxNodeAnalysisTask);
        }
    }

    private static class CodeModifierTasks {
        private final Map<CodeModifierInfo, List<SourceModifierTask>> sourceModTaskMap = new HashMap<CodeModifierInfo, List<SourceModifierTask>>();
        private final Map<CodeModifierInfo, List<SyntaxNodeAnalysisTask>> syntaxNodeAnalysisTaskMap = new HashMap<CodeModifierInfo, List<SyntaxNodeAnalysisTask>>();

        private CodeModifierTasks() {
        }

        void addSourceModifierTask(CodeModifierInfo codeModifierInfo, SourceModifierTask modifierTask) {
            this.addTask(codeModifierInfo, this.sourceModTaskMap, modifierTask);
        }

        void addSyntaxNodeAnalysisTask(CodeModifierInfo codeModifierInfo, SyntaxNodeAnalysisTask analysisTask) {
            this.addTask(codeModifierInfo, this.syntaxNodeAnalysisTaskMap, analysisTask);
        }

        <T> void addTask(CodeModifierInfo codeModifierInfo, Map<CodeModifierInfo, List<T>> map, T task) {
            List tasks = map.computeIfAbsent(codeModifierInfo, key -> new ArrayList());
            tasks.add(task);
        }
    }

    private static class CodeModifyTaskResult {
        private final List<Diagnostic> reportedDiagnostics;
        private final Map<DocumentId, ModifiedSourceFile> sourceFilesMap;
        private final Map<DocumentId, ModifiedTestSourceFile> testSourceFilesMap;

        public CodeModifyTaskResult(List<Diagnostic> reportedDiagnostics, Map<DocumentId, ModifiedSourceFile> sourceFilesMap, Map<DocumentId, ModifiedTestSourceFile> testSourceFilesMap) {
            this.reportedDiagnostics = reportedDiagnostics;
            this.sourceFilesMap = sourceFilesMap;
            this.testSourceFilesMap = testSourceFilesMap;
        }

        Collection<Diagnostic> reportedDiagnostics() {
            return this.reportedDiagnostics;
        }

        ModifiedSourceFile sourceFile(DocumentId documentId) {
            return this.sourceFilesMap.get(documentId);
        }

        Collection<DocumentId> documentIds() {
            return this.sourceFilesMap.keySet();
        }

        boolean containsSourceFile() {
            return !this.sourceFilesMap.isEmpty();
        }

        ModifiedTestSourceFile testSourceFile(DocumentId documentId) {
            return this.testSourceFilesMap.get(documentId);
        }

        Collection<DocumentId> testDocumentIds() {
            return this.testSourceFilesMap.keySet();
        }

        boolean containsTestSourceFile() {
            return !this.testSourceFilesMap.isEmpty();
        }
    }

    static class CodeModifierInfo {
        private final CodeModifier codeModifier;
        private final CompilerPluginInfo compilerPluginInfo;

        CodeModifierInfo(CodeModifier codeModifier, CompilerPluginInfo compilerPluginInfo) {
            this.codeModifier = codeModifier;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        CodeModifier codeModifier() {
            return this.codeModifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CodeModifierInfo that = (CodeModifierInfo)o;
            return Objects.equals(this.codeModifier, that.codeModifier) && Objects.equals(this.compilerPluginInfo, that.compilerPluginInfo);
        }

        public int hashCode() {
            return Objects.hash(this.codeModifier, this.compilerPluginInfo);
        }
    }

    private static class CodeModifierContextImpl
    implements CodeModifierContext {
        private final CodeModifierTasks codeModifierTasks;
        private final CodeModifierInfo codeModifierInfo;

        CodeModifierContextImpl(CodeModifierInfo codeModifierInfo, CodeModifierTasks codeModifierTasks) {
            this.codeModifierInfo = codeModifierInfo;
            this.codeModifierTasks = codeModifierTasks;
        }

        @Override
        public void addSourceModifierTask(ModifierTask<SourceModifierContext> modifierTask) {
            this.codeModifierTasks.addSourceModifierTask(this.codeModifierInfo, new SourceModifierTask(modifierTask, this.codeModifierInfo.compilerPluginInfo));
        }

        @Override
        public void addSyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, SyntaxKind syntaxKind) {
            this.addSyntaxNodeAnalysisTask(analysisTask, Collections.singletonList(syntaxKind));
        }

        @Override
        public void addSyntaxNodeAnalysisTask(AnalysisTask<SyntaxNodeAnalysisContext> analysisTask, Collection<SyntaxKind> syntaxKinds) {
            this.codeModifierTasks.addSyntaxNodeAnalysisTask(this.codeModifierInfo, new SyntaxNodeAnalysisTask(analysisTask, syntaxKinds, this.codeModifierInfo.compilerPluginInfo));
        }
    }

    private static class CodeModifierTaskResultBuilder {
        private final List<Diagnostic> reportedDiagnostics = new ArrayList<Diagnostic>();
        private final List<ModifiedSourceFile> modifiedSourceFiles = new ArrayList<ModifiedSourceFile>();
        private final List<ModifiedTestSourceFile> modifiedTestSourceFiles = new ArrayList<ModifiedTestSourceFile>();

        CodeModifierTaskResultBuilder() {
        }

        CodeModifierTaskResultBuilder addDiagnostics(Collection<Diagnostic> diagnostics) {
            this.reportedDiagnostics.addAll(diagnostics);
            return this;
        }

        CodeModifierTaskResultBuilder addSourceFiles(Collection<ModifiedSourceFile> sourceFiles) {
            this.modifiedSourceFiles.addAll(sourceFiles);
            return this;
        }

        CodeModifierTaskResultBuilder addTestSourceFiles(Collection<ModifiedTestSourceFile> testSourceFiles) {
            this.modifiedTestSourceFiles.addAll(testSourceFiles);
            return this;
        }

        CodeModifyTaskResult build() {
            HashMap<DocumentId, ModifiedSourceFile> sourceFilesMap = new HashMap<DocumentId, ModifiedSourceFile>();
            HashMap<DocumentId, ModifiedTestSourceFile> testSourceFilesMap = new HashMap<DocumentId, ModifiedTestSourceFile>();
            for (ModifiedSourceFile sourceFile : this.modifiedSourceFiles) {
                sourceFilesMap.put(sourceFile.documentId(), sourceFile);
            }
            for (ModifiedTestSourceFile testSourceFile : this.modifiedTestSourceFiles) {
                testSourceFilesMap.put(testSourceFile.testDocumentId(), testSourceFile);
            }
            return new CodeModifyTaskResult(this.reportedDiagnostics, sourceFilesMap, testSourceFilesMap);
        }
    }

    private static class SourceModifierTask {
        private final ModifierTask<SourceModifierContext> modifierTask;
        private final CompilerPluginInfo compilerPluginInfo;

        public SourceModifierTask(ModifierTask<SourceModifierContext> modifierTask, CompilerPluginInfo compilerPluginInfo) {
            this.modifierTask = modifierTask;
            this.compilerPluginInfo = compilerPluginInfo;
        }

        void perform(SourceModifierContext sourceModifierContext) {
            try {
                this.modifierTask.modify(sourceModifierContext);
            }
            catch (Throwable e) {
                String message;
                if (this.compilerPluginInfo.kind().equals((Object)CompilerPluginKind.PACKAGE_PROVIDED)) {
                    PackageProvidedCompilerPluginInfo pkgProvidedCompilerPluginInfo = (PackageProvidedCompilerPluginInfo)this.compilerPluginInfo;
                    PackageDescriptor pkgDesc = pkgProvidedCompilerPluginInfo.packageDesc();
                    message = "The compiler extension in package '" + String.valueOf(pkgDesc.org()) + ":" + String.valueOf(pkgDesc.name()) + ":" + String.valueOf(pkgDesc.version()) + "' failed to complete. ";
                } else {
                    message = "The compiler extension '" + this.compilerPluginInfo.compilerPlugin().getClass().getName() + "' failed to complete. ";
                }
                throw new ProjectException(message + e.getMessage(), e);
            }
        }
    }

    private static class SourceModifierContextImpl
    implements SourceModifierContext {
        private final Package currentPackage;
        private final PackageCompilation compilation;
        private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        private final List<ModifiedSourceFile> sourceFiles = new ArrayList<ModifiedSourceFile>();
        private final List<ModifiedTestSourceFile> testSourceFiles = new ArrayList<ModifiedTestSourceFile>();

        public SourceModifierContextImpl(Package currentPackage, PackageCompilation compilation) {
            this.currentPackage = currentPackage;
            this.compilation = compilation;
        }

        @Override
        public Package currentPackage() {
            return this.currentPackage;
        }

        @Override
        public PackageCompilation compilation() {
            return this.compilation;
        }

        @Override
        public void modifySourceFile(TextDocument textDocument, DocumentId documentId) {
            for (ModuleId moduleId : this.currentPackage().moduleIds()) {
                Module module = this.currentPackage.module(moduleId);
                if (!module.documentIds().contains(documentId)) continue;
                this.sourceFiles.add(new ModifiedSourceFile(textDocument, documentId));
                return;
            }
            throw new IllegalArgumentException("There is no such document in the current package with the given identifier: " + String.valueOf(documentId));
        }

        @Override
        public void modifyTestSourceFile(TextDocument textDocument, DocumentId testDocumentId) {
            for (ModuleId moduleId : this.currentPackage().moduleIds()) {
                Module module = this.currentPackage.module(moduleId);
                if (!module.testDocumentIds().contains(testDocumentId)) continue;
                this.testSourceFiles.add(new ModifiedTestSourceFile(textDocument, testDocumentId));
                return;
            }
            throw new IllegalArgumentException("There is no such test document in the current package with the given identifier: " + String.valueOf(testDocumentId));
        }

        @Override
        public void reportDiagnostic(Diagnostic diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        Collection<Diagnostic> reportedDiagnostics() {
            return this.diagnostics;
        }

        Collection<ModifiedSourceFile> modifiedSourceFiles() {
            return this.sourceFiles;
        }

        Collection<ModifiedTestSourceFile> modifiedTestSourceFiles() {
            return this.testSourceFiles;
        }
    }

    private static class PackageModifier {
        private PackageModifier() {
        }

        Package modifyPackage(Package currentPackage, CodeModifyTaskResult codeModifyTaskResult) {
            Package newPackage = currentPackage;
            ArrayList<ModuleId> moduleIds = new ArrayList<ModuleId>();
            for (DocumentId documentId : codeModifyTaskResult.documentIds()) {
                if (moduleIds.contains(documentId.moduleId())) continue;
                moduleIds.add(documentId.moduleId());
            }
            for (DocumentId testDocumentId : codeModifyTaskResult.testDocumentIds()) {
                if (moduleIds.contains(testDocumentId.moduleId())) continue;
                moduleIds.add(testDocumentId.moduleId());
            }
            for (ModuleId moduleId : moduleIds) {
                newPackage = this.modifyModule(moduleId, newPackage, codeModifyTaskResult);
            }
            return newPackage;
        }

        private Package modifyModule(ModuleId moduleId, Package pkg, CodeModifyTaskResult codeModifyTaskResult) {
            Document document;
            Module module = pkg.module(moduleId);
            Module.Modifier modifier = module.modify();
            for (DocumentId documentId : module.documentIds()) {
                ModifiedSourceFile modifiedSourceFile = codeModifyTaskResult.sourceFile(documentId);
                if (modifiedSourceFile == null) continue;
                document = module.document(documentId);
                this.updateModifiedDocument(document.name(), modifiedSourceFile.textDocument(), modifier, documentId);
            }
            for (DocumentId testDocumentId : module.testDocumentIds()) {
                ModifiedTestSourceFile modifiedTestSourceFile = codeModifyTaskResult.testSourceFile(testDocumentId);
                if (modifiedTestSourceFile == null) continue;
                document = module.document(testDocumentId);
                this.updateModifiedDocument(document.name(), modifiedTestSourceFile.textDocument(), modifier, testDocumentId);
            }
            return modifier.apply().packageInstance();
        }

        private void updateModifiedDocument(String newDocFilename, TextDocument textDocument, Module.Modifier modifier, DocumentId documentId) {
            DocumentConfig documentConfig = DocumentConfig.from(documentId, textDocument.toString(), newDocFilename);
            DocumentContext documentContext = DocumentContext.from(documentConfig, false);
            modifier.updateDocument(documentContext);
        }
    }

    private static class ModifiedTestSourceFile {
        private final TextDocument textDocument;
        private final DocumentId testDocumentId;

        public ModifiedTestSourceFile(TextDocument textDocument, DocumentId testDocumentId) {
            this.textDocument = textDocument;
            this.testDocumentId = testDocumentId;
        }

        public TextDocument textDocument() {
            return this.textDocument;
        }

        public DocumentId testDocumentId() {
            return this.testDocumentId;
        }
    }

    private static class ModifiedSourceFile {
        private final TextDocument textDocument;
        private final DocumentId documentId;

        public ModifiedSourceFile(TextDocument textDocument, DocumentId documentId) {
            this.textDocument = textDocument;
            this.documentId = documentId;
        }

        public TextDocument textDocument() {
            return this.textDocument;
        }

        public DocumentId documentId() {
            return this.documentId;
        }
    }
}

