/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.projects.CodeAnalyzerManager;
import io.ballerina.projects.CodeGeneratorManager;
import io.ballerina.projects.CodeModifierManager;
import io.ballerina.projects.CompilerLifecycleManager;
import io.ballerina.projects.CompilerPluginInfo;
import io.ballerina.projects.plugins.CodeAnalyzer;
import io.ballerina.projects.plugins.CodeGenerator;
import io.ballerina.projects.plugins.CodeModifier;
import io.ballerina.projects.plugins.CompilerLifecycleListener;
import io.ballerina.projects.plugins.CompilerPluginContext;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.completion.CompletionProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CompilerPluginContextIml
implements CompilerPluginContext {
    private final CompilerPluginInfo compilerPluginInfo;
    private final List<CodeAnalyzerManager.CodeAnalyzerInfo> codeAnalyzers = new ArrayList<CodeAnalyzerManager.CodeAnalyzerInfo>();
    private final List<CodeGeneratorManager.CodeGeneratorInfo> codeGenerators = new ArrayList<CodeGeneratorManager.CodeGeneratorInfo>();
    private final List<CodeModifierManager.CodeModifierInfo> codeModifiers = new ArrayList<CodeModifierManager.CodeModifierInfo>();
    private final List<CompilerLifecycleManager.LifecycleListenerInfo> lifecycleListeners = new ArrayList<CompilerLifecycleManager.LifecycleListenerInfo>();
    private final List<CodeAction> codeActions = new ArrayList<CodeAction>();
    private Map<String, Object> compilerPluginUserData = new HashMap<String, Object>();
    private final List<CompletionProvider<? extends Node>> completionProviders = new ArrayList<CompletionProvider<? extends Node>>();

    CompilerPluginContextIml(CompilerPluginInfo compilerPluginInfo) {
        this.compilerPluginInfo = compilerPluginInfo;
    }

    CompilerPluginContextIml(CompilerPluginInfo compilerPluginInfo, Map<String, Object> userData) {
        this.compilerPluginInfo = compilerPluginInfo;
        this.compilerPluginUserData = userData;
    }

    @Override
    public void addCodeAnalyzer(CodeAnalyzer codeAnalyzer) {
        this.codeAnalyzers.add(new CodeAnalyzerManager.CodeAnalyzerInfo(codeAnalyzer, this.compilerPluginInfo));
    }

    @Override
    public void addCodeGenerator(CodeGenerator codeGenerator) {
        this.codeGenerators.add(new CodeGeneratorManager.CodeGeneratorInfo(codeGenerator, this.compilerPluginInfo));
    }

    @Override
    public void addCodeModifier(CodeModifier codeModifier) {
        this.codeModifiers.add(new CodeModifierManager.CodeModifierInfo(codeModifier, this.compilerPluginInfo));
    }

    @Override
    public void addCompilerLifecycleListener(CompilerLifecycleListener lifecycleListener) {
        this.lifecycleListeners.add(new CompilerLifecycleManager.LifecycleListenerInfo(lifecycleListener, this.compilerPluginInfo));
    }

    @Override
    public void addCodeAction(CodeAction codeAction) {
        this.codeActions.add(codeAction);
    }

    @Override
    public void addCompletionProvider(CompletionProvider<? extends Node> completionProvider) {
        this.completionProviders.add(completionProvider);
    }

    List<CodeAnalyzerManager.CodeAnalyzerInfo> codeAnalyzers() {
        return this.codeAnalyzers;
    }

    List<CodeGeneratorManager.CodeGeneratorInfo> codeGenerators() {
        return this.codeGenerators;
    }

    List<CodeModifierManager.CodeModifierInfo> codeModifiers() {
        return this.codeModifiers;
    }

    public List<CompilerLifecycleManager.LifecycleListenerInfo> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public List<CodeAction> codeActions() {
        return this.codeActions;
    }

    public List<CompletionProvider<? extends Node>> completionProviders() {
        return this.completionProviders;
    }

    public CompilerPluginInfo compilerPluginInfo() {
        return this.compilerPluginInfo;
    }

    @Override
    public Map<String, Object> userData() {
        return this.compilerPluginUserData;
    }
}

