/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.configurations.ConfigModuleDetails;
import io.ballerina.projects.configurations.ConfigVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public final class ConfigReader {
    private ConfigReader() {
    }

    public static Map<ConfigModuleDetails, List<ConfigVariable>> getConfigVariables(Package packageInstance) {
        HashMap<ConfigModuleDetails, List<ConfigVariable>> configDetails = new HashMap<ConfigModuleDetails, List<ConfigVariable>>();
        Set<BVarSymbol> validConfigs = ConfigReader.getValidConfigs(packageInstance.getDefaultModule().moduleContext().bLangPackage().symbol);
        for (Module module : packageInstance.modules()) {
            ConfigReader.getConfigs(module, module.moduleContext().bLangPackage(), configDetails, validConfigs);
        }
        ArrayList<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
        ConfigReader.getValidDependencies(packageInstance, packageInstance.getDefaultModule(), dependencies);
        ConfigReader.getImportedConfigVars(packageInstance, dependencies, configDetails);
        return configDetails;
    }

    private static void getImportedConfigVars(Package currentPackage, Collection<ModuleDependency> moduleDependencies, Map<ConfigModuleDetails, List<ConfigVariable>> configDetails) {
        currentPackage.modules().forEach(module -> module.moduleContext().bLangPackage().symbol.imports.stream().filter(importSymbol -> ConfigReader.isDirectDependency(moduleDependencies, importSymbol.descriptor.org().value(), importSymbol.descriptor.packageName().value(), importSymbol.descriptor.name().moduleNamePart())).forEach(importSymbol -> {
            String orgName = importSymbol.descriptor.org().value();
            String packageName = importSymbol.descriptor.packageName().value();
            String moduleName = importSymbol.descriptor.name().moduleNamePart();
            if (moduleName == null) {
                moduleName = packageName;
            }
            ArrayList<ConfigVariable> configVariables = new ArrayList<ConfigVariable>();
            ConfigReader.getConfigVars(module, importSymbol.scope.entries.values(), null, configVariables);
            if (!configVariables.isEmpty()) {
                configDetails.put(new ConfigModuleDetails(orgName, packageName, moduleName, ProjectKind.BALA_PROJECT), configVariables);
            }
        }));
    }

    private static boolean isDirectDependency(Collection<ModuleDependency> moduleDependencies, String orgName, String packageName, String moduleName) {
        return moduleDependencies.stream().anyMatch(dependency -> dependency.descriptor().org().value().equals(orgName) && dependency.descriptor().packageName().value().equals(packageName) && (moduleName == null ? dependency.descriptor().name().moduleNamePart() == null : moduleName.equals(dependency.descriptor().name().moduleNamePart())));
    }

    private static String getDescriptionValue(MetadataNode metadataNode) {
        for (AnnotationNode annotation : metadataNode.annotations()) {
            Node annotReference = annotation.annotReference();
            if (annotReference.kind() != SyntaxKind.SIMPLE_NAME_REFERENCE || !((SimpleNameReferenceNode)annotReference).name().text().equals("display") || !annotation.annotValue().isPresent()) continue;
            for (MappingFieldNode fieldNode : ((MappingConstructorExpressionNode)annotation.annotValue().get()).fields()) {
                ExpressionNode valueNode;
                SpecificFieldNode specificField;
                if (fieldNode.kind() != SyntaxKind.SPECIFIC_FIELD || (specificField = (SpecificFieldNode)fieldNode).fieldName().kind() != SyntaxKind.IDENTIFIER_TOKEN || !((IdentifierToken)specificField.fieldName()).text().equals("description") || !specificField.valueExpr().isPresent() || !((valueNode = (ExpressionNode)specificField.valueExpr().get()) instanceof BasicLiteralNode)) continue;
                return ((BasicLiteralNode)valueNode).literalToken().text();
            }
        }
        return "";
    }

    private static void getConfigs(Module module, BLangPackage bLangPackage, Map<ConfigModuleDetails, List<ConfigVariable>> configDetails, Set<BVarSymbol> validConfigs) {
        ArrayList<ConfigVariable> configVariables = new ArrayList<ConfigVariable>();
        PackageID currentPkgId = bLangPackage.symbol.pkgID;
        ConfigReader.getConfigVars(module, bLangPackage.symbol.scope.entries.values(), validConfigs, configVariables);
        if (!configVariables.isEmpty()) {
            configDetails.put(ConfigReader.getConfigModuleDetails(module.moduleName(), currentPkgId, module.project().kind()), configVariables);
        }
    }

    private static void getConfigVars(Module module, Collection<Scope.ScopeEntry> scopeEntries, Set<BVarSymbol> validConfigs, List<ConfigVariable> configVariables) {
        for (Scope.ScopeEntry entry : scopeEntries) {
            BSymbol symbol = entry.symbol;
            if (symbol == null || symbol.tag != 52L || !Symbols.isFlagOn(symbol.flags, 0x80000000L) || !(symbol instanceof BVarSymbol)) continue;
            BVarSymbol varSymbol = (BVarSymbol)symbol;
            if ((validConfigs == null || !validConfigs.contains(varSymbol)) && validConfigs != null) continue;
            String description = ConfigReader.getDescriptionValue(varSymbol, module);
            configVariables.add(new ConfigVariable(varSymbol.name.value.replace("\\", ""), varSymbol.type, Symbols.isFlagOn(varSymbol.flags, 256L), description));
        }
    }

    private static Set<BVarSymbol> getValidConfigs(BPackageSymbol packageSymbol) {
        HashSet<BVarSymbol> configVars = new HashSet<BVarSymbol>();
        ConfigReader.populateConfigVars(packageSymbol, configVars);
        if (!packageSymbol.imports.isEmpty()) {
            for (BPackageSymbol importSymbol : packageSymbol.imports) {
                configVars.addAll(ConfigReader.getValidConfigs(importSymbol));
            }
        }
        return configVars;
    }

    private static void populateConfigVars(BPackageSymbol pkgSymbol, Set<BVarSymbol> configVars) {
        for (Scope.ScopeEntry entry : pkgSymbol.scope.entries.values()) {
            BSymbol symbol = entry.symbol;
            if (symbol == null) continue;
            if (symbol.tag == 32796L) {
                symbol = symbol.type.tsymbol;
            }
            if (symbol == null || symbol.tag != 52L || !Symbols.isFlagOn(symbol.flags, 0x80000000L) || !(symbol instanceof BVarSymbol)) continue;
            BVarSymbol bVarSymbol = (BVarSymbol)symbol;
            configVars.add(bVarSymbol);
        }
    }

    private static ConfigModuleDetails getConfigModuleDetails(ModuleName moduleName, PackageID packageID, ProjectKind projectKind) {
        String orgName = packageID.getOrgName().getValue();
        String packageName = packageID.getPkgName().getValue();
        String moduleNameVal = moduleName.isDefaultModuleName() ? moduleName.toString() : moduleName.moduleNamePart();
        return new ConfigModuleDetails(orgName, packageName, moduleNameVal, projectKind);
    }

    private static String getDescriptionValue(BVarSymbol symbol, Module module) {
        Optional optionalMetadataNode;
        Map<Document, SyntaxTree> syntaxTreeMap = ConfigReader.getSyntaxTreeMap(module);
        Node variableNode = ConfigReader.getVariableNode(symbol.getPosition().lineRange().startLine().line(), syntaxTreeMap);
        if (variableNode != null && (optionalMetadataNode = ((ModuleVariableDeclarationNode)variableNode).metadata()).isPresent()) {
            String description = ConfigReader.getDescriptionValue((MetadataNode)optionalMetadataNode.get());
            if (description.startsWith("\"") && description.endsWith("\"")) {
                description = description.substring(1, description.length() - 1);
            }
            return description;
        }
        return "";
    }

    private static Node getVariableNode(int position, Map<Document, SyntaxTree> syntaxTreeMap) {
        for (Map.Entry<Document, SyntaxTree> syntaxTreeEntry : syntaxTreeMap.entrySet()) {
            if (!syntaxTreeEntry.getValue().containsModulePart()) continue;
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTreeMap.get(syntaxTreeEntry.getKey()).rootNode();
            return modulePartNode.members().stream().filter(node -> node.kind() == SyntaxKind.MODULE_VAR_DECL && node instanceof ModuleVariableDeclarationNode && node.location().lineRange().startLine().line() <= position && node.location().lineRange().endLine().line() >= position).findFirst().orElse(null);
        }
        return null;
    }

    private static Map<Document, SyntaxTree> getSyntaxTreeMap(Module module) {
        HashMap<Document, SyntaxTree> syntaxTreeMap = new HashMap<Document, SyntaxTree>();
        module.documentIds().forEach(documentId -> {
            Document document = module.document((DocumentId)documentId);
            syntaxTreeMap.put(document, document.syntaxTree());
        });
        return syntaxTreeMap;
    }

    private static void getValidDependencies(Package packageInstance, Module module, Collection<ModuleDependency> dependencies) {
        Collection<ModuleDependency> directDependencies = module.moduleContext().dependencies();
        for (ModuleDependency moduleDependency : directDependencies) {
            if (!ConfigReader.isDefaultScope(moduleDependency)) continue;
            dependencies.add(moduleDependency);
            if (!ConfigReader.isSamePackage(packageInstance, moduleDependency)) continue;
            for (Module mod : packageInstance.modules()) {
                String modName = mod.descriptor().name().moduleNamePart();
                if (modName == null || !modName.equals(moduleDependency.descriptor().name().moduleNamePart())) continue;
                ConfigReader.getValidDependencies(packageInstance, mod, dependencies);
            }
        }
    }

    private static boolean isDefaultScope(ModuleDependency moduleDependency) {
        return moduleDependency.packageDependency().scope().getValue().equals(PlatformLibraryScope.DEFAULT.getStringValue());
    }

    private static boolean isSamePackage(Package packageInstance, ModuleDependency moduleDependency) {
        String orgValue = moduleDependency.descriptor().org().value();
        String packageVal = moduleDependency.descriptor().packageName().value();
        return orgValue.equals(packageInstance.packageOrg().value()) && packageVal.equals(packageInstance.packageName().value());
    }
}

