/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.identifier.Utils;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;

public class JarResolver {
    private final JBallerinaBackend jBalBackend;
    private final PackageResolution pkgResolution;
    private final PackageContext rootPackageContext;
    private final List<Diagnostic> diagnosticList;
    private DiagnosticResult diagnosticResult;
    private final List<PlatformLibrary> providedPlatformLibs;
    private ClassLoader classLoaderWithAllJars;

    JarResolver(JBallerinaBackend jBalBackend, PackageResolution pkgResolution) {
        this.jBalBackend = jBalBackend;
        this.pkgResolution = pkgResolution;
        this.rootPackageContext = pkgResolution.packageContext();
        this.diagnosticList = new ArrayList<Diagnostic>();
        this.providedPlatformLibs = new ArrayList<PlatformLibrary>();
    }

    DiagnosticResult diagnosticResult() {
        if (this.diagnosticResult == null) {
            this.diagnosticResult = new DefaultDiagnosticResult(this.diagnosticList);
        }
        return this.diagnosticResult;
    }

    public List<PlatformLibrary> providedPlatformLibs() {
        return this.providedPlatformLibs;
    }

    public Collection<JarLibrary> getJarFilePathsRequiredForExecution() {
        HashSet<JarLibrary> jarFiles = new HashSet<JarLibrary>();
        this.addCodeGeneratedLibraryPaths(this.rootPackageContext, PlatformLibraryScope.DEFAULT, jarFiles);
        this.addPlatformLibraryPaths(this.rootPackageContext, PlatformLibraryScope.DEFAULT, jarFiles);
        this.addPlatformLibraryPaths(this.rootPackageContext, PlatformLibraryScope.PROVIDED, jarFiles);
        this.pkgResolution.allDependencies().stream().filter(pkgDep -> pkgDep.scope() != PackageDependencyScope.TEST_ONLY).filter(pkgDep -> !pkgDep.packageInstance().descriptor().isLangLibPackage()).map(pkgDep -> pkgDep.packageInstance().packageContext()).forEach(pkgContext -> {
            this.addCodeGeneratedLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.DEFAULT, (Set<JarLibrary>)jarFiles);
            this.addPlatformLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.DEFAULT, (Set<JarLibrary>)jarFiles);
            this.addPlatformLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.PROVIDED, (Set<JarLibrary>)jarFiles, true);
        });
        String packageName = this.getPackageName(this.rootPackageContext);
        jarFiles.add(new JarLibrary(this.jBalBackend.runtimeLibrary().path(), PlatformLibraryScope.DEFAULT, packageName));
        Optional.ofNullable(this.jBalBackend.codeGeneratedResourcesLibrary(this.rootPackageContext.packageId())).ifPresent(library -> jarFiles.add(new JarLibrary(library.path(), PlatformLibraryScope.DEFAULT, packageName)));
        return jarFiles;
    }

    private void addCodeGeneratedLibraryPaths(PackageContext packageContext, PlatformLibraryScope scope, Set<JarLibrary> libraryPaths) {
        for (ModuleId moduleId : packageContext.moduleIds()) {
            ModuleContext moduleContext = packageContext.moduleContext(moduleId);
            PlatformLibrary generatedJarLibrary = this.jBalBackend.codeGeneratedLibrary(packageContext.packageId(), moduleContext.moduleName());
            libraryPaths.add(new JarLibrary(generatedJarLibrary.path(), scope, this.getPackageName(packageContext)));
        }
    }

    private void addPlatformLibraryPaths(PackageContext packageContext, PlatformLibraryScope scope, Set<JarLibrary> libraryPaths) {
        this.addPlatformLibraryPaths(packageContext, scope, libraryPaths, false);
    }

    private void addPlatformLibraryPaths(PackageContext packageContext, PlatformLibraryScope scope, Set<JarLibrary> libraryPaths, boolean addProvidedJars) {
        Collection<PlatformLibrary> otherJarDependencies = this.jBalBackend.platformLibraryDependencies(packageContext.packageId(), scope);
        if (addProvidedJars) {
            this.providedPlatformLibs.addAll(otherJarDependencies);
        }
        for (PlatformLibrary otherJarDependency : otherJarDependencies) {
            JarLibrary newEntry = (JarLibrary)otherJarDependency;
            if (newEntry.groupId().isEmpty() || newEntry.artifactId().isEmpty() || newEntry.version().isEmpty()) {
                libraryPaths.add(new JarLibrary(otherJarDependency.path(), scope, this.getPackageName(packageContext)));
                continue;
            }
            if (libraryPaths.contains(newEntry)) {
                ComparableVersion newVersion;
                JarLibrary existingEntry = libraryPaths.stream().filter(jarLibrary1 -> jarLibrary1.equals(newEntry)).findAny().orElseThrow();
                if (existingEntry.groupId().isEmpty() || existingEntry.artifactId().isEmpty() || existingEntry.version().isEmpty()) continue;
                ComparableVersion existingVersion = new ComparableVersion(existingEntry.version().orElseThrow());
                if (existingVersion.compareTo(newVersion = new ComparableVersion(newEntry.version().get())) >= 0) {
                    if (existingVersion.compareTo(newVersion) == 0) continue;
                    this.reportDiagnostic(newEntry, existingEntry);
                    continue;
                }
                this.reportDiagnostic(existingEntry, newEntry);
                libraryPaths.remove(existingEntry);
            }
            libraryPaths.add(new JarLibrary(newEntry.path(), scope, newEntry.artifactId().orElseThrow(), newEntry.groupId().orElseThrow(), newEntry.version().orElseThrow(), newEntry.packageName().orElseThrow()));
        }
    }

    private void reportDiagnostic(JarLibrary existingEntry, JarLibrary newEntry) {
        if (!existingEntry.packageName().orElseThrow().startsWith("ballerina") || !newEntry.packageName().orElseThrow().startsWith("ballerina")) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.CONFLICTING_PLATFORM_JAR_FILES.diagnosticId(), "detected conflicting jar files. '" + String.valueOf(newEntry.path().getFileName()) + "' dependency of '" + newEntry.packageName().get() + "' conflicts with '" + String.valueOf(existingEntry.path().getFileName()) + "' dependency of '" + existingEntry.packageName().get() + "'. Picking '" + String.valueOf(newEntry.path().getFileName()) + "' over '" + String.valueOf(existingEntry.path().getFileName()) + "'.", DiagnosticSeverity.WARNING);
            this.diagnosticList.add(new PackageDiagnostic(diagnosticInfo, this.jBalBackend.packageContext().descriptor().name().toString()));
        }
    }

    public Collection<JarLibrary> getJarFilePathsRequiredForTestExecution(ModuleName moduleName) {
        HashSet<JarLibrary> allJarFileForTestExec = new HashSet<JarLibrary>(this.getJarFilePathsRequiredForExecution());
        if (!this.rootPackageContext.packageManifest().org().anonymous()) {
            PackageId rootPackageId = this.rootPackageContext.packageId();
            PlatformLibrary generatedTestJar = this.jBalBackend.codeGeneratedTestLibrary(rootPackageId, moduleName);
            allJarFileForTestExec.add(new JarLibrary(generatedTestJar.path(), PlatformLibraryScope.DEFAULT, this.getPackageName(this.rootPackageContext)));
        }
        this.addPlatformLibraryPaths(this.rootPackageContext, PlatformLibraryScope.TEST_ONLY, allJarFileForTestExec);
        this.pkgResolution.allDependencies().stream().filter(pkgDep -> pkgDep.scope() == PackageDependencyScope.TEST_ONLY).filter(pkgDep -> !pkgDep.packageInstance().descriptor().isLangLibPackage()).map(pkgDep -> pkgDep.packageInstance().packageContext()).forEach(pkgContext -> {
            this.addCodeGeneratedLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.DEFAULT, (Set<JarLibrary>)allJarFileForTestExec);
            this.addPlatformLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.DEFAULT, (Set<JarLibrary>)allJarFileForTestExec);
            this.addPlatformLibraryPaths((PackageContext)pkgContext, PlatformLibraryScope.PROVIDED, (Set<JarLibrary>)allJarFileForTestExec);
        });
        allJarFileForTestExec.addAll(ProjectUtils.testDependencies());
        return allJarFileForTestExec;
    }

    public ClassLoader getClassLoaderWithRequiredJarFilesForExecution() {
        if (this.classLoaderWithAllJars != null) {
            return this.classLoaderWithAllJars;
        }
        this.classLoaderWithAllJars = this.createClassLoader(this.getJarFilePathsRequiredForExecution());
        return this.classLoaderWithAllJars;
    }

    public ClassLoader getClassLoaderWithRequiredJarFilesForTestExecution(ModuleName moduleName) {
        return this.createClassLoader(this.getJarFilePathsRequiredForTestExecution(moduleName));
    }

    private URLClassLoader createClassLoader(Collection<JarLibrary> jarFiles) {
        if (this.jBalBackend.diagnosticResult().hasErrors()) {
            throw new IllegalStateException("Cannot create a ClassLoader: this compilation has errors.");
        }
        ArrayList<URL> urlList = new ArrayList<URL>(jarFiles.size());
        for (JarLibrary jarFile : jarFiles) {
            try {
                urlList.add(jarFile.path().toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to create classloader with all jar files", e);
            }
        }
        return AccessController.doPrivileged(() -> new URLClassLoader(urlList.toArray(new URL[0]), ClassLoader.getSystemClassLoader()));
    }

    private String getPackageName(PackageContext packageContext) {
        return packageContext.packageOrg().value() + "/" + packageContext.packageName().value();
    }

    public static String getQualifiedClassName(String orgName, String packageName, String version, String className) {
        if (!".".equals(packageName)) {
            className = Utils.encodeNonFunctionIdentifier((String)packageName) + "." + CompilerUtils.getMajorVersion(version) + "." + (String)className;
        }
        if (!"$anon".equals(orgName)) {
            className = Utils.encodeNonFunctionIdentifier((String)orgName) + "." + (String)className;
        }
        return className;
    }
}

