/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.impl.BallerinaSemanticModel;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.ModuleContext;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageContext;
import io.ballerina.projects.PackageId;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.PackageDiagnostic;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class ModuleCompilation {
    private final ModuleContext moduleContext;
    private final PackageContext packageContext;
    private final PackageCache packageCache;
    private final CompilerContext compilerContext;
    private final DependencyGraph<ModuleDescriptor> dependencyGraph;
    private DiagnosticResult diagnosticResult;

    ModuleCompilation(PackageContext packageContext, ModuleContext moduleContext) {
        this.packageContext = packageContext;
        this.moduleContext = moduleContext;
        packageContext.getResolution();
        ProjectEnvironment projectEnvContext = packageContext.project().projectEnvironmentContext();
        this.packageCache = projectEnvContext.getService(PackageCache.class);
        this.compilerContext = projectEnvContext.getService(CompilerContext.class);
        this.dependencyGraph = this.buildDependencyGraph();
        this.compile();
    }

    private DependencyGraph<ModuleDescriptor> buildDependencyGraph() {
        HashMap<ModuleDescriptor, Set<ModuleDescriptor>> dependencyDescriptorMap = new HashMap<ModuleDescriptor, Set<ModuleDescriptor>>();
        this.addModuleDependencies(this.moduleContext.descriptor(), dependencyDescriptorMap);
        return DependencyGraph.from(dependencyDescriptorMap);
    }

    private void addModuleDependencies(ModuleDescriptor moduleDescriptor, Map<ModuleDescriptor, Set<ModuleDescriptor>> dependencyDescriptorMap) {
        Optional<Package> pkg = this.packageCache.getPackage(moduleDescriptor.org(), moduleDescriptor.packageName(), moduleDescriptor.version());
        if (pkg.isEmpty()) {
            throw new IllegalStateException("Cannot find a package for the given details, org: " + String.valueOf(moduleDescriptor.org()) + ", name: " + String.valueOf(moduleDescriptor.packageName()) + ", version: " + String.valueOf(moduleDescriptor.version()));
        }
        HashSet<ModuleDescriptor> directDependencies = new HashSet<ModuleDescriptor>(pkg.get().moduleDependencyGraph().getDirectDependencies(moduleDescriptor));
        ModuleContext moduleCtx = pkg.get().packageContext().moduleContext(moduleDescriptor.name());
        for (ModuleDependency moduleDependency : moduleCtx.dependencies()) {
            PackageId dependentPkgId = moduleDependency.packageDependency().packageId();
            if (dependentPkgId == pkg.get().packageId()) continue;
            ModuleDescriptor dependentModuleDescriptor = moduleDependency.descriptor();
            directDependencies.add(dependentModuleDescriptor);
            this.addModuleDependencies(dependentModuleDescriptor, dependencyDescriptorMap);
        }
        dependencyDescriptorMap.put(moduleDescriptor, new HashSet<ModuleDescriptor>(directDependencies));
        for (ModuleDescriptor depModuleDescriptor : directDependencies) {
            this.addModuleDependencies(depModuleDescriptor, dependencyDescriptorMap);
        }
    }

    private void compile() {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        List<ModuleDescriptor> sortedModuleDescriptors = this.dependencyGraph.toTopologicallySortedList();
        for (ModuleDescriptor sortedModuleDescriptor : sortedModuleDescriptors) {
            Optional<Package> pkg = this.packageCache.getPackage(sortedModuleDescriptor.org(), sortedModuleDescriptor.packageName(), sortedModuleDescriptor.version());
            if (pkg.isEmpty()) {
                throw new IllegalStateException("Cannot find a package for the given details, org: " + String.valueOf(sortedModuleDescriptor.org()) + ", name: " + String.valueOf(sortedModuleDescriptor.packageName()) + ", version: " + String.valueOf(sortedModuleDescriptor.version()));
            }
            ModuleContext moduleContext = pkg.get().module(sortedModuleDescriptor.name()).moduleContext();
            moduleContext.compile(this.compilerContext);
            for (Diagnostic diagnostic : moduleContext.diagnostics()) {
                diagnostics.add(new PackageDiagnostic(diagnostic, moduleContext.descriptor(), moduleContext.project()));
            }
        }
        this.diagnosticResult = new DefaultDiagnosticResult(diagnostics);
    }

    public SemanticModel getSemanticModel() {
        return new BallerinaSemanticModel(this.moduleContext.bLangPackage(), this.compilerContext);
    }

    public DiagnosticResult diagnostics() {
        return this.diagnosticResult;
    }
}

