/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.Bootstrap;
import io.ballerina.projects.CompilationCache;
import io.ballerina.projects.CompilerBackend;
import io.ballerina.projects.Diagnostics;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentContext;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.MdDocumentContext;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleCompilationState;
import io.ballerina.projects.ModuleConfig;
import io.ballerina.projects.ModuleDependency;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDependency;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageResolution;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.CompilerPhaseRunner;
import io.ballerina.projects.internal.ModuleContextDataHolder;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.tree.SourceKind;
import org.wso2.ballerinalang.compiler.BIRPackageSymbolEnter;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.bir.writer.BIRBinaryWriter;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;
import org.wso2.ballerinalang.programfile.PackageFileWriter;

class ModuleContext {
    private final ModuleId moduleId;
    private final ModuleDescriptor moduleDescriptor;
    private final Collection<DocumentId> srcDocIds;
    private final boolean isDefaultModule;
    private final Map<DocumentId, DocumentContext> srcDocContextMap;
    private final Collection<DocumentId> testSrcDocIds;
    private final MdDocumentContext readmeMdContext;
    private final Map<DocumentId, DocumentContext> testDocContextMap;
    private final Project project;
    private final CompilationCache compilationCache;
    private final List<ModuleDescriptor> moduleDescDependencies;
    private Set<ModuleDependency> moduleDependencies;
    private BLangPackage bLangPackage;
    private BPackageSymbol bPackageSymbol;
    private byte[] birBytes = new byte[0];
    private final Bootstrap bootstrap;
    private ModuleCompilationState moduleCompState;
    private Set<ModuleLoadRequest> allModuleLoadRequests = null;
    private Set<ModuleLoadRequest> allTestModuleLoadRequests = null;

    ModuleContext(Project project, ModuleId moduleId, ModuleDescriptor moduleDescriptor, boolean isDefaultModule, Map<DocumentId, DocumentContext> srcDocContextMap, Map<DocumentId, DocumentContext> testDocContextMap, MdDocumentContext readmeMd, List<ModuleDescriptor> moduleDescDependencies) {
        this.project = project;
        this.moduleId = moduleId;
        this.moduleDescriptor = moduleDescriptor;
        this.isDefaultModule = isDefaultModule;
        this.srcDocContextMap = srcDocContextMap;
        this.srcDocIds = Collections.unmodifiableCollection(srcDocContextMap.keySet());
        this.testDocContextMap = testDocContextMap;
        this.testSrcDocIds = Collections.unmodifiableCollection(testDocContextMap.keySet());
        this.readmeMdContext = readmeMd;
        this.moduleDescDependencies = Collections.unmodifiableList(moduleDescDependencies);
        ProjectEnvironment projectEnvironment = project.projectEnvironmentContext();
        this.bootstrap = new Bootstrap(projectEnvironment.getService(PackageResolver.class));
        this.compilationCache = projectEnvironment.getService(CompilationCache.class);
    }

    static ModuleContext from(Project project, ModuleConfig moduleConfig, boolean disableSyntaxTree) {
        LinkedHashMap<DocumentId, DocumentContext> srcDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
        for (DocumentConfig sourceDocConfig : moduleConfig.sourceDocs()) {
            srcDocContextMap.put(sourceDocConfig.documentId(), DocumentContext.from(sourceDocConfig, disableSyntaxTree));
        }
        LinkedHashMap<DocumentId, DocumentContext> testDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
        for (DocumentConfig testSrcDocConfig : moduleConfig.testSourceDocs()) {
            testDocContextMap.put(testSrcDocConfig.documentId(), DocumentContext.from(testSrcDocConfig, disableSyntaxTree));
        }
        return new ModuleContext(project, moduleConfig.moduleId(), moduleConfig.moduleDescriptor(), moduleConfig.isDefaultModule(), srcDocContextMap, testDocContextMap, moduleConfig.readmeMd().map(c -> MdDocumentContext.from(c)).orElse(null), moduleConfig.dependencies());
    }

    ModuleId moduleId() {
        return this.moduleId;
    }

    ModuleDescriptor descriptor() {
        return this.moduleDescriptor;
    }

    ModuleName moduleName() {
        return this.moduleDescriptor.name();
    }

    Collection<DocumentId> srcDocumentIds() {
        return this.srcDocIds;
    }

    Collection<DocumentId> testSrcDocumentIds() {
        return this.testSrcDocIds;
    }

    DocumentContext documentContext(DocumentId documentId) {
        if (this.srcDocIds.contains(documentId)) {
            return this.srcDocContextMap.get(documentId);
        }
        return this.testDocContextMap.get(documentId);
    }

    Project project() {
        return this.project;
    }

    boolean isExported() {
        List<String> exports = this.project.currentPackage().manifest().exportedModules();
        return exports.contains(this.moduleDescriptor.name().toString());
    }

    boolean isDefaultModule() {
        return this.isDefaultModule;
    }

    Collection<ModuleDependency> dependencies() {
        return this.moduleDependencies;
    }

    List<ModuleDescriptor> moduleDescDependencies() {
        return this.moduleDescDependencies;
    }

    Set<ModuleLoadRequest> populateModuleLoadRequests() {
        if (this.allModuleLoadRequests != null) {
            return this.allModuleLoadRequests;
        }
        this.allModuleLoadRequests = new OverwritableLinkedHashSet();
        for (DocumentContext docContext : this.srcDocContextMap.values()) {
            this.allModuleLoadRequests.addAll(docContext.moduleLoadRequests(this.moduleDescriptor, PackageDependencyScope.DEFAULT));
        }
        return this.allModuleLoadRequests;
    }

    Set<ModuleLoadRequest> populateTestSrcModuleLoadRequests() {
        if (this.allTestModuleLoadRequests != null) {
            return this.allTestModuleLoadRequests;
        }
        this.allTestModuleLoadRequests = new OverwritableLinkedHashSet();
        for (DocumentContext docContext : this.testDocContextMap.values()) {
            this.allTestModuleLoadRequests.addAll(docContext.moduleLoadRequests(this.moduleDescriptor, PackageDependencyScope.TEST_ONLY));
        }
        return this.allTestModuleLoadRequests;
    }

    BLangPackage bLangPackage() {
        return this.getBLangPackageOrThrow();
    }

    protected void cleanBLangPackage() {
        this.bLangPackage = null;
    }

    ModuleCompilationState compilationState() {
        return this.moduleCompState;
    }

    private BLangPackage getBLangPackageOrThrow() {
        if (this.bLangPackage == null) {
            throw new IllegalStateException("Compile the module first!");
        }
        return this.bLangPackage;
    }

    List<Diagnostic> diagnostics() {
        if (this.bLangPackage != null) {
            return this.bLangPackage.getDiagnostics();
        }
        return Collections.emptyList();
    }

    private void parseTestSources(BLangPackage pkgNode, PackageID pkgId, CompilerContext compilerContext) {
        Types types = Types.getInstance(compilerContext);
        BLangTestablePackage testablePkg = TreeBuilder.createTestablePackageNode(types.typeEnv());
        testablePkg.packageID = pkgId;
        testablePkg.flagSet.add(Flag.TESTABLE);
        testablePkg.parent = pkgNode;
        testablePkg.pos = new BLangDiagnosticLocation(this.moduleName().toString(), 1, 1, 1, 1);
        pkgNode.addTestablePkg(testablePkg);
        for (DocumentContext documentContext : this.testDocContextMap.values()) {
            testablePkg.addCompilationUnit(documentContext.compilationUnit(compilerContext, pkgId, SourceKind.TEST_SOURCE));
        }
    }

    ModuleCompilationState currentCompilationState() {
        if (this.moduleCompState != null) {
            return this.moduleCompState;
        }
        this.moduleCompState = this.compilationCache.getBir(this.moduleDescriptor.name()).length == 0 ? ModuleCompilationState.LOADED_FROM_SOURCES : (this.project().kind() == ProjectKind.BUILD_PROJECT && !this.project.buildOptions().enableCache() ? ModuleCompilationState.LOADED_FROM_SOURCES : ModuleCompilationState.LOADED_FROM_CACHE);
        return this.moduleCompState;
    }

    void setCompilationState(ModuleCompilationState moduleCompState) {
        this.moduleCompState = moduleCompState;
    }

    void resolveDependencies(PackageResolution.DependencyResolution dependencyResolution) {
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>();
        if (this.project.kind() == ProjectKind.BALA_PROJECT) {
            for (ModuleDescriptor dependencyModDesc : this.moduleDescDependencies) {
                this.addModuleDependency(dependencyModDesc.org(), dependencyModDesc.packageName(), dependencyModDesc.name(), PackageDependencyScope.DEFAULT, moduleDependencies, dependencyResolution);
            }
        } else {
            LinkedHashSet<ModuleLoadRequest> moduleLoadRequests = new LinkedHashSet<ModuleLoadRequest>();
            moduleLoadRequests.addAll(this.allModuleLoadRequests);
            moduleLoadRequests.addAll(this.allTestModuleLoadRequests);
            for (ModuleLoadRequest modLoadRequest : moduleLoadRequests) {
                PackageOrg packageOrg;
                if (modLoadRequest.orgName().isEmpty()) {
                    if (this.project.kind() == ProjectKind.SINGLE_FILE_PROJECT) continue;
                    packageOrg = this.descriptor().org();
                } else {
                    packageOrg = modLoadRequest.orgName().get();
                }
                this.addModuleDependency(packageOrg, modLoadRequest.moduleName(), modLoadRequest.scope(), moduleDependencies, dependencyResolution);
            }
        }
        this.moduleDependencies = Collections.unmodifiableSet(moduleDependencies);
    }

    private void addModuleDependency(PackageOrg org, String moduleName, PackageDependencyScope scope, Set<ModuleDependency> moduleDependencies, PackageResolution.DependencyResolution dependencyResolution) {
        Optional<ModuleContext> resolvedModuleOptional = dependencyResolution.getModule(org, moduleName);
        if (resolvedModuleOptional.isEmpty()) {
            return;
        }
        ModuleContext resolvedModule = resolvedModuleOptional.get();
        ModuleDependency moduleDependency = new ModuleDependency(new PackageDependency(resolvedModule.moduleId().packageId(), scope), resolvedModule.descriptor());
        moduleDependencies.add(moduleDependency);
    }

    private void addModuleDependency(PackageOrg org, PackageName packageName, ModuleName moduleName, PackageDependencyScope scope, Set<ModuleDependency> moduleDependencies, PackageResolution.DependencyResolution dependencyResolution) {
        Optional<Module> resolvedModuleOptional = dependencyResolution.getModule(org, packageName, moduleName);
        if (resolvedModuleOptional.isEmpty()) {
            return;
        }
        Module resolvedModule = resolvedModuleOptional.get();
        ModuleDependency moduleDependency = new ModuleDependency(new PackageDependency(resolvedModule.packageInstance().packageId(), scope), resolvedModule.descriptor());
        moduleDependencies.add(moduleDependency);
    }

    void compile(CompilerContext compilerContext) {
        this.currentCompilationState().compile(this, compilerContext);
    }

    void generatePlatformSpecificCode(CompilerContext compilerContext, CompilerBackend compilerBackend) {
        this.currentCompilationState().generatePlatformSpecificCode(this, compilerContext, compilerBackend);
    }

    static void parseInternal(ModuleContext moduleContext) {
        for (DocumentContext docContext : moduleContext.srcDocContextMap.values()) {
            docContext.parse();
        }
    }

    static void resolveDependenciesInternal(ModuleContext moduleContext) {
    }

    static void compileInternal(ModuleContext moduleContext, CompilerContext compilerContext) {
        PackageID moduleCompilationId = moduleContext.descriptor().moduleCompilationId();
        String bootstrapLangLibName = System.getProperty("BOOTSTRAP_LANG_LIB");
        if (bootstrapLangLibName != null) {
            moduleContext.bootstrap.loadLangLib(compilerContext, moduleCompilationId);
        }
        PackageCache packageCache = PackageCache.getInstance(compilerContext);
        SymbolEnter symbolEnter = SymbolEnter.getInstance(compilerContext);
        CompilerPhaseRunner compilerPhaseRunner = CompilerPhaseRunner.getInstance(compilerContext);
        Types types = Types.getInstance(compilerContext);
        BLangPackage pkgNode = (BLangPackage)TreeBuilder.createPackageNode(types.typeEnv());
        pkgNode.moduleContextDataHolder = new ModuleContextDataHolder(moduleContext.isExported(), moduleContext.descriptor(), moduleContext.project.kind(), moduleContext.project.buildOptions().skipTests(), moduleContext.project().sourceRoot());
        packageCache.put(moduleCompilationId, pkgNode);
        for (DocumentContext documentContext : moduleContext.srcDocContextMap.values()) {
            pkgNode.addCompilationUnit(documentContext.compilationUnit(compilerContext, moduleCompilationId, SourceKind.REGULAR_SOURCE));
        }
        if (!moduleContext.testSrcDocumentIds().isEmpty()) {
            PackageID moduleTestCompilationId = moduleContext.descriptor().moduleTestCompilationId();
            moduleContext.parseTestSources(pkgNode, moduleTestCompilationId, compilerContext);
        }
        pkgNode.pos = new BLangDiagnosticLocation(moduleContext.moduleName().toString(), 0, 0, 0, 0);
        try {
            symbolEnter.definePackage(pkgNode);
            packageCache.putSymbol(pkgNode.packageID, pkgNode.symbol);
            compilerPhaseRunner.performTypeCheckPhases(pkgNode);
        }
        catch (Throwable t) {
            assert (false) : "Compilation failed due to " + ((Supplier<String>)() -> {
                StringWriter errors = new StringWriter();
                t.printStackTrace(new PrintWriter(errors));
                return errors.toString();
            }).get();
            compilerPhaseRunner.addDiagnosticForUnhandledException(pkgNode, t);
        }
        moduleContext.bLangPackage = pkgNode;
    }

    static void generateCodeInternal(ModuleContext moduleContext, CompilerBackend compilerBackend, CompilerContext compilerContext) {
        String bootstrapLangLibName = System.getProperty("BOOTSTRAP_LANG_LIB");
        CompilerPhaseRunner compilerPhaseRunner = CompilerPhaseRunner.getInstance(compilerContext);
        if (bootstrapLangLibName != null) {
            compilerPhaseRunner.performLangLibBirGenPhases(moduleContext.bLangPackage);
        } else {
            try {
                compilerPhaseRunner.performBirGenPhases(moduleContext.bLangPackage);
            }
            catch (Throwable t) {
                assert (false) : "Compilation failed due to " + ((Supplier<String>)() -> {
                    StringWriter errors = new StringWriter();
                    t.printStackTrace(new PrintWriter(errors));
                    return errors.toString();
                }).get();
                compilerPhaseRunner.addDiagnosticForUnhandledException(moduleContext.bLangPackage, t);
                return;
            }
        }
        if (Diagnostics.hasErrors(moduleContext.diagnostics())) {
            return;
        }
        ByteArrayOutputStream birContent = ModuleContext.generateBIR(moduleContext, compilerContext);
        if (Diagnostics.hasErrors(moduleContext.diagnostics())) {
            return;
        }
        compilerBackend.performCodeGen(moduleContext, moduleContext.compilationCache);
        if (Diagnostics.hasErrors(moduleContext.diagnostics())) {
            return;
        }
        if (birContent == null) {
            return;
        }
        moduleContext.compilationCache.cacheBir(moduleContext.moduleName(), birContent);
    }

    private static boolean shouldGenerateBir(ModuleContext moduleContext, CompilerContext compilerContext) {
        if (moduleContext.project.kind().equals((Object)ProjectKind.BALA_PROJECT)) {
            return true;
        }
        if (ProjectUtils.isBuiltInPackage(moduleContext.descriptor().org(), moduleContext.descriptor().packageName().toString())) {
            return true;
        }
        CompilerOptions compilerOptions = CompilerOptions.getInstance(compilerContext);
        if (Boolean.parseBoolean(compilerOptions.get(CompilerOptionName.DUMP_BIR_FILE))) {
            return true;
        }
        return moduleContext.project.kind().equals((Object)ProjectKind.BUILD_PROJECT) && moduleContext.project().buildOptions().enableCache();
    }

    private static ByteArrayOutputStream generateBIR(ModuleContext moduleContext, CompilerContext compilerContext) {
        if (!ModuleContext.shouldGenerateBir(moduleContext, compilerContext)) {
            return null;
        }
        ByteArrayOutputStream birContent = new ByteArrayOutputStream();
        SymbolTable symTable = SymbolTable.getInstance(compilerContext);
        try {
            CompiledBinaryFile.BIRPackageFile birPackageFile = moduleContext.bLangPackage.symbol.birPackageFile;
            if (birPackageFile == null) {
                moduleContext.bLangPackage.symbol.birPackageFile = birPackageFile = new CompiledBinaryFile.BIRPackageFile(new BIRBinaryWriter(moduleContext.bLangPackage.symbol.bir, symTable.typeEnv()).serialize());
            }
            byte[] pkgBirBinaryContent = PackageFileWriter.writePackage(birPackageFile);
            birContent.writeBytes(pkgBirBinaryContent);
            return birContent;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert BIR model to a byte array", e);
        }
    }

    static void loadBirBytesInternal(ModuleContext moduleContext) {
        moduleContext.birBytes = moduleContext.compilationCache.getBir(moduleContext.moduleName());
    }

    static void resolveDependenciesFromBALAInternal(ModuleContext moduleContext) {
    }

    static void loadPackageSymbolInternal(ModuleContext moduleContext, CompilerContext compilerContext) {
        PackageCache packageCache = PackageCache.getInstance(compilerContext);
        BIRPackageSymbolEnter birPackageSymbolEnter = BIRPackageSymbolEnter.getInstance(compilerContext);
        PackageID moduleCompilationId = moduleContext.descriptor().moduleCompilationId();
        moduleContext.bPackageSymbol = birPackageSymbolEnter.definePackage(moduleCompilationId, moduleContext.birBytes);
        moduleContext.bPackageSymbol.exported = moduleContext.isExported();
        moduleContext.bPackageSymbol.descriptor = moduleContext.descriptor();
        packageCache.putSymbol(moduleCompilationId, moduleContext.bPackageSymbol);
    }

    static void loadPlatformSpecificCodeInternal(ModuleContext moduleContext, CompilerBackend compilerBackend) {
    }

    static void shrinkDocuments(ModuleContext moduleContext) {
        moduleContext.srcDocContextMap.values().forEach(DocumentContext::shrink);
    }

    @Deprecated(forRemoval=true)
    Optional<MdDocumentContext> moduleMdContext() {
        return Optional.ofNullable(this.readmeMdContext);
    }

    public Optional<MdDocumentContext> readmeMdContext() {
        return Optional.ofNullable(this.readmeMdContext);
    }

    ModuleContext duplicate(Project project) {
        LinkedHashMap<DocumentId, DocumentContext> srcDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
        for (DocumentId documentId : this.srcDocumentIds()) {
            DocumentContext documentContext = this.documentContext(documentId);
            srcDocContextMap.put(documentId, documentContext.duplicate());
        }
        LinkedHashMap<DocumentId, DocumentContext> testDocContextMap = new LinkedHashMap<DocumentId, DocumentContext>();
        for (DocumentId documentId : this.testSrcDocumentIds()) {
            DocumentContext documentContext = this.documentContext(documentId);
            testDocContextMap.put(documentId, documentContext.duplicate());
        }
        return new ModuleContext(project, this.moduleId, this.moduleDescriptor, this.isDefaultModule, srcDocContextMap, testDocContextMap, this.readmeMdContext().orElse(null), this.moduleDescDependencies);
    }

    static class OverwritableLinkedHashSet
    extends LinkedHashSet<ModuleLoadRequest> {
        private static final long serialVersionUID = 1L;

        OverwritableLinkedHashSet() {
        }

        @Override
        public boolean add(ModuleLoadRequest moduleLoadRequest) {
            if (this.contains(moduleLoadRequest)) {
                HashSet<Location> locations = new HashSet<Location>();
                ModuleLoadRequest finalModuleLoadRequest = moduleLoadRequest;
                ModuleLoadRequest oldLoadRequest = this.stream().filter(oldRequest -> oldRequest.equals(finalModuleLoadRequest)).findFirst().orElseThrow();
                locations.addAll(oldLoadRequest.locations());
                locations.addAll(moduleLoadRequest.locations());
                PackageDependencyScope scope = oldLoadRequest.scope() == PackageDependencyScope.DEFAULT ? oldLoadRequest.scope() : moduleLoadRequest.scope();
                moduleLoadRequest = new ModuleLoadRequest((PackageOrg)oldLoadRequest.orgName().orElse(null), oldLoadRequest.moduleName(), scope, oldLoadRequest.dependencyResolvedType(), locations);
                this.remove(oldLoadRequest);
            }
            return super.add(moduleLoadRequest);
        }
    }
}

