/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.PackageId;
import java.util.Objects;
import java.util.UUID;

public final class ModuleId {
    private final UUID id;
    private final String moduleName;
    private final PackageId packageId;

    private ModuleId(UUID id, String moduleName, PackageId packageId) {
        this.id = id;
        this.moduleName = moduleName;
        this.packageId = packageId;
    }

    public static ModuleId create(String moduleDirPath, PackageId packageId) {
        return new ModuleId(UUID.randomUUID(), moduleDirPath, packageId);
    }

    public UUID id() {
        return this.id;
    }

    @Deprecated
    public String moduleName() {
        return this.moduleName;
    }

    public PackageId packageId() {
        return this.packageId;
    }

    public String toString() {
        return "ModuleId{moduleName='" + this.moduleName + "', id=" + String.valueOf(this.id) + ", packageId=" + String.valueOf(this.packageId) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleId moduleId = (ModuleId)o;
        return this.id.equals(moduleId.id) && this.packageId.equals(moduleId.packageId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.packageId);
    }
}

