/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.model.BalToolDescriptor;
import io.ballerina.projects.internal.model.CompilerPluginDescriptor;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Location;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PackageManifest {
    private final PackageDescriptor packageDesc;
    private final CompilerPluginDescriptor compilerPluginDesc;
    private final BalToolDescriptor balToolDesc;
    private final Map<String, Platform> platforms;
    private final List<Tool> tools;
    private final List<Dependency> dependencies;
    private final DiagnosticResult diagnostics;
    private final List<String> license;
    private final List<String> authors;
    private final List<String> keywords;
    private final String repository;
    private final List<String> exportedModules;
    private final List<String> includes;
    private final String ballerinaVersion;
    private final String visibility;
    private boolean template;
    private final String icon;
    private final String readme;
    private final String description;
    private final List<Module> moduleList;
    private final Map<String, Object> otherEntries;

    private PackageManifest(PackageDescriptor packageDesc, CompilerPluginDescriptor compilerPluginDesc, BalToolDescriptor balToolDesc, Map<String, Platform> platforms, List<Dependency> dependencies, Map<String, Object> otherEntries, List<Tool> tools, DiagnosticResult diagnostics) {
        this.packageDesc = packageDesc;
        this.compilerPluginDesc = compilerPluginDesc;
        this.balToolDesc = balToolDesc;
        this.platforms = Collections.unmodifiableMap(platforms);
        this.dependencies = Collections.unmodifiableList(dependencies);
        this.otherEntries = Collections.unmodifiableMap(otherEntries);
        this.diagnostics = diagnostics;
        this.license = Collections.emptyList();
        this.authors = Collections.emptyList();
        this.keywords = Collections.emptyList();
        this.exportedModules = Collections.emptyList();
        this.includes = Collections.emptyList();
        this.repository = "";
        this.ballerinaVersion = "";
        this.visibility = "";
        this.icon = "";
        this.tools = Collections.unmodifiableList(tools);
        this.readme = "";
        this.description = "";
        this.moduleList = Collections.emptyList();
    }

    private PackageManifest(PackageDescriptor packageDesc, CompilerPluginDescriptor compilerPluginDesc, BalToolDescriptor balToolDesc, Map<String, Platform> platforms, List<Dependency> dependencies, Map<String, Object> otherEntries, DiagnosticResult diagnostics, List<String> license, List<String> authors, List<String> keywords, List<String> exportedModules, List<String> includes, String repository, String ballerinaVersion, String visibility, boolean template, String icon, String readme, String description, List<Module> moduleList) {
        this.packageDesc = packageDesc;
        this.compilerPluginDesc = compilerPluginDesc;
        this.balToolDesc = balToolDesc;
        this.platforms = Collections.unmodifiableMap(platforms);
        this.dependencies = Collections.unmodifiableList(dependencies);
        this.otherEntries = Collections.unmodifiableMap(otherEntries);
        this.diagnostics = diagnostics;
        this.license = license;
        this.authors = authors;
        this.keywords = keywords;
        this.exportedModules = this.getExport(packageDesc, exportedModules);
        this.includes = includes;
        this.repository = repository;
        this.ballerinaVersion = ballerinaVersion;
        this.visibility = visibility;
        this.template = template;
        this.icon = icon;
        this.tools = Collections.emptyList();
        this.readme = readme;
        this.description = description;
        this.moduleList = moduleList;
    }

    private PackageManifest(PackageDescriptor packageDesc, CompilerPluginDescriptor compilerPluginDesc, BalToolDescriptor balToolDesc, Map<String, Platform> platforms, List<Dependency> dependencies, Map<String, Object> otherEntries, DiagnosticResult diagnostics, List<String> license, List<String> authors, List<String> keywords, List<String> exportedModules, List<String> includes, String repository, String ballerinaVersion, String visibility, boolean template, String icon, List<Tool> tools, String readme, String description, List<Module> moduleList) {
        this.packageDesc = packageDesc;
        this.compilerPluginDesc = compilerPluginDesc;
        this.balToolDesc = balToolDesc;
        this.platforms = Collections.unmodifiableMap(platforms);
        this.dependencies = Collections.unmodifiableList(dependencies);
        this.otherEntries = Collections.unmodifiableMap(otherEntries);
        this.diagnostics = diagnostics;
        this.license = license;
        this.authors = authors;
        this.keywords = keywords;
        this.exportedModules = this.getExport(packageDesc, exportedModules);
        this.includes = includes;
        this.repository = repository;
        this.ballerinaVersion = ballerinaVersion;
        this.visibility = visibility;
        this.template = template;
        this.icon = icon;
        this.tools = tools;
        this.readme = readme;
        this.description = description;
        this.moduleList = moduleList;
    }

    public static PackageManifest from(PackageDescriptor packageDesc) {
        return new PackageManifest(packageDesc, null, null, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), new DefaultDiagnosticResult(Collections.emptyList()));
    }

    public static PackageManifest from(PackageDescriptor packageDesc, CompilerPluginDescriptor compilerPluginDesc, BalToolDescriptor balToolDesc, Map<String, Platform> platforms, List<Dependency> dependencies) {
        return new PackageManifest(packageDesc, compilerPluginDesc, balToolDesc, platforms, dependencies, Collections.emptyMap(), Collections.emptyList(), new DefaultDiagnosticResult(Collections.emptyList()));
    }

    public static PackageManifest from(PackageDescriptor packageDesc, CompilerPluginDescriptor compilerPluginDesc, BalToolDescriptor balToolDesc, Map<String, Platform> platforms, List<Dependency> dependencies, Map<String, Object> otherEntries, DiagnosticResult diagnostics, List<String> license, List<String> authors, List<String> keywords, List<String> export, List<String> include, String repository, String ballerinaVersion, String visibility, boolean template, String icon, List<Tool> tools, String readme, String description, List<Module> moduleList) {
        return new PackageManifest(packageDesc, compilerPluginDesc, balToolDesc, platforms, dependencies, otherEntries, diagnostics, license, authors, keywords, export, include, repository, ballerinaVersion, visibility, template, icon, tools, readme, description, moduleList);
    }

    public static PackageManifest from(PackageDescriptor packageDesc, CompilerPluginDescriptor compilerPluginDesc, BalToolDescriptor balToolDescriptor, Map<String, Platform> platforms, List<Dependency> dependencies, List<String> license, List<String> authors, List<String> keywords, List<String> export, List<String> include, String repository, String ballerinaVersion, String visibility, boolean template, String readme, String description, List<Module> moduleList) {
        return new PackageManifest(packageDesc, compilerPluginDesc, balToolDescriptor, platforms, dependencies, Collections.emptyMap(), new DefaultDiagnosticResult(Collections.emptyList()), license, authors, keywords, export, include, repository, ballerinaVersion, visibility, template, "", readme, description, moduleList);
    }

    public PackageName name() {
        return this.packageDesc.name();
    }

    public PackageOrg org() {
        return this.packageDesc.org();
    }

    public PackageVersion version() {
        return this.packageDesc.version();
    }

    public PackageDescriptor descriptor() {
        return this.packageDesc;
    }

    public Optional<CompilerPluginDescriptor> compilerPluginDescriptor() {
        return Optional.ofNullable(this.compilerPluginDesc);
    }

    public Optional<BalToolDescriptor> balToolDescriptor() {
        return Optional.ofNullable(this.balToolDesc);
    }

    public Platform platform(String platformCode) {
        return this.platforms.get(platformCode);
    }

    public Map<String, Platform> platforms() {
        return this.platforms;
    }

    public List<Tool> tools() {
        return this.tools;
    }

    public Object getValue(String key) {
        return this.otherEntries.get(key);
    }

    public List<String> license() {
        return this.license;
    }

    public List<String> authors() {
        return this.authors;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public List<String> exportedModules() {
        return this.exportedModules;
    }

    public List<String> includes() {
        return this.includes;
    }

    public String repository() {
        return this.repository;
    }

    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    public String ballerinaVersion() {
        return this.ballerinaVersion;
    }

    public String visibility() {
        return this.visibility;
    }

    public String icon() {
        return this.icon;
    }

    public DiagnosticResult diagnostics() {
        return this.diagnostics;
    }

    public boolean template() {
        return this.template;
    }

    public String readme() {
        return this.readme;
    }

    public List<Module> modules() {
        return this.moduleList;
    }

    public String description() {
        return this.description;
    }

    private List<String> getExport(PackageDescriptor packageDesc, List<String> export) {
        if (export == null || export.isEmpty()) {
            return Collections.singletonList(packageDesc.name().value());
        }
        return export;
    }

    public static class Platform {
        public static final String GRAALVM_COMPATIBLE = "graalvmCompatible";
        private final List<Map<String, Object>> dependencies;
        private final List<Map<String, Object>> repositories;
        private final Boolean graalvmCompatible;

        public Platform(List<Map<String, Object>> dependencies) {
            this(dependencies, Collections.emptyList(), null);
        }

        public Platform(List<Map<String, Object>> dependencies, List<Map<String, Object>> repositories, Boolean graalvmCompatible) {
            this.dependencies = dependencies != null ? Collections.unmodifiableList(dependencies) : Collections.emptyList();
            this.repositories = repositories != null ? Collections.unmodifiableList(repositories) : Collections.emptyList();
            this.graalvmCompatible = graalvmCompatible;
        }

        public List<Map<String, Object>> dependencies() {
            return this.dependencies;
        }

        public List<Map<String, Object>> repositories() {
            return this.repositories;
        }

        public Boolean graalvmCompatible() {
            return this.graalvmCompatible;
        }

        public Boolean isPlatfromDepsGraalvmCompatible() {
            Boolean overallGraalvmCompatibility = true;
            for (Map<String, Object> dependency : this.dependencies) {
                Boolean dependencyGraalvmCompatibility = (Boolean)dependency.get(GRAALVM_COMPATIBLE);
                if (dependencyGraalvmCompatibility == null) {
                    overallGraalvmCompatibility = null;
                    continue;
                }
                if (dependencyGraalvmCompatibility.booleanValue()) continue;
                return false;
            }
            return overallGraalvmCompatibility;
        }
    }

    public record Module(String name, boolean export, String description, String readme) {
        public Module(String name, boolean export, String description, String readme) {
            this.name = name;
            this.export = export;
            this.description = description;
            this.readme = readme != null ? readme : "";
        }
    }

    public static class Tool {
        private final Field id;
        private final TomlTableNode optionsTable;
        private final Field filePath;
        private final Field targetModule;
        private final Field type;
        private final Toml optionsToml;
        private final boolean hasErrorDiagnostic;

        public Tool(Field type, Field id, Field filePath, Field targetModule, Toml optionsToml, TomlTableNode optionsTable, boolean hasErrorDiagnostic) {
            this.type = type;
            this.id = id;
            this.filePath = filePath;
            this.targetModule = targetModule;
            this.optionsTable = optionsTable;
            this.optionsToml = optionsToml;
            this.hasErrorDiagnostic = hasErrorDiagnostic;
        }

        public Field id() {
            return this.id;
        }

        public Field filePath() {
            return this.filePath;
        }

        public Field targetModule() {
            return this.targetModule;
        }

        public TomlTableNode optionsTable() {
            return this.optionsTable;
        }

        public Field type() {
            return this.type;
        }

        public Toml optionsToml() {
            return this.optionsToml;
        }

        public boolean hasErrorDiagnostic() {
            return this.hasErrorDiagnostic;
        }

        public record Field(String value, TomlNodeLocation location) {
        }
    }

    public static class Dependency {
        private final PackageName packageName;
        private final PackageOrg packageOrg;
        private final PackageVersion version;
        private final String repository;
        private final Location location;

        public Dependency(PackageName packageName, PackageOrg packageOrg, PackageVersion version) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.location = null;
            this.repository = null;
        }

        public Dependency(PackageName packageName, PackageOrg packageOrg, PackageVersion version, String repository) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.repository = repository;
            this.location = null;
        }

        public Dependency(PackageName packageName, PackageOrg packageOrg, PackageVersion version, String repository, Location location) {
            this.packageName = packageName;
            this.packageOrg = packageOrg;
            this.version = version;
            this.repository = repository;
            this.location = location;
        }

        public PackageName name() {
            return this.packageName;
        }

        public PackageOrg org() {
            return this.packageOrg;
        }

        public PackageVersion version() {
            return this.version;
        }

        public String repository() {
            return this.repository;
        }

        public Optional<Location> location() {
            return Optional.ofNullable(this.location);
        }
    }
}

