/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.MdDocumentContext;
import io.ballerina.projects.Package;

public class PackageReadmeMd {
    private final MdDocumentContext mdDocumentContext;
    private final Package packageInstance;

    PackageReadmeMd(MdDocumentContext documentContext, Package packageInstance) {
        this.mdDocumentContext = documentContext;
        this.packageInstance = packageInstance;
    }

    public static PackageReadmeMd from(DocumentConfig documentConfig, Package aPackage) {
        MdDocumentContext documentContext = MdDocumentContext.from(documentConfig);
        return new PackageReadmeMd(documentContext, aPackage);
    }

    public static PackageReadmeMd from(MdDocumentContext documentContext, Package aPackage) {
        return new PackageReadmeMd(documentContext, aPackage);
    }

    public Package packageInstance() {
        return this.packageInstance;
    }

    public String content() {
        return this.mdDocumentContext.content();
    }

    public Modifier modify() {
        return new Modifier(this);
    }

    public static class Modifier {
        private String content;
        private final String name;
        private final DocumentId documentId;
        private final Package oldPackage;

        private Modifier(PackageReadmeMd oldDocument) {
            this.content = oldDocument.mdDocumentContext.content();
            this.oldPackage = oldDocument.packageInstance();
            this.name = oldDocument.mdDocumentContext.name();
            this.documentId = oldDocument.mdDocumentContext.documentId();
        }

        public Modifier withContent(String content) {
            this.content = content;
            return this;
        }

        public PackageReadmeMd apply() {
            MdDocumentContext readmeMd = MdDocumentContext.from(DocumentConfig.from(this.documentId, this.content, this.name));
            Package newPackage = this.oldPackage.modify().updatePackageMd(readmeMd).apply();
            return newPackage.readmeMd().get();
        }
    }
}

