/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.internal.DefaultDiagnosticResult;
import io.ballerina.projects.internal.model.Central;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.internal.model.Repository;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.util.Collections;

public class Settings {
    private final Proxy proxy;
    private final Central central;
    private final Repository[] repositories;
    private final DiagnosticResult diagnostics;

    private Settings(Proxy proxy, Central central, DiagnosticResult diagnostics, Repository[] repositories) {
        this.proxy = proxy;
        this.central = central;
        this.diagnostics = diagnostics;
        this.repositories = repositories;
    }

    public static Settings from(Proxy proxy, Central central, DiagnosticResult diagnostics, Repository[] repositories) {
        return new Settings(proxy, central, diagnostics, repositories);
    }

    public static Settings from() {
        return new Settings(Proxy.from(), Central.from(), new DefaultDiagnosticResult(Collections.emptyList()), null);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Central getCentral() {
        return this.central;
    }

    public DiagnosticResult diagnostics() {
        return this.diagnostics;
    }

    public Repository[] getRepositories() {
        if (this.repositories == null) {
            return new Repository[0];
        }
        return this.repositories;
    }

    public String getErrorMessage() {
        StringBuilder message = new StringBuilder();
        message.append("Settings.toml contains errors\n");
        for (Diagnostic diagnostic : this.diagnostics().errors()) {
            message.append(this.convertDiagnosticToString(diagnostic));
            message.append("\n");
        }
        return message.toString();
    }

    private String convertDiagnosticToString(Diagnostic diagnostic) {
        LineRange lineRange = diagnostic.location().lineRange();
        LineRange oneBasedLineRange = LineRange.from((String)lineRange.fileName(), (LinePosition)LinePosition.from((int)lineRange.startLine().line(), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)lineRange.endLine().line(), (int)(lineRange.endLine().offset() + 1)));
        return diagnostic.diagnosticInfo().severity().toString() + " [" + oneBasedLineRange.fileName() + ":" + String.valueOf(oneBasedLineRange) + "] " + diagnostic.message();
    }
}

