/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects;

import io.ballerina.projects.ProjectException;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlTransformer;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;

public class TomlDocument {
    private final String fileName;
    private final String content;
    private TextDocument textDocument;
    private SyntaxTree syntaxTree;
    private Toml toml;

    protected TomlDocument(String fileName, String content) {
        this.fileName = fileName;
        this.content = content;
    }

    public static TomlDocument from(String fileName, String content) {
        return new TomlDocument(fileName, content);
    }

    public Toml toml() {
        if (this.toml != null) {
            return this.toml;
        }
        this.parseToml();
        return this.toml;
    }

    public SyntaxTree syntaxTree() {
        if (this.syntaxTree != null) {
            return this.syntaxTree;
        }
        this.parseToml();
        return this.syntaxTree;
    }

    public TextDocument textDocument() {
        if (this.textDocument != null) {
            return this.textDocument;
        }
        this.textDocument = TextDocuments.from((String)this.content);
        return this.textDocument;
    }

    private void parseToml() {
        try {
            this.textDocument = TextDocuments.from((String)this.content);
            this.syntaxTree = SyntaxTree.from((TextDocument)this.textDocument, (String)this.fileName);
            TomlTransformer nodeTransformer = new TomlTransformer();
            TomlTableNode transformedTable = (TomlTableNode)nodeTransformer.transform((DocumentNode)this.syntaxTree.rootNode());
            this.toml = new Toml(transformedTable);
        }
        catch (RuntimeException e) {
            throw new ProjectException("Failed to parse file: " + this.fileName, e);
        }
    }
}

