/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.environment.ResolutionResponse;
import java.util.Optional;

public class PackageMetadataResponse {
    private final ResolutionRequest packageLoadRequest;
    private final PackageDescriptor packageDescriptor;
    private final DependencyGraph<PackageDescriptor> dependencyGraph;
    private final ResolutionResponse.ResolutionStatus resolutionStatus;

    private PackageMetadataResponse(ResolutionRequest packageLoadRequest, PackageDescriptor resolvedDescriptor, DependencyGraph<PackageDescriptor> dependencyGraph, ResolutionResponse.ResolutionStatus resolutionStatus) {
        this.packageLoadRequest = packageLoadRequest;
        this.packageDescriptor = resolvedDescriptor;
        this.dependencyGraph = dependencyGraph;
        this.resolutionStatus = resolutionStatus;
    }

    public static PackageMetadataResponse from(ResolutionRequest packageLoadRequest, PackageDescriptor resolvedDescriptor, DependencyGraph<PackageDescriptor> dependencyGraph) {
        return new PackageMetadataResponse(packageLoadRequest, resolvedDescriptor, dependencyGraph, ResolutionResponse.ResolutionStatus.RESOLVED);
    }

    public static PackageMetadataResponse createUnresolvedResponse(ResolutionRequest packageLoadRequest) {
        return new PackageMetadataResponse(packageLoadRequest, null, null, ResolutionResponse.ResolutionStatus.UNRESOLVED);
    }

    public PackageDescriptor resolvedDescriptor() {
        return this.packageDescriptor;
    }

    public ResolutionRequest packageLoadRequest() {
        return this.packageLoadRequest;
    }

    public Optional<DependencyGraph<PackageDescriptor>> dependencyGraph() {
        return Optional.ofNullable(this.dependencyGraph);
    }

    public ResolutionResponse.ResolutionStatus resolutionStatus() {
        return this.resolutionStatus;
    }
}

