/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.environment;

import io.ballerina.projects.BuildTool;
import io.ballerina.projects.BuildToolId;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.environment.PackageLockingMode;
import java.util.Objects;
import java.util.Optional;

public final class ToolResolutionRequest {
    private final BuildTool tool;
    private final PackageLockingMode packageLockingMode;

    private ToolResolutionRequest(BuildTool tool, PackageLockingMode packageLockingMode) {
        this.tool = tool;
        this.packageLockingMode = packageLockingMode;
    }

    public static ToolResolutionRequest from(BuildTool tool, PackageLockingMode packageLockingMode) {
        return new ToolResolutionRequest(tool, packageLockingMode);
    }

    public BuildToolId id() {
        return this.tool.id();
    }

    public Optional<PackageVersion> version() {
        return Optional.ofNullable(this.tool.version());
    }

    public PackageLockingMode packageLockingMode() {
        return this.packageLockingMode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ToolResolutionRequest that = (ToolResolutionRequest)other;
        return Objects.equals(this.tool, that.tool);
    }

    public int hashCode() {
        return Objects.hash(this.tool);
    }
}

