/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyResolutionType;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.PackageDependencyScope;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.environment.ModuleLoadRequest;
import io.ballerina.projects.environment.PackageResolver;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionResponse;
import io.ballerina.projects.internal.BlendedManifest;
import io.ballerina.projects.internal.ImportModuleRequest;
import io.ballerina.projects.internal.ImportModuleResponse;
import io.ballerina.projects.internal.PackageContainer;
import io.ballerina.projects.util.ProjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ModuleResolver {
    private final Map<ImportModuleRequest, ImportModuleResponse> responseMap = new HashMap<ImportModuleRequest, ImportModuleResponse>();
    private final PackageDescriptor rootPkgDesc;
    private final Collection<ModuleName> moduleNames;
    private final BlendedManifest blendedManifest;
    private final PackageResolver packageResolver;
    private final ResolutionOptions resolutionOptions;

    public ModuleResolver(PackageDescriptor rootPkgDesc, Collection<ModuleName> moduleNames, BlendedManifest blendedManifest, PackageResolver packageResolver, ResolutionOptions resolutionOptions) {
        this.rootPkgDesc = rootPkgDesc;
        this.moduleNames = moduleNames;
        this.blendedManifest = blendedManifest;
        this.packageResolver = packageResolver;
        this.resolutionOptions = resolutionOptions;
    }

    public ImportModuleResponse getImportModuleResponse(ImportModuleRequest importModuleRequest) {
        return this.responseMap.get(importModuleRequest);
    }

    public PackageContainer<DirectPackageDependency> resolveModuleLoadRequests(Collection<ModuleLoadRequest> moduleLoadRequests) {
        PackageContainer<DirectPackageDependency> pkgContainer = new PackageContainer<DirectPackageDependency>();
        ArrayList<ImportModuleRequest> unresolvedModuleRequests = new ArrayList<ImportModuleRequest>();
        for (ModuleLoadRequest moduleLoadRequest : moduleLoadRequests) {
            this.resolveModuleLoadRequest(moduleLoadRequest, pkgContainer, unresolvedModuleRequests);
        }
        if (unresolvedModuleRequests.isEmpty()) {
            return pkgContainer;
        }
        Collection<ImportModuleResponse> importModResponses = this.packageResolver.resolvePackageNames(unresolvedModuleRequests, this.resolutionOptions);
        for (ImportModuleResponse importModResp : importModResponses) {
            DirectPackageDependency newPkgDep;
            if (importModResp.resolutionStatus() == ResolutionResponse.ResolutionStatus.UNRESOLVED) continue;
            ImportModuleRequest importModuleRequest = importModResp.importModuleRequest();
            PackageDescriptor pkgDesc = importModResp.packageDescriptor();
            Optional<DirectPackageDependency> pkgDepOptional = pkgContainer.get(pkgDesc.org(), pkgDesc.name());
            ModuleLoadRequest moduleLoadRequest = importModuleRequest.moduleLoadRequest();
            if (pkgDepOptional.isEmpty()) {
                newPkgDep = new DirectPackageDependency(pkgDesc, DirectPackageDependencyKind.NEW, moduleLoadRequest.scope(), moduleLoadRequest.dependencyResolvedType());
            } else {
                DirectPackageDependency currentPkgDep = pkgDepOptional.get();
                PackageDependencyScope scope = currentPkgDep.scope() == PackageDependencyScope.DEFAULT ? PackageDependencyScope.DEFAULT : moduleLoadRequest.scope();
                DependencyResolutionType resolutionType = currentPkgDep.resolutionType() == DependencyResolutionType.SOURCE ? DependencyResolutionType.SOURCE : moduleLoadRequest.dependencyResolvedType();
                newPkgDep = new DirectPackageDependency(pkgDesc, DirectPackageDependencyKind.NEW, scope, resolutionType);
            }
            pkgContainer.add(pkgDesc.org(), pkgDesc.name(), newPkgDep);
            this.responseMap.put(importModuleRequest, importModResp);
        }
        return pkgContainer;
    }

    private void resolveModuleLoadRequest(ModuleLoadRequest moduleLoadRequest, PackageContainer<DirectPackageDependency> pkgContainer, List<ImportModuleRequest> unresolvedModuleRequests) {
        PackageName pkgName;
        PackageDescriptor pkgDesc;
        PackageOrg pkgOrg = this.getPackageOrg(moduleLoadRequest);
        String moduleName = moduleLoadRequest.moduleName();
        List<PackageName> possiblePkgNames = ProjectUtils.getPossiblePackageNames(pkgOrg, moduleLoadRequest.moduleName());
        if (ProjectUtils.isBuiltInPackage(pkgOrg, moduleName)) {
            pkgDesc = PackageDescriptor.from(pkgOrg, PackageName.from(moduleName));
        } else if (possiblePkgNames.size() == 1) {
            pkgName = PackageName.from(moduleName);
            pkgDesc = this.createPkgDesc(pkgOrg, pkgName, this.blendedManifest.dependency(pkgOrg, pkgName).orElse(null));
        } else {
            pkgDesc = this.findHierarchicalModule(moduleName, pkgOrg, possiblePkgNames);
        }
        if (pkgDesc == null) {
            ArrayList<PackageDescriptor> possiblePackages = new ArrayList<PackageDescriptor>();
            for (PackageName possiblePkgName : possiblePkgNames) {
                Optional<BlendedManifest.Dependency> dependency = this.blendedManifest.dependency(pkgOrg, possiblePkgName);
                dependency.ifPresent(value -> possiblePackages.add(this.createPkgDesc(pkgOrg, possiblePkgName, (BlendedManifest.Dependency)value)));
            }
            ImportModuleRequest importModuleRequest = new ImportModuleRequest(pkgOrg, moduleLoadRequest, possiblePackages);
            unresolvedModuleRequests.add(importModuleRequest);
            return;
        }
        pkgName = pkgDesc.name();
        if (this.isRootPackage(pkgOrg, pkgName)) {
            ImportModuleRequest importModuleRequest = new ImportModuleRequest(pkgOrg, moduleLoadRequest);
            this.responseMap.put(importModuleRequest, new ImportModuleResponse(PackageDescriptor.from(pkgOrg, pkgName), importModuleRequest));
            return;
        }
        Optional<DirectPackageDependency> pkgDepOptional = pkgContainer.get(pkgOrg, pkgName);
        if (pkgDepOptional.isEmpty()) {
            DirectPackageDependencyKind dependencyKind = this.blendedManifest.lockedDependency(pkgDesc.org(), pkgDesc.name()).isEmpty() ? DirectPackageDependencyKind.NEW : DirectPackageDependencyKind.EXISTING;
            pkgContainer.add(pkgOrg, pkgName, new DirectPackageDependency(pkgDesc, dependencyKind, moduleLoadRequest.scope(), moduleLoadRequest.dependencyResolvedType()));
        } else {
            DirectPackageDependency currentPkgDep = pkgDepOptional.get();
            DependencyResolutionType resolutionType = currentPkgDep.resolutionType() == DependencyResolutionType.SOURCE ? DependencyResolutionType.SOURCE : moduleLoadRequest.dependencyResolvedType();
            PackageDependencyScope scope = currentPkgDep.scope() == PackageDependencyScope.DEFAULT ? PackageDependencyScope.DEFAULT : moduleLoadRequest.scope();
            DirectPackageDependencyKind directDepKind = currentPkgDep.dependencyKind() == DirectPackageDependencyKind.EXISTING ? DirectPackageDependencyKind.EXISTING : currentPkgDep.dependencyKind();
            pkgContainer.add(pkgOrg, pkgName, new DirectPackageDependency(pkgDesc, directDepKind, scope, resolutionType));
        }
        ImportModuleRequest importModuleRequest = new ImportModuleRequest(pkgOrg, moduleLoadRequest);
        this.responseMap.put(importModuleRequest, new ImportModuleResponse(pkgDesc, importModuleRequest));
    }

    private PackageDescriptor findHierarchicalModule(String moduleName, PackageOrg packageOrg, Collection<PackageName> possiblePkgNames) {
        for (PackageName possiblePkgName : possiblePkgNames) {
            PackageDescriptor pkgDesc = this.findHierarchicalModule(moduleName, packageOrg, possiblePkgName);
            if (pkgDesc == null) continue;
            return pkgDesc;
        }
        return null;
    }

    private PackageDescriptor findHierarchicalModule(String moduleName, PackageOrg packageOrg, PackageName packageName) {
        PackageDescriptor pkgDesc = this.findModuleInRootPackage(moduleName, packageOrg, packageName);
        if (pkgDesc != null) {
            return pkgDesc;
        }
        return this.findModuleInBlendedManifest(moduleName, packageOrg, packageName);
    }

    private PackageDescriptor findModuleInRootPackage(String moduleName, PackageOrg packageOrg, PackageName packageName) {
        if (packageOrg.equals(this.rootPkgDesc.org()) && packageName.equals(this.rootPkgDesc.name())) {
            for (ModuleName rootPkgModName : this.moduleNames) {
                if (!rootPkgModName.toString().equals(moduleName)) continue;
                return this.rootPkgDesc;
            }
        }
        return null;
    }

    private boolean isRootPackage(PackageOrg pkgOrg, PackageName pkgName) {
        return pkgOrg.equals(this.rootPkgDesc.org()) && pkgName.equals(this.rootPkgDesc.name());
    }

    private PackageDescriptor findModuleInBlendedManifest(String moduleName, PackageOrg packageOrg, PackageName packageName) {
        Optional<BlendedManifest.Dependency> blendedDep = this.blendedManifest.dependency(packageOrg, packageName);
        if (blendedDep.isPresent() && blendedDep.get().moduleNames().contains(moduleName)) {
            return this.createPkgDesc(packageOrg, packageName, blendedDep.get());
        }
        return null;
    }

    private PackageOrg getPackageOrg(ModuleLoadRequest moduleLoadRequest) {
        Optional<PackageOrg> optionalOrgName = moduleLoadRequest.orgName();
        return optionalOrgName.orElseGet(this.rootPkgDesc::org);
    }

    private PackageDescriptor createPkgDesc(PackageOrg packageOrg, PackageName packageName, BlendedManifest.Dependency blendedDep) {
        if (blendedDep != null && blendedDep.isFromLocalRepository()) {
            return PackageDescriptor.from(packageOrg, packageName, blendedDep.version(), "local");
        }
        return PackageDescriptor.from(packageOrg, packageName, blendedDep != null ? blendedDep.version() : null);
    }

    public static class DirectPackageDependency {
        private final PackageDescriptor pkgDesc;
        private final DirectPackageDependencyKind dependencyKind;
        private final PackageDependencyScope scope;
        private final DependencyResolutionType resolutionType;

        public DirectPackageDependency(PackageDescriptor pkgDesc, DirectPackageDependencyKind dependencyKind, PackageDependencyScope scope, DependencyResolutionType resolutionType) {
            this.pkgDesc = pkgDesc;
            this.dependencyKind = dependencyKind;
            this.scope = scope;
            this.resolutionType = resolutionType;
        }

        public PackageDescriptor pkgDesc() {
            return this.pkgDesc;
        }

        public DirectPackageDependencyKind dependencyKind() {
            return this.dependencyKind;
        }

        public PackageDependencyScope scope() {
            return this.scope;
        }

        public DependencyResolutionType resolutionType() {
            return this.resolutionType;
        }
    }

    public static enum DirectPackageDependencyKind {
        EXISTING,
        NEW;

    }
}

