/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal;

import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.internal.DocumentData;
import io.ballerina.projects.internal.ModuleData;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class PackageData {
    private final Path packagePath;
    private final ModuleData defaultModule;
    private final List<ModuleData> otherModules;
    private final DependencyGraph<PackageDescriptor> packageDesDependencyGraph;
    private final DependencyGraph<ModuleDescriptor> moduleDependencyGraph;
    private final DocumentData ballerinaToml;
    private final DocumentData dependenciesToml;
    private final DocumentData cloudToml;
    private final DocumentData compilerPluginToml;
    private final DocumentData balToolToml;
    private final DocumentData readmeMd;
    private final List<Path> resources;
    private final List<Path> testResources;

    private PackageData(Path packagePath, ModuleData defaultModule, List<ModuleData> otherModules, DependencyGraph<PackageDescriptor> packageDesDependencyGraph, DependencyGraph<ModuleDescriptor> moduleDependencyGraph, DocumentData ballerinaToml, DocumentData dependenciesToml, DocumentData cloudToml, DocumentData compilerPluginToml, DocumentData balToolToml, DocumentData readmeMd, List<Path> resources, List<Path> testResources) {
        this.packagePath = packagePath;
        this.defaultModule = defaultModule;
        this.otherModules = otherModules;
        this.packageDesDependencyGraph = packageDesDependencyGraph;
        this.moduleDependencyGraph = moduleDependencyGraph;
        this.readmeMd = readmeMd;
        this.ballerinaToml = ballerinaToml;
        this.dependenciesToml = dependenciesToml;
        this.cloudToml = cloudToml;
        this.compilerPluginToml = compilerPluginToml;
        this.balToolToml = balToolToml;
        this.resources = resources;
        this.testResources = testResources;
    }

    public static PackageData from(Path packagePath, ModuleData defaultModule, List<ModuleData> otherModules, DocumentData ballerinaToml, DocumentData dependenciesToml, DocumentData cloudToml, DocumentData compilerPluginToml, DocumentData balToolToml, DocumentData readmeMd, List<Path> resources, List<Path> testResources) {
        return new PackageData(packagePath, defaultModule, otherModules, DependencyGraph.emptyGraph(), DependencyGraph.emptyGraph(), ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, readmeMd, resources, testResources);
    }

    public static PackageData from(Path packagePath, ModuleData defaultModule, List<ModuleData> otherModules, DependencyGraph<PackageDescriptor> packageDesDependencyGraph, DependencyGraph<ModuleDescriptor> moduleDependencyGraph, DocumentData ballerinaToml, DocumentData dependenciesToml, DocumentData cloudToml, DocumentData compilerPluginToml, DocumentData balToolToml, DocumentData packageMd, List<Path> resources, List<Path> testResources) {
        return new PackageData(packagePath, defaultModule, otherModules, packageDesDependencyGraph, moduleDependencyGraph, ballerinaToml, dependenciesToml, cloudToml, compilerPluginToml, balToolToml, packageMd, resources, testResources);
    }

    public Path packagePath() {
        return this.packagePath;
    }

    public ModuleData defaultModule() {
        return this.defaultModule;
    }

    public List<ModuleData> otherModules() {
        return this.otherModules;
    }

    public DependencyGraph<PackageDescriptor> packageDescriptorDependencyGraph() {
        return this.packageDesDependencyGraph;
    }

    public DependencyGraph<ModuleDescriptor> moduleDependencyGraph() {
        return this.moduleDependencyGraph;
    }

    public Optional<DocumentData> ballerinaToml() {
        return Optional.ofNullable(this.ballerinaToml);
    }

    public Optional<DocumentData> dependenciesToml() {
        return Optional.ofNullable(this.dependenciesToml);
    }

    public Optional<DocumentData> cloudToml() {
        return Optional.ofNullable(this.cloudToml);
    }

    public Optional<DocumentData> compilerPluginToml() {
        return Optional.ofNullable(this.compilerPluginToml);
    }

    public Optional<DocumentData> balToolToml() {
        return Optional.ofNullable(this.balToolToml);
    }

    @Deprecated(forRemoval=true)
    public Optional<DocumentData> packageMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    public Optional<DocumentData> readmeMd() {
        return Optional.ofNullable(this.readmeMd);
    }

    public List<Path> resources() {
        return this.resources;
    }

    public List<Path> testResources() {
        return this.testResources;
    }
}

