/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.configschema;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.configurations.ConfigModuleDetails;
import io.ballerina.projects.configurations.ConfigVariable;
import io.ballerina.projects.internal.configschema.TypeConverter;
import java.util.List;
import java.util.Map;

public class ConfigSchemaBuilder {
    public String getConfigSchemaContent(Map<ConfigModuleDetails, List<ConfigVariable>> configDetails) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)this.getRootNode(configDetails));
    }

    private JsonObject getRootNode(Map<ConfigModuleDetails, List<ConfigVariable>> configDetails) {
        JsonObject rootNode = new JsonObject();
        JsonObject root = new JsonObject();
        root.addProperty("$schema", "http://json-schema.org/draft-07/schema#");
        root.addProperty("type", "object");
        root.add("properties", (JsonElement)rootNode);
        root.addProperty("additionalProperties", Boolean.valueOf(false));
        for (Map.Entry<ConfigModuleDetails, List<ConfigVariable>> configModuleDetails : configDetails.entrySet()) {
            JsonObject pkgNode;
            List<ConfigVariable> configVariables = configModuleDetails.getValue();
            if (ProjectKind.SINGLE_FILE_PROJECT.equals((Object)configModuleDetails.getKey().projectKind())) {
                this.setConfigVariables(configVariables, rootNode);
                ConfigSchemaBuilder.setRequiredConfigs(configVariables, root);
                continue;
            }
            JsonElement orgJsonNode = rootNode.get(configModuleDetails.getKey().orgName());
            JsonObject orgNode = orgJsonNode == null ? TypeConverter.createObjNode(new JsonObject()) : (JsonObject)orgJsonNode;
            JsonObject orgPropertiesNode = (JsonObject)orgNode.get("properties");
            JsonElement pkgJsonNode = orgPropertiesNode.get(configModuleDetails.getKey().packageName());
            if (pkgJsonNode == null) {
                pkgNode = TypeConverter.createObjNode(new JsonObject());
                orgPropertiesNode.add(configModuleDetails.getKey().packageName(), (JsonElement)pkgNode);
            } else {
                pkgNode = (JsonObject)pkgJsonNode;
            }
            JsonObject packagePropertiesNode = (JsonObject)pkgNode.get("properties");
            if (configModuleDetails.getKey().moduleName().equals(configModuleDetails.getKey().packageName())) {
                this.setConfigVariables(configVariables, packagePropertiesNode);
                ConfigSchemaBuilder.setRequiredConfigs(configVariables, pkgNode);
            } else {
                JsonObject modVarNode = new JsonObject();
                JsonObject modObjNode = TypeConverter.createObjNode(this.setConfigVariables(configVariables, modVarNode));
                ConfigSchemaBuilder.setRequiredConfigs(configVariables, modObjNode);
                packagePropertiesNode.add(configModuleDetails.getKey().moduleName(), (JsonElement)modObjNode);
            }
            rootNode.add(configModuleDetails.getKey().orgName(), (JsonElement)orgNode);
        }
        return root;
    }

    private static void setRequiredConfigs(List<ConfigVariable> configVariables, JsonObject modObjNode) {
        JsonArray requiredConfigs = ConfigSchemaBuilder.getRequiredConfigs(configVariables);
        if (!requiredConfigs.isEmpty()) {
            modObjNode.add("required", (JsonElement)requiredConfigs);
        }
    }

    private static JsonArray getRequiredConfigs(List<ConfigVariable> configVariables) {
        JsonArray requiredConfigs = new JsonArray();
        for (ConfigVariable configVariable : configVariables) {
            if (!configVariable.isRequired()) continue;
            requiredConfigs.add(configVariable.name());
        }
        return requiredConfigs;
    }

    private JsonObject setConfigVariables(List<ConfigVariable> configVariables, JsonObject node) {
        for (ConfigVariable configVariable : configVariables) {
            if (configVariable.type() == null) continue;
            JsonObject typeNode = new TypeConverter().getType(configVariable.type());
            typeNode.addProperty("description", configVariable.description());
            node.add(configVariable.name(), (JsonElement)typeNode);
        }
        return node;
    }
}

