/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.ProjectException;
import io.ballerina.projects.Settings;
import io.ballerina.projects.TomlDocument;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.internal.SettingsBuilder;
import io.ballerina.projects.internal.model.Repository;
import io.ballerina.projects.internal.repositories.CustomPkgRepositoryContainer;
import io.ballerina.projects.internal.repositories.LocalPackageRepository;
import io.ballerina.projects.internal.repositories.MavenPackageRepository;
import io.ballerina.projects.internal.repositories.RemotePackageRepository;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.wso2.ballerinalang.util.RepoUtils;

public final class BallerinaUserHome {
    private final Path ballerinaUserHomeDirPath;
    private final RemotePackageRepository remotePackageRepository;
    private final LocalPackageRepository localPackageRepository;
    private final Map<String, MavenPackageRepository> mavenCustomRepositories;

    private BallerinaUserHome(Environment environment, Path ballerinaUserHomeDirPath) {
        this.ballerinaUserHomeDirPath = ballerinaUserHomeDirPath;
        Path repositoryPath = ballerinaUserHomeDirPath.resolve("repositories");
        Path remotePackageRepositoryPath = ballerinaUserHomeDirPath.resolve("repositories").resolve("central.ballerina.io");
        try {
            Files.createDirectories(remotePackageRepositoryPath, new FileAttribute[0]);
        }
        catch (AccessDeniedException ae) {
            throw new ProjectException("permission denied to create the directory: " + String.valueOf(repositoryPath));
        }
        catch (IOException exception) {
            throw new ProjectException("unable to create the file system cache of Ballerina Central repository: " + String.valueOf(remotePackageRepositoryPath));
        }
        this.remotePackageRepository = RemotePackageRepository.from(environment, remotePackageRepositoryPath, this.readSettings());
        this.localPackageRepository = this.createLocalRepository(environment);
        this.mavenCustomRepositories = this.createMavenCustomRepositories(environment);
    }

    private Map<String, MavenPackageRepository> createMavenCustomRepositories(Environment environment) {
        Repository[] repositories;
        HashMap<String, MavenPackageRepository> customRepositories = new HashMap<String, MavenPackageRepository>();
        for (Repository repository : repositories = this.readSettings().getRepositories()) {
            Path repositoryPath = this.ballerinaUserHomeDirPath.resolve("repositories").resolve(repository.id());
            try {
                Files.createDirectories(repositoryPath, new FileAttribute[0]);
            }
            catch (IOException exception) {
                throw new ProjectException("unable to create repository: local");
            }
            if (customRepositories.containsKey(repository.id())) continue;
            customRepositories.put(repository.id(), MavenPackageRepository.from(environment, repositoryPath, repository));
        }
        return customRepositories;
    }

    public static BallerinaUserHome from(Environment environment, Path ballerinaUserHomeDirPath) {
        BallerinaUserHome.validateBallerinaUserHomeDir(ballerinaUserHomeDirPath);
        return new BallerinaUserHome(environment, ballerinaUserHomeDirPath);
    }

    public static BallerinaUserHome from(Environment environment) {
        String userHomeDir = System.getProperty("user.home");
        if (userHomeDir == null || userHomeDir.isEmpty()) {
            throw new ProjectException("unable to get user home directory");
        }
        Path homeRepoPath = Path.of(userHomeDir, ".ballerina");
        return BallerinaUserHome.from(environment, homeRepoPath);
    }

    public RemotePackageRepository remotePackageRepository() {
        return this.remotePackageRepository;
    }

    public Map<String, MavenPackageRepository> customRepositories() {
        return this.mavenCustomRepositories;
    }

    public CustomPkgRepositoryContainer customPkgRepositoryContainer() {
        return new CustomPkgRepositoryContainer(this.mavenCustomRepositories);
    }

    public LocalPackageRepository localPackageRepository() {
        return this.localPackageRepository;
    }

    private Settings readSettings() {
        Path settingsFilePath = this.ballerinaUserHomeDirPath.resolve("Settings.toml");
        if (Files.notExists(settingsFilePath, new LinkOption[0])) {
            try {
                Files.createFile(settingsFilePath, new FileAttribute[0]);
            }
            catch (AccessDeniedException ae) {
                throw new ProjectException("permission denied to create the file: Settings.toml in " + String.valueOf(this.ballerinaUserHomeDirPath));
            }
            catch (IOException e) {
                throw new ProjectException("failed to create file: Settings.toml in " + String.valueOf(this.ballerinaUserHomeDirPath) + " " + e.getMessage());
            }
        }
        try {
            TomlDocument settingsTomlDocument = TomlDocument.from(String.valueOf(settingsFilePath.getFileName()), Files.readString(settingsFilePath));
            SettingsBuilder settingsBuilder = SettingsBuilder.from(settingsTomlDocument);
            return settingsBuilder.settings();
        }
        catch (IOException e) {
            return Settings.from();
        }
    }

    private static void validateBallerinaUserHomeDir(Path ballerinaUserHomeDirPath) {
        if (Files.notExists(ballerinaUserHomeDirPath, new LinkOption[0]) || !Files.isDirectory(ballerinaUserHomeDirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(ballerinaUserHomeDirPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProjectException("Ballerina user home directory does not exists in '" + String.valueOf(ballerinaUserHomeDirPath) + "', Directory creation also failed");
            }
        }
    }

    private LocalPackageRepository createLocalRepository(Environment environment) {
        Path repositoryPath = this.ballerinaUserHomeDirPath.resolve("repositories").resolve("local");
        try {
            Files.createDirectories(repositoryPath, new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new ProjectException("unable to create repository: local");
        }
        String ballerinaShortVersion = RepoUtils.getBallerinaShortVersion();
        return new LocalPackageRepository(environment, repositoryPath, ballerinaShortVersion);
    }
}

