/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.environment;

import io.ballerina.projects.Project;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.PackageCache;
import io.ballerina.projects.environment.ProjectEnvironment;
import io.ballerina.projects.internal.environment.ProjectPackageCache;
import io.ballerina.projects.internal.environment.WritablePackageCache;
import java.util.Map;

public class DefaultProjectEnvironment
extends ProjectEnvironment {
    private final Map<Class<?>, Object> services;
    private final Environment environment;

    public DefaultProjectEnvironment(Project project, Environment environment, Map<Class<?>, Object> services) {
        this.environment = environment;
        this.services = services;
        WritablePackageCache globalPackageCache = (WritablePackageCache)environment.getService(PackageCache.class);
        ProjectPackageCache projectPackageCache = new ProjectPackageCache(project, globalPackageCache);
        services.put(PackageCache.class, projectPackageCache);
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        Object service = this.services.get(clazz);
        if (service == null) {
            service = this.environment.getService(clazz);
        }
        return (T)service;
    }

    @Override
    public Environment environment() {
        return this.environment;
    }
}

