/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.plugins;

import io.ballerina.compiler.internal.parser.tree.STAnnotationNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.plugins.CompilerPlugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;

public final class CompilerPlugins {
    static List<CompilerPlugin> builtInPlugins = new ArrayList<CompilerPlugin>();

    private CompilerPlugins() {
    }

    public static List<CompilerPlugin> getBuiltInPlugins() {
        return builtInPlugins;
    }

    public static CompilerPlugin loadCompilerPlugin(String pluginClassName, List<Path> jarDependencyPaths) {
        Class<CompilerPlugin> compilerPluginAbstractClass = CompilerPlugin.class;
        ClassLoader classLoader = CompilerPlugins.createClassLoader(jarDependencyPaths);
        Class<?> pluginClass = CompilerPlugins.loadPluginClass(pluginClassName, classLoader);
        if (!compilerPluginAbstractClass.isAssignableFrom(pluginClass)) {
            throw new ProjectException("Specified class '" + pluginClassName + "' is not a subclass of '" + compilerPluginAbstractClass.getName() + "'");
        }
        Constructor<?> defaultConstructor = CompilerPlugins.getDefaultConstructor(pluginClass);
        try {
            return (CompilerPlugin)defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ProjectException("Cannot create a new instance of the class '" + pluginClassName + "', reason: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ProjectException("Cannot create a new instance of the class '" + pluginClassName + "', reason: " + String.valueOf(e.getTargetException()));
        }
    }

    private static Constructor<?> getDefaultConstructor(Class<?> pluginClass) {
        try {
            return pluginClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ProjectException("Cannot find the default constructor in class: '" + pluginClass.getName() + "'");
        }
    }

    private static Class<?> loadPluginClass(String pluginClassName, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(pluginClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ProjectException("Cannot find class '" + pluginClassName + "'");
        }
    }

    private static ClassLoader createClassLoader(List<Path> jarDependencyPaths) {
        return AccessController.doPrivileged(() -> new URLClassLoader(CompilerPlugins.getJarURLS(jarDependencyPaths), Thread.currentThread().getContextClassLoader()));
    }

    private static URL[] getJarURLS(List<Path> jarDependencyPaths) {
        URL[] jarURLS = new URL[jarDependencyPaths.size()];
        for (int i = 0; i < jarDependencyPaths.size(); ++i) {
            try {
                jarURLS[i] = jarDependencyPaths.get(i).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new ProjectException(e.getMessage(), e);
            }
        }
        return jarURLS;
    }

    public static List<String> annotationsAsStr(NodeList<AnnotationNode> supportedAnnotations) {
        ArrayList<String> annotations = new ArrayList<String>();
        StringBuilder id = new StringBuilder();
        for (AnnotationNode annotation : supportedAnnotations) {
            String annotationRef = ((STAnnotationNode)annotation.internalNode()).annotReference.toString().replaceAll("\\s", "");
            id.append(annotationRef);
            String annotationVal = ((STAnnotationNode)annotation.internalNode()).annotValue.toString().replaceAll("\\s", "");
            id.append(annotationVal);
            annotations.add(id.toString());
        }
        annotations.sort(Comparator.naturalOrder());
        return annotations;
    }

    static {
        ServiceLoader<CompilerPlugin> pluginServiceLoader = ServiceLoader.load(CompilerPlugin.class, CompilerPlugins.class.getClassLoader());
        for (CompilerPlugin plugin : pluginServiceLoader) {
            builtInPlugins.add(plugin);
        }
    }
}

