/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.internal.repositories;

import com.github.zafarkhaja.semver.UnexpectedCharacterException;
import com.github.zafarkhaja.semver.Version;
import io.ballerina.projects.DependencyGraph;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageDescriptor;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.environment.Environment;
import io.ballerina.projects.environment.ResolutionOptions;
import io.ballerina.projects.environment.ResolutionRequest;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.repositories.AbstractPackageRepository;
import io.ballerina.projects.repos.FileSystemCache;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.wso2.ballerinalang.util.RepoUtils;

public class FileSystemRepository
extends AbstractPackageRepository {
    Path bala;
    private final Path cacheDir;
    private final Environment environment;

    public FileSystemRepository(Environment environment, Path cacheDirectory) {
        this.cacheDir = cacheDirectory.resolve("cache");
        this.bala = cacheDirectory.resolve("bala");
        this.environment = environment;
    }

    public FileSystemRepository(Environment environment, Path cacheDirectory, String distributionVersion) {
        this.cacheDir = cacheDirectory.resolve("cache-" + distributionVersion);
        this.bala = cacheDirectory.resolve("bala");
        this.environment = environment;
    }

    @Override
    public Optional<Package> getPackage(ResolutionRequest request, ResolutionOptions options) {
        String version;
        String packageName = request.packageName().value();
        String orgName = request.orgName().value();
        Path balaPath = this.getPackagePath(orgName, packageName, version = request.version().isPresent() ? request.version().get().toString() : "0.0.0");
        if (!Files.exists(balaPath, new LinkOption[0])) {
            return Optional.empty();
        }
        ProjectEnvironmentBuilder environmentBuilder = ProjectEnvironmentBuilder.getBuilder(this.environment);
        environmentBuilder = environmentBuilder.addCompilationCacheFactory(new FileSystemCache.FileSystemCacheFactory(this.cacheDir));
        BalaProject project = BalaProject.loadProject(environmentBuilder, balaPath);
        return Optional.of(project.currentPackage());
    }

    void updateDeprecatedStatusForPackage(PackageDescriptor descriptor) {
        Path balaPath = this.getPackagePath(descriptor.org().value(), descriptor.name().value(), descriptor.version().value().toString());
        if (balaPath != null && Files.exists(balaPath, new LinkOption[0])) {
            Path deprecateMsgMetaFile = Path.of(balaPath.toString(), "deprecated.txt");
            if (descriptor.getDeprecated().booleanValue() && !deprecateMsgMetaFile.toFile().exists()) {
                FileUtils.addDeprecatedMetaFile(deprecateMsgMetaFile, descriptor.getDeprecationMsg());
            }
            if (!descriptor.getDeprecated().booleanValue() && deprecateMsgMetaFile.toFile().exists()) {
                FileUtils.deleteDeprecatedMetaFile(deprecateMsgMetaFile);
            }
        }
    }

    @Override
    public boolean isPackageExists(PackageOrg org, PackageName name, PackageVersion version) {
        if (org.value() == null || name.value() == null) {
            return false;
        }
        Path balaPath = this.getPackagePath(org.value(), name.value(), version.value().toString());
        return Files.exists(balaPath, new LinkOption[0]);
    }

    @Override
    public Collection<PackageVersion> getPackageVersions(ResolutionRequest request, ResolutionOptions options) {
        return this.getPackageVersions(request.orgName(), request.packageName(), request.version().orElse(null));
    }

    @Override
    public Map<String, List<String>> getPackages() {
        HashMap<String, List<String>> packagesMap = new HashMap<String, List<String>>();
        File[] orgDirs = this.bala.toFile().listFiles();
        if (orgDirs == null) {
            return packagesMap;
        }
        for (File file : orgDirs) {
            String orgName;
            File[] filesList;
            if (!file.isDirectory() || file.isHidden() || (filesList = this.bala.resolve(orgName = file.getName()).toFile().listFiles()) == null || filesList.length == 0) continue;
            ArrayList<CallSite> pkgList = new ArrayList<CallSite>();
            for (File pkgDir : filesList) {
                File[] pkgs;
                if (!pkgDir.isDirectory() || (pkgs = this.bala.resolve(orgName).resolve(pkgDir.getName()).toFile().listFiles()) == null) continue;
                ArrayList<String> versions = new ArrayList<String>();
                for (File listFile : pkgs) {
                    if (listFile.isHidden() || !listFile.isDirectory()) continue;
                    versions.add(listFile.getName());
                }
                if (versions.isEmpty()) continue;
                for (String version : versions) {
                    try {
                        PackageVersion.from(version);
                    }
                    catch (ProjectException ignored) {
                        continue;
                    }
                    pkgList.add((CallSite)((Object)(pkgDir.getName() + ":" + version)));
                }
            }
            packagesMap.put(orgName, pkgList);
        }
        return packagesMap;
    }

    @Override
    protected List<PackageVersion> getPackageVersions(PackageOrg org, PackageName name, PackageVersion version) {
        ArrayList<Path> versions;
        block8: {
            versions = new ArrayList<Path>();
            try {
                Path balaPackagePath = this.bala.resolve(org.value()).resolve(name.value());
                if (!Files.exists(balaPackagePath, new LinkOption[0])) break block8;
                try (Stream<Path> collect = Files.list(balaPackagePath);){
                    versions.addAll(collect.toList());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while accessing Distribution cache: " + e.getMessage());
            }
        }
        versions.removeAll(this.getIncompatibleVer(versions, org, name));
        return this.pathToVersions(versions);
    }

    protected List<Path> getIncompatibleVer(List<Path> versions, PackageOrg org, PackageName name) {
        ArrayList<Path> incompatibleVersions = new ArrayList<Path>();
        if (!versions.isEmpty()) {
            for (Path ver : versions) {
                Path pkgJsonPath = this.getPackagePath(org.value(), name.value(), Optional.of(ver.getFileName()).get().toFile().getName()).resolve("package.json");
                if (Files.exists(pkgJsonPath, new LinkOption[0])) {
                    String packVer;
                    String packageVer = BalaFiles.readPkgJson(pkgJsonPath).getBallerinaVersion();
                    if (this.isCompatible(packageVer, packVer = RepoUtils.getBallerinaShortVersion())) continue;
                    incompatibleVersions.add(ver);
                    continue;
                }
                incompatibleVersions.add(ver);
            }
        }
        return incompatibleVersions;
    }

    private boolean isCompatible(String pkgBalVer, String distBalVer) {
        if (pkgBalVer.equals(distBalVer) || pkgBalVer.startsWith("slbeta")) {
            return true;
        }
        try {
            Version pkgSemVer = Version.valueOf((String)pkgBalVer);
            Version distSemVer = Version.valueOf((String)distBalVer);
            if (pkgSemVer.getMajorVersion() == distSemVer.getMajorVersion()) {
                if (pkgSemVer.getMinorVersion() == distSemVer.getMinorVersion()) {
                    return true;
                }
                return !pkgSemVer.greaterThan(distSemVer);
            }
        }
        catch (UnexpectedCharacterException unexpectedCharacterException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected DependencyGraph<PackageDescriptor> getDependencyGraph(PackageOrg org, PackageName name, PackageVersion version) {
        Path balaPath = this.getPackagePath(org.toString(), name.toString(), version.toString());
        BalaFiles.DependencyGraphResult dependencyGraphResult = BalaFiles.createPackageDependencyGraph(balaPath);
        return dependencyGraphResult.packageDependencyGraph();
    }

    @Override
    public Collection<ModuleDescriptor> getModules(PackageOrg org, PackageName name, PackageVersion version) {
        Path balaPath = this.getPackagePath(org.toString(), name.toString(), version.toString());
        BalaFiles.DependencyGraphResult dependencyGraphResult = BalaFiles.createPackageDependencyGraph(balaPath);
        return dependencyGraphResult.moduleDependencies().keySet();
    }

    protected Path getPackagePath(String org, String name, String version) {
        Path balaPath = this.bala.resolve(ProjectUtils.getRelativeBalaPath(org, name, version, null));
        if (!Files.exists(balaPath, new LinkOption[0])) {
            JvmTarget jvmTarget;
            JvmTarget[] jvmTargetArray = JvmTarget.values();
            int n = jvmTargetArray.length;
            for (int i = 0; i < n && !Files.exists(balaPath = this.bala.resolve(ProjectUtils.getRelativeBalaPath(org, name, version, (jvmTarget = jvmTargetArray[i]).code())), new LinkOption[0]); ++i) {
            }
        }
        return balaPath;
    }

    protected List<PackageVersion> pathToVersions(List<Path> versions) {
        ArrayList<PackageVersion> availableVersions = new ArrayList<PackageVersion>();
        versions.stream().map(path -> Optional.ofNullable(path).map(Path::getFileName).map(Path::toString).orElse("0.0.0")).forEach(version -> {
            try {
                availableVersions.add(PackageVersion.from(version));
            }
            catch (ProjectException projectException) {
                // empty catch block
            }
        });
        return availableVersions;
    }
}

