/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.repos;

import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.repos.FileSystemCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;

public class BuildProjectCompilationCache
extends FileSystemCache {
    private Path birPath;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private BuildProjectCompilationCache(Project project, Path cacheDirPath) {
        super(project, cacheDirPath.resolve("cache"));
    }

    public static BuildProjectCompilationCache from(Project project) {
        Path targetPath = project.targetDir();
        return new BuildProjectCompilationCache(project, targetPath);
    }

    @Override
    public byte[] getBir(ModuleName moduleName) {
        Path birFilePath = this.getBirPath().resolve(moduleName.toString() + ".bir");
        if (Files.exists(birFilePath, new LinkOption[0])) {
            try {
                return FileUtils.readFileToByteArray((File)birFilePath.toFile());
            }
            catch (IOException e) {
                return EMPTY_BYTE_ARRAY;
            }
        }
        return new byte[0];
    }

    private Path getBirPath() {
        if (this.birPath != null) {
            return this.birPath;
        }
        Package currentPkg = this.project.currentPackage();
        PackageManifest pkgDescriptor = currentPkg.manifest();
        Path targetCachePath = this.project.targetDir().resolve("cache");
        this.birPath = targetCachePath.resolve(pkgDescriptor.org().value()).resolve(pkgDescriptor.name().value()).resolve(pkgDescriptor.version().value().toString()).resolve("bir");
        return this.birPath;
    }
}

