/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.repos;

import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Project;
import io.ballerina.projects.repos.FileSystemCache;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempDirCompilationCache
extends FileSystemCache {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private TempDirCompilationCache(Project project, Path cacheDirPath) {
        super(project, cacheDirPath.resolve("cache"));
    }

    public static TempDirCompilationCache from(Project project) {
        Path targetPath = TempDirCompilationCache.createTempProjectRoot();
        return new TempDirCompilationCache(project, targetPath);
    }

    @Override
    public byte[] getBir(ModuleName moduleName) {
        return EMPTY_BYTE_ARRAY;
    }

    private static Path createTempProjectRoot() {
        try {
            return Files.createTempDirectory("ballerina-compilation-cache" + System.nanoTime(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating a temp directory.", e);
        }
    }
}

