/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.BalToolsManifest;
import io.ballerina.projects.BalToolsToml;
import io.ballerina.projects.BuildTool;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.PackageOrg;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.buildtools.CodeGeneratorTool;
import io.ballerina.projects.buildtools.ToolConfig;
import io.ballerina.projects.environment.PackageLockingMode;
import io.ballerina.projects.internal.BalToolsManifestBuilder;
import io.ballerina.projects.internal.BalaFiles;
import io.ballerina.projects.internal.ProjectDiagnosticErrorCode;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Stream;
import org.wso2.ballerinalang.util.RepoUtils;

public final class BuildToolUtils {
    private BuildToolUtils() {
    }

    public static TomlDiagnostic getBuildToolCommandNotFoundDiagnostic(String commandName, TomlNodeLocation location) {
        String message = "Build tool command '" + commandName + "' not found";
        ProjectDiagnosticErrorCode diagnosticCode = ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND;
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.messageKey(), DiagnosticSeverity.ERROR);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    public static TomlDiagnostic getCannotResolveBuildToolDiagnostic(String toolId, TomlNodeLocation location) {
        String message = "Build tool '" + toolId + "' cannot be resolved";
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.diagnosticId(), ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND.messageKey(), DiagnosticSeverity.ERROR);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    public static Optional<CodeGeneratorTool> getTargetTool(String commandName, ServiceLoader<CodeGeneratorTool> buildRunners) {
        String[] subcommandNames = commandName.split("\\.");
        CodeGeneratorTool[] subcommands = (CodeGeneratorTool[])buildRunners.stream().map(ServiceLoader.Provider::get).toArray(CodeGeneratorTool[]::new);
        return BuildToolUtils.getTargetToolRec(subcommandNames, 0, subcommands);
    }

    public static Optional<TomlDiagnostic> getDiagnosticIfInvalidCommandName(String fullCommandName, TomlNodeLocation location) {
        String[] subcommandNames;
        for (String subcommandName : subcommandNames = fullCommandName.split("\\.")) {
            ValidationStatus validationStatus = BuildToolUtils.validateCommandName(subcommandName);
            if (validationStatus == ValidationStatus.VALID) continue;
            return Optional.of(BuildToolUtils.getInvalidCommandNameDiagnostic(fullCommandName, validationStatus.message(), location));
        }
        return Optional.empty();
    }

    private static TomlDiagnostic getInvalidCommandNameDiagnostic(String cmdName, String reason, TomlNodeLocation location) {
        String message = "Command name '" + cmdName + "' is invalid because " + reason;
        ProjectDiagnosticErrorCode diagnosticCode = ProjectDiagnosticErrorCode.BUILD_TOOL_NOT_FOUND;
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode.diagnosticId(), diagnosticCode.messageKey(), DiagnosticSeverity.ERROR);
        return new TomlDiagnostic(location, diagnosticInfo, message);
    }

    private static Optional<CodeGeneratorTool> getTargetToolRec(String[] subcommandNames, int level, CodeGeneratorTool[] commands) {
        for (CodeGeneratorTool buildRunner : commands) {
            ToolConfig toolConfig;
            Class<?> codeGeneratorToolClass = buildRunner.getClass();
            if (!codeGeneratorToolClass.isAnnotationPresent(ToolConfig.class) || !(toolConfig = codeGeneratorToolClass.getAnnotation(ToolConfig.class)).name().equals(subcommandNames[level])) continue;
            if (level + 1 == subcommandNames.length) {
                if (toolConfig.hidden()) {
                    return Optional.empty();
                }
                return Optional.of(buildRunner);
            }
            CodeGeneratorTool[] subcommands = (CodeGeneratorTool[])Arrays.stream(toolConfig.subcommands()).map(cmdClz -> {
                try {
                    return (CodeGeneratorTool)cmdClz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new ProjectException("Error while fetching target tool: " + String.valueOf(e));
                }
            }).toArray(CodeGeneratorTool[]::new);
            return BuildToolUtils.getTargetToolRec(subcommandNames, level + 1, subcommands);
        }
        return Optional.empty();
    }

    public static boolean isToolAvailableLocally(String org, String name, String version, String repositoryName) {
        Path toolCacheDir = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve(repositoryName).resolve("bala").resolve(org).resolve(name).resolve(version);
        return toolCacheDir.toFile().isDirectory();
    }

    private static ValidationStatus validateCommandName(String cmdName) {
        ValidationStatus status = ValidationStatus.VALID;
        if (cmdName == null || cmdName.isEmpty()) {
            status = ValidationStatus.EMPTY;
        } else if (!cmdName.matches("^[\\w-]+$")) {
            status = ValidationStatus.NON_ALPHANUMERIC;
        } else if (cmdName.startsWith("_")) {
            status = ValidationStatus.LEADING_UNDERSCORE;
        } else if (cmdName.endsWith("_")) {
            status = ValidationStatus.TRAILING_UNDERSCORE;
        } else if (cmdName.contains("__")) {
            status = ValidationStatus.CONSECUTIVE_UNDERSCORES;
        }
        return status;
    }

    public static Path getCentralBalaDirPath() {
        Path userHomeDirPath = RepoUtils.createAndGetHomeReposPath();
        return userHomeDirPath.resolve(Path.of("repositories", "central.ballerina.io", "bala"));
    }

    public static TomlNodeLocation getFirstToolEntryLocation(String toolId, List<PackageManifest.Tool> toolEntries) {
        for (PackageManifest.Tool toolEntry : toolEntries) {
            if (!toolEntry.type().value().equals(toolId)) continue;
            return toolEntry.type().location();
        }
        return null;
    }

    public static Optional<BalToolsManifest.Tool> getCompatibleToolVersionsAvailableLocally(BuildTool tool, PackageVersion minVersion, PackageLockingMode packageLockingMode) {
        ProjectUtils.CompatibleRange compatibleRange;
        List<SemanticVersion> distCompatibleVersions;
        SemanticVersion minSemVer;
        List<SemanticVersion> versionsInCompatibleRange;
        Optional<SemanticVersion> latestVersion;
        PackageOrg org = tool.org();
        PackageName name = tool.name();
        if (tool.org() == null || tool.name() == null) {
            BalToolsToml balToolsToml = BalToolsToml.from(ProjectUtils.BAL_TOOLS_TOML_PATH);
            BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from(balToolsToml).build();
            Map<String, Map<String, BalToolsManifest.Tool>> toolVersions = balToolsManifest.tools().get(tool.id().toString());
            if (toolVersions == null) {
                return Optional.empty();
            }
            if (toolVersions.values().stream().findAny().isPresent()) {
                org = PackageOrg.from(toolVersions.values().stream().findAny().get().values().stream().findAny().get().org());
                name = PackageName.from(toolVersions.values().stream().findAny().get().values().stream().findAny().get().name());
            }
        }
        if ((latestVersion = BuildToolUtils.getLatestVersion(versionsInCompatibleRange = ProjectUtils.getVersionsInCompatibleRange(minSemVer = minVersion == null ? null : minVersion.value(), distCompatibleVersions = BuildToolUtils.getCompatibleToolVersions(org, name), compatibleRange = ProjectUtils.getCompatibleRange(minSemVer, packageLockingMode)))).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BalToolsManifest.Tool(tool.id().toString(), org.value(), name.value(), latestVersion.get().toString(), false, null));
    }

    private static List<SemanticVersion> getCompatibleToolVersions(PackageOrg org, PackageName name) {
        ArrayList<String> versions = new ArrayList<String>();
        Path centralBalaDirPath = BuildToolUtils.getCentralBalaDirPath();
        Path balaParentPath = centralBalaDirPath.resolve(org.value()).resolve(name.value());
        if (Files.exists(balaParentPath, new LinkOption[0])) {
            try (Stream<Path> versionFiles = Files.list(balaParentPath);){
                versions.addAll(versionFiles.map(path -> Optional.of(path.getFileName()).get().toString()).toList());
            }
            catch (IOException e) {
                throw new ProjectException("Error while accessing the central cache: " + e.getMessage());
            }
        }
        ArrayList<SemanticVersion> compatibleVersions = new ArrayList<SemanticVersion>();
        for (String version : versions) {
            String packVer;
            String packageVer;
            Path balaPackagePath = BuildToolUtils.getPackagePath(org.value(), name.value(), version);
            if (!Files.exists(balaPackagePath, new LinkOption[0]) || !BuildToolUtils.isCompatible(packageVer = BalaFiles.readPkgJson(balaPackagePath.resolve("package.json")).getBallerinaVersion(), packVer = RepoUtils.getBallerinaShortVersion())) continue;
            compatibleVersions.add(SemanticVersion.from(version));
        }
        return compatibleVersions;
    }

    public static void addToolToBalToolsToml(BuildTool tool) {
        BalToolsToml balToolsToml = BalToolsToml.from(ProjectUtils.BAL_TOOLS_TOML_PATH);
        BalToolsManifest balToolsManifest = BalToolsManifestBuilder.from(balToolsToml).build();
        balToolsManifest.addTool(tool.id().toString(), tool.org().toString(), tool.name().toString(), tool.version().toString(), false, null);
        balToolsToml.modify(balToolsManifest);
    }

    private static Path getPackagePath(String org, String name, String version) {
        Path centralBalaDirPath = BuildToolUtils.getCentralBalaDirPath();
        Path balaPath = centralBalaDirPath.resolve(ProjectUtils.getRelativeBalaPath(org, name, version, null));
        if (!Files.exists(balaPath, new LinkOption[0])) {
            JvmTarget jvmTarget;
            JvmTarget[] jvmTargetArray = JvmTarget.values();
            int n = jvmTargetArray.length;
            for (int i = 0; i < n && !Files.exists(balaPath = centralBalaDirPath.resolve(ProjectUtils.getRelativeBalaPath(org, name, version, (jvmTarget = jvmTargetArray[i]).code())), new LinkOption[0]); ++i) {
            }
        }
        return balaPath;
    }

    private static boolean isCompatible(String pkgBalVersion, String distBalVersion) {
        SemanticVersion distSemVer;
        SemanticVersion pkgSemVer;
        try {
            pkgSemVer = SemanticVersion.from(pkgBalVersion);
            distSemVer = SemanticVersion.from(distBalVersion);
        }
        catch (ProjectException ignore) {
            return false;
        }
        if (pkgSemVer.major() == distSemVer.major()) {
            if (pkgSemVer.minor() == distSemVer.minor()) {
                return true;
            }
            return !pkgSemVer.greaterThan(distSemVer);
        }
        return false;
    }

    private static Optional<SemanticVersion> getLatestVersion(List<SemanticVersion> versions) {
        if (versions.isEmpty()) {
            return Optional.empty();
        }
        SemanticVersion latestVersion = versions.get(0);
        for (SemanticVersion version : versions) {
            if (!version.greaterThan(latestVersion)) continue;
            latestVersion = version;
        }
        return Optional.of(latestVersion);
    }

    private static enum ValidationStatus {
        EMPTY("command name should not be empty."),
        NON_ALPHANUMERIC("command name should only contain alphanumeric characters and underscores."),
        LEADING_UNDERSCORE("command name should not start with an underscore."),
        TRAILING_UNDERSCORE("command name should not end with an underscore."),
        CONSECUTIVE_UNDERSCORES("command name should not contain consecutive underscores."),
        VALID("Valid command name.");

        private final String message;

        private ValidationStatus(String message) {
            this.message = message;
        }

        public String message() {
            return this.message;
        }
    }
}

