/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.projects.util;

import io.ballerina.projects.ProjectException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public final class ProjectPaths {
    private ProjectPaths() {
    }

    public static Path packageRoot(Path filepath) throws ProjectException {
        if (!Files.exists(filepath, new LinkOption[0])) {
            throw new ProjectException("'" + String.valueOf(filepath) + "' does not exist");
        }
        if (Files.isDirectory(filepath, new LinkOption[0])) {
            if (ProjectPaths.hasBallerinaToml(filepath) || ProjectPaths.hasPackageJson(filepath)) {
                return filepath;
            }
            if (ProjectPaths.isModulesRoot(filepath) || ProjectPaths.isGeneratedModulesRoot(filepath) || ProjectPaths.isAModuleRoot(filepath) || ProjectPaths.isAGeneratedModuleRoot(filepath) || ProjectPaths.isAModuleTestsRoot(filepath) || ProjectPaths.isAGeneratedModuleTestsRoot(filepath)) {
                return ProjectPaths.findProjectRoot(filepath).orElseThrow();
            }
            throw new ProjectException("provided directory does not belong to a Ballerina package: " + String.valueOf(filepath));
        }
        if (!Files.isRegularFile(filepath, new LinkOption[0])) {
            throw new ProjectException("'" + String.valueOf(filepath) + "' is not a regular file");
        }
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(filepath);
        if (projectRoot.isEmpty()) {
            throw new ProjectException("provided file path does not belong to a Ballerina package: " + String.valueOf(filepath));
        }
        Path absFilePath = filepath.toAbsolutePath().normalize();
        if (ProjectPaths.hasBallerinaToml(projectRoot.get())) {
            if (ProjectPaths.isBallerinaRelatedToml(filepath)) {
                return filepath.getParent();
            }
            if (!ProjectPaths.isBalFile(filepath)) {
                throw new ProjectException("'" + String.valueOf(filepath) + "' is not a valid Ballerina source file");
            }
            if (ProjectPaths.isDefaultModuleSrcFile(absFilePath)) {
                Path parentPath = absFilePath.getParent();
                if ("generated".equals(Optional.of(parentPath).get().toFile().getName())) {
                    parentPath = parentPath.getParent();
                }
                return parentPath;
            }
            if (ProjectPaths.isDefaultModuleTestFile(absFilePath)) {
                Path testsRoot = Optional.of(absFilePath.getParent()).get();
                Path parentPath = testsRoot.getParent();
                if ("generated".equals(Optional.of(parentPath).get().toFile().getName())) {
                    parentPath = parentPath.getParent();
                }
                return parentPath;
            }
            if (ProjectPaths.isNonDefaultModuleSrcFile(filepath)) {
                Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
                return modulesRoot.getParent();
            }
            if (ProjectPaths.isNonDefaultModuleTestFile(filepath)) {
                Path testsRoot = Optional.of(absFilePath.getParent()).get();
                Path modulesRoot = Optional.of(Optional.of(testsRoot.getParent()).get().getParent()).get();
                return modulesRoot.getParent();
            }
        } else if (ProjectPaths.isBalaProjectSrcFile(filepath)) {
            Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
            return modulesRoot.getParent();
        }
        throw new ProjectException("provided file path does not belong to a Ballerina package: " + String.valueOf(filepath));
    }

    private static boolean isAGeneratedModuleRoot(Path filepath) {
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null) {
            Path generatedModuleRoot = projectRoot.get().resolve("generated").resolve(fileName);
            return generatedModuleRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    private static boolean isAGeneratedModuleTestsRoot(Path filepath) {
        Path parent;
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null && fileName.toString().equals("tests") && (parent = filepath.getParent()) != null) {
            if (projectRoot.get().resolve("generated").resolve("tests").toString().equals(absFilePath.toString())) {
                return true;
            }
            Path generatedModuleRoot = projectRoot.get().resolve("generated").resolve(Optional.of(parent.getFileName()).get());
            return generatedModuleRoot.toAbsolutePath().normalize().toString().equals(parent.toString());
        }
        return false;
    }

    private static boolean isModulesRoot(Path filepath) {
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent()) {
            Path modulesRoot = projectRoot.get().resolve("modules");
            return modulesRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    private static boolean isGeneratedModulesRoot(Path filepath) {
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent()) {
            Path generatedModulesRoot = projectRoot.get().resolve("generated");
            return generatedModulesRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    private static boolean isAModuleTestsRoot(Path filepath) {
        Path parent;
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(filepath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null && fileName.toString().equals("tests") && (parent = filepath.getParent()) != null) {
            if (projectRoot.get().resolve("tests").toString().equals(absFilePath.toString())) {
                return true;
            }
            Path moduleRoot = projectRoot.get().resolve("modules").resolve(Optional.of(parent.getFileName()).get());
            return moduleRoot.toAbsolutePath().normalize().toString().equals(parent.toString());
        }
        return false;
    }

    private static boolean isAModuleRoot(Path filepath) {
        Path fileName;
        Path absFilePath = filepath.toAbsolutePath().normalize();
        Optional<Path> projectRoot = ProjectPaths.findProjectRoot(absFilePath);
        if (projectRoot.isPresent() && (fileName = absFilePath.getFileName()) != null) {
            Path moduleRoot = projectRoot.get().resolve("modules").resolve(fileName);
            return moduleRoot.toAbsolutePath().normalize().toString().equals(absFilePath.toString());
        }
        return false;
    }

    public static boolean isBalFile(Path filepath) {
        return Files.exists(filepath, new LinkOption[0]) && Files.isRegularFile(filepath, new LinkOption[0]) && filepath.toString().endsWith(".bal");
    }

    private static boolean isBallerinaRelatedToml(Path filepath) {
        String fileName;
        return switch (fileName = Optional.of(filepath.getFileName()).get().toString()) {
            case "Ballerina.toml", "Cloud.toml", "Config.toml", "Dependencies.toml" -> true;
            default -> false;
        };
    }

    public static boolean isStandaloneBalFile(Path filepath) {
        if (!ProjectPaths.isBalFile(filepath)) {
            return false;
        }
        if (ProjectPaths.findProjectRoot(filepath).isEmpty()) {
            return true;
        }
        if (ProjectPaths.isDefaultModuleSrcFile(filepath)) {
            return false;
        }
        if (ProjectPaths.isDefaultModuleTestFile(filepath)) {
            return false;
        }
        if (ProjectPaths.isNonDefaultModuleSrcFile(filepath)) {
            return false;
        }
        if (ProjectPaths.isNonDefaultModuleTestFile(filepath)) {
            return false;
        }
        return !ProjectPaths.isBalaProjectSrcFile(filepath);
    }

    static boolean isDefaultModuleSrcFile(Path filePath) {
        Path parentPath = filePath.toAbsolutePath().normalize().getParent();
        if ("generated".equals(Optional.of(parentPath).get().toFile().getName())) {
            parentPath = parentPath.getParent();
        }
        return ProjectPaths.hasBallerinaToml(Optional.of(parentPath).get());
    }

    static boolean isDefaultModuleTestFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path testsRoot = Optional.of(absFilePath.getParent()).get();
        if (!"tests".equals(testsRoot.toFile().getName())) {
            return false;
        }
        Path projectRoot = Optional.of(testsRoot.getParent()).get();
        if ("generated".equals(projectRoot.toFile().getName())) {
            projectRoot = projectRoot.getParent();
        }
        return projectRoot != null && ProjectPaths.hasBallerinaToml(projectRoot);
    }

    static boolean isNonDefaultModuleSrcFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
        Path projectRoot = modulesRoot.getParent();
        return ("modules".equals(modulesRoot.toFile().getName()) || "generated".equals(modulesRoot.toFile().getName())) && ProjectPaths.hasBallerinaToml(projectRoot);
    }

    static boolean isBalaProjectSrcFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path modulesRoot = Optional.of(Optional.of(absFilePath.getParent()).get().getParent()).get();
        Path projectRoot = modulesRoot.getParent();
        return "modules".equals(modulesRoot.toFile().getName()) && ProjectPaths.hasPackageJson(projectRoot);
    }

    static boolean isNonDefaultModuleTestFile(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        Path testsRoot = Optional.of(absFilePath.getParent()).get();
        if (!"tests".equals(testsRoot.toFile().getName())) {
            return false;
        }
        Path modulesRoot = Optional.of(Optional.of(testsRoot.getParent()).get().getParent()).get();
        Path projectRoot = modulesRoot.getParent();
        return ("modules".equals(modulesRoot.toFile().getName()) || "generated".equals(modulesRoot.toFile().getName())) && ProjectPaths.hasBallerinaToml(projectRoot);
    }

    private static boolean hasBallerinaToml(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve("Ballerina.toml").toFile().exists();
    }

    private static boolean hasPackageJson(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve("package.json").toFile().exists();
    }

    private static Optional<Path> findProjectRoot(Path filePath) {
        if (filePath != null) {
            if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && (ProjectPaths.hasBallerinaToml(filePath) || ProjectPaths.hasPackageJson(filePath))) {
                return Optional.of(filePath);
            }
            return ProjectPaths.findProjectRoot(filePath.getParent());
        }
        return Optional.empty();
    }
}

