/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.tree;

public enum OperatorKind {
    ADD("+"),
    SUB("-"),
    MUL("*"),
    DIV("/"),
    MOD("%"),
    AND("&&"),
    OR("||"),
    EQUAL("=="),
    EQUALS("equals"),
    NOT_EQUAL("!="),
    GREATER_THAN(">"),
    GREATER_EQUAL(">="),
    LESS_THAN("<"),
    LESS_EQUAL("<="),
    IS_ASSIGNABLE("isassignable"),
    NOT("!"),
    LENGTHOF("lengthof"),
    TYPEOF("typeof"),
    UNTAINT("untaint"),
    INCREMENT("++"),
    DECREMENT("--"),
    CHECK("check"),
    CHECK_PANIC("checkpanic"),
    ELVIS("?:"),
    BITWISE_AND("&"),
    BITWISE_OR("|"),
    BITWISE_XOR("^"),
    BITWISE_COMPLEMENT("~"),
    BITWISE_LEFT_SHIFT("<<"),
    BITWISE_RIGHT_SHIFT(">>"),
    BITWISE_UNSIGNED_RIGHT_SHIFT(">>>"),
    CLOSED_RANGE("..."),
    HALF_OPEN_RANGE("..<"),
    REF_EQUAL("==="),
    REF_NOT_EQUAL("!=="),
    ANNOT_ACCESS(".@"),
    UNDEFINED("UNDEF");

    private final String opValue;

    private OperatorKind(String opValue) {
        this.opValue = opValue;
    }

    public String value() {
        return this.opValue;
    }

    public String toString() {
        return this.opValue;
    }

    public static OperatorKind valueFrom(String opValue) {
        for (OperatorKind operatorKind : OperatorKind.values()) {
            if (!operatorKind.opValue.equals(opValue)) continue;
            return operatorKind;
        }
        return null;
    }
}

