/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.repository;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.PackageEntity;
import org.ballerinalang.repository.PackageRepository;

public class AggregatedPackageRepository
implements PackageRepository {
    private final List<PackageRepository> repos = new ArrayList<PackageRepository>();

    public void addRepository(PackageRepository repo) {
        this.repos.add(repo);
    }

    public List<PackageRepository> getRepositories() {
        return this.repos;
    }

    @Override
    public PackageEntity loadPackage(PackageID pkgId) {
        PackageRepository repo;
        PackageEntity result = null;
        Iterator<PackageRepository> iterator = this.repos.iterator();
        while (iterator.hasNext() && (result = (repo = iterator.next()).loadPackage(pkgId)) == null) {
        }
        return result;
    }

    @Override
    public PackageEntity loadPackage(PackageID pkgId, String entryName) {
        PackageRepository repo;
        PackageEntity result = null;
        Iterator<PackageRepository> iterator = this.repos.iterator();
        while (iterator.hasNext() && (result = (repo = iterator.next()).loadPackage(pkgId, entryName)) == null) {
        }
        return result;
    }

    @Override
    public Set<PackageID> listPackages(int maxDepth) {
        return this.repos.stream().flatMap(e -> e.listPackages(maxDepth).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

