/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.repository.CompiledPackage;
import org.ballerinalang.repository.CompilerOutputEntry;
import org.wso2.ballerinalang.compiler.FileSystemProgramDirectory;
import org.wso2.ballerinalang.compiler.util.FileUtils;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.util.LambdaExceptionUtils;
import org.wso2.ballerinalang.util.RepoUtils;

public class FileSystemProjectDirectory
extends FileSystemProgramDirectory {
    private final Path projectDirPath;
    private final Path sourceDirPath;
    private List<String> packageNames;
    protected boolean scanned = false;
    private static final PrintStream OUT_STREAM = System.out;

    public FileSystemProjectDirectory(Path projectDirPath) {
        super(projectDirPath);
        this.projectDirPath = projectDirPath;
        this.sourceDirPath = projectDirPath.resolve("src");
    }

    @Override
    public boolean canHandle(Path dirPath) {
        return RepoUtils.isBallerinaProject(dirPath);
    }

    @Override
    public Path getPath() {
        return this.projectDirPath;
    }

    @Override
    public List<String> getSourceFileNames() {
        return new ArrayList<String>(0);
    }

    @Override
    public List<String> getSourcePackageNames() {
        if (this.scanned) {
            return this.packageNames;
        }
        try (Stream<Path> stream = Files.list(this.sourceDirPath);){
            this.packageNames = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).filter(ProjectDirs::containsSourceFiles).map(ProjectDirs::getLastComp).map(Path::toString).toList();
        }
        catch (SecurityException | AccessDeniedException e) {
            throw new BLangCompilerException("permission denied: " + this.projectDirPath.toString());
        }
        catch (IOException e) {
            throw new BLangCompilerException("error reading directory: " + this.projectDirPath.toString());
        }
        this.scanned = true;
        return this.packageNames;
    }

    @Override
    public InputStream getManifestContent() {
        Path tomlFilePath = this.projectDirPath.resolve("Ballerina.toml");
        if (Files.exists(tomlFilePath, new LinkOption[0])) {
            try {
                return Files.newInputStream(tomlFilePath, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public InputStream getLockFileContent() {
        Path tomlFilePath = this.projectDirPath.resolve("Ballerina.lock");
        if (Files.exists(tomlFilePath, new LinkOption[0])) {
            try {
                return Files.newInputStream(tomlFilePath, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public Path saveCompiledProgram(InputStream source, String fileName) {
        Path targetFilePath = this.ensureAndGetTargetDirPath().resolve(fileName);
        try {
            OUT_STREAM.println("    ./target/" + fileName);
            Files.copy(source, targetFilePath, StandardCopyOption.REPLACE_EXISTING);
            return targetFilePath;
        }
        catch (DirectoryNotEmptyException e) {
            throw new BLangCompilerException("A directory exists with the same name as the file name '" + targetFilePath.toString() + "'");
        }
        catch (IOException e) {
            throw new BLangCompilerException("failed to write the compiled program to '" + targetFilePath.toString() + "'");
        }
    }

    @Override
    public void saveCompiledPackage(CompiledPackage compiledPackage, Path dirPath, String fileName) throws IOException {
        Files.createDirectories(dirPath, new FileAttribute[0]);
        Path compiledPkgPath = dirPath.resolve(fileName);
        FileUtils.deleteFile(compiledPkgPath);
        HashMap<String, String> fsEnv = new HashMap<String, String>(){
            {
                this.put("create", "true");
            }
        };
        URI filepath = compiledPkgPath.toUri();
        try {
            URI zipFileURI = new URI("jar:" + filepath.getScheme(), filepath.getUserInfo(), filepath.getHost(), filepath.getPort(), filepath.getPath() + "!/", filepath.getQuery(), filepath.getFragment());
            try (FileSystem fs = FileSystems.newFileSystem(zipFileURI, fsEnv);){
                compiledPackage.getAllEntries().forEach(LambdaExceptionUtils.rethrow(entry -> this.addCompilerOutputEntry(fs, (CompilerOutputEntry)entry)));
            }
        }
        catch (URISyntaxException e) {
            throw new BLangCompilerException("error creating artifact: " + String.valueOf(compiledPkgPath.getFileName()));
        }
    }

    private void createDirectory(Path targetPath) {
        try {
            Files.createDirectory(targetPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BLangCompilerException("failed to create directory '" + targetPath.toString() + "'");
        }
    }

    private Path ensureAndGetTargetDirPath() {
        Path targetPath = this.projectDirPath.resolve("target");
        if (!Files.exists(targetPath, new LinkOption[0])) {
            this.createDirectory(targetPath);
        }
        return targetPath;
    }

    private void addCompilerOutputEntry(FileSystem fs, CompilerOutputEntry outputEntry) throws IOException {
        String rootDirName = this.getTopLevelDirNameInPackage(outputEntry.getEntryKind(), fs);
        Path rootDirPath = fs.getPath(rootDirName, new String[0]);
        Path destPath = rootDirPath.resolve(outputEntry.getEntryName());
        Path parent = destPath.getParent();
        if (Files.notExists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.copy(outputEntry.getInputStream(), destPath, StandardCopyOption.REPLACE_EXISTING);
    }

    private String getTopLevelDirNameInPackage(CompilerOutputEntry.Kind kind, FileSystem fs) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case CompilerOutputEntry.Kind.SRC, CompilerOutputEntry.Kind.BIR, CompilerOutputEntry.Kind.OBJ -> kind.getValue();
            case CompilerOutputEntry.Kind.ROOT -> fs.getSeparator();
        };
    }
}

