/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.types.PredefinedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.AnnotationAttachmentSymbol;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.bir.BIRGenEnv;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.bir.optimizer.BIROptimizer;
import org.wso2.ballerinalang.compiler.bir.writer.BIRWriterUtils;
import org.wso2.ballerinalang.compiler.diagnostic.BLangDiagnosticLocation;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SemTypeHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourceFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BResourcePathSegmentSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangResourceFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAlternateWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangDynamicArgExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMultipleWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAssertion;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomCharOrEscape;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReAtomQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCapturingGroups;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSet;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharSetRange;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReCharacterClass;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReDisjunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReFlagsOnOff;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReQuantifier;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangReSequence;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRegExpTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerAsyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSendReceiveExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangFail;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.ClosureVarSymbol;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.Unifier;

public class BIRGen
extends BLangNodeVisitor {
    private static final CompilerContext.Key<BIRGen> BIR_GEN = new CompilerContext.Key();
    public static final String DEFAULT_WORKER_NAME = "function";
    private BIRGenEnv env;
    private final Names names;
    private final SymbolTable symTable;
    private final BIROptimizer birOptimizer;
    private final Types types;
    private boolean varAssignment = false;
    private final Map<BSymbol, BIRNode.BIRTypeDefinition> typeDefs = new LinkedHashMap<BSymbol, BIRNode.BIRTypeDefinition>();
    private BlockNode currentBlock;
    public Map<BSymbol, BIRNode.BIRGlobalVariableDcl> globalVarMap = new HashMap<BSymbol, BIRNode.BIRGlobalVariableDcl>();
    private final Map<BSymbol, BIRNode.BIRGlobalVariableDcl> dummyGlobalVarMapForLocks = new HashMap<BSymbol, BIRNode.BIRGlobalVariableDcl>();
    private final Map<BLangLock.BLangLockStmt, BIRTerminator.Lock> lockStmtMap = new HashMap<BLangLock.BLangLockStmt, BIRTerminator.Lock>();
    private final Unifier unifier;
    private BirScope currentScope;

    public static BIRGen getInstance(CompilerContext context) {
        BIRGen birGen = context.get(BIR_GEN);
        if (birGen == null) {
            birGen = new BIRGen(context);
        }
        return birGen;
    }

    private BIRGen(CompilerContext context) {
        context.put(BIR_GEN, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.birOptimizer = BIROptimizer.getInstance(context);
        this.unifier = new Unifier();
        this.types = Types.getInstance(context);
    }

    public BLangPackage genBIR(BLangPackage astPkg) {
        BIRNode.BIRPackage birPkg;
        boolean skipTest = astPkg.moduleContextDataHolder.skipTests();
        String sourceRoot = astPkg.moduleContextDataHolder.sourceRoot().toString();
        astPkg.symbol.bir = birPkg = new BIRNode.BIRPackage(astPkg.pos, astPkg.packageID.orgName, astPkg.packageID.pkgName, astPkg.packageID.name, astPkg.packageID.version, astPkg.packageID.sourceFileName, sourceRoot, skipTest);
        this.env = new BIRGenEnv(birPkg);
        astPkg.accept(this);
        this.birOptimizer.optimizePackage(birPkg);
        if (!astPkg.moduleContextDataHolder.skipTests() && astPkg.hasTestablePackage()) {
            astPkg.getTestablePkgs().forEach(testPkg -> {
                BIRNode.BIRPackage testBirPkg = new BIRNode.BIRPackage(testPkg.pos, testPkg.packageID.orgName, testPkg.packageID.pkgName, testPkg.packageID.name, testPkg.packageID.version, testPkg.packageID.sourceFileName, sourceRoot, skipTest, true);
                this.env = new BIRGenEnv(testBirPkg);
                testPkg.accept(this);
                this.birOptimizer.optimizePackage(testBirPkg);
                testPkg.symbol.bir = testBirPkg;
                testBirPkg.importModules.add(new BIRNode.BIRImportModule(null, testPkg.packageID.orgName, testPkg.packageID.name, testPkg.packageID.version));
            });
        }
        this.setEntryPoints(astPkg);
        return astPkg;
    }

    private void setEntryPoints(BLangPackage pkgNode) {
        BLangFunction mainFunc = this.getMainFunction(pkgNode);
        if (mainFunc != null || this.listenerDeclarationFound(pkgNode.getGlobalVariables()) || !pkgNode.services.isEmpty()) {
            pkgNode.symbol.entryPointExists = true;
        }
    }

    private boolean listenerDeclarationFound(List<BLangVariable> globalVars) {
        for (BLangVariable globalVar : globalVars) {
            if (!Symbols.isFlagOn(globalVar.symbol.flags, 524288L)) continue;
            return true;
        }
        return false;
    }

    private BLangFunction getMainFunction(BLangPackage pkgNode) {
        for (BLangFunction funcNode : pkgNode.functions) {
            if (!CompilerUtils.isMainFunction(funcNode)) continue;
            return funcNode;
        }
        return null;
    }

    @Override
    public void visit(BLangPackage astPkg) {
        astPkg.imports.forEach(impPkg -> impPkg.accept(this));
        astPkg.constants.forEach(astConst -> astConst.accept(this));
        astPkg.typeDefinitions.forEach(astTypeDef -> astTypeDef.accept(this));
        this.generateClassDefinitions(astPkg.topLevelNodes);
        astPkg.globalVars.forEach(astGlobalVar -> astGlobalVar.accept(this));
        astPkg.initFunction.accept(this);
        astPkg.startFunction.accept(this);
        astPkg.stopFunction.accept(this);
        astPkg.functions.forEach(astFunc -> astFunc.accept(this));
        astPkg.annotations.forEach(astAnn -> astAnn.accept(this));
        astPkg.services.forEach(service -> service.accept(this));
    }

    private void generateClassDefinitions(List<TopLevelNode> topLevelNodes) {
        for (TopLevelNode topLevelNode : topLevelNodes) {
            if (topLevelNode.getKind() != NodeKind.CLASS_DEFN) continue;
            ((BLangClassDefinition)topLevelNode).accept(this);
        }
    }

    @Override
    public void visit(BLangTypeDefinition astTypeDefinition) {
        BSymbol typeSymbol;
        BRecordType recordType;
        BType type = this.getDefinedType(astTypeDefinition);
        BType referredType = Types.getImpliedType(type);
        BSymbol symbol = astTypeDefinition.symbol;
        String displayName = symbol.name.value;
        if (referredType.tag == 12 && (recordType = (BRecordType)referredType).shouldPrintShape()) {
            displayName = recordType.toString();
        }
        BIRNode.BIRTypeDefinition typeDef = new BIRNode.BIRTypeDefinition(astTypeDefinition.pos, symbol.name, symbol.flags, astTypeDefinition.isBuiltinTypeDef, type, new ArrayList<BIRNode.BIRFunction>(), symbol.origin.toBIROrigin(), new Name(Utils.unescapeBallerina((String)displayName)), symbol.originalName);
        if (symbol.tag == 32796L) {
            BTypeReferenceType referenceType = ((BTypeDefinitionSymbol)symbol).referenceType;
            typeDef.referenceType = referenceType;
            BTypeSymbol typeSymbol2 = symbol.type.tsymbol;
            if (type.tsymbol.owner == symbol.owner && !Symbols.isFlagOn(typeSymbol2.flags, 0x10000000L)) {
                this.typeDefs.put(typeSymbol2, typeDef);
            } else if (referenceType != null) {
                typeDef.type = referenceType;
            }
            typeDef.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(((BTypeDefinitionSymbol)symbol).getAnnotations()));
        } else {
            this.typeDefs.put(symbol, typeDef);
            if (astTypeDefinition.flagSet.contains((Object)Flag.ENUM)) {
                typeDef.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(((BEnumSymbol)symbol).getAnnotations()));
            }
        }
        this.env.enclPkg.typeDefs.add(typeDef);
        typeDef.index = this.env.enclPkg.typeDefs.size() - 1;
        typeDef.setMarkdownDocAttachment(symbol.markdownDocumentation);
        if (astTypeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE || astTypeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            BLangStructureTypeNode typeNode = (BLangStructureTypeNode)astTypeDefinition.typeNode;
            for (BLangType typeRef : typeNode.typeRefs) {
                typeDef.referencedTypes.add(typeRef.getBType());
            }
        }
        BSymbol bSymbol = typeSymbol = symbol.tag == 32796L ? symbol.type.tsymbol : symbol;
        if (typeSymbol.tag != 98396L || !Symbols.isFlagOn(typeSymbol.flags, 0x10000000L)) {
            return;
        }
        for (BAttachedFunction func : ((BObjectTypeSymbol)typeSymbol).referencedFunctions) {
            if (!Symbols.isFlagOn(func.symbol.flags, 128L)) {
                return;
            }
            BInvokableSymbol funcSymbol = func.symbol;
            BIRNode.BIRFunction birFunc = new BIRNode.BIRFunction(astTypeDefinition.pos, func.funcName, funcSymbol.flags, func.type, Names.fromString(DEFAULT_WORKER_NAME), 0, funcSymbol.origin.toBIROrigin());
            if (funcSymbol.receiverSymbol != null) {
                birFunc.receiver = this.getSelf(funcSymbol.receiverSymbol);
            }
            birFunc.setMarkdownDocAttachment(funcSymbol.markdownDocumentation);
            int defaultableParamsCount = 0;
            birFunc.argsCount = funcSymbol.params.size() + defaultableParamsCount + (funcSymbol.restParam != null ? 1 : 0);
            funcSymbol.params.forEach(requiredParam -> this.addParam(birFunc, (BVarSymbol)requiredParam, astTypeDefinition.pos));
            if (funcSymbol.restParam != null) {
                this.addRestParam(birFunc, funcSymbol.restParam, astTypeDefinition.pos);
            }
            birFunc.returnVariable = new BIRNode.BIRVariableDcl(astTypeDefinition.pos, funcSymbol.retType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.RETURN, null);
            birFunc.localVars.add(0, birFunc.returnVariable);
            typeDef.attachedFuncs.add(birFunc);
        }
    }

    private BType getDefinedType(BLangTypeDefinition astTypeDefinition) {
        BType nodeType = astTypeDefinition.typeNode.getBType();
        if (Types.getImpliedType((BType)nodeType).tag == 29) {
            return astTypeDefinition.symbol.type;
        }
        return nodeType;
    }

    @Override
    public void visit(BLangClassDefinition classDefinition) {
        BIRNode.BIRTypeDefinition typeDef = new BIRNode.BIRTypeDefinition(classDefinition.pos, classDefinition.symbol.name, classDefinition.symbol.originalName, classDefinition.symbol.flags, false, classDefinition.getBType(), new ArrayList<BIRNode.BIRFunction>(), classDefinition.symbol.origin.toBIROrigin());
        this.typeDefs.put(classDefinition.symbol, typeDef);
        this.env.enclPkg.typeDefs.add(typeDef);
        typeDef.index = this.env.enclPkg.typeDefs.size() - 1;
        typeDef.setMarkdownDocAttachment(classDefinition.symbol.markdownDocumentation);
        for (BLangType typeRef : classDefinition.typeRefs) {
            typeDef.referencedTypes.add(typeRef.getBType());
        }
        typeDef.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(((BClassSymbol)classDefinition.symbol).getAnnotations()));
        for (BAttachedFunction func : ((BObjectTypeSymbol)classDefinition.symbol).referencedFunctions) {
            BInvokableSymbol funcSymbol = func.symbol;
            BIRNode.BIRFunction birFunc = new BIRNode.BIRFunction(classDefinition.pos, func.funcName, funcSymbol.flags, func.type, Names.fromString(DEFAULT_WORKER_NAME), 0, funcSymbol.origin.toBIROrigin());
            if (funcSymbol.receiverSymbol != null) {
                birFunc.receiver = this.getSelf(funcSymbol.receiverSymbol);
            }
            birFunc.setMarkdownDocAttachment(funcSymbol.markdownDocumentation);
            int defaultableParamsCount = 0;
            birFunc.argsCount = funcSymbol.params.size() + defaultableParamsCount + (funcSymbol.restParam != null ? 1 : 0);
            funcSymbol.params.forEach(requiredParam -> this.addParam(birFunc, (BVarSymbol)requiredParam, classDefinition.pos));
            if (funcSymbol.restParam != null) {
                this.addRestParam(birFunc, funcSymbol.restParam, classDefinition.pos);
            }
            birFunc.returnVariable = new BIRNode.BIRVariableDcl(classDefinition.pos, funcSymbol.retType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.RETURN, null);
            birFunc.localVars.add(0, birFunc.returnVariable);
            typeDef.attachedFuncs.add(birFunc);
        }
    }

    @Override
    public void visit(BLangService serviceNode) {
        BServiceSymbol symbol = (BServiceSymbol)serviceNode.symbol;
        List attachPoint = symbol.getAbsResourcePath().orElse(null);
        String attachPointLiteral = symbol.getAttachPointStringLiteral().orElse(null);
        BIRNode.BIRServiceDeclaration serviceDecl = new BIRNode.BIRServiceDeclaration(attachPoint, attachPointLiteral, symbol.getListenerTypes(), symbol.name, symbol.getAssociatedClassSymbol().name, symbol.type, symbol.origin, symbol.flags, symbol.pos);
        serviceDecl.setMarkdownDocAttachment(symbol.markdownDocumentation);
        this.env.enclPkg.serviceDecls.add(serviceDecl);
    }

    @Override
    public void visit(BLangConstant astConstant) {
        BConstantSymbol constantSymbol = astConstant.symbol;
        Name constName = constantSymbol.name;
        Name constOriginalName = constantSymbol.getOriginalName();
        BType type = constantSymbol.type;
        BIRNode.ConstValue constantValue = BIRWriterUtils.getBIRConstantVal(constantSymbol.value);
        BIRNode.BIRConstant birConstant = new BIRNode.BIRConstant(astConstant.pos, constName, constOriginalName, constantSymbol.flags, type, constantValue, constantSymbol.origin.toBIROrigin());
        birConstant.constValue = constantValue;
        birConstant.setMarkdownDocAttachment(astConstant.symbol.markdownDocumentation);
        birConstant.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(constantSymbol.getAnnotations()));
        this.env.enclPkg.constants.add(birConstant);
    }

    @Override
    public void visit(BLangImportPackage impPkg) {
        if (impPkg.symbol == null) {
            return;
        }
        this.env.enclPkg.importModules.add(new BIRNode.BIRImportModule(impPkg.pos, impPkg.symbol.pkgID.orgName, impPkg.symbol.pkgID.name, impPkg.symbol.pkgID.version));
    }

    @Override
    public void visit(BLangResourceFunction resourceFunction) {
        this.visit((BLangFunction)resourceFunction);
    }

    @Override
    public void visit(BLangFunction astFunc) {
        BInvokableType type = astFunc.symbol.getType();
        boolean isTypeAttachedFunction = astFunc.flagSet.contains((Object)Flag.ATTACHED) && !this.typeDefs.containsKey(astFunc.receiver.getBType().tsymbol);
        Name workerName = this.names.fromIdNode(astFunc.defaultWorkerName);
        this.env.unlockVars.push(new BIRNode.BIRLockDetailsHolder());
        Name funcName = isTypeAttachedFunction ? Names.fromString(astFunc.symbol.name.value) : this.getFuncName(astFunc.symbol);
        BIRNode.BIRFunction birFunc = new BIRNode.BIRFunction(astFunc.pos, funcName, Names.fromString(astFunc.symbol.getOriginalName().value), astFunc.symbol.flags, type, workerName, astFunc.sendsToThis.size(), astFunc.symbol.origin.toBIROrigin());
        this.currentScope = new BirScope(0, null);
        if (astFunc.receiver != null) {
            BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(astFunc.pos, astFunc.receiver.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, astFunc.receiver.name.value, false, false);
            this.env.symbolVarMap.put(astFunc.receiver.symbol, birVarDcl);
            birFunc.receiver = this.getSelf(astFunc.receiver.symbol);
        }
        birFunc.setMarkdownDocAttachment(astFunc.symbol.markdownDocumentation);
        int i = 0;
        for (BLangWorkerSendReceiveExpr.Channel channel : astFunc.sendsToThis) {
            String channelId = channel.channelId();
            birFunc.workerChannels[i] = new BIRNode.ChannelDetails(channelId, astFunc.defaultWorkerName.value.equals(DEFAULT_WORKER_NAME), this.isWorkerSend(channelId, astFunc.defaultWorkerName.value));
            ++i;
        }
        if (astFunc.hasBody() && astFunc.body.getKind() == NodeKind.EXTERN_FUNCTION_BODY) {
            birFunc.annotAttachments.addAll(this.getBIRAnnotAttachmentsForASTAnnotAttachments(((BLangExternalFunctionBody)astFunc.body).annAttachments));
        }
        birFunc.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(astFunc.symbol.getAnnotations()));
        if (Symbols.isFlagOn(astFunc.symbol.flags, 2L)) {
            birFunc.annotAttachmentsOnExternal = BIRWriterUtils.getBIRAnnotAttachments(astFunc.symbol.getAnnotationAttachmentsOnExternal());
        }
        BTypeSymbol tsymbol = astFunc.symbol.type.tsymbol;
        if (astFunc.returnTypeNode != null && tsymbol != null) {
            birFunc.returnTypeAnnots.addAll(BIRWriterUtils.getBIRAnnotAttachments(((BInvokableTypeSymbol)tsymbol).returnTypeAnnots));
        }
        birFunc.argsCount = astFunc.requiredParams.size() + (astFunc.restParam != null ? 1 : 0) + astFunc.paramClosureMap.size();
        if (astFunc.flagSet.contains((Object)Flag.ATTACHED) && this.typeDefs.containsKey(astFunc.receiver.getBType().tsymbol)) {
            this.typeDefs.get((Object)astFunc.receiver.getBType().tsymbol).attachedFuncs.add(birFunc);
        } else {
            this.env.enclPkg.functions.add(birFunc);
        }
        this.env.enclFunc = birFunc;
        BType retType = this.unifier.build(this.symTable.typeEnv(), astFunc.symbol.type.getReturnType());
        birFunc.returnVariable = new BIRNode.BIRVariableDcl(astFunc.pos, retType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.RETURN, null);
        birFunc.localVars.add(0, birFunc.returnVariable);
        astFunc.paramClosureMap.forEach((k, v) -> this.addRequiredParam(birFunc, (BVarSymbol)v, astFunc.pos));
        astFunc.requiredParams.forEach(requiredParam -> this.addParam(birFunc, (BLangVariable)requiredParam));
        if (astFunc.restParam != null) {
            this.addRestParam(birFunc, astFunc.restParam.symbol, astFunc.restParam.pos);
        }
        if (astFunc.flagSet.contains((Object)Flag.RESOURCE)) {
            BTypeSymbol parentTSymbol = astFunc.parent.getBType().tsymbol;
            BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)parentTSymbol;
            for (BAttachedFunction func : objectTypeSymbol.attachedFuncs) {
                if (!func.funcName.value.equals(funcName.value)) continue;
                BResourceFunction resourceFunction = (BResourceFunction)func;
                List<BVarSymbol> pathParamSymbols = resourceFunction.pathParams;
                ArrayList<BIRNode.BIRVariableDcl> pathParams = new ArrayList<BIRNode.BIRVariableDcl>(pathParamSymbols.size());
                for (BVarSymbol pathParamSym : pathParamSymbols) {
                    pathParams.add(this.createBIRVarDeclForPathParam(pathParamSym));
                }
                birFunc.pathParams = pathParams;
                BVarSymbol restPathParamSym = resourceFunction.restPathParam;
                if (restPathParamSym != null) {
                    birFunc.restPathParam = this.createBIRVarDeclForPathParam(restPathParamSym);
                }
                List<BResourcePathSegmentSymbol> pathSegmentSymbols = resourceFunction.pathSegmentSymbols;
                int pathSegmentSize = pathSegmentSymbols.size();
                ArrayList<Name> pathSegmentNameList = new ArrayList<Name>(pathSegmentSize);
                ArrayList<Location> pathSegmentPosList = new ArrayList<Location>(pathSegmentSize);
                ArrayList<BType> pathSegmentTypeList = new ArrayList<BType>(pathSegmentSize);
                for (BSymbol bSymbol : pathSegmentSymbols) {
                    pathSegmentNameList.add(bSymbol.name);
                    pathSegmentPosList.add(bSymbol.pos);
                    pathSegmentTypeList.add(bSymbol.type);
                }
                birFunc.resourcePathSegmentPosList = pathSegmentPosList;
                birFunc.resourcePath = pathSegmentNameList;
                birFunc.accessor = resourceFunction.accessor;
                birFunc.pathSegmentTypeList = pathSegmentTypeList;
                break;
            }
        }
        if (astFunc.interfaceFunction || Symbols.isNative(astFunc.symbol)) {
            this.env.clear();
            return;
        }
        BIRNode.BIRBasicBlock entryBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.env.enclBasicBlocks = birFunc.basicBlocks;
        birFunc.basicBlocks.add(entryBB);
        this.env.enclBB = entryBB;
        this.addToTrapStack(entryBB);
        astFunc.body.accept(this);
        birFunc.basicBlocks.add(this.env.returnBB);
        BIRNode.BIRBasicBlock enclBB = this.env.enclBB;
        if (enclBB.terminator == null && this.env.returnBB != null) {
            enclBB.terminator = new BIRTerminator.GOTO(null, this.env.returnBB, this.currentScope);
        }
        this.env.clear();
        birFunc.dependentGlobalVars = astFunc.symbol.dependentGlobalVars.stream().map(varSymbol -> this.globalVarMap.get(varSymbol)).collect(Collectors.toSet());
    }

    private BIRNode.BIRVariableDcl createBIRVarDeclForPathParam(BVarSymbol pathParamSym) {
        return new BIRNode.BIRVariableDcl(pathParamSym.pos, pathParamSym.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, pathParamSym.name.value);
    }

    private BIRNode.BIRVariableDcl getSelf(BSymbol receiver) {
        BIRNode.BIRVariableDcl self = this.env.symbolVarMap.get(receiver);
        if (self == null) {
            return new BIRNode.BIRVariableDcl(null, receiver.type, receiver.name, VarScope.FUNCTION, VarKind.SELF, null);
        }
        self.kind = VarKind.SELF;
        self.name = new Name("%self");
        return self;
    }

    @Override
    public void visit(BLangBlockFunctionBody astBody) {
        BIRNode.BIRBasicBlock endLoopEndBB = this.env.enclLoopEndBB;
        BlockNode prevBlock = this.currentBlock;
        this.currentBlock = astBody;
        this.env.varDclsByBlock.computeIfAbsent(astBody, k -> new ArrayList());
        for (BLangStatement astStmt : astBody.stmts) {
            astStmt.accept(this);
        }
        List<BIRNode.BIRVariableDcl> varDecls = this.env.varDclsByBlock.get(astBody);
        for (BIRNode.BIRVariableDcl birVariableDcl : varDecls) {
            birVariableDcl.endBB = this.env.enclBasicBlocks.get(this.env.enclBasicBlocks.size() - 1);
        }
        this.env.enclLoopEndBB = endLoopEndBB;
        this.currentBlock = prevBlock;
        this.addReturnBB(astBody.pos);
    }

    private BIRNode.BIRBasicBlock beginBreakableBlock(BLangBlockStmt.FailureBreakMode mode) {
        BIRNode.BIRBasicBlock blockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(blockBB);
        this.env.enclBasicBlocks.add(blockBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(null, blockBB, this.currentScope);
        BIRNode.BIRBasicBlock blockEndBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(blockEndBB);
        blockBB.terminator = new BIRTerminator.GOTO(null, blockEndBB, this.currentScope);
        this.env.enclBB = blockBB;
        if (mode == BLangBlockStmt.FailureBreakMode.BREAK_WITHIN_BLOCK) {
            this.env.enclInnerOnFailEndBB = blockEndBB;
        } else {
            this.env.enclOnFailEndBB = blockEndBB;
        }
        this.env.unlockVars.push(new BIRNode.BIRLockDetailsHolder());
        return blockEndBB;
    }

    private void endBreakableBlock(BIRNode.BIRBasicBlock blockEndBB) {
        this.env.unlockVars.pop();
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, blockEndBB, this.currentScope);
        }
        this.env.enclBasicBlocks.add(blockEndBB);
        this.env.enclBB = blockEndBB;
    }

    @Override
    public void visit(BLangAnnotation astAnnotation) {
        BAnnotationSymbol annSymbol = (BAnnotationSymbol)astAnnotation.symbol;
        BIRNode.BIRAnnotation birAnn = this.getBirAnnotation(annSymbol, astAnnotation.pos);
        this.env.enclPkg.annotations.add(birAnn);
    }

    private BIRNode.BIRAnnotation getBirAnnotation(BAnnotationSymbol annSymbol, Location pos) {
        BIRNode.BIRAnnotation birAnn = new BIRNode.BIRAnnotation(pos, annSymbol.name, annSymbol.originalName, annSymbol.flags, annSymbol.points, annSymbol.attachedType == null ? this.symTable.trueType : annSymbol.attachedType, annSymbol.origin.toBIROrigin());
        birAnn.packageID = annSymbol.pkgID;
        birAnn.setMarkdownDocAttachment(annSymbol.markdownDocumentation);
        birAnn.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(annSymbol.getAnnotations()));
        return birAnn;
    }

    private boolean isWorkerSend(String chnlName, String workerName) {
        return chnlName.split("->")[0].equals(workerName);
    }

    @Override
    public void visit(BLangLambdaFunction lambdaExpr) {
        BIRNode.BIRVariableDcl tempVarLambda = new BIRNode.BIRVariableDcl(lambdaExpr.pos, lambdaExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP, null);
        this.env.enclFunc.localVars.add(tempVarLambda);
        BIROperand lhsOp = new BIROperand(tempVarLambda);
        Name funcName = this.getFuncName(lambdaExpr.function.symbol);
        ArrayList<BIRNode.BIRVariableDcl> params = new ArrayList<BIRNode.BIRVariableDcl>();
        lambdaExpr.function.requiredParams.forEach(param -> {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(param.pos, param.symbol.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, param.name.value);
            params.add(birVarDcl);
        });
        BLangSimpleVariable restParam = lambdaExpr.function.restParam;
        if (restParam != null) {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(restParam.pos, restParam.symbol.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, null);
            params.add(birVarDcl);
        }
        PackageID pkgID = lambdaExpr.function.symbol.pkgID;
        PackageID boundMethodPkgId = this.getPackageIdForBoundMethod(lambdaExpr, funcName.value);
        List<BIROperand> closureMapOperands = this.getClosureMapOperands(lambdaExpr);
        BIRNonTerminator.FPLoad fpLoad = new BIRNonTerminator.FPLoad(lambdaExpr.pos, pkgID, funcName, lhsOp, params, closureMapOperands, lambdaExpr.getBType(), lambdaExpr.function.symbol.strandName, lambdaExpr.function.symbol.schedulerPolicy, boundMethodPkgId);
        this.setScopeAndEmit(fpLoad);
        BType targetType = this.getRecordTargetType(funcName.value);
        if (lambdaExpr.function.flagSet.contains((Object)Flag.RECORD) && targetType != null && targetType.tag == 12) {
            this.setScopeAndEmit(new BIRNonTerminator.RecordDefaultFPLoad(lhsOp.pos, lhsOp, targetType, this.getFieldName(funcName.value, targetType.tsymbol.name.value)));
        }
        this.env.targetOperand = lhsOp;
    }

    private String getFieldName(String funcName, String typeName) {
        String[] splitNames = funcName.split(Pattern.quote(typeName + "$rec$"));
        return splitNames[splitNames.length - 1];
    }

    private BType getRecordTargetType(String funcName) {
        if (!funcName.contains("$rec$")) {
            return null;
        }
        String[] split = funcName.split(Pattern.quote("$rec$"));
        String typeName = split[split.length - 2];
        for (BIRNode.BIRTypeDefinition type : this.env.enclPkg.typeDefs) {
            if (!typeName.equals(type.originalName.value)) continue;
            return type.type;
        }
        return null;
    }

    private List<BIROperand> getClosureMapOperands(BLangLambdaFunction lambdaExpr) {
        ArrayList<BIROperand> closureMaps = new ArrayList<BIROperand>(lambdaExpr.function.paramClosureMap.size());
        lambdaExpr.function.paramClosureMap.forEach((k, v) -> {
            BVarSymbol symbol = lambdaExpr.enclMapSymbols.get(k);
            if (symbol == null) {
                symbol = lambdaExpr.paramMapSymbolsOfEnclInvokable.get(k);
            }
            BIROperand varRef = new BIROperand(this.env.symbolVarMap.get(symbol));
            closureMaps.add(varRef);
        });
        return closureMaps;
    }

    private Name getFuncName(BInvokableSymbol symbol) {
        if (symbol.receiverSymbol == null) {
            return Names.fromString(symbol.name.value);
        }
        int offset = symbol.receiverSymbol.type.tsymbol.name.value.length() + 1;
        String attachedFuncName = symbol.name.value;
        return Names.fromString(attachedFuncName.substring(offset));
    }

    private void addParam(BIRNode.BIRFunction birFunc, BLangVariable functionParam) {
        this.addParam(birFunc, functionParam.symbol, functionParam.expr, functionParam.pos, functionParam.symbol.getAnnotations());
    }

    private void addParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, Location pos) {
        this.addParam(birFunc, paramSymbol, null, pos, paramSymbol.getAnnotations());
    }

    private void addParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, BLangExpression defaultValExpr, Location pos, List<? extends AnnotationAttachmentSymbol> annots) {
        boolean isPathParam = paramSymbol.kind == SymbolKind.PATH_PARAMETER || paramSymbol.kind == SymbolKind.PATH_REST_PARAMETER;
        BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(pos, paramSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, paramSymbol.name.value, defaultValExpr != null, isPathParam);
        birFunc.localVars.add(birVarDcl);
        BIRNode.BIRParameter parameter = new BIRNode.BIRParameter(pos, paramSymbol.name, paramSymbol.flags);
        parameter.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(annots));
        birFunc.requiredParams.add(parameter);
        birFunc.parameters.add(birVarDcl);
        this.env.symbolVarMap.put(paramSymbol, birVarDcl);
    }

    private void addRestParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, Location pos) {
        BIRNode.BIRParameter restParam;
        BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(pos, paramSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, paramSymbol.name.value, false, paramSymbol.kind == SymbolKind.PATH_REST_PARAMETER);
        birFunc.parameters.add(birVarDcl);
        birFunc.localVars.add(birVarDcl);
        birFunc.restParam = restParam = new BIRNode.BIRParameter(pos, paramSymbol.name, paramSymbol.flags);
        restParam.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(paramSymbol.getAnnotations()));
        this.env.symbolVarMap.put(paramSymbol, birVarDcl);
    }

    private void addRequiredParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, Location pos) {
        boolean isPathParam = paramSymbol.kind == SymbolKind.PATH_PARAMETER || paramSymbol.kind == SymbolKind.PATH_REST_PARAMETER;
        BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(pos, paramSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, paramSymbol.name.value, false, isPathParam);
        birFunc.parameters.add(birVarDcl);
        birFunc.localVars.add(birVarDcl);
        BIRNode.BIRParameter parameter = new BIRNode.BIRParameter(pos, paramSymbol.name, paramSymbol.flags);
        birFunc.requiredParams.add(parameter);
        this.env.symbolVarMap.put(paramSymbol, birVarDcl);
    }

    private PackageID getPackageIdForBoundMethod(BLangLambdaFunction lambdaExpr, String funcName) {
        if (!funcName.startsWith("$anon$method$delegate$")) {
            return null;
        }
        Set<ClosureVarSymbol> closureVarSymbols = lambdaExpr.function.closureVarSymbols;
        if (closureVarSymbols.isEmpty()) {
            return null;
        }
        Object[] symbols = closureVarSymbols.toArray();
        ClosureVarSymbol next = (ClosureVarSymbol)symbols[symbols.length - 1];
        return next.bSymbol.type.tsymbol.pkgID;
    }

    @Override
    public void visit(BLangBlockStmt astBlockStmt) {
        BIRNode.BIRBasicBlock blockEndBB = null;
        BIRNode.BIRBasicBlock currentOnFailEndBB = this.env.enclOnFailEndBB;
        BIRNode.BIRBasicBlock currentWithinOnFailEndBB = this.env.enclInnerOnFailEndBB;
        BlockNode prevBlock = this.currentBlock;
        this.currentBlock = astBlockStmt;
        this.env.varDclsByBlock.computeIfAbsent(astBlockStmt, k -> new ArrayList());
        if (astBlockStmt.failureBreakMode != BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE) {
            blockEndBB = this.beginBreakableBlock(astBlockStmt.failureBreakMode);
        }
        for (BLangStatement astStmt : astBlockStmt.stmts) {
            astStmt.accept(this);
        }
        if (astBlockStmt.failureBreakMode != BLangBlockStmt.FailureBreakMode.NOT_BREAKABLE) {
            this.endBreakableBlock(blockEndBB);
        }
        this.env.varDclsByBlock.get(astBlockStmt).forEach(birVariableDcl -> {
            birVariableDcl.endBB = this.env.enclBasicBlocks.get(this.env.enclBasicBlocks.size() - 1);
        });
        if (astBlockStmt.isLetExpr) {
            this.breakBBForLetExprVariables(astBlockStmt.pos);
        }
        this.env.enclInnerOnFailEndBB = currentWithinOnFailEndBB;
        this.env.enclOnFailEndBB = currentOnFailEndBB;
        this.currentBlock = prevBlock;
    }

    private void breakBBForLetExprVariables(Location pos) {
        BIRNode.BIRBasicBlock letExprEndBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.env.enclBB.terminator = new BIRTerminator.GOTO(pos, letExprEndBB, this.currentScope);
        this.env.enclBasicBlocks.add(letExprEndBB);
        this.env.enclBB = letExprEndBB;
    }

    @Override
    public void visit(BLangFail failNode) {
        if (failNode.expr == null) {
            if (this.env.enclInnerOnFailEndBB != null) {
                this.env.enclBB.terminator = new BIRTerminator.GOTO(null, this.env.enclInnerOnFailEndBB, this.currentScope);
            }
            return;
        }
        BIRNode.BIRLockDetailsHolder toUnlock = this.env.unlockVars.peek();
        if (!toUnlock.isEmpty()) {
            BIRNode.BIRBasicBlock goToBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(goToBB);
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, goToBB, this.currentScope);
            this.env.enclBB = goToBB;
        }
        for (int numLocks = toUnlock.size(); numLocks > 0; --numLocks) {
            BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(unlockBB);
            BIRTerminator.Unlock unlock = new BIRTerminator.Unlock(null, unlockBB, this.currentScope);
            this.env.enclBB.terminator = unlock;
            unlock.relatedLock = toUnlock.getLock(numLocks - 1);
            this.env.enclBB = unlockBB;
        }
        BIRNode.BIRBasicBlock onFailBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(onFailBB);
        this.env.enclBasicBlocks.add(onFailBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(null, onFailBB, this.currentScope);
        this.env.enclBB = onFailBB;
        failNode.exprStmt.accept(this);
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, this.env.enclOnFailEndBB, this.currentScope);
        }
        BIRNode.BIRBasicBlock ignoreBlock = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(ignoreBlock);
        ignoreBlock.terminator = new BIRTerminator.GOTO(null, this.env.enclOnFailEndBB, this.currentScope);
        this.env.enclBasicBlocks.add(ignoreBlock);
        this.env.enclBB = ignoreBlock;
    }

    @Override
    public void visit(BLangSimpleVariableDef astVarDefStmt) {
        BirScope newScope;
        VarKind kind = astVarDefStmt.var.symbol.origin == SymbolOrigin.VIRTUAL ? VarKind.SYNTHETIC : VarKind.LOCAL;
        BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(astVarDefStmt.pos, astVarDefStmt.var.symbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, kind, astVarDefStmt.var.name.value);
        birVarDcl.startBB = this.env.enclBB;
        this.env.varDclsByBlock.get(this.currentBlock).add(birVarDcl);
        this.env.enclFunc.localVars.add(birVarDcl);
        this.env.symbolVarMap.put(astVarDefStmt.var.symbol, birVarDcl);
        birVarDcl.insScope = newScope = new BirScope(this.currentScope.id() + 1, this.currentScope);
        this.currentScope = newScope;
        if (astVarDefStmt.var.expr == null) {
            return;
        }
        astVarDefStmt.var.expr.accept(this);
        BIROperand varRef = new BIROperand(birVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.Move(astVarDefStmt.pos, this.env.targetOperand, varRef));
        birVarDcl.insOffset = this.env.enclBB.instructions.size() - 1;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        String name = "$annotation_data".equals(varNode.symbol.name.value) ? "$annotation_data" : varNode.name.value;
        String originalName = "$annotation_data".equals(varNode.symbol.getOriginalName().value) ? "$annotation_data" : varNode.name.originalValue;
        BIRNode.BIRGlobalVariableDcl birVarDcl = new BIRNode.BIRGlobalVariableDcl(varNode.pos, varNode.symbol.flags, varNode.symbol.type, varNode.symbol.pkgID, Names.fromString(name), Names.fromString(originalName), VarScope.GLOBAL, VarKind.GLOBAL, varNode.name.value, varNode.symbol.origin.toBIROrigin());
        birVarDcl.setMarkdownDocAttachment(varNode.symbol.markdownDocumentation);
        birVarDcl.annotAttachments.addAll(BIRWriterUtils.getBIRAnnotAttachments(varNode.symbol.getAnnotations()));
        this.env.enclPkg.globalVars.add(birVarDcl);
        this.globalVarMap.put(varNode.symbol, birVarDcl);
        this.env.enclPkg.isListenerAvailable |= Symbols.isFlagOn(varNode.symbol.flags, 524288L);
    }

    @Override
    public void visit(BLangAssignment astAssignStmt) {
        astAssignStmt.expr.accept(this);
        this.varAssignment = true;
        astAssignStmt.varRef.accept(this);
        this.varAssignment = false;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        BLangExpression expr = exprStmtNode.expr;
        expr.accept(this);
        if (this.env.returnBB == null && expr.getKind() == NodeKind.STATEMENT_EXPRESSION && ((BLangStatementExpression)expr).expr.getKind() == NodeKind.INVOCATION && this.types.isNeverTypeOrStructureTypeWithARequiredNeverMember(expr.getBType())) {
            BIRNode.BIRBasicBlock returnBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            returnBB.terminator = new BIRTerminator.Return(exprStmtNode.pos);
            this.env.returnBB = returnBB;
        }
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        this.createCall(invocationExpr, false);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocation) {
        this.createCall(actionInvocation, false);
    }

    @Override
    public void visit(BLangStatementExpression statementExpression) {
        statementExpression.stmt.accept(this);
        statementExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation invocationExpr) {
        this.createCall(invocationExpr, true);
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation invocation) {
        invocation.functionPointerInvocation = true;
        this.createCall(invocation, false);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        forkJoin.workers.forEach(worker -> worker.accept(this));
    }

    @Override
    public void visit(BLangAlternateWorkerReceive altWorkerReceive) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(altWorkerReceive.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerAlternateReceive(altWorkerReceive.pos, this.getChannelList(altWorkerReceive), lhsOp, isOnSameStrand, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    private List<String> getChannelList(BLangAlternateWorkerReceive alternateWorkerReceive) {
        ArrayList<String> channels = new ArrayList<String>();
        for (BLangWorkerReceive workerReceive : alternateWorkerReceive.getWorkerReceives()) {
            channels.add(workerReceive.getChannel().channelId());
        }
        return channels;
    }

    private List<BIRTerminator.WorkerMultipleReceive.ReceiveField> getChannelList(BLangMultipleWorkerReceive multipleWorkerReceive) {
        ArrayList<BIRTerminator.WorkerMultipleReceive.ReceiveField> channels = new ArrayList<BIRTerminator.WorkerMultipleReceive.ReceiveField>();
        for (BLangMultipleWorkerReceive.BLangReceiveField workerReceive : multipleWorkerReceive.getReceiveFields()) {
            channels.add(new BIRTerminator.WorkerMultipleReceive.ReceiveField(workerReceive.getKey().value, workerReceive.getWorkerReceive().getChannel().channelId()));
        }
        return channels;
    }

    @Override
    public void visit(BLangMultipleWorkerReceive multipleWorkerReceive) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(multipleWorkerReceive.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerMultipleReceive(multipleWorkerReceive.pos, this.getChannelList(multipleWorkerReceive), lhsOp, isOnSameStrand, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerReceive workerReceive) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(workerReceive.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerReceive(workerReceive.pos, Names.fromString(workerReceive.getChannel().channelId()), lhsOp, isOnSameStrand, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerAsyncSendExpr asyncSendExpr) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        asyncSendExpr.expr.accept(this);
        BIROperand dataOp = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(asyncSendExpr.receive.matchingSendsError, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerSend(asyncSendExpr.pos, Names.fromString(asyncSendExpr.getChannel().channelId()), dataOp, isOnSameStrand, false, lhsOp, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSend) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        syncSend.expr.accept(this);
        BIROperand dataOp = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(syncSend.receive.matchingSendsError, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerSend(syncSend.pos, Names.fromString(syncSend.getChannel().channelId()), dataOp, isOnSameStrand, true, lhsOp, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerFlushExpr flushExpr) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        BIRNode.ChannelDetails[] channels = new BIRNode.ChannelDetails[flushExpr.cachedWorkerSendStmts.size()];
        int i = 0;
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        for (BLangWorkerAsyncSendExpr sendStmt : flushExpr.cachedWorkerSendStmts) {
            channels[i] = new BIRNode.ChannelDetails(sendStmt.getChannel().channelId(), isOnSameStrand, true);
            ++i;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(flushExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        this.env.enclBB.terminator = new BIRTerminator.Flush(flushExpr.pos, channels, lhsOp, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    private void createWait(BLangWaitExpr waitExpr) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        ArrayList<BIROperand> exprList = new ArrayList<BIROperand>();
        waitExpr.exprList.forEach(expr -> {
            expr.accept(this);
            exprList.add(this.env.targetOperand);
        });
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(waitExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        this.env.enclBB.terminator = new BIRTerminator.Wait(waitExpr.pos, exprList, lhsOp, thenBB, this.currentScope);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangErrorConstructorExpr errorConstructorExpr) {
        BIROperand lhsOp;
        BIRNode.BIRVariableDcl tempVarError = new BIRNode.BIRVariableDcl(errorConstructorExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarError);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarError);
        List<BLangExpression> positionalArgs = errorConstructorExpr.positionalArgs;
        positionalArgs.get(0).accept(this);
        BIROperand messageOp = this.env.targetOperand;
        positionalArgs.get(1).accept(this);
        BIROperand causeOp = this.env.targetOperand;
        errorConstructorExpr.errorDetail.accept(this);
        BIROperand detailsOp = this.env.targetOperand;
        BIRNonTerminator.NewError newError = new BIRNonTerminator.NewError(errorConstructorExpr.pos, errorConstructorExpr.getBType(), lhsOp, messageOp, causeOp, detailsOp);
        this.setScopeAndEmit(newError);
        this.env.targetOperand = lhsOp;
    }

    private void createCall(BLangInvocation invocationExpr, boolean isVirtual) {
        BIROperand lhsOp;
        BIRNode.BIRVariableDcl tempVarDcl;
        BLangNode bLangNode;
        List<BLangExpression> requiredArgs = invocationExpr.requiredArgs;
        List<BLangExpression> restArgs = invocationExpr.restArgs;
        ArrayList<BIROperand> args = new ArrayList<BIROperand>(requiredArgs.size() + restArgs.size());
        for (BLangExpression requiredArg : requiredArgs) {
            if (requiredArg.getKind() != NodeKind.IGNORE_EXPR) {
                requiredArg.accept(this);
                args.add(this.env.targetOperand);
                continue;
            }
            BIRNode.BIRVariableDcl birVariableDcl = new BIRNode.BIRVariableDcl(requiredArg.getBType(), new Name("_"), VarScope.FUNCTION, VarKind.ARG);
            birVariableDcl.ignoreVariable = true;
            args.add(new BIROperand(birVariableDcl));
        }
        for (BLangExpression arg : restArgs) {
            arg.accept(this);
            args.add(this.env.targetOperand);
        }
        BIROperand fp = null;
        if (invocationExpr.functionPointerInvocation) {
            invocationExpr.expr.accept(this);
            fp = this.env.targetOperand;
        }
        if (invocationExpr.async && (bLangNode = invocationExpr.parent) instanceof BLangSimpleVariable) {
            BLangSimpleVariable simpleVar = (BLangSimpleVariable)bLangNode;
            tempVarDcl = new BIRNode.BIRVariableDcl(invocationExpr.pos, invocationExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP, simpleVar.name.value);
        } else {
            tempVarDcl = new BIRNode.BIRVariableDcl(invocationExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        }
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        if (invocationExpr.functionPointerInvocation) {
            boolean workerDerivative = Symbols.isFlagOn(invocationExpr.symbol.flags, 0x800000L);
            List<BIRNode.BIRAnnotationAttachment> annots = this.getBIRAnnotAttachmentsForASTAnnotAttachments(invocationExpr.annAttachments);
            this.env.enclBB.terminator = new BIRTerminator.FPCall(invocationExpr.pos, InstructionKind.FP_CALL, fp, args, lhsOp, invocationExpr.async, thenBB, this.currentScope, annots);
            if (workerDerivative) {
                this.env.enclFunc.hasWorkers = true;
            }
        } else if (invocationExpr.async) {
            BInvokableSymbol bInvokableSymbol = (BInvokableSymbol)invocationExpr.symbol;
            List<BIRNode.BIRAnnotationAttachment> calleeAnnots = BIRWriterUtils.getBIRAnnotAttachments(bInvokableSymbol.getAnnotations());
            List<BIRNode.BIRAnnotationAttachment> annots = this.getBIRAnnotAttachmentsForASTAnnotAttachments(invocationExpr.annAttachments);
            this.env.enclBB.terminator = new BIRTerminator.AsyncCall(invocationExpr.pos, InstructionKind.ASYNC_CALL, isVirtual, invocationExpr.symbol.pkgID, this.getFuncName((BInvokableSymbol)invocationExpr.symbol), args, lhsOp, thenBB, annots, calleeAnnots, bInvokableSymbol.getFlags(), this.currentScope);
        } else {
            BInvokableSymbol bInvokableSymbol = (BInvokableSymbol)invocationExpr.symbol;
            List<BIRNode.BIRAnnotationAttachment> calleeAnnots = BIRWriterUtils.getBIRAnnotAttachments(bInvokableSymbol.getAnnotations());
            this.env.enclBB.terminator = new BIRTerminator.Call(invocationExpr.pos, InstructionKind.CALL, isVirtual, invocationExpr.symbol.pkgID, this.getFuncName((BInvokableSymbol)invocationExpr.symbol), args, lhsOp, thenBB, calleeAnnots, bInvokableSymbol.getFlags(), this.currentScope);
        }
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangReturn astReturnStmt) {
        astReturnStmt.expr.accept(this);
        BIROperand retVarRef = new BIROperand(this.env.enclFunc.returnVariable);
        this.setScopeAndEmit(new BIRNonTerminator.Move(astReturnStmt.pos, this.env.targetOperand, retVarRef));
        this.addReturnBB(this.getFunctionLastLinePos());
        if (this.env.enclBB.terminator == null) {
            this.env.unlockVars.forEach(s -> {
                for (int i = s.size(); i > 0; --i) {
                    BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
                    this.env.enclBasicBlocks.add(unlockBB);
                    BIRTerminator.Unlock unlock = new BIRTerminator.Unlock(null, unlockBB, this.currentScope);
                    this.env.enclBB.terminator = unlock;
                    unlock.relatedLock = s.getLock(i - 1);
                    this.env.enclBB = unlockBB;
                }
            });
            this.env.enclBB.terminator = new BIRTerminator.GOTO(astReturnStmt.pos, this.env.returnBB, this.currentScope);
            BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(nextBB);
            this.env.enclBB = nextBB;
            this.addToTrapStack(nextBB);
        }
    }

    private BLangDiagnosticLocation getFunctionLastLinePos() {
        if (this.env.enclFunc.pos == null) {
            return null;
        }
        LineRange lineRange = this.env.enclFunc.pos.lineRange();
        LinePosition endLine = lineRange.endLine();
        return new BLangDiagnosticLocation(lineRange.fileName(), endLine.line(), endLine.line(), endLine.offset(), endLine.offset(), 0, 0);
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr.accept(this);
        this.addReturnBB(panicNode.pos);
        this.env.enclBB.terminator = new BIRTerminator.Panic(panicNode.pos, this.env.targetOperand, this.currentScope);
        BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(unlockBB);
        this.env.enclBasicBlocks.add(unlockBB);
        this.env.enclBB = unlockBB;
    }

    @Override
    public void visit(BLangIf astIfStmt) {
        astIfStmt.expr.accept(this);
        BIROperand ifExprResult = this.env.targetOperand;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        BIRTerminator.Branch branchIns = new BIRTerminator.Branch(astIfStmt.pos, ifExprResult, thenBB, null, this.currentScope);
        this.env.enclBB.terminator = branchIns;
        this.env.enclBB = thenBB;
        astIfStmt.body.accept(this);
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, nextBB, this.currentScope);
        }
        if (astIfStmt.elseStmt != null) {
            BIRNode.BIRBasicBlock elseBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.addToTrapStack(elseBB);
            this.env.enclBasicBlocks.add(elseBB);
            branchIns.falseBB = elseBB;
            this.env.enclBB = elseBB;
            astIfStmt.elseStmt.accept(this);
            if (this.env.enclBB.terminator == null) {
                this.env.enclBB.terminator = new BIRTerminator.GOTO(null, nextBB, this.currentScope);
            }
        } else {
            branchIns.falseBB = nextBB;
        }
        this.addToTrapStack(nextBB);
        this.env.enclBasicBlocks.add(nextBB);
        this.env.enclBB = nextBB;
    }

    @Override
    public void visit(BLangWhile astWhileStmt) {
        BIRNode.BIRBasicBlock currentEnclLoopBB = this.env.enclLoopBB;
        BIRNode.BIRBasicBlock currentEnclLoopEndBB = this.env.enclLoopEndBB;
        BIRNode.BIRBasicBlock whileExprBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(whileExprBB);
        this.env.enclBasicBlocks.add(whileExprBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(null, whileExprBB, this.currentScope);
        this.env.enclBB = whileExprBB;
        astWhileStmt.expr.accept(this);
        BIROperand whileExprResult = this.env.targetOperand;
        BIRNode.BIRBasicBlock whileBodyBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(whileBodyBB);
        this.env.enclBasicBlocks.add(whileBodyBB);
        BIRNode.BIRBasicBlock whileEndBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(whileEndBB);
        this.env.enclBB.terminator = new BIRTerminator.Branch(astWhileStmt.pos, whileExprResult, whileBodyBB, whileEndBB, this.currentScope);
        this.env.enclBB = whileBodyBB;
        this.env.enclLoopBB = whileExprBB;
        this.env.enclLoopEndBB = whileEndBB;
        this.env.unlockVars.push(new BIRNode.BIRLockDetailsHolder());
        astWhileStmt.body.accept(this);
        this.env.unlockVars.pop();
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, whileExprBB, this.currentScope);
        }
        this.env.enclBasicBlocks.add(whileEndBB);
        this.env.enclBB = whileEndBB;
        this.env.enclLoopBB = currentEnclLoopBB;
        this.env.enclLoopEndBB = currentEnclLoopEndBB;
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(ignoreExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
    }

    @Override
    public void visit(BLangLiteral astLiteralExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astLiteralExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.ConstantLoad(astLiteralExpr.pos, astLiteralExpr.value, astLiteralExpr.getBType(), toVarRef));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral astMapLiteralExpr) {
        ++this.env.isInArrayOrStructure;
        BType type = astMapLiteralExpr.getBType();
        ++this.env.isInArrayOrStructure;
        this.visitTypedesc(astMapLiteralExpr.pos, type, Collections.emptyList(), this.getAnnotations(type.tsymbol, this.env));
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astMapLiteralExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.NewStructure(astMapLiteralExpr.pos, toVarRef, this.env.targetOperand, this.generateMappingConstructorEntries(astMapLiteralExpr.fields)));
        this.env.targetOperand = toVarRef;
        --this.env.isInArrayOrStructure;
    }

    @Override
    public void visit(BLangTypeConversionExpr astTypeConversionExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astTypeConversionExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        astTypeConversionExpr.expr.accept(this);
        BIROperand rhsOp = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.TypeCast(astTypeConversionExpr.pos, toVarRef, rhsOp, toVarRef.variableDcl.type, astTypeConversionExpr.checkTypes));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral astStructLiteralExpr) {
        ++this.env.isInArrayOrStructure;
        BType type = astStructLiteralExpr.getBType();
        this.visitTypedesc(astStructLiteralExpr.pos, type, Collections.emptyList(), this.getAnnotations(type.tsymbol, this.env));
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astStructLiteralExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BIRNonTerminator.NewStructure instruction = new BIRNonTerminator.NewStructure(astStructLiteralExpr.pos, toVarRef, this.env.targetOperand, this.generateMappingConstructorEntries(astStructLiteralExpr.fields));
        this.setScopeAndEmit(instruction);
        this.env.targetOperand = toVarRef;
        --this.env.isInArrayOrStructure;
    }

    @Override
    public void visit(BLangTypeInit connectorInitExpr) {
        BIRNonTerminator.NewInstance instruction;
        BType exprType = connectorInitExpr.getBType();
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(exprType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BType objectType = this.getEffectiveObjectType(exprType);
        BTypeSymbol objectTypeSymbol = Types.getImpliedType((BType)objectType).tsymbol;
        if (this.isInSamePackage(objectTypeSymbol, this.env.enclPkg.packageID)) {
            BIRNode.BIRTypeDefinition def = this.typeDefs.get(objectTypeSymbol);
            instruction = new BIRNonTerminator.NewInstance(connectorInitExpr.pos, def, toVarRef, objectType);
        } else {
            String objectName = objectTypeSymbol.name.value;
            instruction = new BIRNonTerminator.NewInstance(connectorInitExpr.pos, objectTypeSymbol.pkgID, objectName, toVarRef, objectType);
        }
        this.setScopeAndEmit(instruction);
        this.env.targetOperand = toVarRef;
    }

    private boolean isInSamePackage(BSymbol objectTypeSymbol, PackageID packageID) {
        return objectTypeSymbol.pkgID.equals(packageID);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral astArrayLiteralExpr) {
        BType bType = astArrayLiteralExpr.getBType();
        if (bType.tag == 31) {
            this.visitTypedesc(astArrayLiteralExpr.pos, bType);
        }
        this.generateListConstructorExpr(astArrayLiteralExpr);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        BType type = tupleLiteral.getBType();
        this.visitTypedesc(tupleLiteral.pos, type, this.getAnnotations(type.tsymbol, this.env));
        this.generateListConstructorExpr(tupleLiteral);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression.accept(this);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteralExpr) {
        BType bType = jsonArrayLiteralExpr.getBType();
        if (bType.tag == 31) {
            this.visitTypedesc(jsonArrayLiteralExpr.pos, bType);
        }
        this.generateListConstructorExpr(jsonArrayLiteralExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr astMapAccessExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BIROperand rhsOp = this.env.targetOperand;
        astMapAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        astMapAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        if (variableStore) {
            this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astMapAccessExpr.pos, InstructionKind.MAP_STORE, varRefRegIndex, keyRegIndex, rhsOp, astMapAccessExpr.isStoreOnCreation));
            return;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astMapAccessExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astMapAccessExpr.pos, InstructionKind.MAP_LOAD, tempVarRef, keyRegIndex, varRefRegIndex, astMapAccessExpr.optionalFieldAccess, astMapAccessExpr.isLValue && !astMapAccessExpr.leafNode));
        this.env.targetOperand = tempVarRef;
        this.varAssignment = false;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTableAccessExpr astTableAccessExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BIROperand rhsOp = this.env.targetOperand;
        astTableAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        astTableAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        if (variableStore) {
            this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astTableAccessExpr.pos, InstructionKind.TABLE_STORE, varRefRegIndex, keyRegIndex, rhsOp));
            return;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astTableAccessExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astTableAccessExpr.pos, InstructionKind.TABLE_LOAD, tempVarRef, keyRegIndex, varRefRegIndex));
        this.env.targetOperand = tempVarRef;
        this.varAssignment = false;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr astStructFieldAccessExpr) {
        this.generateMappingAccess(astStructFieldAccessExpr, astStructFieldAccessExpr.optionalFieldAccess);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr astJSONFieldAccessExpr) {
        if (Types.getImpliedType((BType)astJSONFieldAccessExpr.indexExpr.getBType()).tag == 1) {
            this.generateArrayAccess(astJSONFieldAccessExpr);
            return;
        }
        this.generateMappingAccess(astJSONFieldAccessExpr, astJSONFieldAccessExpr.optionalFieldAccess);
    }

    @Override
    public void visit(BLangDynamicArgExpr dynamicParamExpr) {
        dynamicParamExpr.condition.accept(this);
        dynamicParamExpr.conditionalArgument.accept(this);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(stringAccessExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        stringAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        stringAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(stringAccessExpr.pos, InstructionKind.STRING_LOAD, tempVarRef, keyRegIndex, varRefRegIndex));
        this.env.targetOperand = tempVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr astArrayAccessExpr) {
        this.generateArrayAccess(astArrayAccessExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr tupleAccessExpr) {
        this.generateArrayAccess(tupleAccessExpr);
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.booleanType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        isLikeExpr.expr.accept(this);
        BIROperand exprIndex = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.IsLike(isLikeExpr.pos, isLikeExpr.typeNode.getBType(), toVarRef, exprIndex));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.booleanType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        typeTestExpr.expr.accept(this);
        BIROperand exprIndex = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.TypeTest(typeTestExpr.pos, typeTestExpr.typeNode.getBType(), toVarRef, exprIndex));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef astVarRefExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BSymbol varSymbol = astVarRefExpr.symbol;
        if (variableStore) {
            if (astVarRefExpr.symbol.name != Names.IGNORE) {
                BIROperand varRef = new BIROperand(this.env.symbolVarMap.get(varSymbol));
                this.setScopeAndEmit(new BIRNonTerminator.Move(astVarRefExpr.pos, this.env.targetOperand, varRef));
            }
        } else {
            BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(varSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
            this.env.enclFunc.localVars.add(tempVarDcl);
            BIROperand tempVarRef = new BIROperand(tempVarDcl);
            BIRNode.BIRVariableDcl varDecl = this.env.symbolVarMap.get(varSymbol);
            BIROperand fromVarRef = new BIROperand(varDecl);
            this.setScopeAndEmit(new BIRNonTerminator.Move(astVarRefExpr.pos, fromVarRef, tempVarRef));
            this.env.targetOperand = tempVarRef;
        }
        this.varAssignment = variableStore;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef astPackageVarRefExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        if (variableStore) {
            if (astPackageVarRefExpr.symbol.name != Names.IGNORE) {
                BIROperand varRef = new BIROperand(this.getVarRef(astPackageVarRefExpr));
                this.setScopeAndEmit(new BIRNonTerminator.Move(astPackageVarRefExpr.pos, this.env.targetOperand, varRef));
            }
        } else if (this.env.isInArrayOrStructure > 0) {
            BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astPackageVarRefExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
            this.env.enclFunc.localVars.add(tempVarDcl);
            BIROperand tempVarRef = new BIROperand(tempVarDcl);
            BIROperand fromVarRef = new BIROperand(this.getVarRef(astPackageVarRefExpr));
            this.setScopeAndEmit(new BIRNonTerminator.Move(astPackageVarRefExpr.pos, fromVarRef, tempVarRef));
            this.env.targetOperand = tempVarRef;
        } else {
            this.env.targetOperand = new BIROperand(this.getVarRef(astPackageVarRefExpr));
        }
        this.varAssignment = variableStore;
    }

    private BIRNode.BIRGlobalVariableDcl getVarRef(BLangSimpleVarRef.BLangPackageVarRef astPackageVarRefExpr) {
        BSymbol symbol = astPackageVarRefExpr.symbol;
        BIRNode.BIRGlobalVariableDcl globalVarDcl = this.globalVarMap.get(symbol);
        if (globalVarDcl == null) {
            globalVarDcl = new BIRNode.BIRGlobalVariableDcl(astPackageVarRefExpr.pos, symbol.flags, symbol.type, symbol.pkgID, symbol.name, symbol.getOriginalName(), VarScope.GLOBAL, VarKind.CONSTANT, symbol.name.getValue(), symbol.origin.toBIROrigin());
            this.globalVarMap.put(symbol, globalVarDcl);
        }
        if (!this.isInSamePackage(astPackageVarRefExpr.varSymbol, this.env.enclPkg.packageID) || this.env.enclPkg.packageID.isTestPkg) {
            this.env.enclPkg.importedGlobalVarsDummyVarDcls.add(globalVarDcl);
        }
        return globalVarDcl;
    }

    @Override
    public void visit(BLangBinaryExpr astBinaryExpr) {
        BIROperand lhsOp;
        astBinaryExpr.lhsExpr.accept(this);
        BIROperand rhsOp1 = this.env.targetOperand;
        astBinaryExpr.rhsExpr.accept(this);
        BIROperand rhsOp2 = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astBinaryExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        BIRNonTerminator.BinaryOp binaryIns = new BIRNonTerminator.BinaryOp(astBinaryExpr.pos, this.getBinaryInstructionKind(astBinaryExpr.opKind), lhsOp, rhsOp1, rhsOp2);
        this.setScopeAndEmit(binaryIns);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr.accept(this);
        BIROperand rhsOp = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(unaryExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand lhsOp = new BIROperand(tempVarDcl);
        if (OperatorKind.ADD.equals((Object)unaryExpr.operator) || OperatorKind.UNTAINT.equals((Object)unaryExpr.operator)) {
            this.setScopeAndEmit(new BIRNonTerminator.Move(unaryExpr.pos, rhsOp, lhsOp));
            this.env.targetOperand = lhsOp;
            return;
        }
        BIRNonTerminator.UnaryOP unaryIns = new BIRNonTerminator.UnaryOP(unaryExpr.pos, this.getUnaryInstructionKind(unaryExpr.operator), lhsOp, rhsOp);
        this.setScopeAndEmit(unaryIns);
        this.env.targetOperand = lhsOp;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        BIRNode.BIRBasicBlock trapBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.env.enclBasicBlocks.add(trapBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(trapExpr.pos, trapBB, this.currentScope);
        this.env.enclBB = trapBB;
        this.env.trapBlocks.push(new ArrayList());
        this.addToTrapStack(trapBB);
        trapExpr.expr.accept(this);
        List<BIRNode.BIRBasicBlock> trappedBlocks = this.env.trapBlocks.pop();
        BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(nextBB);
        this.env.enclBasicBlocks.add(nextBB);
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(trapExpr.pos, nextBB, this.currentScope);
        }
        this.env.enclFunc.errorTable.add(new BIRNode.BIRErrorEntry(trappedBlocks.getFirst(), trappedBlocks.getLast(), this.env.targetOperand, nextBB));
        this.env.enclBB = nextBB;
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.createWait(waitExpr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        ++this.env.isInArrayOrStructure;
        this.visitTypedesc(waitLiteral.pos, waitLiteral.getBType());
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(thenBB);
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(waitLiteral.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.NewStructure(waitLiteral.pos, toVarRef, this.env.targetOperand));
        this.env.targetOperand = toVarRef;
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<BIROperand> valueExprs = new ArrayList<BIROperand>();
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValue : waitLiteral.keyValuePairs) {
            keys.add(keyValue.key.value);
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            expr.accept(this);
            BIROperand valueRegIndex = this.env.targetOperand;
            valueExprs.add(valueRegIndex);
        }
        this.env.enclBB.terminator = new BIRTerminator.WaitAll(waitLiteral.pos, toVarRef, keys, valueExprs, thenBB, this.currentScope);
        this.env.targetOperand = toVarRef;
        this.env.enclFunc.basicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
        --this.env.isInArrayOrStructure;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.booleanType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        assignableExpr.lhsExpr.accept(this);
        BIROperand exprIndex = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.TypeTest(assignableExpr.pos, assignableExpr.targetType, toVarRef, exprIndex));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.anyType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        if (!xmlQName.isUsedInXML) {
            String qName = xmlQName.namespaceURI == null ? xmlQName.localname.value : "{" + xmlQName.namespaceURI + "}" + String.valueOf(xmlQName.localname);
            this.generateStringLiteral(qName);
            return;
        }
        BIROperand nsURIIndex = this.generateStringLiteral(xmlQName.namespaceURI);
        BIROperand localnameIndex = this.generateStringLiteral(xmlQName.localname.value);
        BIROperand prefixIndex = this.generateStringLiteral(xmlQName.prefix.value);
        BIRNonTerminator.NewXMLQName newXMLQName = new BIRNonTerminator.NewXMLQName(xmlQName.pos, toVarRef, localnameIndex, nsURIIndex, prefixIndex);
        this.setScopeAndEmit(newXMLQName);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlElementLiteral.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlElementLiteral.inlineNamespaces.forEach(xmlns -> xmlns.accept(this));
        BLangExpression startTagName = (BLangExpression)xmlElementLiteral.getStartTagName();
        startTagName.accept(this);
        BIROperand startTagNameIndex = this.env.targetOperand;
        BIROperand defaultNsURIVarRef = this.generateNamespaceRef(xmlElementLiteral.defaultNsSymbol, xmlElementLiteral.pos);
        BIRNonTerminator.NewXMLElement newXMLElement = new BIRNonTerminator.NewXMLElement(xmlElementLiteral.pos, toVarRef, startTagNameIndex, defaultNsURIVarRef, Symbols.isFlagOn(xmlElementLiteral.getBType().getFlags(), 32L));
        this.setScopeAndEmit(newXMLElement);
        this.populateXML(xmlElementLiteral, toVarRef);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLAttribute attribute) {
        BIROperand xmlVarRef = this.env.targetOperand;
        attribute.name.accept(this);
        BIROperand attrNameOp = this.env.targetOperand;
        attribute.value.accept(this);
        BIROperand attrValueOp = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(attribute.pos, InstructionKind.XML_ATTRIBUTE_STORE, xmlVarRef, attrNameOp, attrValueOp));
    }

    @Override
    public void visit(BLangXMLSequenceLiteral xmlSequenceLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlSequenceLiteral.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BIRNonTerminator.NewXMLSequence newXMLSequence = new BIRNonTerminator.NewXMLSequence(xmlSequenceLiteral.pos, toVarRef);
        this.setScopeAndEmit(newXMLSequence);
        this.populateXMLSequence(xmlSequenceLiteral, toVarRef);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlTextLiteral.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlTextLiteral.concatExpr.accept(this);
        BIROperand xmlTextIndex = this.env.targetOperand;
        BIRNonTerminator.NewXMLText newXMLElement = new BIRNonTerminator.NewXMLText(xmlTextLiteral.pos, toVarRef, xmlTextIndex);
        this.setScopeAndEmit(newXMLElement);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlCommentLiteral.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlCommentLiteral.concatExpr.accept(this);
        BIROperand xmlCommentIndex = this.env.targetOperand;
        BIRNonTerminator.NewXMLComment newXMLComment = new BIRNonTerminator.NewXMLComment(xmlCommentLiteral.pos, toVarRef, xmlCommentIndex, Symbols.isFlagOn(xmlCommentLiteral.getBType().getFlags(), 32L));
        this.setScopeAndEmit(newXMLComment);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlProcInsLiteral.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlProcInsLiteral.dataConcatExpr.accept(this);
        BIROperand dataIndex = this.env.targetOperand;
        xmlProcInsLiteral.target.accept(this);
        BIROperand targetIndex = this.env.targetOperand;
        BIRNonTerminator.NewXMLProcIns newXMLProcIns = new BIRNonTerminator.NewXMLProcIns(xmlProcInsLiteral.pos, toVarRef, dataIndex, targetIndex, Symbols.isFlagOn(xmlProcInsLiteral.getBType().getFlags(), 32L));
        this.setScopeAndEmit(newXMLProcIns);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.concatExpr.accept(this);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl.accept(this);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        this.generateXMLNamespace(xmlnsNode);
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        this.generateXMLNamespace(xmlnsNode);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr) {
        this.generateMappingAccess(xmlAccessExpr, false);
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(accessExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.NewTypeDesc(accessExpr.pos, toVarRef, accessExpr.resolvedType, Collections.emptyList()));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangTableConstructorExpr tableConstructorExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(tableConstructorExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BLangListConstructorExpr.BLangArrayLiteral keySpecifierLiteral = new BLangListConstructorExpr.BLangArrayLiteral();
        keySpecifierLiteral.pos = tableConstructorExpr.pos;
        keySpecifierLiteral.setBType(this.symTable.stringArrayType);
        keySpecifierLiteral.exprs = new ArrayList();
        BTableType type = (BTableType)Types.getImpliedType(tableConstructorExpr.getBType());
        if (!type.fieldNameList.isEmpty()) {
            type.fieldNameList.forEach(col -> {
                BLangLiteral colLiteral = new BLangLiteral();
                colLiteral.pos = tableConstructorExpr.pos;
                colLiteral.setBType(this.symTable.stringType);
                colLiteral.value = col;
                keySpecifierLiteral.exprs.add(colLiteral);
            });
        }
        keySpecifierLiteral.accept(this);
        BIROperand keyColOp = this.env.targetOperand;
        BLangListConstructorExpr.BLangArrayLiteral dataLiteral = new BLangListConstructorExpr.BLangArrayLiteral();
        dataLiteral.pos = tableConstructorExpr.pos;
        dataLiteral.setBType(new BArrayType(this.symTable.typeEnv(), ((BTableType)Types.getImpliedType((BType)tableConstructorExpr.getBType())).constraint));
        dataLiteral.exprs = new ArrayList<BLangRecordLiteral>(tableConstructorExpr.recordLiteralList);
        dataLiteral.accept(this);
        BIROperand dataOp = this.env.targetOperand;
        this.setScopeAndEmit(new BIRNonTerminator.NewTable(tableConstructorExpr.pos, tableConstructorExpr.getBType(), toVarRef, keyColOp, dataOp));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        BType type = typeLoad.symbol.tag == 32796L ? ((BTypeDefinitionSymbol)typeLoad.symbol).referenceType : typeLoad.symbol.type;
        this.visitTypedesc(typeLoad.pos, type);
    }

    private void visitTypedesc(Location pos, BType type) {
        this.visitTypedesc(pos, type, Collections.emptyList(), null);
    }

    private void visitTypedesc(Location pos, BType type, BIROperand annotations) {
        this.visitTypedesc(pos, type, Collections.emptyList(), annotations);
    }

    private void visitTypedesc(Location pos, BType type, List<BIROperand> varDcls, BIROperand annotations) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.typeDesc, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        BIRGenEnv env = this.env;
        env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        if (annotations != null) {
            this.setScopeAndEmit(new BIRNonTerminator.NewTypeDesc(pos, toVarRef, type, varDcls, annotations));
            env.targetOperand = toVarRef;
            return;
        }
        this.setScopeAndEmit(new BIRNonTerminator.NewTypeDesc(pos, toVarRef, type, Collections.emptyList()));
        env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangBreak breakStmt) {
        BIRNode.BIRLockDetailsHolder toUnlock = this.env.unlockVars.peek();
        if (!toUnlock.isEmpty()) {
            BIRNode.BIRBasicBlock goToBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(goToBB);
            this.env.enclBB.terminator = new BIRTerminator.GOTO(breakStmt.pos, goToBB, this.currentScope);
            this.env.enclBB = goToBB;
        }
        for (int numLocks = toUnlock.size(); numLocks > 0; --numLocks) {
            BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(unlockBB);
            BIRTerminator.Unlock unlock = new BIRTerminator.Unlock(null, unlockBB, this.currentScope);
            this.env.enclBB.terminator = unlock;
            unlock.relatedLock = toUnlock.getLock(numLocks - 1);
            this.env.enclBB = unlockBB;
        }
        this.env.enclBB.terminator = new BIRTerminator.GOTO(breakStmt.pos, this.env.enclLoopEndBB, this.currentScope);
    }

    @Override
    public void visit(BLangContinue continueStmt) {
        BIRNode.BIRLockDetailsHolder toUnlock = this.env.unlockVars.peek();
        if (!toUnlock.isEmpty()) {
            BIRNode.BIRBasicBlock goToBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(goToBB);
            this.env.enclBB.terminator = new BIRTerminator.GOTO(continueStmt.pos, goToBB, this.currentScope);
            this.env.enclBB = goToBB;
        }
        for (int numLocks = toUnlock.size(); numLocks > 0; --numLocks) {
            BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.env.enclBasicBlocks.add(unlockBB);
            BIRTerminator.Unlock unlock = new BIRTerminator.Unlock(null, unlockBB, this.currentScope);
            this.env.enclBB.terminator = unlock;
            unlock.relatedLock = toUnlock.getLock(numLocks - 1);
            this.env.enclBB = unlockBB;
        }
        this.env.enclBB.terminator = new BIRTerminator.GOTO(continueStmt.pos, this.env.enclLoopBB, this.currentScope);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef fpVarRef) {
        this.generateFPVarRef(fpVarRef, (BInvokableSymbol)fpVarRef.symbol);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef structFpVarRef) {
        this.generateFPVarRef(structFpVarRef, (BInvokableSymbol)structFpVarRef.symbol);
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmt) {
        BIRNode.BIRBasicBlock lockedBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(lockedBB);
        this.env.enclBasicBlocks.add(lockedBB);
        BIRTerminator.Lock lock = new BIRTerminator.Lock(lockStmt.pos, lockedBB, this.currentScope);
        this.env.enclBB.terminator = lock;
        this.lockStmtMap.put(lockStmt, lock);
        this.env.unlockVars.peek().addLock(lock);
        this.populateBirLockWithGlobalVars(lockStmt);
        this.env.enclBB = lockedBB;
    }

    private void populateBirLockWithGlobalVars(BLangLock.BLangLockStmt lockStmt) {
        for (BVarSymbol globalVar : lockStmt.lockVariables) {
            BIRNode.BIRGlobalVariableDcl birGlobalVar = this.globalVarMap.get(globalVar);
            if (birGlobalVar == null) {
                birGlobalVar = this.dummyGlobalVarMapForLocks.computeIfAbsent(globalVar, k -> new BIRNode.BIRGlobalVariableDcl(null, globalVar.flags, globalVar.type, globalVar.pkgID, globalVar.name, globalVar.getOriginalName(), VarScope.GLOBAL, VarKind.GLOBAL, globalVar.name.value, globalVar.origin.toBIROrigin()));
            }
            ((BIRTerminator.Lock)this.env.enclBB.terminator).lockVariables.add(birGlobalVar);
        }
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockStmt) {
        BIRNode.BIRLockDetailsHolder lockDetailsHolder = this.env.unlockVars.peek();
        if (lockDetailsHolder.isEmpty()) {
            return;
        }
        BIRNode.BIRBasicBlock unLockedBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
        this.addToTrapStack(unLockedBB);
        this.env.enclBasicBlocks.add(unLockedBB);
        this.env.enclBB.terminator = new BIRTerminator.Unlock(unLockStmt.pos, unLockedBB, this.currentScope);
        ((BIRTerminator.Unlock)this.env.enclBB.terminator).relatedLock = this.lockStmtMap.get(unLockStmt.relatedLock);
        this.env.enclBB = unLockedBB;
        lockDetailsHolder.removeLastLock();
    }

    @Override
    public void visit(BLangRegExpTemplateLiteral regExpTemplateLiteral) {
        BIROperand toVarRef = this.createVarRefOperand(regExpTemplateLiteral.getBType());
        regExpTemplateLiteral.reDisjunction.accept(this);
        BIROperand reDisjunction = this.env.targetOperand;
        BIRNonTerminator.NewRegExp newRegExp = new BIRNonTerminator.NewRegExp(regExpTemplateLiteral.pos, toVarRef, reDisjunction);
        this.setScopeAndEmit(newRegExp);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReDisjunction reDisjunction) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        BLangListConstructorExpr.BLangArrayLiteral seqList = new BLangListConstructorExpr.BLangArrayLiteral();
        seqList.pos = reDisjunction.pos;
        seqList.setBType(this.symTable.arrayAnydataType);
        seqList.exprs = new ArrayList();
        seqList.exprs.addAll(reDisjunction.sequenceList);
        seqList.accept(this);
        BIROperand sequences = this.env.targetOperand;
        BIRNonTerminator.NewReDisjunction newRegExp = new BIRNonTerminator.NewReDisjunction(reDisjunction.pos, sequences, toVarRef);
        this.setScopeAndEmit(newRegExp);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReSequence reSequence) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        BLangListConstructorExpr.BLangArrayLiteral terms = new BLangListConstructorExpr.BLangArrayLiteral();
        terms.pos = reSequence.pos;
        terms.setBType(this.symTable.arrayAnydataType);
        terms.exprs = new ArrayList();
        terms.exprs.addAll(reSequence.termList);
        terms.accept(this);
        BIROperand sequences = this.env.targetOperand;
        BIRNonTerminator.NewReSequence newReSequence = new BIRNonTerminator.NewReSequence(reSequence.pos, sequences, toVarRef);
        this.setScopeAndEmit(newReSequence);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReAssertion reAssertion) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reAssertion.assertion.accept(this);
        BIROperand assertion = this.env.targetOperand;
        BIRNonTerminator.NewReAssertion newReAssertion = new BIRNonTerminator.NewReAssertion(reAssertion.pos, assertion, toVarRef);
        this.setScopeAndEmit(newReAssertion);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReAtomQuantifier reAtomQuantifier) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reAtomQuantifier.atom.accept(this);
        BIROperand atom = this.env.targetOperand;
        reAtomQuantifier.quantifier.accept(this);
        BIROperand quantifier = this.env.targetOperand;
        BIRNonTerminator.NewReAtomQuantifier newReAtomQuantifier = new BIRNonTerminator.NewReAtomQuantifier(reAtomQuantifier.pos, toVarRef, atom, quantifier);
        this.setScopeAndEmit(newReAtomQuantifier);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReQuantifier reQuantifier) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reQuantifier.quantifier.accept(this);
        BIROperand quantifier = this.env.targetOperand;
        reQuantifier.nonGreedyChar.accept(this);
        BIROperand nonGreedyChar = this.env.targetOperand;
        BIRNonTerminator.NewReQuantifier newReQuantifier = new BIRNonTerminator.NewReQuantifier(reQuantifier.pos, toVarRef, quantifier, nonGreedyChar);
        this.setScopeAndEmit(newReQuantifier);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReAtomCharOrEscape reLiteralCharOrEscape) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reLiteralCharOrEscape.charOrEscape.accept(this);
        BIROperand charOrEscape = this.env.targetOperand;
        BIRNonTerminator.NewReLiteralCharOrEscape newReLiteralCharOrEscape = new BIRNonTerminator.NewReLiteralCharOrEscape(reLiteralCharOrEscape.pos, toVarRef, charOrEscape);
        this.setScopeAndEmit(newReLiteralCharOrEscape);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReCharacterClass reCharacterClass) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reCharacterClass.characterClassStart.accept(this);
        BIROperand classStart = this.env.targetOperand;
        reCharacterClass.negation.accept(this);
        BIROperand negation = this.env.targetOperand;
        reCharacterClass.charSet.accept(this);
        BIROperand charSet = this.env.targetOperand;
        reCharacterClass.characterClassEnd.accept(this);
        BIROperand classEnd = this.env.targetOperand;
        BIRNonTerminator.NewReCharacterClass newReCharacterClass = new BIRNonTerminator.NewReCharacterClass(reCharacterClass.pos, toVarRef, classStart, negation, charSet, classEnd);
        this.setScopeAndEmit(newReCharacterClass);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReCharSet reCharSet) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        BLangListConstructorExpr.BLangArrayLiteral atoms = new BLangListConstructorExpr.BLangArrayLiteral();
        atoms.pos = reCharSet.pos;
        atoms.setBType(this.symTable.arrayAnydataType);
        atoms.exprs = new ArrayList();
        atoms.exprs.addAll(reCharSet.charSetAtoms);
        atoms.accept(this);
        BIROperand charSetAtoms = this.env.targetOperand;
        BIRNonTerminator.NewReCharSet newReCharSet = new BIRNonTerminator.NewReCharSet(reCharSet.pos, toVarRef, charSetAtoms);
        this.setScopeAndEmit(newReCharSet);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReCharSetRange reCharSetRange) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reCharSetRange.lhsCharSetAtom.accept(this);
        BIROperand lhsCharSetAtom = this.env.targetOperand;
        reCharSetRange.dash.accept(this);
        BIROperand dash = this.env.targetOperand;
        reCharSetRange.rhsCharSetAtom.accept(this);
        BIROperand rhsCharSetAtom = this.env.targetOperand;
        BIRNonTerminator.NewReCharSetRange newReCharSet = new BIRNonTerminator.NewReCharSetRange(reCharSetRange.pos, toVarRef, lhsCharSetAtom, dash, rhsCharSetAtom);
        this.setScopeAndEmit(newReCharSet);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReCapturingGroups reCapturingGroups) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reCapturingGroups.openParen.accept(this);
        BIROperand openParen = this.env.targetOperand;
        reCapturingGroups.flagExpr.accept(this);
        BIROperand flagExpr = this.env.targetOperand;
        reCapturingGroups.disjunction.accept(this);
        BIROperand reDisjunction = this.env.targetOperand;
        reCapturingGroups.closeParen.accept(this);
        BIROperand closeParen = this.env.targetOperand;
        BIRNonTerminator.NewReCapturingGroup newReCapturingGroup = new BIRNonTerminator.NewReCapturingGroup(reCapturingGroups.pos, toVarRef, openParen, flagExpr, reDisjunction, closeParen);
        this.setScopeAndEmit(newReCapturingGroup);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReFlagExpression reFlagExpression) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reFlagExpression.questionMark.accept(this);
        BIROperand questionMark = this.env.targetOperand;
        reFlagExpression.flagsOnOff.accept(this);
        BIROperand flagsOnOff = this.env.targetOperand;
        reFlagExpression.colon.accept(this);
        BIROperand colon = this.env.targetOperand;
        BIRNonTerminator.NewReFlagExpression newReFlagExpression = new BIRNonTerminator.NewReFlagExpression(reFlagExpression.pos, toVarRef, questionMark, flagsOnOff, colon);
        this.setScopeAndEmit(newReFlagExpression);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangReFlagsOnOff reFlagsOnOff) {
        BIROperand toVarRef = this.createVarRefOperand(this.symTable.anydataType);
        reFlagsOnOff.flags.accept(this);
        BIROperand flags = this.env.targetOperand;
        BIRNonTerminator.NewReFlagOnOff newReFlagOnOff = new BIRNonTerminator.NewReFlagOnOff(reFlagsOnOff.pos, toVarRef, flags);
        this.setScopeAndEmit(newReFlagOnOff);
        this.env.targetOperand = toVarRef;
    }

    private BIROperand createVarRefOperand(BType type) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        return new BIROperand(tempVarDcl);
    }

    private void setScopeAndEmit(BIRNonTerminator instruction) {
        instruction.scope = this.currentScope;
        this.env.enclBB.instructions.add(instruction);
    }

    private InstructionKind getBinaryInstructionKind(OperatorKind opKind) {
        return switch (opKind) {
            case OperatorKind.ADD -> InstructionKind.ADD;
            case OperatorKind.SUB -> InstructionKind.SUB;
            case OperatorKind.MUL -> InstructionKind.MUL;
            case OperatorKind.DIV -> InstructionKind.DIV;
            case OperatorKind.MOD -> InstructionKind.MOD;
            case OperatorKind.EQUAL, OperatorKind.EQUALS -> InstructionKind.EQUAL;
            case OperatorKind.NOT_EQUAL -> InstructionKind.NOT_EQUAL;
            case OperatorKind.GREATER_THAN -> InstructionKind.GREATER_THAN;
            case OperatorKind.GREATER_EQUAL -> InstructionKind.GREATER_EQUAL;
            case OperatorKind.LESS_THAN -> InstructionKind.LESS_THAN;
            case OperatorKind.LESS_EQUAL -> InstructionKind.LESS_EQUAL;
            case OperatorKind.AND -> InstructionKind.AND;
            case OperatorKind.OR -> InstructionKind.OR;
            case OperatorKind.REF_EQUAL -> InstructionKind.REF_EQUAL;
            case OperatorKind.REF_NOT_EQUAL -> InstructionKind.REF_NOT_EQUAL;
            case OperatorKind.CLOSED_RANGE -> InstructionKind.CLOSED_RANGE;
            case OperatorKind.HALF_OPEN_RANGE -> InstructionKind.HALF_OPEN_RANGE;
            case OperatorKind.ANNOT_ACCESS -> InstructionKind.ANNOT_ACCESS;
            case OperatorKind.BITWISE_AND -> InstructionKind.BITWISE_AND;
            case OperatorKind.BITWISE_OR -> InstructionKind.BITWISE_OR;
            case OperatorKind.BITWISE_XOR -> InstructionKind.BITWISE_XOR;
            case OperatorKind.BITWISE_LEFT_SHIFT -> InstructionKind.BITWISE_LEFT_SHIFT;
            case OperatorKind.BITWISE_RIGHT_SHIFT -> InstructionKind.BITWISE_RIGHT_SHIFT;
            case OperatorKind.BITWISE_UNSIGNED_RIGHT_SHIFT -> InstructionKind.BITWISE_UNSIGNED_RIGHT_SHIFT;
            default -> throw new IllegalStateException("unsupported binary operation: " + opKind.value());
        };
    }

    private InstructionKind getUnaryInstructionKind(OperatorKind opKind) {
        return switch (opKind) {
            case OperatorKind.TYPEOF -> InstructionKind.TYPEOF;
            case OperatorKind.NOT -> InstructionKind.NOT;
            case OperatorKind.SUB -> InstructionKind.NEGATE;
            case OperatorKind.ADD -> InstructionKind.MOVE;
            default -> throw new IllegalStateException("unsupported unary operator: " + opKind.value());
        };
    }

    private void generateListConstructorExpr(BLangListConstructorExpr listConstructorExpr) {
        ++this.env.isInArrayOrStructure;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(listConstructorExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        long size = -1L;
        BIROperand typedescOp = null;
        List<BLangExpression> exprs = listConstructorExpr.exprs;
        BType listConstructorExprType = listConstructorExpr.getBType();
        BType referredType = Types.getImpliedType(listConstructorExprType);
        if (referredType.tag == 20 && ((BArrayType)referredType).state != BArrayState.OPEN) {
            size = ((BArrayType)referredType).getSize();
        } else if (referredType.tag == 31) {
            typedescOp = this.env.targetOperand;
            size = exprs.size();
        }
        BLangLiteral literal = new BLangLiteral();
        literal.pos = listConstructorExpr.pos;
        literal.value = size;
        literal.setBType(this.symTable.intType);
        literal.accept(this);
        BIROperand sizeOp = this.env.targetOperand;
        ArrayList<BIRNode.BIRListConstructorEntry> initialValues = new ArrayList<BIRNode.BIRListConstructorEntry>(exprs.size());
        for (BLangExpression expr : exprs) {
            if (expr.getKind() == NodeKind.LIST_CONSTRUCTOR_SPREAD_OP) {
                BLangListConstructorExpr.BLangListConstructorSpreadOpExpr spreadMember = (BLangListConstructorExpr.BLangListConstructorSpreadOpExpr)expr;
                spreadMember.expr.accept(this);
                initialValues.add(new BIRNode.BIRListConstructorSpreadMemberEntry(this.env.targetOperand));
                continue;
            }
            expr.accept(this);
            initialValues.add(new BIRNode.BIRListConstructorExprEntry(this.env.targetOperand));
        }
        if (referredType.tag == 31) {
            this.setScopeAndEmit(new BIRNonTerminator.NewArray(listConstructorExpr.pos, listConstructorExprType, toVarRef, typedescOp, sizeOp, initialValues));
        } else {
            this.setScopeAndEmit(new BIRNonTerminator.NewArray(listConstructorExpr.pos, listConstructorExprType, toVarRef, sizeOp, initialValues));
        }
        this.env.targetOperand = toVarRef;
        --this.env.isInArrayOrStructure;
    }

    private void generateArrayAccess(BLangIndexBasedAccess astArrayAccessExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BIROperand rhsOp = this.env.targetOperand;
        astArrayAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        astArrayAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        if (variableStore) {
            this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astArrayAccessExpr.pos, InstructionKind.ARRAY_STORE, varRefRegIndex, keyRegIndex, rhsOp));
            return;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astArrayAccessExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astArrayAccessExpr.pos, InstructionKind.ARRAY_LOAD, tempVarRef, keyRegIndex, varRefRegIndex, false, astArrayAccessExpr.isLValue && !astArrayAccessExpr.leafNode));
        this.env.targetOperand = tempVarRef;
        this.varAssignment = false;
    }

    private void generateMappingAccess(BLangIndexBasedAccess astIndexBasedAccessExpr, boolean except) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BType astAccessExprExprType = Types.getImpliedType(astIndexBasedAccessExpr.expr.getBType());
        if (variableStore) {
            InstructionKind insKind;
            BIROperand rhsOp = this.env.targetOperand;
            astIndexBasedAccessExpr.expr.accept(this);
            BIROperand varRefRegIndex = this.env.targetOperand;
            astIndexBasedAccessExpr.indexExpr.accept(this);
            BIROperand keyRegIndex = this.env.targetOperand;
            if (astIndexBasedAccessExpr.getKind() == NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
                insKind = InstructionKind.XML_ATTRIBUTE_STORE;
                keyRegIndex = this.getQNameOP(astIndexBasedAccessExpr.indexExpr, keyRegIndex);
            } else {
                insKind = SemTypeHelper.isSubtypeSimple(astAccessExprExprType, PredefinedType.OBJECT) ? InstructionKind.OBJECT_STORE : InstructionKind.MAP_STORE;
            }
            this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astIndexBasedAccessExpr.pos, insKind, varRefRegIndex, keyRegIndex, rhsOp, astIndexBasedAccessExpr.isStoreOnCreation));
        } else {
            InstructionKind insKind;
            BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astIndexBasedAccessExpr.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
            this.env.enclFunc.localVars.add(tempVarDcl);
            BIROperand tempVarRef = new BIROperand(tempVarDcl);
            astIndexBasedAccessExpr.expr.accept(this);
            BIROperand varRefRegIndex = this.env.targetOperand;
            astIndexBasedAccessExpr.indexExpr.accept(this);
            BIROperand keyRegIndex = this.env.targetOperand;
            if (astIndexBasedAccessExpr.getKind() == NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
                insKind = InstructionKind.XML_ATTRIBUTE_LOAD;
                keyRegIndex = this.getQNameOP(astIndexBasedAccessExpr.indexExpr, keyRegIndex);
            } else {
                if (this.types.isAssignable(astAccessExprExprType, this.symTable.xmlType)) {
                    this.generateXMLAccess((BLangIndexBasedAccess.BLangXMLAccessExpr)astIndexBasedAccessExpr, tempVarRef, varRefRegIndex, keyRegIndex);
                    this.varAssignment = false;
                    return;
                }
                insKind = SemTypeHelper.isSubtypeSimple(astAccessExprExprType, PredefinedType.OBJECT) ? InstructionKind.OBJECT_LOAD : InstructionKind.MAP_LOAD;
            }
            this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(astIndexBasedAccessExpr.pos, insKind, tempVarRef, keyRegIndex, varRefRegIndex, except, astIndexBasedAccessExpr.isLValue && !astIndexBasedAccessExpr.leafNode));
            this.env.targetOperand = tempVarRef;
        }
        this.varAssignment = variableStore;
    }

    private BType getEffectiveObjectType(BType objType) {
        BType type = Types.getImpliedType(objType);
        if (type.tag == 21) {
            return ((BUnionType)type).getMemberTypes().stream().filter(t -> Types.getImpliedType((BType)t).tag != 29).findFirst().orElse(this.symTable.noType);
        }
        return objType;
    }

    private BIROperand generateStringLiteral(String value) {
        BLangLiteral prefixLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        prefixLiteral.value = value;
        if (value == null) {
            prefixLiteral.setBType(this.symTable.nilType);
        } else {
            prefixLiteral.setBType(this.symTable.stringType);
        }
        prefixLiteral.accept(this);
        return this.env.targetOperand;
    }

    private void generateXMLNamespace(BLangXMLNS xmlnsNode) {
        BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(xmlnsNode.pos, this.symTable.stringType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.LOCAL, null);
        this.env.enclFunc.localVars.add(birVarDcl);
        this.env.symbolVarMap.put(xmlnsNode.symbol, birVarDcl);
        xmlnsNode.namespaceURI.accept(this);
        BIROperand varRef = new BIROperand(birVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.Move(xmlnsNode.pos, this.env.targetOperand, varRef));
    }

    private BIROperand generateNamespaceRef(BXMLNSSymbol nsSymbol, Location pos) {
        if (nsSymbol == null) {
            return this.generateStringLiteral(null);
        }
        long ownerTag = nsSymbol.owner.tag;
        if ((ownerTag & 0x1001L) == 4097L || (ownerTag & 0x1805CL) == 98396L || (ownerTag & 0x2805CL) == 163932L) {
            return this.generateStringLiteral(nsSymbol.namespaceURI);
        }
        BIRNode.BIRVariableDcl nsURIVarDcl = new BIRNode.BIRVariableDcl(this.symTable.stringType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(nsURIVarDcl);
        BIROperand nsURIVarRef = new BIROperand(nsURIVarDcl);
        BIRNode.BIRVariableDcl varDecl = this.env.symbolVarMap.get(nsSymbol);
        BIROperand fromVarRef = new BIROperand(varDecl);
        this.setScopeAndEmit(new BIRNonTerminator.Move(pos, fromVarRef, nsURIVarRef));
        return nsURIVarRef;
    }

    private void populateXMLSequence(BLangXMLSequenceLiteral xmlSequenceLiteral, BIROperand toVarRef) {
        for (BLangExpression xmlItem : xmlSequenceLiteral.xmlItems) {
            xmlItem.accept(this);
            BIROperand childOp = this.env.targetOperand;
            this.setScopeAndEmit(new BIRNonTerminator.XMLAccess(xmlItem.pos, InstructionKind.XML_SEQ_STORE, toVarRef, childOp));
        }
    }

    private void populateXML(BLangXMLElementLiteral xmlElementLiteral, BIROperand toVarRef) {
        xmlElementLiteral.namespacesInScope.forEach((name, symbol) -> {
            BLangXMLQName nsQName = new BLangXMLQName(name.getValue(), "xmlns");
            nsQName.setBType(this.symTable.stringType);
            nsQName.accept(this);
            BIROperand nsQNameIndex = this.env.targetOperand;
            BIROperand nsURIIndex = this.generateNamespaceRef((BXMLNSSymbol)symbol, xmlElementLiteral.pos);
            this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(xmlElementLiteral.pos, InstructionKind.XML_ATTRIBUTE_STORE, toVarRef, nsQNameIndex, nsURIIndex));
        });
        xmlElementLiteral.attributes.forEach(attribute -> {
            this.env.targetOperand = toVarRef;
            attribute.accept(this);
        });
        xmlElementLiteral.modifiedChildren.forEach(child -> {
            child.accept(this);
            BIROperand childOp = this.env.targetOperand;
            this.setScopeAndEmit(new BIRNonTerminator.XMLAccess(child.pos, InstructionKind.XML_SEQ_STORE, toVarRef, childOp));
        });
    }

    private BIROperand getQNameOP(BLangExpression qnameExpr, BIROperand keyRegIndex) {
        if (qnameExpr.getKind() == NodeKind.XML_QNAME) {
            return keyRegIndex;
        }
        BIRNode.BIRVariableDcl tempQNameVarDcl = new BIRNode.BIRVariableDcl(this.symTable.anyType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempQNameVarDcl);
        BIROperand qnameVarRef = new BIROperand(tempQNameVarDcl);
        this.setScopeAndEmit(new BIRNonTerminator.NewStringXMLQName(qnameExpr.pos, qnameVarRef, keyRegIndex));
        return qnameVarRef;
    }

    private void generateXMLAccess(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr, BIROperand tempVarRef, BIROperand varRefRegIndex, BIROperand keyRegIndex) {
        this.env.targetOperand = tempVarRef;
        if (xmlAccessExpr.fieldType == FieldKind.ALL) {
            this.setScopeAndEmit(new BIRNonTerminator.XMLAccess(xmlAccessExpr.pos, InstructionKind.XML_LOAD_ALL, tempVarRef, varRefRegIndex));
            return;
        }
        InstructionKind insKind = Types.getImpliedType((BType)xmlAccessExpr.indexExpr.getBType()).tag == 5 ? InstructionKind.XML_LOAD : InstructionKind.XML_SEQ_LOAD;
        this.setScopeAndEmit(new BIRNonTerminator.FieldAccess(xmlAccessExpr.pos, insKind, tempVarRef, keyRegIndex, varRefRegIndex));
    }

    private void generateFPVarRef(BLangExpression fpVarRef, BInvokableSymbol funcSymbol) {
        BIRNode.BIRVariableDcl tempVarLambda = new BIRNode.BIRVariableDcl(fpVarRef.getBType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarLambda);
        BIROperand lhsOp = new BIROperand(tempVarLambda);
        Name funcName = this.getFuncName(funcSymbol);
        ArrayList<BIRNode.BIRVariableDcl> params = new ArrayList<BIRNode.BIRVariableDcl>();
        funcSymbol.params.forEach(param -> {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(fpVarRef.pos, param.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, null);
            params.add(birVarDcl);
        });
        BVarSymbol restParam = funcSymbol.restParam;
        if (restParam != null) {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(fpVarRef.pos, restParam.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, null);
            params.add(birVarDcl);
        }
        this.setScopeAndEmit(new BIRNonTerminator.FPLoad(fpVarRef.pos, funcSymbol.pkgID, funcName, lhsOp, params, new ArrayList<BIROperand>(), funcSymbol.type, funcSymbol.strandName, funcSymbol.schedulerPolicy, funcSymbol.pkgID));
        this.env.targetOperand = lhsOp;
    }

    private void addToTrapStack(BIRNode.BIRBasicBlock birBasicBlock) {
        if (this.env.trapBlocks.isEmpty()) {
            return;
        }
        this.env.trapBlocks.peek().add(birBasicBlock);
    }

    private List<BIRNode.BIRMappingConstructorEntry> generateMappingConstructorEntries(List<RecordLiteralNode.RecordField> fields) {
        ArrayList<BIRNode.BIRMappingConstructorEntry> initialValues = new ArrayList<BIRNode.BIRMappingConstructorEntry>(fields.size());
        for (RecordLiteralNode.RecordField field : fields) {
            if (field.isKeyValueField()) {
                BLangRecordLiteral.BLangRecordKeyValueField keyValueField = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                keyValueField.key.expr.accept(this);
                BIROperand keyOperand = this.env.targetOperand;
                keyValueField.valueExpr.accept(this);
                BIROperand valueOperand = this.env.targetOperand;
                initialValues.add(new BIRNode.BIRMappingConstructorKeyValueEntry(keyOperand, valueOperand));
                continue;
            }
            BLangRecordLiteral.BLangRecordSpreadOperatorField spreadField = (BLangRecordLiteral.BLangRecordSpreadOperatorField)field;
            spreadField.expr.accept(this);
            initialValues.add(new BIRNode.BIRMappingConstructorSpreadFieldEntry(this.env.targetOperand));
        }
        return initialValues;
    }

    private List<BIRNode.BIRAnnotationAttachment> getBIRAnnotAttachmentsForASTAnnotAttachments(List<BLangAnnotationAttachment> astAnnotAttachments) {
        ArrayList<BIRNode.BIRAnnotationAttachment> annotationAttachments = new ArrayList<BIRNode.BIRAnnotationAttachment>(astAnnotAttachments.size());
        for (BLangAnnotationAttachment astAnnotAttachment : astAnnotAttachments) {
            annotationAttachments.add(BIRWriterUtils.createBIRAnnotationAttachment(astAnnotAttachment.annotationAttachmentSymbol));
        }
        return annotationAttachments;
    }

    private BIROperand getAnnotations(BTypeSymbol typeSymbol, BIRGenEnv env) {
        if (typeSymbol == null || typeSymbol.annotations == null) {
            return null;
        }
        return new BIROperand(this.getAnnotations(typeSymbol.annotations, env));
    }

    private BIRNode.BIRVariableDcl getAnnotations(BVarSymbol annotations, BIRGenEnv env) {
        if (env.symbolVarMap.containsKey(annotations)) {
            return env.symbolVarMap.get(annotations);
        }
        return this.globalVarMap.get(annotations);
    }

    private void addReturnBB(Location pos) {
        if (this.env.returnBB == null) {
            BIRNode.BIRBasicBlock returnBB = new BIRNode.BIRBasicBlock(this.env.nextBBId());
            this.addToTrapStack(returnBB);
            returnBB.terminator = new BIRTerminator.Return(pos);
            this.env.returnBB = returnBB;
        }
    }
}

