/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Context;
import io.ballerina.types.Core;
import io.ballerina.types.PredefinedType;
import io.ballerina.types.SemType;
import io.ballerina.types.SemTypes;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmTypeTestGen {
    private final JvmInstructionGen jvmInstructionGen;
    private final Types types;
    private final MethodVisitor mv;
    private final JvmTypeGen jvmTypeGen;
    private final JvmCastGen jvmCastGen;

    public JvmTypeTestGen(JvmInstructionGen jvmInstructionGen, Types types, MethodVisitor mv, JvmTypeGen jvmTypeGen, JvmCastGen jvmCastGen) {
        this.jvmInstructionGen = jvmInstructionGen;
        this.types = types;
        this.mv = mv;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmCastGen = jvmCastGen;
    }

    void generateTypeTestIns(BIRNonTerminator.TypeTest typeTestIns) {
        BIRNode.BIRVariableDcl sourceValue = typeTestIns.rhsOp.variableDcl;
        BType sourceType = sourceValue.type;
        BType targetType = typeTestIns.type;
        if (this.canOptimizeNilCheck(sourceType, targetType) || this.canOptimizeNilUnionCheck(sourceType, targetType) || sourceValue.name.value.startsWith("%param")) {
            this.handleNilUnionType(typeTestIns);
            return;
        }
        if (this.canOptimizeErrorCheck(sourceType, targetType) || this.canOptimizeErrorUnionCheck(sourceType, targetType)) {
            this.handleErrorUnionType(typeTestIns);
            return;
        }
        this.jvmInstructionGen.loadVar(sourceValue);
        this.jvmTypeGen.loadType(this.mv, targetType);
        this.mv.visitMethodInsn(184, "io/ballerina/runtime/internal/TypeChecker", "checkIsType", "(Ljava/lang/Object;Lio/ballerina/runtime/api/types/Type;)Z", false);
        this.jvmInstructionGen.storeToVar(typeTestIns.lhsOp.variableDcl);
    }

    private boolean canOptimizeNilCheck(BType sourceType, BType targetType) {
        return PredefinedType.NIL.equals((Object)targetType.semType()) && SemTypes.containsBasicType((SemType)sourceType.semType(), (BasicTypeBitSet)PredefinedType.NIL);
    }

    private boolean canOptimizeNilUnionCheck(BType sourceType, BType targetType) {
        SemType sourceTy = sourceType.semType();
        if (!SemTypes.containsBasicType((SemType)sourceTy, (BasicTypeBitSet)PredefinedType.NIL)) {
            return false;
        }
        SemType tyButNil = Core.diff((SemType)sourceTy, (SemType)PredefinedType.NIL);
        if (Core.isNever((SemType)tyButNil)) {
            return false;
        }
        return SemTypes.isSameType((Context)this.types.typeCtx(), (SemType)tyButNil, (SemType)targetType.semType());
    }

    private boolean canOptimizeErrorCheck(BType sourceType, BType targetType) {
        SemType targetTy = targetType.semType();
        if (!Core.isSubtypeSimple((SemType)targetTy, (BasicTypeBitSet)PredefinedType.ERROR)) {
            return false;
        }
        SemType errIntersect = SemTypes.intersect((SemType)sourceType.semType(), (SemType)PredefinedType.ERROR);
        if (Core.isNever((SemType)errIntersect)) {
            return false;
        }
        return SemTypes.isSubtype((Context)this.types.typeCtx(), (SemType)errIntersect, (SemType)targetTy);
    }

    private boolean canOptimizeErrorUnionCheck(BType sourceType, BType targetType) {
        SemType sourceTy = sourceType.semType();
        if (!SemTypes.containsBasicType((SemType)sourceTy, (BasicTypeBitSet)PredefinedType.ERROR)) {
            return false;
        }
        SemType tyButError = Core.diff((SemType)sourceTy, (SemType)PredefinedType.ERROR);
        if (Core.isNever((SemType)tyButError)) {
            return false;
        }
        return SemTypes.isSameType((Context)this.types.typeCtx(), (SemType)tyButError, (SemType)targetType.semType());
    }

    private void handleNilUnionType(BIRNonTerminator.TypeTest typeTestIns) {
        this.jvmInstructionGen.loadVar(typeTestIns.rhsOp.variableDcl);
        this.jvmCastGen.addBoxInsn(this.mv, typeTestIns.rhsOp.variableDcl.type);
        Label ifLabel = new Label();
        if (PredefinedType.NIL.equals((Object)typeTestIns.type.semType())) {
            this.mv.visitJumpInsn(199, ifLabel);
        } else {
            this.mv.visitJumpInsn(198, ifLabel);
        }
        this.loadBoolean(ifLabel);
        this.jvmInstructionGen.storeToVar(typeTestIns.lhsOp.variableDcl);
    }

    private void loadBoolean(Label ifLabel) {
        this.mv.visitInsn(4);
        Label gotoLabel = new Label();
        this.mv.visitJumpInsn(167, gotoLabel);
        this.mv.visitLabel(ifLabel);
        this.mv.visitInsn(3);
        this.mv.visitLabel(gotoLabel);
    }

    private void handleErrorUnionType(BIRNonTerminator.TypeTest typeTestIns) {
        this.jvmInstructionGen.loadVar(typeTestIns.rhsOp.variableDcl);
        this.mv.visitTypeInsn(193, "io/ballerina/runtime/api/values/BError");
        if (!Core.isSubtypeSimple((SemType)typeTestIns.type.semType(), (BasicTypeBitSet)PredefinedType.ERROR)) {
            this.generateNegateBoolean();
        }
        this.jvmInstructionGen.storeToVar(typeTestIns.lhsOp.variableDcl);
    }

    private void generateNegateBoolean() {
        Label ifLabel = new Label();
        this.mv.visitJumpInsn(154, ifLabel);
        this.loadBoolean(ifLabel);
    }
}

