/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JType;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;

public final class AnnotationProc {
    public static final String NAME_FIELD_NAME = "name";
    public static final String CLASS_FIELD_NAME = "class";
    public static final String PARAM_TYPES_FIELD_NAME = "paramTypes";
    public static final String DIMENSIONS_FIELD_NAME = "dimensions";

    private AnnotationProc() {
    }

    static InteropValidationRequest getInteropAnnotValue(BIRNode.BIRFunction birFunc) {
        BIRNode.BIRAnnotationAttachment annotAttach = AnnotationProc.getInteropAnnotAttachment(birFunc);
        if (annotAttach == null) {
            return null;
        }
        String annotTagRef = annotAttach.annotTagRef.value;
        return AnnotationProc.createJInteropValidationRequest(annotTagRef, annotAttach, birFunc);
    }

    private static BIRNode.BIRAnnotationAttachment getInteropAnnotAttachment(BIRNode.BIRFunction birFunc) {
        for (BIRNode.BIRAnnotationAttachment annotationAttachment : birFunc.annotAttachments) {
            if (!AnnotationProc.isInteropAnnotAttachment(annotationAttachment)) continue;
            return annotationAttachment;
        }
        return null;
    }

    private static boolean isInteropAnnotAttachment(BIRNode.BIRAnnotationAttachment annotAttach) {
        return "ballerina".equals(annotAttach.annotPkgId.orgName.value) && "jballerina.java".equals(annotAttach.annotPkgId.name.value) && JInterop.isInteropAnnotationTag(annotAttach.annotTagRef.value);
    }

    private static InteropValidationRequest createJInteropValidationRequest(String annotTagRef, BIRNode.BIRAnnotationAttachment annotAttach, BIRNode.BIRFunction birFunc) {
        BIRNode.ConstValue annotRecValue = ((BIRNode.BIRConstAnnotationAttachment)annotAttach).annotValue;
        Map annotValueMap = (Map)annotRecValue.value;
        if (JInterop.isMethodAnnotationTag(annotTagRef)) {
            return AnnotationProc.createJMethodValidationRequest(annotTagRef, annotValueMap, birFunc);
        }
        return AnnotationProc.createJFieldValidationRequest(annotTagRef, annotValueMap, birFunc);
    }

    private static InteropValidationRequest createJMethodValidationRequest(String annotTagRef, Map<String, BIRNode.ConstValue> annotValues, BIRNode.BIRFunction birFunc) {
        InteropValidationRequest.MethodValidationRequest valRequest = new InteropValidationRequest.MethodValidationRequest(AnnotationProc.getJMethodNameFromAnnot(annotTagRef, annotValues.get(NAME_FIELD_NAME), birFunc), (String)AnnotationProc.getLiteralValueFromAnnotValue(annotValues.get(CLASS_FIELD_NAME)), birFunc.type, JInterop.getMethodKindFromAnnotTag(annotTagRef));
        List<JType> paramTypeConstraints = AnnotationProc.buildParamTypeConstraints(annotValues.get(PARAM_TYPES_FIELD_NAME));
        if (paramTypeConstraints != null) {
            valRequest.paramTypeConstraints = paramTypeConstraints;
        }
        if (birFunc.receiver != null) {
            valRequest.receiverType = birFunc.receiver.type;
        }
        return valRequest;
    }

    private static InteropValidationRequest createJFieldValidationRequest(String annotTagRef, Map<String, BIRNode.ConstValue> annotValues, BIRNode.BIRFunction birFunc) {
        return new InteropValidationRequest.FieldValidationRequest(AnnotationProc.getJFieldNameFromAnnot(annotValues.get(NAME_FIELD_NAME), birFunc), (String)AnnotationProc.getLiteralValueFromAnnotValue(annotValues.get(CLASS_FIELD_NAME)), birFunc.type, JInterop.getFieldMethodFromAnnotTag(annotTagRef));
    }

    private static List<JType> buildParamTypeConstraints(BIRNode.ConstValue annotValue) {
        if (annotValue == null) {
            return null;
        }
        Object value = annotValue.value;
        BIRNode.ConstValue[] annotArrayElements = (BIRNode.ConstValue[])value;
        ArrayList<JType> constraints = new ArrayList<JType>(annotArrayElements.length);
        for (BIRNode.ConstValue annotArrayElement : annotArrayElements) {
            JType jType;
            Object elementValue = annotArrayElement.value;
            if (elementValue instanceof String) {
                String s = (String)elementValue;
                jType = JType.getJTypeFromTypeName(s);
            } else if (elementValue instanceof Map) {
                Map annotValueMap = (Map)elementValue;
                String elementClass = (String)AnnotationProc.getLiteralValueFromAnnotValue((BIRNode.ConstValue)annotValueMap.get(CLASS_FIELD_NAME));
                byte dimensions = ((Long)AnnotationProc.getLiteralValueFromAnnotValue((BIRNode.ConstValue)annotValueMap.get(DIMENSIONS_FIELD_NAME))).byteValue();
                jType = JType.getJArrayTypeFromTypeName(elementClass, dimensions);
            } else {
                throw new BLangCompilerException("unexpected annotation value: " + String.valueOf(annotArrayElement));
            }
            constraints.add(jType);
        }
        return constraints;
    }

    private static Object getLiteralValueFromAnnotValue(BIRNode.ConstValue annotValue) {
        if (annotValue == null) {
            return null;
        }
        Object value = annotValue.value;
        if (value instanceof String || value instanceof Long) {
            return value;
        }
        throw new BLangCompilerException("unexpected annotation value, expected a literal value, found " + String.valueOf(annotValue));
    }

    private static String getJMethodNameFromAnnot(String annotTagRef, BIRNode.ConstValue jNameValueEntry, BIRNode.BIRFunction birFunc) {
        if (annotTagRef.equals("Constructor")) {
            return "<init>";
        }
        String methodName = (String)AnnotationProc.getLiteralValueFromAnnotValue(jNameValueEntry);
        return methodName != null ? methodName : birFunc.name.value;
    }

    private static String getJFieldNameFromAnnot(BIRNode.ConstValue jNameValueEntry, BIRNode.BIRFunction birFunc) {
        String fieldName = (String)AnnotationProc.getLiteralValueFromAnnotValue(jNameValueEntry);
        return fieldName != null ? fieldName : birFunc.name.value;
    }
}

