/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.wso2.ballerinalang.compiler.bir.BIRGenUtils;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JLargeArrayInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JLargeMapInstruction;
import org.wso2.ballerinalang.compiler.bir.codegen.model.JMethodCallInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRAbstractInstruction;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BirScope;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.util.Name;

public class LargeMethodOptimizer {
    private static final Name DEFAULT_WORKER_NAME = new Name("function");
    private static final String OBJECT_INITIALIZATION_FUNCTION_NAME = "$init$";
    private static final String SPLIT_METHOD = "$split$method$_";
    private final SymbolTable symbolTable;
    private static final int FUNCTION_INSTRUCTION_COUNT_THRESHOLD = 1000;
    private static final int SPLIT_INSTRUCTION_COUNT_THRESHOLD = 25;
    private static final int MAX_SPLIT_FUNCTION_ARG_COUNT = 125;
    private static final int INS_COUNT_PERIODIC_SPLIT_THRESHOLD = 500;
    private PackageID currentPackageId;
    private int splitFuncNum;
    private int splitTempVarNum;

    public LargeMethodOptimizer(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public void splitLargeBIRFunctions(BIRNode.BIRPackage birPkg) {
        this.currentPackageId = birPkg.packageID;
        this.splitFuncNum = 0;
        this.splitTempVarNum = 0;
        ArrayList<BIRNode.BIRFunction> newlyAddedBIRFunctions = new ArrayList<BIRNode.BIRFunction>();
        for (BIRNode.BIRFunction function : birPkg.functions) {
            if (this.hasLessInstructionCount(function)) continue;
            List<BIRNode.BIRFunction> newBIRFunctions = this.splitBIRFunction(function, false, false, false);
            newlyAddedBIRFunctions.addAll(newBIRFunctions);
        }
        for (BIRNode.BIRTypeDefinition birTypeDef : birPkg.typeDefs) {
            for (BIRNode.BIRFunction function : birTypeDef.attachedFuncs) {
                if (this.hasLessInstructionCount(function)) continue;
                List<BIRNode.BIRFunction> newBIRFunctions = this.splitBIRFunction(function, true, false, false);
                newlyAddedBIRFunctions.addAll(newBIRFunctions);
            }
        }
        birPkg.functions.addAll(newlyAddedBIRFunctions);
    }

    private boolean hasLessInstructionCount(BIRNode.BIRFunction birFunction) {
        int instructionCount = 0;
        for (BIRNode.BIRBasicBlock basicBlock : birFunction.basicBlocks) {
            instructionCount += basicBlock.instructions.size() + 1;
        }
        return instructionCount < 1000;
    }

    private List<BIRNode.BIRFunction> splitBIRFunction(BIRNode.BIRFunction birFunction, boolean fromAttachedFunction, boolean fromSplitFunction, boolean splitTypeArray) {
        ArrayList<BIRNode.BIRFunction> newlyAddingFunctions = new ArrayList<BIRNode.BIRFunction>();
        List<Split> possibleSplits = this.getPossibleSplits(birFunction.basicBlocks, birFunction.errorTable, fromSplitFunction);
        boolean splitFurther = fromSplitFunction;
        if (!possibleSplits.isEmpty()) {
            this.generateSplits(birFunction, possibleSplits, newlyAddingFunctions, fromAttachedFunction);
            BIRGenUtils.rearrangeBasicBlocks(birFunction);
            if (this.hasLessInstructionCount(birFunction)) {
                splitFurther = false;
            }
        }
        if (splitFurther) {
            this.periodicSplitFunction(birFunction, newlyAddingFunctions, fromAttachedFunction, splitTypeArray);
        }
        return newlyAddingFunctions;
    }

    private void periodicSplitFunction(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction, boolean splitTypeArray) {
        if (splitTypeArray) {
            this.periodicSplitArray(parentFunc, newlyAddingFunctions, fromAttachedFunction);
        } else {
            this.periodicSplitMap(parentFunc, newlyAddingFunctions, fromAttachedFunction);
        }
    }

    private void periodicSplitMap(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction) {
        List<BIRNode.BIRBasicBlock> bbs = parentFunc.basicBlocks;
        int newMapInsBBNum = bbs.size() - 2;
        int newMapInsNumInRelevantBB = bbs.get((int)newMapInsBBNum).instructions.size() - 1;
        BIRNonTerminator.NewStructure mapIns = (BIRNonTerminator.NewStructure)bbs.get((int)newMapInsBBNum).instructions.get(newMapInsNumInRelevantBB);
        TempVarsForArraySplit parentFuncTempVars = this.getTempVarsForArraySplit();
        ParentFuncEnv parentFuncEnv = new ParentFuncEnv(bbs.get(newMapInsBBNum + 1));
        SplitFuncEnv splitFuncEnv = new SplitFuncEnv(this.getTempVarsForArraySplit(), fromAttachedFunction);
        parentFuncEnv.returnOperand = mapIns.lhsOp;
        BIRNode.BIRVariableDcl handleArray = new BIRNode.BIRVariableDcl(null, this.symbolTable.handleType, new Name("%mapEntryArray"), VarScope.FUNCTION, VarKind.TEMP, null);
        BIROperand handleArrayOperand = new BIROperand(handleArray);
        this.createAndAddNewHandleArrayForLargeMapIns(parentFuncEnv, mapIns, handleArray, handleArrayOperand);
        JLargeMapInstruction newLargeMapIns = new JLargeMapInstruction(mapIns.pos, mapIns.lhsOp, mapIns.rhsOp, handleArrayOperand);
        HashMap<BIROperand, BIRMappingConstructorEntryWithIndex> birOperands = new HashMap<BIROperand, BIRMappingConstructorEntryWithIndex>();
        HashSet<BIROperand> mapValuesOperands = new HashSet<BIROperand>();
        HashMap<BIROperand, NonTerminatorLocation> mapKeyOperandLocations = new HashMap<BIROperand, NonTerminatorLocation>();
        HashMap<BIROperand, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueLhsOperands = new HashMap<BIROperand, BIRMappingConstructorEntryWithIndex>();
        List<BIRNonTerminator> globalAndArgVarIns = this.getGlobalAndArgVarInsForMap(parentFuncTempVars, mapIns, handleArrayOperand, birOperands, mapValuesOperands, globalAndArgVarKeyOrValueLhsOperands, mapKeyOperandLocations);
        parentFuncEnv.parentFuncNewInsList.add(bbs.getFirst().instructions.getFirst());
        parentFuncEnv.parentFuncLocalVarList.add(bbs.getFirst().instructions.getFirst().lhsOp.variableDcl);
        this.splitParentFuncForPeriodicMapSplits(parentFunc, newlyAddingFunctions, fromAttachedFunction, bbs, newMapInsBBNum, newMapInsNumInRelevantBB, handleArray, handleArrayOperand, birOperands, splitFuncEnv, parentFuncEnv, mapValuesOperands, globalAndArgVarKeyOrValueLhsOperands, mapKeyOperandLocations);
        this.setParentFuncDetails(parentFunc, bbs, newMapInsBBNum, parentFuncTempVars, parentFuncEnv, newLargeMapIns, globalAndArgVarIns);
    }

    private void setParentFuncDetails(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRBasicBlock> bbs, int newMapOrArrayInsBBNum, TempVarsForArraySplit parentFuncTempVars, ParentFuncEnv parentFuncEnv, JInstruction jLargeStructureIns, List<BIRNonTerminator> globalAndArgVarIns) {
        parentFuncEnv.parentFuncNewInsList.addAll(globalAndArgVarIns);
        parentFuncEnv.parentFuncNewInsList.add(jLargeStructureIns);
        parentFuncEnv.parentFuncNewBB.instructions = parentFuncEnv.parentFuncNewInsList;
        parentFuncEnv.parentFuncNewBB.terminator = bbs.get((int)newMapOrArrayInsBBNum).terminator;
        parentFuncEnv.parentFuncNewBBList.add(parentFuncEnv.parentFuncNewBB);
        BIRNode.BIRBasicBlock parentFuncExitBB = bbs.get(newMapOrArrayInsBBNum + 1);
        BIRGenUtils.renumberBasicBlock(parentFuncEnv.parentFuncBBId++, parentFuncExitBB);
        parentFuncEnv.parentFuncNewBBList.add(parentFuncExitBB);
        parentFunc.basicBlocks = parentFuncEnv.parentFuncNewBBList;
        parentFunc.errorTable = new ArrayList<BIRNode.BIRErrorEntry>();
        parentFunc.localVars = new ArrayList<BIRNode.BIRVariableDcl>();
        parentFunc.localVars.add(parentFunc.returnVariable);
        parentFunc.localVars.addAll(parentFunc.parameters);
        parentFunc.localVars.addAll(parentFuncEnv.parentFuncLocalVarList);
        if (parentFuncTempVars.tempVarsUsed) {
            parentFunc.localVars.add(parentFuncTempVars.arrayIndexVarDcl);
            parentFunc.localVars.add(parentFuncTempVars.typeCastVarDcl);
        }
    }

    private void periodicSplitArray(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction) {
        List<BIRNode.BIRBasicBlock> bbs = parentFunc.basicBlocks;
        int newArrayInsBBNum = bbs.size() - 2;
        int newArrayInsNumInRelevantBB = bbs.get((int)newArrayInsBBNum).instructions.size() - 1;
        BIRNonTerminator.NewArray arrayIns = (BIRNonTerminator.NewArray)bbs.get((int)newArrayInsBBNum).instructions.get(newArrayInsNumInRelevantBB);
        TempVarsForArraySplit parentFuncTempVars = this.getTempVarsForArraySplit();
        ParentFuncEnv parentFuncEnv = new ParentFuncEnv(bbs.get(newArrayInsBBNum + 1));
        SplitFuncEnv splitFuncEnv = new SplitFuncEnv(this.getTempVarsForArraySplit(), fromAttachedFunction);
        parentFuncEnv.returnOperand = arrayIns.lhsOp;
        BIRNode.BIRVariableDcl handleArray = new BIRNode.BIRVariableDcl(null, this.symbolTable.handleType, new Name("%listEntryArray"), VarScope.FUNCTION, VarKind.TEMP, null);
        BIROperand handleArrayOperand = new BIROperand(handleArray);
        this.createAndAddNewHandleArrayForLargeArrayIns(parentFuncEnv, arrayIns, handleArray, handleArrayOperand);
        JLargeArrayInstruction newLargeArrayIns = new JLargeArrayInstruction(arrayIns.pos, arrayIns.type, arrayIns.lhsOp, arrayIns.typedescOp, arrayIns.sizeOp, handleArrayOperand);
        HashMap<BIROperand, BIRListConstructorEntryWithIndex> birOperands = new HashMap<BIROperand, BIRListConstructorEntryWithIndex>();
        HashSet<BIROperand> arrayValuesOperands = new HashSet<BIROperand>();
        List<BIRNonTerminator> globalAndArgVarIns = this.getGlobalAndArgVarInsForArray(parentFuncTempVars, arrayIns, handleArrayOperand, birOperands, arrayValuesOperands);
        parentFuncEnv.parentFuncNewInsList.add(bbs.getFirst().instructions.getFirst());
        parentFuncEnv.parentFuncLocalVarList.add(bbs.getFirst().instructions.getFirst().lhsOp.variableDcl);
        this.splitParentFuncForPeriodicArraySplits(parentFunc, newlyAddingFunctions, fromAttachedFunction, bbs, newArrayInsBBNum, newArrayInsNumInRelevantBB, handleArray, handleArrayOperand, birOperands, splitFuncEnv, parentFuncEnv, arrayValuesOperands);
        this.setParentFuncDetails(parentFunc, bbs, newArrayInsBBNum, parentFuncTempVars, parentFuncEnv, newLargeArrayIns, globalAndArgVarIns);
    }

    private List<BIRNonTerminator> getGlobalAndArgVarInsForMap(TempVarsForArraySplit parentFuncTempVars, BIRNonTerminator.NewStructure mapIns, BIROperand handleArrayOperand, Map<BIROperand, BIRMappingConstructorEntryWithIndex> birOperands, Set<BIROperand> mapValuesOperands, Map<BIROperand, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueLhsOperands, Map<BIROperand, NonTerminatorLocation> mapKeyOperandLocations) {
        ArrayList<BIRNonTerminator> globalAndArgVarIns = new ArrayList<BIRNonTerminator>();
        int arrIndex = 0;
        for (BIRNode.BIRMappingConstructorEntry value : mapIns.initialValues) {
            if (value.isKeyValuePair()) {
                BIRNode.BIRMappingConstructorKeyValueEntry keyValueEntry = (BIRNode.BIRMappingConstructorKeyValueEntry)value;
                BIROperand valueOp = keyValueEntry.valueOp;
                BIRNode.BIRVariableDcl valueVarDcl = valueOp.variableDcl;
                BIROperand keyOp = keyValueEntry.keyOp;
                BIRNode.BIRVariableDcl keyVarDcl = keyOp.variableDcl;
                if (this.isTempOrSyntheticVar(valueVarDcl)) {
                    if (this.isTempOrSyntheticVar(keyVarDcl)) {
                        birOperands.put(valueOp, new BIRMappingConstructorEntryWithIndex(value, arrIndex));
                        mapValuesOperands.add(valueOp);
                    } else {
                        globalAndArgVarKeyOrValueLhsOperands.put(valueOp, new BIRMappingConstructorEntryWithIndex(value, arrIndex));
                    }
                } else if (this.isTempOrSyntheticVar(keyVarDcl)) {
                    globalAndArgVarKeyOrValueLhsOperands.put(keyOp, new BIRMappingConstructorEntryWithIndex(value, arrIndex));
                } else {
                    this.setMapElement(globalAndArgVarIns, handleArrayOperand, valueOp, value, arrIndex, parentFuncTempVars);
                }
                mapKeyOperandLocations.put(keyOp, null);
            } else {
                BIRNode.BIRMappingConstructorSpreadFieldEntry spreadFieldEntry = (BIRNode.BIRMappingConstructorSpreadFieldEntry)value;
                BIROperand exprOp = spreadFieldEntry.exprOp;
                if (this.isTempOrSyntheticVar(exprOp.variableDcl)) {
                    birOperands.put(exprOp, new BIRMappingConstructorEntryWithIndex(value, arrIndex));
                    mapValuesOperands.add(exprOp);
                } else {
                    this.setMapElement(globalAndArgVarIns, handleArrayOperand, exprOp, value, arrIndex, parentFuncTempVars);
                }
            }
            ++arrIndex;
        }
        return globalAndArgVarIns;
    }

    private List<BIRNonTerminator> getGlobalAndArgVarInsForArray(TempVarsForArraySplit parentFuncTempVars, BIRNonTerminator.NewArray arrayIns, BIROperand handleArrayOperand, Map<BIROperand, BIRListConstructorEntryWithIndex> birOperands, Set<BIROperand> arrayValuesOperands) {
        ArrayList<BIRNonTerminator> globalAndArgVarIns = new ArrayList<BIRNonTerminator>();
        int arrIndex = 0;
        for (BIRNode.BIRListConstructorEntry value : arrayIns.values) {
            BIRNode.BIRVariableDcl arrElementVarDcl = value.exprOp.variableDcl;
            if (this.isTempOrSyntheticVar(arrElementVarDcl)) {
                birOperands.put(value.exprOp, new BIRListConstructorEntryWithIndex(value, arrIndex));
                arrayValuesOperands.add(value.exprOp);
            } else {
                this.setArrayElement(globalAndArgVarIns, handleArrayOperand, value.exprOp, value, arrIndex, parentFuncTempVars);
            }
            ++arrIndex;
        }
        return globalAndArgVarIns;
    }

    private void createAndAddNewHandleArrayForLargeMapIns(ParentFuncEnv parentFuncEnv, BIRNonTerminator.NewStructure mapIns, BIRNode.BIRVariableDcl handleArray, BIROperand handleArrayOperand) {
        BIRNode.BIRVariableDcl arraySizeVarDcl = new BIRNode.BIRVariableDcl(null, this.symbolTable.intType, new Name("%mapEntryArraySize"), VarScope.FUNCTION, VarKind.TEMP, null);
        parentFuncEnv.parentFuncLocalVarList.add(arraySizeVarDcl);
        BIROperand arraySizeOperand = new BIROperand(arraySizeVarDcl);
        parentFuncEnv.parentFuncLocalVarList.add(handleArray);
        JMethodCallInstruction callHandleArray = new JMethodCallInstruction(null);
        callHandleArray.lhsOp = handleArrayOperand;
        callHandleArray.invocationType = 184;
        callHandleArray.jClassName = "io/ballerina/runtime/internal/utils/LargeStructureUtils";
        callHandleArray.jMethodVMSig = "(J)Lio/ballerina/runtime/internal/values/HandleValue;";
        callHandleArray.name = "getBMapInitialValueEntryArray";
        callHandleArray.args = Collections.singletonList(arraySizeOperand);
        BIRNonTerminator.ConstantLoad loadArraySize = new BIRNonTerminator.ConstantLoad(null, mapIns.initialValues.size(), this.symbolTable.intType, arraySizeOperand);
        parentFuncEnv.parentFuncNewInsList.add(loadArraySize);
        parentFuncEnv.parentFuncNewInsList.add(callHandleArray);
    }

    private void createAndAddNewHandleArrayForLargeArrayIns(ParentFuncEnv parentFuncEnv, BIRNonTerminator.NewArray arrayIns, BIRNode.BIRVariableDcl handleArray, BIROperand handleArrayOperand) {
        BIRNode.BIRVariableDcl arraySizeVarDcl = new BIRNode.BIRVariableDcl(null, this.symbolTable.intType, new Name("%listEntryArraySize"), VarScope.FUNCTION, VarKind.TEMP, null);
        parentFuncEnv.parentFuncLocalVarList.add(arraySizeVarDcl);
        BIROperand arraySizeOperand = new BIROperand(arraySizeVarDcl);
        parentFuncEnv.parentFuncLocalVarList.add(handleArray);
        JMethodCallInstruction callHandleArray = new JMethodCallInstruction(null);
        callHandleArray.lhsOp = handleArrayOperand;
        callHandleArray.invocationType = 184;
        callHandleArray.jClassName = "io/ballerina/runtime/internal/utils/LargeStructureUtils";
        callHandleArray.jMethodVMSig = "(J)Lio/ballerina/runtime/internal/values/HandleValue;";
        callHandleArray.name = "getListInitialValueEntryArray";
        callHandleArray.args = Collections.singletonList(arraySizeOperand);
        BIRNonTerminator.ConstantLoad loadArraySize = new BIRNonTerminator.ConstantLoad(null, arrayIns.values.size(), this.symbolTable.intType, arraySizeOperand);
        parentFuncEnv.parentFuncNewInsList.add(loadArraySize);
        parentFuncEnv.parentFuncNewInsList.add(callHandleArray);
    }

    private Map<BIRAbstractInstruction, SplitPointDetails> getSplitPointsForMap(List<BIRNode.BIRBasicBlock> bbs, Set<BIROperand> mapValueOperands, Map<BIROperand, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueLhsOperands, Map<BIRAbstractInstruction, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueRelatedIns, Map<BIROperand, NonTerminatorLocation> mapKeyOperandLocations) {
        HashSet<BIROperand> remainingArrayValueOperands = new HashSet<BIROperand>(mapValueOperands);
        HashMap<BIRAbstractInstruction, SplitPointDetails> insSplitPoints = new HashMap<BIRAbstractInstruction, SplitPointDetails>();
        for (int bbIndex = bbs.size() - 2; bbIndex >= 0; --bbIndex) {
            int lastInsNum;
            HashSet<BIROperand> operandsInSameBB = new HashSet<BIROperand>();
            BIRNode.BIRBasicBlock bb = bbs.get(bbIndex);
            List<BIRNonTerminator> bbInstructions = bb.instructions;
            BIROperand terminatorLhsOp = bb.terminator.lhsOp;
            if (terminatorLhsOp != null) {
                this.populateGlobalAndArgVarKeyOrValueRelatedIns(globalAndArgVarKeyOrValueLhsOperands, globalAndArgVarKeyOrValueRelatedIns, bb.terminator, terminatorLhsOp);
            }
            for (int insIndex = lastInsNum = this.getLastInsNumAndHandleTerminator(bbs, mapValueOperands, remainingArrayValueOperands, insSplitPoints, bbIndex, operandsInSameBB, bb, bbInstructions); insIndex >= 0; --insIndex) {
                BIRNonTerminator currIns = bbInstructions.get(insIndex);
                BIROperand lhsOp = currIns.lhsOp;
                if (lhsOp == null) continue;
                if (mapKeyOperandLocations.containsKey(lhsOp) && mapKeyOperandLocations.get(lhsOp) == null) {
                    mapKeyOperandLocations.put(lhsOp, new NonTerminatorLocation(bbIndex, insIndex));
                }
                this.populateGlobalAndArgVarKeyOrValueRelatedIns(globalAndArgVarKeyOrValueLhsOperands, globalAndArgVarKeyOrValueRelatedIns, currIns, lhsOp);
                this.addOperandToInsSplitPoints(mapValueOperands, insSplitPoints, currIns, lhsOp, operandsInSameBB, remainingArrayValueOperands);
            }
        }
        return insSplitPoints;
    }

    private void populateGlobalAndArgVarKeyOrValueRelatedIns(Map<BIROperand, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueLhsOperands, Map<BIRAbstractInstruction, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueRelatedIns, BIRAbstractInstruction currIns, BIROperand lhsOp) {
        if (globalAndArgVarKeyOrValueLhsOperands.containsKey(lhsOp)) {
            globalAndArgVarKeyOrValueRelatedIns.put(currIns, globalAndArgVarKeyOrValueLhsOperands.get(lhsOp));
            globalAndArgVarKeyOrValueLhsOperands.remove(lhsOp);
        }
    }

    private int getLastInsNumAndHandleTerminator(List<BIRNode.BIRBasicBlock> bbs, Set<BIROperand> arrayOrMapValueOperands, Set<BIROperand> remainingArrayValueOperands, Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints, int bbIndex, Set<BIROperand> operandsInSameBB, BIRNode.BIRBasicBlock bb, List<BIRNonTerminator> bbInstructions) {
        int lastInsNum;
        if (bbIndex == bbs.size() - 2) {
            lastInsNum = bbInstructions.size() - 2;
        } else {
            lastInsNum = bbInstructions.size() - 1;
            BIRTerminator bbTerminator = bb.terminator;
            if (bbTerminator.kind != InstructionKind.BRANCH) {
                this.populateInsSplitPoints(arrayOrMapValueOperands, insSplitPoints, bbTerminator, operandsInSameBB, remainingArrayValueOperands);
            }
            if (bbTerminator.kind == InstructionKind.CALL) {
                BIRTerminator.Call callIns = (BIRTerminator.Call)bbTerminator;
                if (callIns.name.value.contains(OBJECT_INITIALIZATION_FUNCTION_NAME)) {
                    for (BIROperand arg : callIns.args) {
                        this.addOperandToInsSplitPoints(arrayOrMapValueOperands, insSplitPoints, callIns, arg, operandsInSameBB, remainingArrayValueOperands);
                    }
                }
            }
        }
        return lastInsNum;
    }

    private Map<BIRAbstractInstruction, SplitPointDetails> getSplitPointsForArray(List<BIRNode.BIRBasicBlock> bbs, Set<BIROperand> arrayValuesOperands) {
        HashSet<BIROperand> remainingArrayValueOperands = new HashSet<BIROperand>(arrayValuesOperands);
        HashMap<BIRAbstractInstruction, SplitPointDetails> insSplitPoints = new HashMap<BIRAbstractInstruction, SplitPointDetails>();
        for (int bbIndex = bbs.size() - 2; bbIndex >= 0; --bbIndex) {
            int lastInsNum;
            HashSet<BIROperand> operandsInSameBB = new HashSet<BIROperand>();
            BIRNode.BIRBasicBlock bb = bbs.get(bbIndex);
            List<BIRNonTerminator> bbInstructions = bb.instructions;
            for (int insIndex = lastInsNum = this.getLastInsNumAndHandleTerminator(bbs, arrayValuesOperands, remainingArrayValueOperands, insSplitPoints, bbIndex, operandsInSameBB, bb, bbInstructions); insIndex >= 0; --insIndex) {
                this.populateInsSplitPoints(arrayValuesOperands, insSplitPoints, bbInstructions.get(insIndex), operandsInSameBB, remainingArrayValueOperands);
            }
        }
        return insSplitPoints;
    }

    private void populateInsSplitPoints(Set<BIROperand> arrayValuesOperands, Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints, BIRAbstractInstruction ins, Set<BIROperand> operandsInSameBB, Set<BIROperand> remainingArrayValueOperands) {
        BIROperand insLhsOp = ins.lhsOp;
        if (insLhsOp != null) {
            this.addOperandToInsSplitPoints(arrayValuesOperands, insSplitPoints, ins, insLhsOp, operandsInSameBB, remainingArrayValueOperands);
        }
    }

    private void addOperandToInsSplitPoints(Set<BIROperand> arrayValuesOperands, Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints, BIRAbstractInstruction ins, BIROperand insOperand, Set<BIROperand> operandsInSameBB, Set<BIROperand> remainingArrayValueOperands) {
        if (arrayValuesOperands.contains(insOperand) && !operandsInSameBB.contains(insOperand)) {
            operandsInSameBB.add(insOperand);
            if (insSplitPoints.containsKey(ins)) {
                SplitPointDetails splitPointDetails = insSplitPoints.get(ins);
                List<BIROperand> operandList = splitPointDetails.arrayElementsBIROperands;
                operandList.add(insOperand);
                if (remainingArrayValueOperands.contains(insOperand)) {
                    remainingArrayValueOperands.remove(insOperand);
                } else if (splitPointDetails.splitHere) {
                    splitPointDetails.splitHere = false;
                }
            } else {
                ArrayList<BIROperand> operandList = new ArrayList<BIROperand>();
                operandList.add(insOperand);
                if (remainingArrayValueOperands.contains(insOperand)) {
                    remainingArrayValueOperands.remove(insOperand);
                    insSplitPoints.put(ins, new SplitPointDetails(operandList, true));
                } else {
                    insSplitPoints.put(ins, new SplitPointDetails(operandList, false));
                }
            }
        }
    }

    private Map<BIROperand, Integer> getErrorOperandsAndTargetBBs(List<BIRNode.BIRErrorEntry> errorTable) {
        HashMap<BIROperand, Integer> errorOperandsAndTargetBBs = new HashMap<BIROperand, Integer>();
        for (BIRNode.BIRErrorEntry birErrorEntry : errorTable) {
            errorOperandsAndTargetBBs.put(birErrorEntry.errorOp, birErrorEntry.targetBB.number);
        }
        return errorOperandsAndTargetBBs;
    }

    private void splitParentFuncForPeriodicMapSplits(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction, List<BIRNode.BIRBasicBlock> bbs, int newArrayInsBBNum, int newArrayInsNumInRelevantBB, BIRNode.BIRVariableDcl handleArray, BIROperand handleArrayOperand, Map<BIROperand, BIRMappingConstructorEntryWithIndex> birOperands, SplitFuncEnv splitFuncEnv, ParentFuncEnv parentFuncEnv, Set<BIROperand> mapValuesOperands, Map<BIROperand, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueLhsOperands, Map<BIROperand, NonTerminatorLocation> mapKeyOperandLocations) {
        HashMap<BIRAbstractInstruction, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueRelatedIns = new HashMap<BIRAbstractInstruction, BIRMappingConstructorEntryWithIndex>();
        Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints = this.getSplitPointsForMap(bbs, mapValuesOperands, globalAndArgVarKeyOrValueLhsOperands, globalAndArgVarKeyOrValueRelatedIns, mapKeyOperandLocations);
        Map<BIROperand, Integer> errorOperandsAndTargetBBs = this.getErrorOperandsAndTargetBBs(parentFunc.errorTable);
        ArrayList<BIRNonTerminator> nextBBPendingIns = new ArrayList<BIRNonTerminator>();
        for (int bbIndex = 0; bbIndex < bbs.size() - 1; ++bbIndex) {
            boolean mapElementSet;
            ArrayList<BIRNonTerminator> newBBInsList;
            BIRNode.BIRBasicBlock bb = bbs.get(bbIndex);
            this.handleBasicBlockStart(splitFuncEnv, nextBBPendingIns, bb);
            for (int insIndex = 0; insIndex < bb.instructions.size(); ++insIndex) {
                if (bbIndex == 0 && insIndex == 0) continue;
                if (bbIndex == newArrayInsBBNum && insIndex == newArrayInsNumInRelevantBB) {
                    this.createNewFuncForPeriodicSplit(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, bb, bb.instructions.get(newArrayInsNumInRelevantBB));
                    return;
                }
                BIRNonTerminator bbIns = bb.instructions.get(insIndex);
                BIROperand bbInsLhsOp = bbIns.lhsOp;
                this.handleReturnValAssignedInstruction(splitFuncEnv, bb, bbInsLhsOp);
                splitFuncEnv.splitFuncNewInsList.add(bbIns);
                ++splitFuncEnv.periodicSplitInsCount;
                this.populateSplitFuncArgsAndLocalVarList(splitFuncEnv, bbIns);
                newBBInsList = new ArrayList();
                mapElementSet = this.setMapElementGivenOperand(birOperands, newBBInsList, handleArrayOperand, splitFuncEnv.splitFuncTempVars, insSplitPoints, bbIns, splitFuncEnv, mapKeyOperandLocations, bbIndex, insIndex, globalAndArgVarKeyOrValueRelatedIns);
                this.handleSplittingAtNonTerminator(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, errorOperandsAndTargetBBs, nextBBPendingIns, newBBInsList, mapElementSet, bb, bbIns, bbInsLhsOp);
            }
            this.handleBBInstructions(splitFuncEnv, bb);
            this.populateSplitFuncArgsAndLocalVarList(splitFuncEnv, bb.terminator);
            ++splitFuncEnv.periodicSplitInsCount;
            newBBInsList = new ArrayList<BIRNonTerminator>();
            mapElementSet = this.setMapElementGivenOperand(birOperands, newBBInsList, handleArrayOperand, splitFuncEnv.splitFuncTempVars, insSplitPoints, bb.terminator, splitFuncEnv, mapKeyOperandLocations, bbIndex, -1, globalAndArgVarKeyOrValueRelatedIns);
            this.handleSplittingAtTerminator(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, newBBInsList, mapElementSet, bb);
        }
    }

    private void handleSplittingAtTerminator(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction, BIRNode.BIRVariableDcl handleArray, SplitFuncEnv splitFuncEnv, ParentFuncEnv parentFuncEnv, List<BIRNonTerminator> newBBInsList, boolean mapElementSet, BIRNode.BIRBasicBlock bb) {
        if (mapElementSet) {
            splitFuncEnv.splitFuncCorrectTerminatorBBs.add(splitFuncEnv.splitFuncBB);
            BIRNode.BIRBasicBlock newBB = new BIRNode.BIRBasicBlock(splitFuncEnv.splitFuncBBId++);
            splitFuncEnv.splitFuncBB = new BIRNode.BIRBasicBlock(splitFuncEnv.splitFuncBBId++);
            newBB.instructions.addAll(newBBInsList);
            newBB.terminator = new BIRTerminator.GOTO(null, bb.terminator.thenBB, bb.terminator.scope);
            bb.terminator.thenBB = newBB;
            splitFuncEnv.splitFuncNewBBList.add(newBB);
        } else {
            splitFuncEnv.splitFuncBB = new BIRNode.BIRBasicBlock(splitFuncEnv.splitFuncBBId++);
        }
        if (bb.terminator.kind == InstructionKind.BRANCH) {
            splitFuncEnv.splitOkay = false;
            BIRTerminator.Branch branch = (BIRTerminator.Branch)bb.terminator;
            int higherBBNumber = Math.max(branch.trueBB.number, branch.falseBB.number);
            splitFuncEnv.doNotSplitTillThisBBNum = Math.max(splitFuncEnv.doNotSplitTillThisBBNum, higherBBNumber);
        }
        if (splitFuncEnv.periodicSplitInsCount > 500 && splitFuncEnv.splitOkay && mapElementSet && splitFuncEnv.splitHere) {
            this.createNewFuncForPeriodicSplit(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, bb, bb.terminator);
        }
    }

    private void handleSplittingAtNonTerminator(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction, BIRNode.BIRVariableDcl handleArray, SplitFuncEnv splitFuncEnv, ParentFuncEnv parentFuncEnv, Map<BIROperand, Integer> errorOperandsAndTargetBBs, List<BIRNonTerminator> nextBBPendingIns, List<BIRNonTerminator> newBBInsList, boolean mapElementSet, BIRNode.BIRBasicBlock bb, BIRNonTerminator bbIns, BIROperand bbInsLhsOp) {
        if (bbInsLhsOp != null && errorOperandsAndTargetBBs.containsKey(bbInsLhsOp)) {
            nextBBPendingIns.addAll(newBBInsList);
            splitFuncEnv.splitOkay = false;
            splitFuncEnv.doNotSplitTillThisBBNum = Math.max(splitFuncEnv.doNotSplitTillThisBBNum, errorOperandsAndTargetBBs.get(bbInsLhsOp));
        } else {
            splitFuncEnv.splitFuncNewInsList.addAll(newBBInsList);
        }
        if (splitFuncEnv.periodicSplitInsCount > 500 && splitFuncEnv.splitOkay && mapElementSet && splitFuncEnv.splitHere) {
            this.createNewFuncForPeriodicSplit(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, bb, bbIns);
        }
    }

    private void handleReturnValAssignedInstruction(SplitFuncEnv splitFuncEnv, BIRNode.BIRBasicBlock bb, BIROperand bbInsLhsOp) {
        if (!splitFuncEnv.returnValAssigned && bbInsLhsOp != null && bbInsLhsOp.variableDcl.kind == VarKind.RETURN) {
            splitFuncEnv.returnValAssigned = true;
            bb.terminator = new BIRTerminator.GOTO(bb.terminator.pos, splitFuncEnv.returnBB, bb.terminator.scope);
            splitFuncEnv.splitFuncCorrectTerminatorBBs.add(splitFuncEnv.splitFuncBB);
        }
    }

    private void handleBasicBlockStart(SplitFuncEnv splitFuncEnv, List<BIRNonTerminator> nextBBPendingIns, BIRNode.BIRBasicBlock bb) {
        if (!splitFuncEnv.splitOkay && splitFuncEnv.doNotSplitTillThisBBNum == bb.number) {
            splitFuncEnv.splitOkay = true;
            --splitFuncEnv.periodicSplitInsCount;
        }
        splitFuncEnv.splitFuncChangedBBs.put(bb.number, splitFuncEnv.splitFuncBB);
        if (!nextBBPendingIns.isEmpty()) {
            splitFuncEnv.splitFuncNewInsList.addAll(nextBBPendingIns);
            nextBBPendingIns.clear();
        }
    }

    private void splitParentFuncForPeriodicArraySplits(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction, List<BIRNode.BIRBasicBlock> bbs, int newArrayInsBBNum, int newArrayInsNumInRelevantBB, BIRNode.BIRVariableDcl handleArray, BIROperand handleArrayOperand, Map<BIROperand, BIRListConstructorEntryWithIndex> birOperands, SplitFuncEnv splitFuncEnv, ParentFuncEnv parentFuncEnv, Set<BIROperand> arrayValuesOperands) {
        Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints = this.getSplitPointsForArray(bbs, arrayValuesOperands);
        Map<BIROperand, Integer> errorOperandsAndTargetBBs = this.getErrorOperandsAndTargetBBs(parentFunc.errorTable);
        ArrayList<BIRNonTerminator> nextBBPendingIns = new ArrayList<BIRNonTerminator>();
        for (int bbIndex = 0; bbIndex < bbs.size() - 1; ++bbIndex) {
            boolean arrayElementSet;
            ArrayList<BIRNonTerminator> newBBInsList;
            BIRNode.BIRBasicBlock bb = bbs.get(bbIndex);
            this.handleBasicBlockStart(splitFuncEnv, nextBBPendingIns, bb);
            for (int insIndex = 0; insIndex < bb.instructions.size(); ++insIndex) {
                if (bbIndex == 0 && insIndex == 0) continue;
                if (bbIndex == newArrayInsBBNum && insIndex == newArrayInsNumInRelevantBB) {
                    this.createNewFuncForPeriodicSplit(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, bb, bb.instructions.get(newArrayInsNumInRelevantBB));
                    return;
                }
                BIRNonTerminator bbIns = bb.instructions.get(insIndex);
                BIROperand bbInsLhsOp = bbIns.lhsOp;
                this.handleReturnValAssignedInstruction(splitFuncEnv, bb, bbInsLhsOp);
                splitFuncEnv.splitFuncNewInsList.add(bbIns);
                ++splitFuncEnv.periodicSplitInsCount;
                this.populateSplitFuncArgsAndLocalVarList(splitFuncEnv, bbIns);
                newBBInsList = new ArrayList();
                arrayElementSet = this.setArrayElementGivenOperand(birOperands, newBBInsList, handleArrayOperand, splitFuncEnv.splitFuncTempVars, insSplitPoints, bbIns, splitFuncEnv);
                this.handleSplittingAtNonTerminator(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, errorOperandsAndTargetBBs, nextBBPendingIns, newBBInsList, arrayElementSet, bb, bbIns, bbInsLhsOp);
            }
            this.handleBBInstructions(splitFuncEnv, bb);
            this.populateSplitFuncArgsAndLocalVarList(splitFuncEnv, bb.terminator);
            ++splitFuncEnv.periodicSplitInsCount;
            newBBInsList = new ArrayList<BIRNonTerminator>();
            arrayElementSet = this.setArrayElementGivenOperand(birOperands, newBBInsList, handleArrayOperand, splitFuncEnv.splitFuncTempVars, insSplitPoints, bb.terminator, splitFuncEnv);
            this.handleSplittingAtTerminator(parentFunc, newlyAddingFunctions, fromAttachedFunction, handleArray, splitFuncEnv, parentFuncEnv, newBBInsList, arrayElementSet, bb);
        }
    }

    private void handleBBInstructions(SplitFuncEnv splitFuncEnv, BIRNode.BIRBasicBlock bb) {
        splitFuncEnv.splitFuncBB.instructions = splitFuncEnv.splitFuncNewInsList;
        splitFuncEnv.splitFuncBB.terminator = bb.terminator;
        splitFuncEnv.splitFuncNewBBList.add(splitFuncEnv.splitFuncBB);
        splitFuncEnv.splitFuncNewInsList = new ArrayList<BIRNonTerminator>();
    }

    private void createNewFuncForPeriodicSplit(BIRNode.BIRFunction parentFunc, List<BIRNode.BIRFunction> newlyAddingFunctions, boolean fromAttachedFunction, BIRNode.BIRVariableDcl handleArray, SplitFuncEnv splitFuncEnv, ParentFuncEnv parentFuncEnv, BIRNode.BIRBasicBlock bb, BIRAbstractInstruction bbIns) {
        splitFuncEnv.periodicSplitInsCount = 0;
        if (splitFuncEnv.splitFuncTempVars.tempVarsUsed) {
            splitFuncEnv.splitFuncArgs.add(handleArray);
        }
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BIRNode.BIRVariableDcl funcArg : splitFuncEnv.splitFuncArgs) {
            paramTypes.add(funcArg.type);
        }
        BType funcRetType = splitFuncEnv.returnValAssigned ? this.symbolTable.errorOrNilType : this.symbolTable.nilType;
        BInvokableType type = new BInvokableType(this.symbolTable.typeEnv(), paramTypes, funcRetType, null);
        ++this.splitFuncNum;
        String splitFuncName = SPLIT_METHOD + this.splitFuncNum;
        Name newFuncName = new Name(splitFuncName);
        BIRNode.BIRFunction splitBirFunc = new BIRNode.BIRFunction(null, newFuncName, newFuncName, 0L, type, DEFAULT_WORKER_NAME, 0, SymbolOrigin.VIRTUAL);
        this.populateSplitFuncLocalVarsAndErrorTable(parentFunc, splitFuncEnv, parentFuncEnv, bb, bbIns, funcRetType, splitBirFunc);
        BIRNonTerminator.ConstantLoad constantLoad = new BIRNonTerminator.ConstantLoad(bbIns.pos, new Name("()"), this.symbolTable.nilType, splitFuncEnv.returnOperand);
        splitFuncEnv.splitFuncNewInsList.add(constantLoad);
        splitFuncEnv.splitFuncBB.instructions.addAll(splitFuncEnv.splitFuncNewInsList);
        BIRNode.BIRBasicBlock exitBB = splitFuncEnv.returnBB;
        exitBB.terminator = new BIRTerminator.Return(null);
        splitFuncEnv.splitFuncBB.terminator = new BIRTerminator.GOTO(null, exitBB, bbIns.scope);
        splitFuncEnv.splitFuncCorrectTerminatorBBs.add(splitFuncEnv.splitFuncBB);
        splitFuncEnv.splitFuncNewBBList.add(splitFuncEnv.splitFuncBB);
        this.fixTerminatorBBsInPeriodicSplitFunc(splitFuncEnv);
        splitFuncEnv.splitFuncBBId = BIRGenUtils.renumberBasicBlock(splitFuncEnv.splitFuncBBId, exitBB);
        splitFuncEnv.splitFuncNewBBList.add(exitBB);
        splitBirFunc.basicBlocks = splitFuncEnv.splitFuncNewBBList;
        newlyAddingFunctions.add(splitBirFunc);
        this.fixErrorTableInPeriodicSplitFunc(splitFuncEnv, splitBirFunc);
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        for (BIRNode.BIRVariableDcl funcArg : splitFuncEnv.splitFuncArgs) {
            args.add(new BIROperand(funcArg));
        }
        BIRNode.BIRBasicBlock parentFuncNextBB = new BIRNode.BIRBasicBlock(parentFuncEnv.parentFuncBBId++);
        parentFuncEnv.parentFuncNewBB.instructions = parentFuncEnv.parentFuncNewInsList;
        BIROperand splitFuncCallResultOp = null;
        if (splitFuncEnv.returnValAssigned) {
            splitFuncCallResultOp = this.generateTempLocalVariable((BType)this.symbolTable.errorOrNilType, parentFuncEnv.parentFuncLocalVarList);
        }
        parentFuncEnv.parentFuncNewBB.terminator = new BIRTerminator.Call(bbIns.pos, InstructionKind.CALL, false, this.currentPackageId, newFuncName, args, splitFuncCallResultOp, parentFuncNextBB, Collections.emptyList(), Collections.emptySet(), bbIns.scope);
        parentFuncEnv.parentFuncNewInsList = new ArrayList<BIRNonTerminator>();
        parentFuncEnv.parentFuncNewBBList.add(parentFuncEnv.parentFuncNewBB);
        parentFuncEnv.parentFuncNewBB = parentFuncNextBB;
        if (splitFuncEnv.returnValAssigned) {
            BIROperand isErrorResultOp = this.generateTempLocalVariable(this.symbolTable.booleanType, parentFuncEnv.parentFuncLocalVarList);
            BIRNonTerminator.TypeTest errorTestIns = new BIRNonTerminator.TypeTest(null, this.symbolTable.errorType, isErrorResultOp, splitFuncCallResultOp);
            parentFuncEnv.parentFuncNewInsList.add(errorTestIns);
            parentFuncEnv.parentFuncNewBB.instructions = parentFuncEnv.parentFuncNewInsList;
            BIRNode.BIRBasicBlock trueBB = new BIRNode.BIRBasicBlock(parentFuncEnv.parentFuncBBId++);
            BIRNode.BIRBasicBlock falseBB = new BIRNode.BIRBasicBlock(parentFuncEnv.parentFuncBBId++);
            parentFuncEnv.parentFuncNewBB.terminator = new BIRTerminator.Branch(null, isErrorResultOp, trueBB, falseBB, bbIns.scope);
            parentFuncEnv.parentFuncNewBBList.add(parentFuncEnv.parentFuncNewBB);
            BIROperand castedErrorOp = this.generateTempLocalVariable((BType)this.symbolTable.errorType, parentFuncEnv.parentFuncLocalVarList);
            BIRNonTerminator.TypeCast typeCastErrIns = new BIRNonTerminator.TypeCast(null, castedErrorOp, splitFuncCallResultOp, this.symbolTable.errorType, false);
            trueBB.instructions.add(typeCastErrIns);
            BIRNonTerminator.Move moveIns = new BIRNonTerminator.Move(null, castedErrorOp, parentFuncEnv.returnOperand);
            trueBB.instructions.add(moveIns);
            trueBB.terminator = new BIRTerminator.GOTO(null, parentFuncEnv.returnBB, bbIns.scope);
            parentFuncEnv.parentFuncNewBBList.add(trueBB);
            parentFuncEnv.parentFuncNewBB = falseBB;
            parentFuncEnv.parentFuncNewInsList = new ArrayList<BIRNonTerminator>();
        }
        splitFuncEnv.reset(this.getTempVarsForArraySplit(), fromAttachedFunction);
    }

    private void populateSplitFuncLocalVarsAndErrorTable(BIRNode.BIRFunction parentFunc, SplitFuncEnv splitFuncEnv, ParentFuncEnv parentFuncEnv, BIRNode.BIRBasicBlock bb, BIRAbstractInstruction bbIns, BType funcRetType, BIRNode.BIRFunction splitBirFunc) {
        ArrayList<BIRNode.BIRFunctionParameter> functionParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        for (BIRNode.BIRVariableDcl funcArg : splitFuncEnv.splitFuncArgs) {
            Name argName = funcArg.name;
            splitBirFunc.requiredParams.add(new BIRNode.BIRParameter(bbIns.pos, argName, 0L));
            BIRNode.BIRFunctionParameter funcParameter = new BIRNode.BIRFunctionParameter(bbIns.pos, funcArg.type, argName, VarScope.FUNCTION, VarKind.ARG, argName.getValue(), false, false);
            functionParams.add(funcParameter);
            splitBirFunc.parameters.add(funcParameter);
        }
        splitBirFunc.argsCount = splitFuncEnv.splitFuncArgs.size();
        splitBirFunc.returnVariable = splitFuncEnv.returnVarDcl;
        splitFuncEnv.returnVarDcl.type = funcRetType;
        splitBirFunc.localVars.add(0, splitBirFunc.returnVariable);
        splitBirFunc.localVars.addAll(functionParams);
        splitBirFunc.localVars.addAll(splitFuncEnv.splitFuncLocalVarList);
        if (splitFuncEnv.splitFuncTempVars.tempVarsUsed) {
            splitBirFunc.localVars.add(splitFuncEnv.splitFuncTempVars.arrayIndexVarDcl);
            splitBirFunc.localVars.add(splitFuncEnv.splitFuncTempVars.typeCastVarDcl);
        }
        while (parentFuncEnv.errorTableIndex < parentFunc.errorTable.size() && parentFunc.errorTable.get((int)parentFuncEnv.errorTableIndex).trapBB.number <= bb.number) {
            splitFuncEnv.splitFuncErrorTable.add(parentFunc.errorTable.get(parentFuncEnv.errorTableIndex));
            ++parentFuncEnv.errorTableIndex;
        }
        splitBirFunc.errorTable = splitFuncEnv.splitFuncErrorTable;
    }

    private void fixErrorTableInPeriodicSplitFunc(SplitFuncEnv splitFuncEnv, BIRNode.BIRFunction splitBirFunc) {
        Map<Integer, BIRNode.BIRBasicBlock> changedBBs = splitFuncEnv.splitFuncChangedBBs;
        for (BIRNode.BIRErrorEntry birErrorEntry : splitBirFunc.errorTable) {
            if (changedBBs.containsKey(birErrorEntry.trapBB.number)) {
                birErrorEntry.trapBB = changedBBs.get(birErrorEntry.trapBB.number);
            }
            if (changedBBs.containsKey(birErrorEntry.endBB.number)) {
                birErrorEntry.endBB = changedBBs.get(birErrorEntry.endBB.number);
            }
            if (!changedBBs.containsKey(birErrorEntry.targetBB.number)) continue;
            birErrorEntry.targetBB = changedBBs.get(birErrorEntry.targetBB.number);
        }
    }

    private void fixTerminatorBBsInPeriodicSplitFunc(SplitFuncEnv splitFuncEnv) {
        List<BIRNode.BIRBasicBlock> bbList = splitFuncEnv.splitFuncNewBBList;
        BIRNode.BIRBasicBlock beforeLastBB = null;
        block4: for (BIRNode.BIRBasicBlock basicBlock : bbList) {
            if (splitFuncEnv.splitFuncCorrectTerminatorBBs.contains(basicBlock)) continue;
            BIRTerminator terminator = basicBlock.terminator;
            Map<Integer, BIRNode.BIRBasicBlock> changedBBs = splitFuncEnv.splitFuncChangedBBs;
            if (terminator.thenBB != null) {
                if (changedBBs.containsKey(terminator.thenBB.number)) {
                    terminator.thenBB = changedBBs.get(terminator.thenBB.number);
                } else {
                    if (beforeLastBB == null) {
                        beforeLastBB = this.getBeforeLastBB(splitFuncEnv);
                    }
                    terminator.thenBB = beforeLastBB;
                }
            }
            switch (terminator.getKind()) {
                case GOTO: {
                    if (changedBBs.containsKey(((BIRTerminator.GOTO)terminator).targetBB.number)) {
                        ((BIRTerminator.GOTO)terminator).targetBB = changedBBs.get(((BIRTerminator.GOTO)terminator).targetBB.number);
                        break;
                    }
                    if (beforeLastBB == null) {
                        beforeLastBB = this.getBeforeLastBB(splitFuncEnv);
                    }
                    ((BIRTerminator.GOTO)terminator).targetBB = beforeLastBB;
                    break;
                }
                case BRANCH: {
                    BIRTerminator.Branch branchTerminator = (BIRTerminator.Branch)terminator;
                    if (changedBBs.containsKey(branchTerminator.trueBB.number)) {
                        branchTerminator.trueBB = changedBBs.get(branchTerminator.trueBB.number);
                    }
                    if (!changedBBs.containsKey(branchTerminator.falseBB.number)) continue block4;
                    branchTerminator.falseBB = changedBBs.get(branchTerminator.falseBB.number);
                    break;
                }
            }
        }
        if (beforeLastBB != null) {
            bbList.add(beforeLastBB);
        }
    }

    private BIRNode.BIRBasicBlock getBeforeLastBB(SplitFuncEnv splitFuncEnv) {
        BIRNode.BIRBasicBlock beforeLastBB = new BIRNode.BIRBasicBlock(splitFuncEnv.splitFuncBBId++);
        BIRNonTerminator.ConstantLoad constantLoad = new BIRNonTerminator.ConstantLoad(splitFuncEnv.returnBB.terminator.pos, new Name("()"), this.symbolTable.nilType, splitFuncEnv.returnOperand);
        beforeLastBB.instructions.add(constantLoad);
        beforeLastBB.terminator = new BIRTerminator.GOTO(null, splitFuncEnv.returnBB, splitFuncEnv.returnBB.terminator.scope);
        return beforeLastBB;
    }

    private void populateSplitFuncArgsAndLocalVarList(SplitFuncEnv splitFuncEnv, BIRAbstractInstruction bbIns) {
        for (BIROperand rhsOperand : bbIns.getRhsOperands()) {
            if (splitFuncEnv.splitAvailableOperands.contains(rhsOperand) || !this.needToPassRhsVarDclAsArg(rhsOperand)) continue;
            splitFuncEnv.splitFuncArgs.add(rhsOperand.variableDcl);
        }
        if (bbIns.lhsOp != null) {
            splitFuncEnv.splitAvailableOperands.add(bbIns.lhsOp);
            if (this.needToPassLhsVarDclAsArg(bbIns.lhsOp)) {
                splitFuncEnv.splitFuncArgs.add(bbIns.lhsOp.variableDcl);
            }
            if (this.isTempOrSyntheticVar(bbIns.lhsOp.variableDcl)) {
                splitFuncEnv.splitFuncLocalVarList.add(bbIns.lhsOp.variableDcl);
            }
        }
    }

    private TempVarsForArraySplit getTempVarsForArraySplit() {
        BIRNode.BIRVariableDcl arrayIndexVarDcl = new BIRNode.BIRVariableDcl(null, this.symbolTable.intType, new Name("%arrIndex"), VarScope.FUNCTION, VarKind.TEMP, null);
        BIRNode.BIRVariableDcl typeCastVarDcl = new BIRNode.BIRVariableDcl(null, this.symbolTable.anyOrErrorType, new Name("%typeCast"), VarScope.FUNCTION, VarKind.TEMP, null);
        return new TempVarsForArraySplit(arrayIndexVarDcl, typeCastVarDcl);
    }

    private boolean setMapElementGivenOperand(Map<BIROperand, BIRMappingConstructorEntryWithIndex> birOperands, List<BIRNonTerminator> newInsList, BIROperand handleArrayOperand, TempVarsForArraySplit tempVars, Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints, BIRAbstractInstruction currIns, SplitFuncEnv splitFuncEnv, Map<BIROperand, NonTerminatorLocation> mapKeyOperandLocations, int bbIndex, int insIndex, Map<BIRAbstractInstruction, BIRMappingConstructorEntryWithIndex> globalAndArgVarKeyOrValueRelatedIns) {
        boolean globalAndArgVarKeyInsContainsCurrIns;
        boolean splitPointsContainCurrIns = insSplitPoints.containsKey(currIns);
        if (splitPointsContainCurrIns) {
            SplitPointDetails splitPointDetails = insSplitPoints.get(currIns);
            List<BIROperand> currOperands = splitPointDetails.arrayElementsBIROperands;
            for (BIROperand currOperand : currOperands) {
                NonTerminatorLocation nonTerminatorLocation;
                BIROperand keyOperand;
                BIRMappingConstructorEntryWithIndex mappingConstructorEntryWithIndex = birOperands.get(currOperand);
                BIRNode.BIRMappingConstructorEntry mappingConstructorEntry = mappingConstructorEntryWithIndex.mappingConstructorEntry;
                boolean isKeyValueEntry = mappingConstructorEntry instanceof BIRNode.BIRMappingConstructorKeyValueEntry;
                if (isKeyValueEntry && insIndex != -1 && mapKeyOperandLocations.containsKey(keyOperand = ((BIRNode.BIRMappingConstructorKeyValueEntry)mappingConstructorEntry).keyOp) && (nonTerminatorLocation = mapKeyOperandLocations.get(keyOperand)) != null && (nonTerminatorLocation.bbNum > bbIndex || nonTerminatorLocation.bbNum == bbIndex && nonTerminatorLocation.insNum > insIndex)) {
                    splitPointDetails.splitHere = false;
                    continue;
                }
                int arrayIndex = mappingConstructorEntryWithIndex.index;
                this.setMapElement(newInsList, handleArrayOperand, currOperand, mappingConstructorEntry, arrayIndex, tempVars);
            }
            splitFuncEnv.splitHere = splitPointDetails.splitHere;
        }
        if (globalAndArgVarKeyInsContainsCurrIns = globalAndArgVarKeyOrValueRelatedIns.containsKey(currIns)) {
            if (!splitPointsContainCurrIns) {
                splitFuncEnv.splitHere = true;
            }
            BIRMappingConstructorEntryWithIndex mappingConstructorEntryWithIndex = globalAndArgVarKeyOrValueRelatedIns.get(currIns);
            BIRNode.BIRMappingConstructorKeyValueEntry keyValueEntry = (BIRNode.BIRMappingConstructorKeyValueEntry)mappingConstructorEntryWithIndex.mappingConstructorEntry;
            int arrayIndex = mappingConstructorEntryWithIndex.index;
            BIROperand valueOperand = keyValueEntry.valueOp;
            this.setMapElement(newInsList, handleArrayOperand, valueOperand, keyValueEntry, arrayIndex, tempVars);
            BIRNode.BIRVariableDcl valueVarDcl = valueOperand.variableDcl;
            this.addToSplitFuncArgsIfVarDclIsArg(splitFuncEnv, valueVarDcl);
            BIRNode.BIRVariableDcl keyVarDcl = keyValueEntry.keyOp.variableDcl;
            this.addToSplitFuncArgsIfVarDclIsArg(splitFuncEnv, keyVarDcl);
        }
        return splitPointsContainCurrIns || globalAndArgVarKeyInsContainsCurrIns;
    }

    private void addToSplitFuncArgsIfVarDclIsArg(SplitFuncEnv splitFuncEnv, BIRNode.BIRVariableDcl variableDcl) {
        if (variableDcl.kind == VarKind.ARG) {
            splitFuncEnv.splitFuncArgs.add(variableDcl);
        }
    }

    private boolean setArrayElementGivenOperand(Map<BIROperand, BIRListConstructorEntryWithIndex> birOperands, List<BIRNonTerminator> newInsList, BIROperand handleArrayOperand, TempVarsForArraySplit tempVars, Map<BIRAbstractInstruction, SplitPointDetails> insSplitPoints, BIRAbstractInstruction currIns, SplitFuncEnv splitFuncEnv) {
        if (insSplitPoints.containsKey(currIns)) {
            SplitPointDetails splitPointDetails = insSplitPoints.get(currIns);
            List<BIROperand> currOperands = splitPointDetails.arrayElementsBIROperands;
            for (BIROperand currOperand : currOperands) {
                BIRListConstructorEntryWithIndex listConstructorEntryWithIndex = birOperands.get(currOperand);
                BIRNode.BIRListConstructorEntry listConstructorEntry = listConstructorEntryWithIndex.listConstructorEntry;
                int arrayIndex = listConstructorEntryWithIndex.index;
                this.setArrayElement(newInsList, handleArrayOperand, currOperand, listConstructorEntry, arrayIndex, tempVars);
            }
            splitFuncEnv.splitHere = splitPointDetails.splitHere;
            return true;
        }
        return false;
    }

    private void setMapElement(List<BIRNonTerminator> newInsList, BIROperand handleArrayOperand, BIROperand valueOrExprOperand, BIRNode.BIRMappingConstructorEntry mappingConstructorEntry, int arrayIndex, TempVarsForArraySplit tempVars) {
        JMethodCallInstruction callSetEntry = new JMethodCallInstruction(null);
        callSetEntry.invocationType = 184;
        callSetEntry.jClassName = "io/ballerina/runtime/internal/utils/LargeStructureUtils";
        tempVars.tempVarsUsed = true;
        BIRNonTerminator.ConstantLoad loadArrayIndex = new BIRNonTerminator.ConstantLoad(null, arrayIndex, this.symbolTable.intType, tempVars.arrayIndexOperand);
        newInsList.add(loadArrayIndex);
        BIRNonTerminator.TypeCast typeCastInstruction = new BIRNonTerminator.TypeCast(null, tempVars.typeCastOperand, valueOrExprOperand, this.symbolTable.anyOrErrorType, true);
        newInsList.add(typeCastInstruction);
        if (mappingConstructorEntry instanceof BIRNode.BIRMappingConstructorKeyValueEntry) {
            callSetEntry.jMethodVMSig = "(Lio/ballerina/runtime/internal/values/HandleValue;Ljava/lang/Object;Ljava/lang/Object;J)V";
            callSetEntry.args = new ArrayList<BIROperand>(Arrays.asList(handleArrayOperand, ((BIRNode.BIRMappingConstructorKeyValueEntry)mappingConstructorEntry).keyOp, tempVars.typeCastOperand, tempVars.arrayIndexOperand));
            callSetEntry.name = "setKeyValueEntry";
        } else {
            callSetEntry.jMethodVMSig = "(Lio/ballerina/runtime/internal/values/HandleValue;Ljava/lang/Object;J)V";
            callSetEntry.args = new ArrayList<BIROperand>(Arrays.asList(handleArrayOperand, tempVars.typeCastOperand, tempVars.arrayIndexOperand));
            callSetEntry.name = "setSpreadFieldEntry";
        }
        newInsList.add(callSetEntry);
    }

    private void setArrayElement(List<BIRNonTerminator> newInsList, BIROperand handleArrayOperand, BIROperand insLhsOp, BIRNode.BIRListConstructorEntry listConstructorEntry, int arrayIndex, TempVarsForArraySplit tempVars) {
        JMethodCallInstruction callSetEntry = new JMethodCallInstruction(null);
        callSetEntry.invocationType = 184;
        callSetEntry.jClassName = "io/ballerina/runtime/internal/utils/LargeStructureUtils";
        callSetEntry.jMethodVMSig = "(Lio/ballerina/runtime/internal/values/HandleValue;Ljava/lang/Object;J)V";
        tempVars.tempVarsUsed = true;
        BIRNonTerminator.ConstantLoad loadArrayIndex = new BIRNonTerminator.ConstantLoad(null, arrayIndex, this.symbolTable.intType, tempVars.arrayIndexOperand);
        newInsList.add(loadArrayIndex);
        BIRNonTerminator.TypeCast typeCastInstruction = new BIRNonTerminator.TypeCast(null, tempVars.typeCastOperand, insLhsOp, this.symbolTable.anyOrErrorType, true);
        newInsList.add(typeCastInstruction);
        callSetEntry.args = new ArrayList<BIROperand>(Arrays.asList(handleArrayOperand, tempVars.typeCastOperand, tempVars.arrayIndexOperand));
        callSetEntry.name = listConstructorEntry instanceof BIRNode.BIRListConstructorExprEntry ? "setExpressionEntry" : "setSpreadEntry";
        newInsList.add(callSetEntry);
    }

    private List<Split> getPossibleSplits(List<BIRNode.BIRBasicBlock> basicBlocks, List<BIRNode.BIRErrorEntry> errorTableEntries, boolean fromSplitFunction) {
        ArrayList<Split> possibleSplits = new ArrayList<Split>();
        int splitEndBBIndex = basicBlocks.size() - 1;
        int splitEndInsIndex = basicBlocks.get((int)splitEndBBIndex).instructions.size() - 1;
        int errTableEntryIndex = errorTableEntries.size() - 1;
        boolean splitStarted = false;
        boolean returnValAssigned = false;
        boolean splitTypeArray = true;
        HashSet<BIRNode.BIRVariableDcl> neededOperandsVarDcl = new HashSet<BIRNode.BIRVariableDcl>();
        HashSet<BIRNode.BIRVariableDcl> lhsOperandList = new HashSet<BIRNode.BIRVariableDcl>();
        BIROperand splitStartOperand = null;
        int splitInsCount = 0;
        for (int bbNum = basicBlocks.size() - 1; bbNum >= 0; --bbNum) {
            BIRNode.BIRBasicBlock basicBlock = basicBlocks.get(bbNum);
            BIRTerminator bbTerminator = basicBlock.terminator;
            if (splitStarted) {
                BIROperand[] rhsOperands;
                if (bbTerminator.lhsOp != null) {
                    if (bbTerminator.lhsOp.variableDcl.kind == VarKind.LOCAL) {
                        splitStarted = false;
                    } else if (this.needToPassLhsVarDclAsArg(bbTerminator.lhsOp)) {
                        neededOperandsVarDcl.add(bbTerminator.lhsOp.variableDcl);
                    } else {
                        neededOperandsVarDcl.remove(bbTerminator.lhsOp.variableDcl);
                        if (this.isTempOrSyntheticVar(bbTerminator.lhsOp.variableDcl)) {
                            lhsOperandList.add(bbTerminator.lhsOp.variableDcl);
                        }
                    }
                }
                ++splitInsCount;
                for (BIROperand bIROperand : rhsOperands = bbTerminator.getRhsOperands()) {
                    if (!this.needToPassRhsVarDclAsArg(bIROperand)) continue;
                    neededOperandsVarDcl.add(bIROperand.variableDcl);
                }
            }
            List<BIRNonTerminator> instructions = basicBlock.instructions;
            for (int insNum = instructions.size() - 1; insNum >= 0; --insNum) {
                BIROperand[] initialRhsOperands;
                BIRNonTerminator currIns = instructions.get(insNum);
                if (currIns.lhsOp.variableDcl.kind == VarKind.LOCAL) {
                    splitStarted = false;
                }
                if (splitStarted) {
                    int trapBBNum;
                    BIROperand[] rhsOperands;
                    if (currIns.lhsOp.variableDcl.kind == VarKind.RETURN) {
                        returnValAssigned = true;
                    } else if (this.needToPassLhsVarDclAsArg(currIns.lhsOp)) {
                        neededOperandsVarDcl.add(currIns.lhsOp.variableDcl);
                    } else {
                        neededOperandsVarDcl.remove(currIns.lhsOp.variableDcl);
                        if (this.isTempOrSyntheticVar(currIns.lhsOp.variableDcl)) {
                            lhsOperandList.add(currIns.lhsOp.variableDcl);
                        }
                    }
                    for (BIROperand rhsOperand2 : rhsOperands = currIns.getRhsOperands()) {
                        if (!this.needToPassRhsVarDclAsArg(rhsOperand2)) continue;
                        neededOperandsVarDcl.add(rhsOperand2.variableDcl);
                    }
                    ++splitInsCount;
                    if (currIns.lhsOp != splitStartOperand) continue;
                    if (neededOperandsVarDcl.size() > 125 || splitInsCount < 25) {
                        splitStarted = false;
                        continue;
                    }
                    ArrayList<BIRNode.BIRVariableDcl> newFuncArgs = new ArrayList<BIRNode.BIRVariableDcl>(neededOperandsVarDcl);
                    ArrayList<BIRNode.BIRErrorEntry> arrayList = new ArrayList<BIRNode.BIRErrorEntry>();
                    while (errTableEntryIndex >= 0 && (trapBBNum = errorTableEntries.get((int)errTableEntryIndex).trapBB.number) > this.getBbIdNum(basicBlocks, bbNum)) {
                        if (trapBBNum < this.getBbIdNum(basicBlocks, splitEndBBIndex)) {
                            arrayList.add(errorTableEntries.get(errTableEntryIndex));
                        }
                        --errTableEntryIndex;
                    }
                    Collections.reverse(arrayList);
                    boolean splitAgain = splitInsCount >= 1000;
                    possibleSplits.add(new Split(insNum, splitEndInsIndex, bbNum, splitEndBBIndex, lhsOperandList, newFuncArgs, arrayList, splitAgain, splitTypeArray, returnValAssigned));
                    splitStarted = false;
                    continue;
                }
                if (currIns.kind != InstructionKind.NEW_ARRAY && currIns.kind != InstructionKind.NEW_STRUCTURE) continue;
                if (currIns.kind == InstructionKind.NEW_ARRAY) {
                    BIRNonTerminator.NewArray arrayIns = (BIRNonTerminator.NewArray)currIns;
                    splitStartOperand = arrayIns.sizeOp;
                    splitTypeArray = true;
                } else {
                    BIRNonTerminator.NewStructure structureIns = (BIRNonTerminator.NewStructure)currIns;
                    splitStartOperand = structureIns.rhsOp;
                    splitTypeArray = false;
                }
                if (bbNum == basicBlocks.size() - 2 && !basicBlocks.getFirst().instructions.isEmpty() && basicBlocks.getFirst().instructions.getFirst().lhsOp == splitStartOperand && fromSplitFunction) continue;
                splitStarted = true;
                returnValAssigned = false;
                neededOperandsVarDcl = new HashSet();
                for (BIROperand rhsOperand : initialRhsOperands = currIns.getRhsOperands()) {
                    if (!this.needToPassRhsVarDclAsArg(rhsOperand)) continue;
                    neededOperandsVarDcl.add(rhsOperand.variableDcl);
                }
                lhsOperandList = new HashSet();
                splitInsCount = 1;
                splitEndInsIndex = insNum;
                splitEndBBIndex = bbNum;
            }
        }
        Collections.reverse(possibleSplits);
        return possibleSplits;
    }

    private int getBbIdNum(List<BIRNode.BIRBasicBlock> bbList, int bbIndex) {
        return bbList.get((int)bbIndex).number;
    }

    private boolean needToPassRhsVarDclAsArg(BIROperand rhsOp) {
        return !rhsOp.variableDcl.ignoreVariable && rhsOp.variableDcl.kind != VarKind.GLOBAL && rhsOp.variableDcl.kind != VarKind.CONSTANT;
    }

    private boolean needToPassLhsVarDclAsArg(BIROperand lhsOp) {
        return !lhsOp.variableDcl.ignoreVariable && lhsOp.variableDcl.kind == VarKind.SELF;
    }

    private void generateSplits(BIRNode.BIRFunction function, List<Split> possibleSplits, List<BIRNode.BIRFunction> newlyAddedFunctions, boolean fromAttachedFunction) {
        int splitNum = 0;
        List<BIRNode.BIRBasicBlock> basicBlocks = function.basicBlocks;
        ArrayList<BIRNode.BIRBasicBlock> newBBList = new ArrayList<BIRNode.BIRBasicBlock>();
        int startInsNum = 0;
        int bbNum = 0;
        int newBBNum = this.getBbIdNum(basicBlocks, basicBlocks.size() - 1);
        BIRNode.BIRBasicBlock currentBB = possibleSplits.get((int)splitNum).startBBNum == 0 ? this.replaceExistingBBAndGetCurrentBB(basicBlocks, bbNum) : null;
        HashMap<String, String> changedLocalVarStartBB = new HashMap<String, String>();
        HashMap<String, String> changedLocalVarEndBB = new HashMap<String, String>();
        HashMap<Integer, BIRNode.BIRBasicBlock> changedErrorTableEndBB = new HashMap<Integer, BIRNode.BIRBasicBlock>();
        while (bbNum < basicBlocks.size()) {
            BIROperand splitFuncCallResultOp;
            if (startInsNum == 0) {
                if (splitNum >= possibleSplits.size()) {
                    while (bbNum < basicBlocks.size()) {
                        newBBList.add(basicBlocks.get(bbNum));
                        ++bbNum;
                    }
                    break;
                }
                if (bbNum < possibleSplits.get((int)splitNum).startBBNum) {
                    while (bbNum < possibleSplits.get((int)splitNum).startBBNum) {
                        newBBList.add(basicBlocks.get(bbNum));
                        ++bbNum;
                    }
                    currentBB = this.replaceExistingBBAndGetCurrentBB(basicBlocks, bbNum);
                    continue;
                }
            } else if (splitNum >= possibleSplits.size()) {
                if (startInsNum < basicBlocks.get((int)bbNum).instructions.size()) {
                    currentBB.instructions.addAll(basicBlocks.get((int)bbNum).instructions.subList(startInsNum, basicBlocks.get((int)bbNum).instructions.size()));
                }
                currentBB.terminator = basicBlocks.get((int)bbNum).terminator;
                newBBList.add(currentBB);
                changedLocalVarStartBB.put(basicBlocks.get((int)bbNum).id.value, currentBB.id.value);
                changedLocalVarEndBB.put(basicBlocks.get((int)bbNum).id.value, currentBB.id.value);
                startInsNum = 0;
                ++bbNum;
                continue;
            }
            ArrayList<Split> splitsInSameBBList = new ArrayList<Split>();
            while (splitNum < possibleSplits.size() && possibleSplits.get((int)splitNum).endBBNum == bbNum) {
                splitsInSameBBList.add(possibleSplits.get(splitNum));
                ++splitNum;
            }
            if (currentBB == null) {
                throw new IllegalStateException("currentBB cannot be null");
            }
            changedLocalVarStartBB.put(basicBlocks.get((int)bbNum).id.value, currentBB.id.value);
            if (!splitsInSameBBList.isEmpty()) {
                currentBB = this.generateSplitsInSameBB(function, bbNum, splitsInSameBBList, newlyAddedFunctions, newBBNum, newBBList, startInsNum, currentBB, fromAttachedFunction);
                startInsNum = possibleSplits.get((int)(splitNum - 1)).lastIns + 1;
                newBBNum += splitsInSameBBList.size();
            }
            if (splitNum >= possibleSplits.size() || possibleSplits.get((int)splitNum).startBBNum > bbNum) {
                if (startInsNum < basicBlocks.get((int)bbNum).instructions.size()) {
                    currentBB.instructions.addAll(basicBlocks.get((int)bbNum).instructions.subList(startInsNum, basicBlocks.get((int)bbNum).instructions.size()));
                }
                currentBB.terminator = basicBlocks.get((int)bbNum).terminator;
                newBBList.add(currentBB);
                changedLocalVarEndBB.put(basicBlocks.get((int)bbNum).id.value, currentBB.id.value);
                startInsNum = 0;
                if (splitNum < possibleSplits.size() && possibleSplits.get((int)splitNum).startBBNum == ++bbNum) {
                    currentBB = this.replaceExistingBBAndGetCurrentBB(basicBlocks, bbNum);
                    continue;
                }
                currentBB = null;
                continue;
            }
            if (startInsNum < possibleSplits.get((int)splitNum).firstIns) {
                currentBB.instructions.addAll(basicBlocks.get((int)bbNum).instructions.subList(startInsNum, possibleSplits.get((int)splitNum).firstIns));
            }
            ++this.splitFuncNum;
            String newFunctionName = SPLIT_METHOD + this.splitFuncNum;
            Name newFuncName = new Name(newFunctionName);
            Split currSplit = possibleSplits.get(splitNum);
            ++splitNum;
            BIRNonTerminator lastInstruction = basicBlocks.get((int)currSplit.endBBNum).instructions.get(currSplit.lastIns);
            BType newFuncReturnType = lastInstruction.lhsOp.variableDcl.type;
            BIROperand splitLastInsLhsOp = new BIROperand(lastInstruction.lhsOp.variableDcl);
            if (currSplit.returnValAssigned) {
                splitFuncCallResultOp = this.generateTempLocalVariable(newFuncReturnType, function.localVars);
                newFuncReturnType = this.createErrorUnionReturnType(newFuncReturnType);
            } else {
                splitFuncCallResultOp = splitLastInsLhsOp;
            }
            BIRNode.BIRBasicBlock parentFuncNewBB = new BIRNode.BIRBasicBlock(newBBNum + 2);
            BIRNode.BIRFunction newBIRFunc = this.createNewBIRFunctionAcrossBB(function, newFuncName, newFuncReturnType, currSplit, newBBNum, fromAttachedFunction, changedErrorTableEndBB, parentFuncNewBB);
            newBBNum += 2;
            newlyAddedFunctions.add(newBIRFunc);
            if (currSplit.splitFurther) {
                newlyAddedFunctions.addAll(this.splitBIRFunction(newBIRFunc, fromAttachedFunction, true, currSplit.splitTypeArray));
            }
            function.errorTable.removeAll(currSplit.errorTableEntries);
            startInsNum = currSplit.lastIns + 1;
            ArrayList<BIROperand> args = new ArrayList<BIROperand>();
            for (BIRNode.BIRVariableDcl funcArg : currSplit.funcArgs) {
                args.add(new BIROperand(funcArg));
            }
            currentBB.terminator = new BIRTerminator.Call(lastInstruction.pos, InstructionKind.CALL, false, this.currentPackageId, newFuncName, args, splitFuncCallResultOp, parentFuncNewBB, Collections.emptyList(), Collections.emptySet(), lastInstruction.scope);
            newBBList.add(currentBB);
            changedLocalVarEndBB.put(basicBlocks.get((int)bbNum).id.value, currentBB.id.value);
            currentBB = parentFuncNewBB;
            if (currSplit.returnValAssigned) {
                currentBB = this.handleNewFuncReturnVal(function, splitFuncCallResultOp, lastInstruction.scope, currentBB, newBBNum, newBBList, splitLastInsLhsOp);
                newBBNum += 2;
            }
            bbNum = currSplit.endBBNum;
        }
        this.setLocalVarStartEndBB(function, newBBList, changedLocalVarStartBB, changedLocalVarEndBB);
        function.basicBlocks = newBBList;
        this.removeUnusedVarsAndSetVarUsage(function);
        this.fixErrorTableEndBBs(function.errorTable, changedErrorTableEndBB);
    }

    private void fixErrorTableEndBBs(List<BIRNode.BIRErrorEntry> errorTable, Map<Integer, BIRNode.BIRBasicBlock> changedErrorTableEndBB) {
        for (BIRNode.BIRErrorEntry birErrorEntry : errorTable) {
            if (!changedErrorTableEndBB.containsKey(birErrorEntry.endBB.number)) continue;
            birErrorEntry.endBB = changedErrorTableEndBB.get(birErrorEntry.endBB.number);
        }
    }

    private BIRNode.BIRBasicBlock replaceExistingBBAndGetCurrentBB(List<BIRNode.BIRBasicBlock> basicBlocks, int bbNum) {
        BIRNode.BIRBasicBlock currentBB = basicBlocks.get(bbNum);
        BIRNode.BIRBasicBlock newCurrentBB = new BIRNode.BIRBasicBlock(this.getBbIdNum(basicBlocks, bbNum));
        newCurrentBB.instructions = currentBB.instructions;
        newCurrentBB.terminator = currentBB.terminator;
        basicBlocks.set(bbNum, newCurrentBB);
        currentBB.terminator = null;
        currentBB.instructions = new ArrayList<BIRNonTerminator>();
        return currentBB;
    }

    private BType createErrorUnionReturnType(BType newFuncReturnType) {
        LinkedHashSet<BType> memberTypes = new LinkedHashSet<BType>(2);
        memberTypes.add(newFuncReturnType);
        memberTypes.add(this.symbolTable.errorType);
        return new BUnionType(this.symbolTable.typeEnv(), null, memberTypes, false);
    }

    private BIRNode.BIRBasicBlock handleNewFuncReturnVal(BIRNode.BIRFunction function, BIROperand splitFuncCallResultOp, BirScope lastInsScope, BIRNode.BIRBasicBlock currentBB, int newBBNum, List<BIRNode.BIRBasicBlock> newBBList, BIROperand splitLastInsLhsOp) {
        BIROperand isErrorResultOp = this.generateTempLocalVariable(this.symbolTable.booleanType, function.localVars);
        BIRNonTerminator.TypeTest errorTestIns = new BIRNonTerminator.TypeTest(null, this.symbolTable.errorType, isErrorResultOp, splitFuncCallResultOp);
        currentBB.instructions.add(errorTestIns);
        BIRNode.BIRBasicBlock trueBB = new BIRNode.BIRBasicBlock(++newBBNum);
        BIRNode.BIRBasicBlock falseBB = new BIRNode.BIRBasicBlock(++newBBNum);
        currentBB.terminator = new BIRTerminator.Branch(null, isErrorResultOp, trueBB, falseBB, lastInsScope);
        newBBList.add(currentBB);
        BIROperand castedErrorOp = this.generateTempLocalVariable((BType)this.symbolTable.errorType, function.localVars);
        BIRNonTerminator.TypeCast typeCastErrIns = new BIRNonTerminator.TypeCast(null, castedErrorOp, splitFuncCallResultOp, this.symbolTable.errorType, false);
        trueBB.instructions.add(typeCastErrIns);
        BIRNonTerminator.Move moveIns = new BIRNonTerminator.Move(null, castedErrorOp, new BIROperand(function.returnVariable));
        trueBB.instructions.add(moveIns);
        BIRNode.BIRBasicBlock returnBB = function.basicBlocks.get(function.basicBlocks.size() - 1);
        trueBB.terminator = new BIRTerminator.GOTO(null, returnBB, lastInsScope);
        newBBList.add(trueBB);
        BIRNonTerminator.TypeCast typeCastLhsOpIns = new BIRNonTerminator.TypeCast(null, splitLastInsLhsOp, splitFuncCallResultOp, splitLastInsLhsOp.variableDcl.type, false);
        falseBB.instructions.add(typeCastLhsOpIns);
        return falseBB;
    }

    private boolean isTempOrSyntheticVar(BIRNode.BIRVariableDcl variableDcl) {
        return variableDcl.kind == VarKind.TEMP || variableDcl.kind == VarKind.SYNTHETIC;
    }

    private Set<BIRNode.BIRVariableDcl> findUsedVars(BIRNode.BIRBasicBlock basicBlock, Set<BIRNode.BIRVariableDcl> usedTempAndSyntheticVars, Set<BIRNode.BIRVariableDcl> allUsedVars, Set<BIRNode.BIRVariableDcl> multipleBBUsedVars) {
        BIROperand[] rhsOperands;
        HashSet<BIRNode.BIRVariableDcl> thisBBUsedAllVars = new HashSet<BIRNode.BIRVariableDcl>();
        for (BIRNonTerminator instruction : basicBlock.instructions) {
            BIROperand[] rhsOperands2;
            thisBBUsedAllVars.add(instruction.lhsOp.variableDcl);
            if (allUsedVars.contains(instruction.lhsOp.variableDcl)) {
                multipleBBUsedVars.add(instruction.lhsOp.variableDcl);
            }
            if (this.isTempOrSyntheticVar(instruction.lhsOp.variableDcl)) {
                usedTempAndSyntheticVars.add(instruction.lhsOp.variableDcl);
            }
            for (BIROperand rhsOperand : rhsOperands2 = instruction.getRhsOperands()) {
                thisBBUsedAllVars.add(rhsOperand.variableDcl);
                if (allUsedVars.contains(rhsOperand.variableDcl)) {
                    multipleBBUsedVars.add(rhsOperand.variableDcl);
                }
                if (!this.isTempOrSyntheticVar(rhsOperand.variableDcl)) continue;
                usedTempAndSyntheticVars.add(rhsOperand.variableDcl);
            }
        }
        if (basicBlock.terminator.lhsOp != null) {
            thisBBUsedAllVars.add(basicBlock.terminator.lhsOp.variableDcl);
            if (allUsedVars.contains(basicBlock.terminator.lhsOp.variableDcl)) {
                multipleBBUsedVars.add(basicBlock.terminator.lhsOp.variableDcl);
            }
            if (this.isTempOrSyntheticVar(basicBlock.terminator.lhsOp.variableDcl)) {
                usedTempAndSyntheticVars.add(basicBlock.terminator.lhsOp.variableDcl);
            }
        }
        for (BIROperand rhsOperand : rhsOperands = basicBlock.terminator.getRhsOperands()) {
            thisBBUsedAllVars.add(rhsOperand.variableDcl);
            if (allUsedVars.contains(rhsOperand.variableDcl)) {
                multipleBBUsedVars.add(rhsOperand.variableDcl);
            }
            if (!this.isTempOrSyntheticVar(rhsOperand.variableDcl)) continue;
            usedTempAndSyntheticVars.add(rhsOperand.variableDcl);
        }
        return thisBBUsedAllVars;
    }

    private void removeUnusedVarsAndSetVarUsage(BIRNode.BIRFunction birFunction) {
        HashSet<BIRNode.BIRVariableDcl> usedTempAndSyntheticVars = new HashSet<BIRNode.BIRVariableDcl>();
        HashSet<BIRNode.BIRVariableDcl> allUsedVars = new HashSet<BIRNode.BIRVariableDcl>();
        HashSet<BIRNode.BIRVariableDcl> multipleBBUsedVars = new HashSet<BIRNode.BIRVariableDcl>();
        for (BIRNode.BIRBasicBlock basicBlock : birFunction.basicBlocks) {
            allUsedVars.addAll(this.findUsedVars(basicBlock, usedTempAndSyntheticVars, allUsedVars, multipleBBUsedVars));
        }
        ArrayList<BIRNode.BIRVariableDcl> newLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
        for (BIRNode.BIRVariableDcl localVar : birFunction.localVars) {
            if (localVar.onlyUsedInSingleBB && multipleBBUsedVars.contains(localVar)) {
                localVar.onlyUsedInSingleBB = false;
            }
            if (this.isTempOrSyntheticVar(localVar)) {
                if (!usedTempAndSyntheticVars.contains(localVar)) continue;
                newLocalVars.add(localVar);
                continue;
            }
            newLocalVars.add(localVar);
        }
        birFunction.localVars = newLocalVars;
    }

    private void setLocalVarStartEndBB(BIRNode.BIRFunction birFunction, List<BIRNode.BIRBasicBlock> newBBList, Map<String, String> changedLocalVarStartBB, Map<String, String> changedLocalVarEndBB) {
        HashMap<String, BIRNode.BIRBasicBlock> newBBs = new HashMap<String, BIRNode.BIRBasicBlock>();
        for (BIRNode.BIRBasicBlock newBB : newBBList) {
            newBBs.put(newBB.id.value, newBB);
        }
        for (BIRNode.BIRVariableDcl localVar : birFunction.localVars) {
            if (localVar.kind != VarKind.LOCAL) continue;
            if (localVar.startBB != null) {
                localVar.startBB = changedLocalVarStartBB.containsKey(localVar.startBB.id.value) ? (BIRNode.BIRBasicBlock)newBBs.get(changedLocalVarStartBB.get(localVar.startBB.id.value)) : (BIRNode.BIRBasicBlock)newBBs.get(localVar.startBB.id.value);
            }
            if (localVar.endBB == null) continue;
            if (changedLocalVarEndBB.containsKey(localVar.endBB.id.value)) {
                localVar.endBB = (BIRNode.BIRBasicBlock)newBBs.get(changedLocalVarEndBB.get(localVar.endBB.id.value));
                continue;
            }
            localVar.endBB = (BIRNode.BIRBasicBlock)newBBs.get(localVar.endBB.id.value);
        }
    }

    private BIRNode.BIRFunction createNewBIRFunctionAcrossBB(BIRNode.BIRFunction parentFunc, Name funcName, BType retType, Split currSplit, int newBBNum, boolean fromAttachedFunction, Map<Integer, BIRNode.BIRBasicBlock> changedErrorTableEndBB, BIRNode.BIRBasicBlock parentFuncNewBB) {
        List<BIRNode.BIRBasicBlock> parentFuncBBs = parentFunc.basicBlocks;
        BIRNonTerminator lastIns = parentFuncBBs.get((int)currSplit.endBBNum).instructions.get(currSplit.lastIns);
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BIRNode.BIRVariableDcl funcArg : currSplit.funcArgs) {
            paramTypes.add(funcArg.type);
        }
        BInvokableType type = new BInvokableType(this.symbolTable.typeEnv(), paramTypes, retType, null);
        BIRNode.BIRFunction birFunc = new BIRNode.BIRFunction(null, funcName, funcName, 0L, type, DEFAULT_WORKER_NAME, 0, SymbolOrigin.VIRTUAL);
        ArrayList<BIRNode.BIRFunctionParameter> functionParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        BIRNode.BIRVariableDcl selfVarDcl = null;
        for (BIRNode.BIRVariableDcl funcArg : currSplit.funcArgs) {
            Name argName = funcArg.name;
            birFunc.requiredParams.add(new BIRNode.BIRParameter(lastIns.pos, argName, 0L));
            BIRNode.BIRFunctionParameter funcParameter = new BIRNode.BIRFunctionParameter(lastIns.pos, funcArg.type, argName, VarScope.FUNCTION, VarKind.ARG, argName.getValue(), false, false);
            functionParams.add(funcParameter);
            birFunc.parameters.add(funcParameter);
            if (funcArg.kind != VarKind.SELF) continue;
            selfVarDcl = new BIRNode.BIRVariableDcl(funcArg.pos, funcArg.type, funcArg.name, funcArg.originalName, VarScope.FUNCTION, VarKind.ARG, funcArg.metaVarName);
        }
        birFunc.argsCount = currSplit.funcArgs.size();
        birFunc.returnVariable = fromAttachedFunction ? new BIRNode.BIRVariableDcl(lastIns.pos, retType, new Name("%1"), VarScope.FUNCTION, VarKind.RETURN, null) : new BIRNode.BIRVariableDcl(lastIns.pos, retType, new Name("%0"), VarScope.FUNCTION, VarKind.RETURN, null);
        birFunc.localVars.add(0, birFunc.returnVariable);
        birFunc.localVars.addAll(functionParams);
        birFunc.localVars.addAll(currSplit.lhsVars);
        birFunc.errorTable.addAll(currSplit.errorTableEntries);
        BIRNode.BIRBasicBlock entryBB = new BIRNode.BIRBasicBlock(0);
        if (currSplit.firstIns < parentFuncBBs.get((int)currSplit.startBBNum).instructions.size()) {
            entryBB.instructions.addAll(parentFuncBBs.get((int)currSplit.startBBNum).instructions.subList(currSplit.firstIns, parentFuncBBs.get((int)currSplit.startBBNum).instructions.size()));
        }
        entryBB.terminator = parentFuncBBs.get((int)currSplit.startBBNum).terminator;
        List<BIRNode.BIRBasicBlock> basicBlocks = birFunc.basicBlocks;
        basicBlocks.add(entryBB);
        for (int bbNum = currSplit.startBBNum + 1; bbNum < currSplit.endBBNum; ++bbNum) {
            BIRNode.BIRBasicBlock bb = parentFuncBBs.get(bbNum);
            basicBlocks.add(bb);
            changedErrorTableEndBB.put(bb.number, parentFuncNewBB);
        }
        int lastBBIdNum = this.getBbIdNum(parentFuncBBs, currSplit.endBBNum);
        BIRNode.BIRBasicBlock lastBB = new BIRNode.BIRBasicBlock(lastBBIdNum);
        changedErrorTableEndBB.put(lastBBIdNum, parentFuncNewBB);
        if (0 <= currSplit.lastIns) {
            lastBB.instructions.addAll(parentFuncBBs.get((int)currSplit.endBBNum).instructions.subList(0, currSplit.lastIns + 1));
        }
        lastBB.instructions.get((int)currSplit.lastIns).lhsOp = new BIROperand(birFunc.returnVariable);
        BIRNode.BIRBasicBlock exitBB = new BIRNode.BIRBasicBlock(++newBBNum);
        exitBB.terminator = new BIRTerminator.Return(null);
        lastBB.terminator = new BIRTerminator.GOTO(null, exitBB, lastIns.scope);
        for (BIRNode.BIRBasicBlock basicBlock : basicBlocks) {
            this.fixTerminatorBBs(lastBBIdNum, lastBB, basicBlock.terminator);
        }
        basicBlocks.add(lastBB);
        basicBlocks.add(exitBB);
        this.rectifyVarKindsAndTerminators(birFunc, selfVarDcl, exitBB);
        BIRGenUtils.rearrangeBasicBlocks(birFunc);
        return birFunc;
    }

    private void fixTerminatorBBs(int lastBBIdNum, BIRNode.BIRBasicBlock lastBB, BIRTerminator terminator) {
        if (terminator.thenBB != null && terminator.thenBB.number == lastBBIdNum) {
            terminator.thenBB = lastBB;
        }
        switch (terminator.getKind()) {
            case GOTO: {
                if (((BIRTerminator.GOTO)terminator).targetBB.number != lastBBIdNum) break;
                ((BIRTerminator.GOTO)terminator).targetBB = lastBB;
                break;
            }
            case BRANCH: {
                BIRTerminator.Branch branchTerminator = (BIRTerminator.Branch)terminator;
                if (branchTerminator.trueBB.number == lastBBIdNum) {
                    branchTerminator.trueBB = lastBB;
                }
                if (branchTerminator.falseBB.number != lastBBIdNum) break;
                branchTerminator.falseBB = lastBB;
                break;
            }
        }
    }

    private BIRNode.BIRBasicBlock generateSplitsInSameBB(BIRNode.BIRFunction function, int bbNum, List<Split> possibleSplits, List<BIRNode.BIRFunction> newlyAddedFunctions, int newBBNum, List<BIRNode.BIRBasicBlock> newBBList, int startInsNum, BIRNode.BIRBasicBlock currentBB, boolean fromAttachedFunction) {
        List<BIRNonTerminator> instructionList = function.basicBlocks.get((int)bbNum).instructions;
        for (Split possibleSplit : possibleSplits) {
            ++this.splitFuncNum;
            String newFunctionName = SPLIT_METHOD + this.splitFuncNum;
            Name newFuncName = new Name(newFunctionName);
            BIROperand currentBBTerminatorLhsOp = new BIROperand(instructionList.get((int)possibleSplit.lastIns).lhsOp.variableDcl);
            BIRNode.BIRFunction newBIRFunc = this.createNewBIRFuncForSplitInBB(newFuncName, instructionList.get(possibleSplit.lastIns), instructionList.subList(possibleSplit.firstIns, possibleSplit.lastIns), possibleSplit.lhsVars, possibleSplit.funcArgs, fromAttachedFunction);
            newlyAddedFunctions.add(newBIRFunc);
            if (possibleSplit.splitFurther) {
                newlyAddedFunctions.addAll(this.splitBIRFunction(newBIRFunc, fromAttachedFunction, true, possibleSplit.splitTypeArray));
            }
            currentBB.instructions.addAll(instructionList.subList(startInsNum, possibleSplit.firstIns));
            startInsNum = possibleSplit.lastIns + 1;
            BIRNode.BIRBasicBlock newBB = new BIRNode.BIRBasicBlock(++newBBNum);
            ArrayList<BIROperand> args = new ArrayList<BIROperand>();
            for (BIRNode.BIRVariableDcl funcArg : possibleSplit.funcArgs) {
                args.add(new BIROperand(funcArg));
            }
            currentBB.terminator = new BIRTerminator.Call(instructionList.get((int)possibleSplit.lastIns).pos, InstructionKind.CALL, false, this.currentPackageId, newFuncName, args, currentBBTerminatorLhsOp, newBB, Collections.emptyList(), Collections.emptySet(), instructionList.get((int)possibleSplit.lastIns).scope);
            newBBList.add(currentBB);
            currentBB = newBB;
        }
        return currentBB;
    }

    private BIROperand generateTempLocalVariable(BType variableType, List<BIRNode.BIRVariableDcl> funcLocalVarList) {
        BIRNode.BIRVariableDcl variableDcl = this.getSplitTempVariableDcl(variableType);
        funcLocalVarList.add(variableDcl);
        return new BIROperand(variableDcl);
    }

    private BIRNode.BIRVariableDcl getSplitTempVariableDcl(BType variableType) {
        Name variableName = new Name("$split$tempVar$_" + this.splitTempVarNum++);
        return new BIRNode.BIRVariableDcl(variableType, variableName, VarScope.FUNCTION, VarKind.TEMP);
    }

    private BIROperand generateTempLocalVariable(BType variableType, Set<BIRNode.BIRVariableDcl> funcLocalVarList) {
        BIRNode.BIRVariableDcl variableDcl = this.getSplitTempVariableDcl(variableType);
        funcLocalVarList.add(variableDcl);
        return new BIROperand(variableDcl);
    }

    private BIRNode.BIRFunction createNewBIRFuncForSplitInBB(Name funcName, BIRNonTerminator currentIns, List<BIRNonTerminator> collectedIns, Set<BIRNode.BIRVariableDcl> lhsOperandList, List<BIRNode.BIRVariableDcl> funcArgs, boolean fromAttachedFunction) {
        BType retType = currentIns.lhsOp.variableDcl.type;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        for (BIRNode.BIRVariableDcl funcArg : funcArgs) {
            paramTypes.add(funcArg.type);
        }
        BInvokableType type = new BInvokableType(this.symbolTable.typeEnv(), paramTypes, retType, null);
        BIRNode.BIRFunction birFunc = new BIRNode.BIRFunction(null, funcName, funcName, 0L, type, DEFAULT_WORKER_NAME, 0, SymbolOrigin.VIRTUAL);
        ArrayList<BIRNode.BIRFunctionParameter> functionParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        BIRNode.BIRVariableDcl selfVarDcl = null;
        for (BIRNode.BIRVariableDcl funcArg : funcArgs) {
            Name argName = funcArg.name;
            birFunc.requiredParams.add(new BIRNode.BIRParameter(currentIns.pos, argName, 0L));
            BIRNode.BIRFunctionParameter funcParameter = new BIRNode.BIRFunctionParameter(currentIns.pos, funcArg.type, argName, VarScope.FUNCTION, VarKind.ARG, argName.getValue(), false, false);
            functionParams.add(funcParameter);
            birFunc.parameters.add(funcParameter);
            if (funcArg.kind != VarKind.SELF) continue;
            selfVarDcl = new BIRNode.BIRVariableDcl(funcArg.pos, funcArg.type, funcArg.name, funcArg.originalName, VarScope.FUNCTION, VarKind.ARG, funcArg.metaVarName);
        }
        birFunc.argsCount = funcArgs.size();
        birFunc.returnVariable = fromAttachedFunction ? new BIRNode.BIRVariableDcl(currentIns.pos, retType, new Name("%1"), VarScope.FUNCTION, VarKind.RETURN, null) : new BIRNode.BIRVariableDcl(currentIns.pos, retType, new Name("%0"), VarScope.FUNCTION, VarKind.RETURN, null);
        birFunc.localVars.add(0, birFunc.returnVariable);
        birFunc.localVars.addAll(functionParams);
        birFunc.localVars.addAll(lhsOperandList);
        BIRNode.BIRBasicBlock entryBB = new BIRNode.BIRBasicBlock(0);
        entryBB.instructions.addAll(collectedIns);
        currentIns.lhsOp = new BIROperand(birFunc.returnVariable);
        entryBB.instructions.add(currentIns);
        BIRNode.BIRBasicBlock exitBB = new BIRNode.BIRBasicBlock(1);
        exitBB.terminator = new BIRTerminator.Return(null);
        entryBB.terminator = new BIRTerminator.GOTO(null, exitBB, currentIns.scope);
        birFunc.basicBlocks.add(entryBB);
        birFunc.basicBlocks.add(exitBB);
        this.rectifyVarKindsAndTerminators(birFunc, selfVarDcl, exitBB);
        return birFunc;
    }

    private void rectifyVarKindsAndTerminators(BIRNode.BIRFunction birFunction, BIRNode.BIRVariableDcl selfVarDcl, BIRNode.BIRBasicBlock returnBB) {
        HashMap<Name, BIRNode.BIRVariableDcl> funcArgsWithName = new HashMap<Name, BIRNode.BIRVariableDcl>();
        for (BIRNode.BIRFunctionParameter parameter : birFunction.parameters) {
            funcArgsWithName.put(parameter.name, parameter);
        }
        HashMap<BIRNode.BIRVariableDcl, BIROperand> newRhsOperands = new HashMap<BIRNode.BIRVariableDcl, BIROperand>();
        for (BIRNode.BIRBasicBlock basicBlock : birFunction.basicBlocks) {
            for (BIRNonTerminator instruction : basicBlock.instructions) {
                if (instruction.lhsOp.variableDcl.kind == VarKind.SELF) {
                    instruction.lhsOp.variableDcl = selfVarDcl;
                } else if (instruction.lhsOp.variableDcl.kind == VarKind.RETURN) {
                    instruction.lhsOp.variableDcl = birFunction.returnVariable;
                    basicBlock.terminator = new BIRTerminator.GOTO(null, returnBB, basicBlock.terminator.scope);
                }
                this.setInsRhsOperands(selfVarDcl, funcArgsWithName, instruction, newRhsOperands);
            }
            if (basicBlock.terminator.lhsOp != null && basicBlock.terminator.lhsOp.variableDcl.kind == VarKind.SELF) {
                basicBlock.terminator.lhsOp.variableDcl = selfVarDcl;
            }
            this.setInsRhsOperands(selfVarDcl, funcArgsWithName, basicBlock.terminator, newRhsOperands);
        }
    }

    private void setInsRhsOperands(BIRNode.BIRVariableDcl selfVarDcl, Map<Name, BIRNode.BIRVariableDcl> funcArgsWithName, BIRAbstractInstruction instruction, Map<BIRNode.BIRVariableDcl, BIROperand> newRhsOperands) {
        BIROperand[] rhsOperands;
        if (selfVarDcl == null && funcArgsWithName.isEmpty()) {
            return;
        }
        ArrayList<BIROperand> operandList = new ArrayList<BIROperand>();
        boolean foundArgs = false;
        for (BIROperand rhsOperand : rhsOperands = instruction.getRhsOperands()) {
            if (rhsOperand.variableDcl.kind == VarKind.SELF) {
                foundArgs = true;
                LargeMethodOptimizer.populateNewRHSOperands(selfVarDcl, operandList, newRhsOperands, rhsOperand);
                continue;
            }
            if (funcArgsWithName.containsKey(rhsOperand.variableDcl.name)) {
                foundArgs = true;
                LargeMethodOptimizer.populateNewRHSOperands(funcArgsWithName.get(rhsOperand.variableDcl.name), operandList, newRhsOperands, rhsOperand);
                continue;
            }
            operandList.add(rhsOperand);
        }
        if (foundArgs) {
            instruction.setRhsOperands(operandList.toArray(new BIROperand[0]));
        }
    }

    private static void populateNewRHSOperands(BIRNode.BIRVariableDcl variableDcl, List<BIROperand> operandList, Map<BIRNode.BIRVariableDcl, BIROperand> newRhsOperands, BIROperand rhsOperand) {
        if (!newRhsOperands.containsKey(rhsOperand.variableDcl)) {
            BIROperand newOperand = new BIROperand(variableDcl);
            operandList.add(newOperand);
            newRhsOperands.put(rhsOperand.variableDcl, newOperand);
        } else {
            operandList.add(newRhsOperands.get(rhsOperand.variableDcl));
        }
    }

    static class TempVarsForArraySplit {
        BIRNode.BIRVariableDcl arrayIndexVarDcl;
        BIRNode.BIRVariableDcl typeCastVarDcl;
        BIROperand arrayIndexOperand;
        BIROperand typeCastOperand;
        boolean tempVarsUsed = false;

        private TempVarsForArraySplit(BIRNode.BIRVariableDcl arrayIndexVarDcl, BIRNode.BIRVariableDcl typeCastVarDcl) {
            this.arrayIndexVarDcl = arrayIndexVarDcl;
            this.typeCastVarDcl = typeCastVarDcl;
            this.arrayIndexOperand = new BIROperand(arrayIndexVarDcl);
            this.typeCastOperand = new BIROperand(typeCastVarDcl);
        }
    }

    static class ParentFuncEnv {
        List<BIRNode.BIRBasicBlock> parentFuncNewBBList = new ArrayList<BIRNode.BIRBasicBlock>();
        List<BIRNonTerminator> parentFuncNewInsList = new ArrayList<BIRNonTerminator>();
        Set<BIRNode.BIRVariableDcl> parentFuncLocalVarList = new HashSet<BIRNode.BIRVariableDcl>();
        int errorTableIndex = 0;
        int parentFuncBBId = 0;
        BIRNode.BIRBasicBlock parentFuncNewBB = new BIRNode.BIRBasicBlock(this.parentFuncBBId++);
        BIRNode.BIRBasicBlock returnBB;
        BIROperand returnOperand;

        private ParentFuncEnv(BIRNode.BIRBasicBlock returnBB) {
            this.returnBB = returnBB;
        }
    }

    static class SplitFuncEnv {
        List<BIRNode.BIRBasicBlock> splitFuncNewBBList = new ArrayList<BIRNode.BIRBasicBlock>();
        List<BIRNonTerminator> splitFuncNewInsList = new ArrayList<BIRNonTerminator>();
        Set<BIRNode.BIRVariableDcl> splitFuncLocalVarList = new HashSet<BIRNode.BIRVariableDcl>();
        Set<BIROperand> splitAvailableOperands = new HashSet<BIROperand>();
        Set<BIRNode.BIRVariableDcl> splitFuncArgs = new LinkedHashSet<BIRNode.BIRVariableDcl>();
        List<BIRNode.BIRErrorEntry> splitFuncErrorTable = new ArrayList<BIRNode.BIRErrorEntry>();
        Map<Integer, BIRNode.BIRBasicBlock> splitFuncChangedBBs = new HashMap<Integer, BIRNode.BIRBasicBlock>();
        Set<BIRNode.BIRBasicBlock> splitFuncCorrectTerminatorBBs = new HashSet<BIRNode.BIRBasicBlock>();
        int periodicSplitInsCount = 0;
        boolean splitOkay = true;
        int doNotSplitTillThisBBNum = 0;
        boolean returnValAssigned = false;
        int splitFuncBBId = 0;
        BIRNode.BIRBasicBlock splitFuncBB = new BIRNode.BIRBasicBlock(this.splitFuncBBId++);
        TempVarsForArraySplit splitFuncTempVars;
        BIRNode.BIRBasicBlock returnBB = new BIRNode.BIRBasicBlock(-1);
        BIRNode.BIRVariableDcl returnVarDcl;
        BIROperand returnOperand;
        boolean splitHere = false;

        private SplitFuncEnv(TempVarsForArraySplit splitFuncTempVars, boolean fromAttachedFunction) {
            this.splitFuncTempVars = splitFuncTempVars;
            this.returnVarDcl = fromAttachedFunction ? new BIRNode.BIRVariableDcl(null, null, new Name("%1"), VarScope.FUNCTION, VarKind.RETURN, null) : new BIRNode.BIRVariableDcl(null, null, new Name("%0"), VarScope.FUNCTION, VarKind.RETURN, null);
            this.returnOperand = new BIROperand(this.returnVarDcl);
        }

        void reset(TempVarsForArraySplit tempVars, boolean fromAttachedFunc) {
            this.splitFuncNewBBList = new ArrayList<BIRNode.BIRBasicBlock>();
            this.splitFuncNewInsList = new ArrayList<BIRNonTerminator>();
            this.splitFuncLocalVarList = new HashSet<BIRNode.BIRVariableDcl>();
            this.splitAvailableOperands = new HashSet<BIROperand>();
            this.splitFuncArgs = new LinkedHashSet<BIRNode.BIRVariableDcl>();
            this.splitFuncErrorTable = new ArrayList<BIRNode.BIRErrorEntry>();
            this.splitFuncChangedBBs = new HashMap<Integer, BIRNode.BIRBasicBlock>();
            this.splitFuncCorrectTerminatorBBs = new HashSet<BIRNode.BIRBasicBlock>();
            this.splitFuncTempVars = tempVars;
            this.splitFuncBBId = 0;
            this.splitFuncBB = new BIRNode.BIRBasicBlock(this.splitFuncBBId++);
            this.splitOkay = true;
            this.returnValAssigned = false;
            this.returnVarDcl = fromAttachedFunc ? new BIRNode.BIRVariableDcl(null, null, new Name("%1"), VarScope.FUNCTION, VarKind.RETURN, null) : new BIRNode.BIRVariableDcl(null, null, new Name("%0"), VarScope.FUNCTION, VarKind.RETURN, null);
            this.returnOperand = new BIROperand(this.returnVarDcl);
            this.returnBB = new BIRNode.BIRBasicBlock(-1);
        }
    }

    static class BIRMappingConstructorEntryWithIndex {
        BIRNode.BIRMappingConstructorEntry mappingConstructorEntry;
        int index;

        private BIRMappingConstructorEntryWithIndex(BIRNode.BIRMappingConstructorEntry mappingConstructorEntry, int index) {
            this.mappingConstructorEntry = mappingConstructorEntry;
            this.index = index;
        }
    }

    static class BIRListConstructorEntryWithIndex {
        BIRNode.BIRListConstructorEntry listConstructorEntry;
        int index;

        private BIRListConstructorEntryWithIndex(BIRNode.BIRListConstructorEntry listConstructorEntry, int index) {
            this.listConstructorEntry = listConstructorEntry;
            this.index = index;
        }
    }

    static class NonTerminatorLocation {
        int bbNum;
        int insNum;

        private NonTerminatorLocation(int bbNum, int insNum) {
            this.bbNum = bbNum;
            this.insNum = insNum;
        }
    }

    static class SplitPointDetails {
        List<BIROperand> arrayElementsBIROperands;
        boolean splitHere;

        private SplitPointDetails(List<BIROperand> arrayElementsBIROperands, boolean splitHere) {
            this.arrayElementsBIROperands = arrayElementsBIROperands;
            this.splitHere = splitHere;
        }
    }

    static class Split {
        int firstIns;
        int lastIns;
        int startBBNum;
        int endBBNum;
        boolean splitFurther;
        boolean splitTypeArray;
        boolean returnValAssigned;
        Set<BIRNode.BIRVariableDcl> lhsVars;
        List<BIRNode.BIRVariableDcl> funcArgs;
        List<BIRNode.BIRErrorEntry> errorTableEntries;

        private Split(int firstIns, int lastIns, int startBBNum, int endBBNum, Set<BIRNode.BIRVariableDcl> lhsVars, List<BIRNode.BIRVariableDcl> funcArgs, List<BIRNode.BIRErrorEntry> errorTableEntries, boolean splitFurther, boolean splitTypeArray, boolean returnValAssigned) {
            this.firstIns = firstIns;
            this.lastIns = lastIns;
            this.startBBNum = startBBNum;
            this.endBBNum = endBBNum;
            this.splitFurther = splitFurther;
            this.splitTypeArray = splitTypeArray;
            this.returnValAssigned = returnValAssigned;
            this.lhsVars = lhsVars;
            this.funcArgs = funcArgs;
            this.errorTableEntries = errorTableEntries;
        }
    }
}

