/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmArrayTypeGen;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.TypeTags;

public class JvmArrayTypeConstantsGen {
    private final String arrayConstantsClass;
    private final ClassWriter cw;
    private MethodVisitor mv;
    private final Map<BArrayType, String> arrayTypeVarMap;
    private JvmArrayTypeGen jvmArrayTypeGen;
    private final Types types;
    private final List<String> funcNames = new ArrayList<String>();
    private int arrayTypeVarCount = 0;
    private int methodCount = 1;
    private int constantIndex = 0;

    public JvmArrayTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator, Types types) {
        this.arrayConstantsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "constants/$_array_type_constants");
        this.cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(this.cw, this.arrayConstantsClass);
        this.mv = this.cw.visitMethod(9, "$array_type_init", "()V", null, null);
        this.arrayTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
        this.types = types;
    }

    public void setJvmArrayTypeGen(JvmArrayTypeGen jvmArrayTypeGen) {
        this.jvmArrayTypeGen = jvmArrayTypeGen;
    }

    public String add(BArrayType arrayType) {
        String varName = this.arrayTypeVarMap.get(arrayType);
        if (varName == null) {
            varName = this.generateBArrayInits(arrayType);
            this.arrayTypeVarMap.put(arrayType, varName);
        }
        return varName;
    }

    private String generateBArrayInits(BArrayType arrayType) {
        String varName = "$arrayType" + this.constantIndex++;
        if (this.arrayTypeVarCount % 100 == 0 && this.arrayTypeVarCount != 0) {
            this.mv.visitMethodInsn(184, this.arrayConstantsClass, "$array_type_init" + this.methodCount, "()V", false);
            JvmConstantGenCommons.genMethodReturn(this.mv);
            this.mv = this.cw.visitMethod(8, "$array_type_init" + this.methodCount++, "()V", null, null);
        }
        this.createBArrayType(this.mv, arrayType, varName);
        if (!TypeTags.isSimpleBasicType(arrayType.eType.tag)) {
            this.genPopulateMethod(arrayType, varName);
        }
        ++this.arrayTypeVarCount;
        return varName;
    }

    private void genPopulateMethod(BArrayType arrayType, String varName) {
        String methodName = "$populate" + varName;
        this.funcNames.add(methodName);
        MethodVisitor methodVisitor = this.cw.visitMethod(8, methodName, "()V", null, null);
        methodVisitor.visitCode();
        this.generateGetBArrayType(methodVisitor, varName);
        this.jvmArrayTypeGen.populateArray(methodVisitor, arrayType);
        JvmConstantGenCommons.genMethodReturn(methodVisitor);
    }

    private void visitArrayTypeConstPopulateInitMethods() {
        int populateFuncCount = 0;
        int populateInitMethodCount = 1;
        MethodVisitor mv = this.cw.visitMethod(9, "$populate_array_types", "()V", null, null);
        for (String funcName : this.funcNames) {
            if (populateFuncCount % 100 == 0 && populateFuncCount != 0) {
                mv.visitMethodInsn(184, this.arrayConstantsClass, "$populate_array_types" + populateInitMethodCount, "()V", false);
                JvmConstantGenCommons.genMethodReturn(mv);
                mv = this.cw.visitMethod(8, "$populate_array_types" + populateInitMethodCount++, "()V", null, null);
            }
            mv.visitMethodInsn(184, this.arrayConstantsClass, funcName, "()V", false);
            ++populateFuncCount;
        }
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private void createBArrayType(MethodVisitor mv, BArrayType arrayType, String varName) {
        FieldVisitor fv = this.cw.visitField(9, varName, "Lio/ballerina/runtime/internal/types/BArrayType;", null, null);
        fv.visitEnd();
        this.jvmArrayTypeGen.createArrayType(mv, arrayType, this.types);
        mv.visitFieldInsn(179, this.arrayConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BArrayType;");
    }

    public void generateGetBArrayType(MethodVisitor mv, String varName) {
        mv.visitFieldInsn(178, this.arrayConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BArrayType;");
    }

    public void generateClass(JarEntries jarEntries) {
        JvmConstantGenCommons.genMethodReturn(this.mv);
        this.visitArrayTypeConstPopulateInitMethods();
        this.cw.visitEnd();
        jarEntries.put(this.arrayConstantsClass + ".class", this.cw.toByteArray());
    }

    public String getArrayTypeConstantClass() {
        return this.arrayConstantsClass;
    }
}

