/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;

public class JvmBallerinaConstantsGen {
    private final String constantClass;
    private final String moduleInitClass;
    private final JvmConstantsGen jvmConstantsGen;
    private final BIRNode.BIRPackage module;

    public JvmBallerinaConstantsGen(BIRNode.BIRPackage module, String moduleInitClass, JvmConstantsGen jvmConstantsGen) {
        this.moduleInitClass = moduleInitClass;
        this.constantClass = JvmCodeGenUtil.getModuleLevelClassName(module.packageID, "constants/$_constants");
        this.jvmConstantsGen = jvmConstantsGen;
        this.module = module;
    }

    public void generateConstantInit(JarEntries jarEntries) {
        if (this.module.constants.isEmpty()) {
            return;
        }
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(cw, this.constantClass);
        this.generateConstantsInits(cw);
        this.generateConstantInitPublicMethod(cw);
        cw.visitEnd();
        jarEntries.put(this.constantClass + ".class", cw.toByteArray());
    }

    private void generateConstantsInits(ClassWriter cw) {
        MethodVisitor mv = null;
        int moduleCount = 0;
        int methodCount = 0;
        for (BIRNode.BIRConstant constant : this.module.constants) {
            if (moduleCount % 100 == 0) {
                mv = cw.visitMethod(8, "$constant_init" + methodCount++, "()V", null, null);
            }
            JvmBallerinaConstantsGen.setConstantField(mv, constant, this.moduleInitClass, this.jvmConstantsGen);
            if (++moduleCount % 100 != 0) continue;
            if (moduleCount != this.module.constants.size()) {
                mv.visitMethodInsn(184, this.constantClass, "$constant_init" + methodCount, "()V", false);
            }
            JvmConstantGenCommons.genMethodReturn(mv);
        }
        if (moduleCount % 100 != 0) {
            JvmConstantGenCommons.genMethodReturn(mv);
        }
    }

    private void generateConstantInitPublicMethod(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(9, "$constant_init", "()V", null, null);
        mv.visitMethodInsn(184, this.constantClass, "$constant_init0", "()V", false);
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private static void setConstantField(MethodVisitor mv, BIRNode.BIRConstant constant, String className, JvmConstantsGen jvmConstantsGen) {
        BIRNode.ConstValue constValue = constant.constValue;
        if (JvmCodeGenUtil.isSimpleBasicType(constValue.type)) {
            String descriptor = JvmCodeGenUtil.getFieldTypeSignature(constValue.type);
            JvmCodeGenUtil.loadConstantValue(constValue.type, constValue.value, mv, jvmConstantsGen);
            mv.visitFieldInsn(179, className, constant.name.value, descriptor);
        }
    }

    public String getConstantClass() {
        return this.constantClass;
    }
}

