/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.BTypeHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.codegen.split.types.JvmErrorTypeGen;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmErrorTypeConstantsGen {
    private final String errorVarConstantsClass;
    private JvmErrorTypeGen jvmErrorTypeGen;
    private final ClassWriter cw;
    private MethodVisitor mv;
    private final Map<BErrorType, String> errorTypeVarMap;
    private final List<String> funcNames = new ArrayList<String>();
    private int errorTypeCount = 0;
    private int methodCount = 1;
    private int constantIndex = 0;

    public JvmErrorTypeConstantsGen(PackageID packageID, BTypeHashComparator bTypeHashComparator) {
        this.errorVarConstantsClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "constants/$_error_type_constants");
        this.cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(this.cw, this.errorVarConstantsClass);
        this.mv = this.cw.visitMethod(9, "$error_type_init", "()V", null, null);
        this.errorTypeVarMap = new TreeMap<BType, String>(bTypeHashComparator);
    }

    public void setJvmErrorTypeGen(JvmErrorTypeGen jvmErrorTypeGen) {
        this.jvmErrorTypeGen = jvmErrorTypeGen;
    }

    public String add(BErrorType type) {
        String varName = this.errorTypeVarMap.get(type);
        if (varName == null) {
            varName = this.generateBErrorInits(type);
            this.errorTypeVarMap.put(type, varName);
        }
        return varName;
    }

    private String generateBErrorInits(BErrorType type) {
        String varName = "$errorType" + this.constantIndex++;
        if (this.errorTypeCount % 100 == 0 && this.errorTypeCount != 0) {
            this.mv.visitMethodInsn(184, this.errorVarConstantsClass, "$error_type_init" + this.methodCount, "()V", false);
            JvmConstantGenCommons.genMethodReturn(this.mv);
            this.mv = this.cw.visitMethod(8, "$error_type_init" + this.methodCount++, "()V", null, null);
        }
        this.visitBErrorField(varName);
        this.createBErrorType(type, varName);
        this.genPopulateMethod(type, varName);
        ++this.errorTypeCount;
        return varName;
    }

    private void visitErrorTypePopulateInitMethod() {
        int populateFuncCount = 0;
        int populateInitMethodCount = 1;
        MethodVisitor mv = this.cw.visitMethod(9, "$populate_error_typeS", "()V", null, null);
        for (String funcName : this.funcNames) {
            if (populateFuncCount % 100 == 0 && populateFuncCount != 0) {
                mv.visitMethodInsn(184, this.errorVarConstantsClass, "$populate_error_typeS" + populateInitMethodCount, "()V", false);
                JvmConstantGenCommons.genMethodReturn(mv);
                mv = this.cw.visitMethod(8, "$populate_error_typeS" + populateInitMethodCount++, "()V", null, null);
            }
            mv.visitMethodInsn(184, this.errorVarConstantsClass, funcName, "()V", false);
            ++populateFuncCount;
        }
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    private void genPopulateMethod(BErrorType type, String varName) {
        String methodName = "$populate" + varName;
        this.funcNames.add(methodName);
        MethodVisitor methodVisitor = this.cw.visitMethod(8, methodName, "()V", null, null);
        methodVisitor.visitCode();
        this.generateGetBErrorType(methodVisitor, varName);
        this.jvmErrorTypeGen.populateError(methodVisitor, type);
        JvmConstantGenCommons.genMethodReturn(methodVisitor);
    }

    private void createBErrorType(BErrorType errorType, String varName) {
        this.jvmErrorTypeGen.createErrorType(this.mv, errorType, errorType.tsymbol.name.value);
        this.mv.visitFieldInsn(179, this.errorVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BErrorType;");
    }

    private void visitBErrorField(String varName) {
        FieldVisitor fv = this.cw.visitField(9, varName, "Lio/ballerina/runtime/internal/types/BErrorType;", null, null);
        fv.visitEnd();
    }

    public void generateGetBErrorType(MethodVisitor mv, String varName) {
        mv.visitFieldInsn(178, this.errorVarConstantsClass, varName, "Lio/ballerina/runtime/internal/types/BErrorType;");
    }

    public void generateClass(JarEntries jarEntries) {
        JvmConstantGenCommons.genMethodReturn(this.mv);
        this.visitErrorTypePopulateInitMethod();
        this.cw.visitEnd();
        jarEntries.put(this.errorVarConstantsClass + ".class", this.cw.toByteArray());
    }

    public String getErrorTypeConstantClass() {
        return this.errorVarConstantsClass;
    }
}

