/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.constants;

import io.ballerina.identifier.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.split.constants.JvmConstantGenCommons;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;

public class JvmModuleConstantsGen {
    private final HashMap<PackageID, String> moduleVarMap;
    private final String moduleConstantClass;
    private final AtomicInteger constantIndex = new AtomicInteger();

    public JvmModuleConstantsGen(BIRNode.BIRPackage module) {
        this.moduleVarMap = new HashMap();
        this.moduleConstantClass = JvmCodeGenUtil.getModuleLevelClassName(module.packageID, "constants/$_module_constants");
    }

    public String addModule(PackageID packageID) {
        return this.moduleVarMap.computeIfAbsent(packageID, s -> "$module" + this.constantIndex.getAndIncrement());
    }

    public void generateConstantInit(JarEntries jarEntries) {
        if (this.moduleVarMap.isEmpty()) {
            return;
        }
        BallerinaClassWriter cw = new BallerinaClassWriter(2);
        JvmConstantGenCommons.generateConstantsClassInit(cw, this.moduleConstantClass);
        this.moduleVarMap.values().forEach(moduleVar -> this.visitModuleField(cw, (String)moduleVar));
        this.generateModuleInits(cw);
        this.generateStaticInitializer(cw);
        cw.visitEnd();
        jarEntries.put(this.moduleConstantClass + ".class", cw.toByteArray());
    }

    private void visitModuleField(ClassWriter cw, String varName) {
        FieldVisitor fv = cw.visitField(9, varName, "Lio/ballerina/runtime/api/Module;", null, null);
        fv.visitEnd();
    }

    private void generateModuleInits(ClassWriter cw) {
        MethodVisitor mv = null;
        int moduleCount = 0;
        int methodCount = 0;
        for (Map.Entry<PackageID, String> entry : this.moduleVarMap.entrySet()) {
            if (moduleCount % 100 == 0) {
                mv = cw.visitMethod(8, "$module_init" + methodCount++, "()V", null, null);
            }
            PackageID packageID = entry.getKey();
            String varName = entry.getValue();
            mv.visitTypeInsn(187, "io/ballerina/runtime/api/Module");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)packageID.orgName.value));
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)packageID.name.value));
            mv.visitLdcInsn((Object)CompilerUtils.getMajorVersion(packageID.version.value));
            if (packageID.isTestPkg) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
            mv.visitMethodInsn(183, "io/ballerina/runtime/api/Module", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            mv.visitFieldInsn(179, this.moduleConstantClass, varName, "Lio/ballerina/runtime/api/Module;");
            if (++moduleCount % 100 != 0) continue;
            if (moduleCount != this.moduleVarMap.size()) {
                mv.visitMethodInsn(184, this.moduleConstantClass, "$module_init" + methodCount, "()V", false);
                mv.visitInsn(177);
            }
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "$module_init", this.moduleConstantClass);
            mv.visitEnd();
        }
        if (moduleCount % 100 != 0) {
            JvmConstantGenCommons.genMethodReturn(mv);
        }
    }

    private void generateStaticInitializer(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitMethodInsn(184, this.moduleConstantClass, "$module_init0", "()V", false);
        JvmConstantGenCommons.genMethodReturn(mv);
    }

    public String getModuleConstantClass() {
        return this.moduleConstantClass;
    }
}

