/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.types;

import io.ballerina.identifier.Utils;
import java.util.Map;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.BallerinaClassWriter;
import org.wso2.ballerinalang.compiler.bir.codegen.JarEntries;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmConstantsGen;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class JvmRecordTypeGen {
    public final String recordTypesClass;
    public final ClassWriter recordTypesCw;
    private final JvmCreateTypeGen jvmCreateTypeGen;
    private final JvmTypeGen jvmTypeGen;
    private final JvmConstantsGen jvmConstantsGen;

    public JvmRecordTypeGen(JvmCreateTypeGen jvmCreateTypeGen, JvmTypeGen jvmTypeGen, JvmConstantsGen jvmConstantsGen, PackageID packageID) {
        this.recordTypesClass = JvmCodeGenUtil.getModuleLevelClassName(packageID, "types/$_record_types");
        this.jvmCreateTypeGen = jvmCreateTypeGen;
        this.jvmTypeGen = jvmTypeGen;
        this.jvmConstantsGen = jvmConstantsGen;
        this.recordTypesCw = new BallerinaClassWriter(2);
        this.recordTypesCw.visit(65, 33, this.recordTypesClass, null, "java/lang/Object", null);
    }

    public void visitEnd(JvmPackageGen jvmPackageGen, BIRNode.BIRPackage module, JarEntries jarEntries) {
        this.recordTypesCw.visitEnd();
        jarEntries.put(this.recordTypesClass + ".class", jvmPackageGen.getBytes(this.recordTypesCw, module));
    }

    public void populateRecord(MethodVisitor mv, String methodName, BRecordType bType, SymbolTable symbolTable) {
        mv.visitTypeInsn(192, "io/ballerina/runtime/internal/types/BRecordType");
        mv.visitInsn(89);
        mv.visitInsn(89);
        this.addRecordFields(mv, methodName, bType.fields);
        this.addRecordRestField(mv, bType.restFieldType);
        this.jvmCreateTypeGen.addImmutableType(mv, bType, symbolTable);
    }

    private void addRecordFields(MethodVisitor mv, String methodName, Map<String, BField> fields) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        if (!fields.isEmpty()) {
            mv.visitInsn(89);
            mv.visitMethodInsn(184, this.recordTypesClass, methodName + "$addField$", "(Ljava/util/LinkedHashMap;)V", false);
            this.jvmCreateTypeGen.splitAddFields(this.recordTypesCw, this.recordTypesClass, methodName, fields);
        }
        mv.visitMethodInsn(182, "io/ballerina/runtime/internal/types/BRecordType", "setFields", "(Ljava/util/Map;)V", false);
    }

    private void addRecordRestField(MethodVisitor mv, BType restFieldType) {
        this.jvmTypeGen.loadType(mv, restFieldType);
        mv.visitFieldInsn(181, "io/ballerina/runtime/internal/types/BRecordType", "restFieldType", "Lio/ballerina/runtime/api/types/Type;");
    }

    public void createRecordType(MethodVisitor mv, BRecordType recordType, String typeOwnerClass, String internalName) {
        mv.visitTypeInsn(187, "io/ballerina/runtime/internal/types/BRecordType");
        mv.visitInsn(89);
        String name = this.getFullName(recordType);
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)name));
        mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)internalName));
        String varName = this.jvmConstantsGen.getModuleConstantVar(recordType.tsymbol.pkgID);
        mv.visitFieldInsn(178, this.jvmConstantsGen.getModuleConstantClass(), varName, "Lio/ballerina/runtime/api/Module;");
        mv.visitLdcInsn((Object)recordType.tsymbol.flags);
        mv.visitLdcInsn((Object)recordType.sealed);
        mv.visitLdcInsn((Object)this.jvmTypeGen.typeFlag(recordType));
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/types/BRecordType", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lio/ballerina/runtime/api/Module;JZI)V", false);
        mv.visitInsn(89);
        String packageName = JvmCodeGenUtil.getPackageName(recordType.tsymbol.pkgID);
        String className = JvmValueGen.getTypeDescClassName(packageName, JvmCodeGenUtil.toNameString(recordType));
        mv.visitTypeInsn(187, className);
        mv.visitInsn(90);
        mv.visitInsn(95);
        mv.visitInsn(1);
        mv.visitMethodInsn(183, className, "<init>", "(Lio/ballerina/runtime/api/types/Type;[Lio/ballerina/runtime/internal/values/MapValue;)V", false);
        mv.visitFieldInsn(179, typeOwnerClass, this.jvmTypeGen.getTypedescFieldName(internalName), "Lio/ballerina/runtime/internal/values/TypedescValue;");
    }

    private String getFullName(BRecordType recordType) {
        String fullName = recordType.shouldPrintShape() ? recordType.toString() : recordType.tsymbol.name.value;
        return fullName;
    }
}

