/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.split.values;

import io.ballerina.identifier.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.types.TypeKind;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCastGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmCodeGenUtil;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTypeGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.internal.FieldNameHashComparator;
import org.wso2.ballerinalang.compiler.bir.codegen.split.JvmCreateTypeGen;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;

public class JvmRecordGen {
    static final FieldNameHashComparator FIELD_NAME_HASH_COMPARATOR = new FieldNameHashComparator();
    private final BType booleanType;
    private final BType intType;
    private final BType floatType;

    public JvmRecordGen(SymbolTable symbolTable) {
        this.booleanType = symbolTable.booleanType;
        this.intType = symbolTable.intType;
        this.floatType = symbolTable.floatType;
    }

    public void createAndSplitGetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        MethodVisitor mv = cw.visitMethod(1, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Object;)TV;", null);
        mv.visitCode();
        int selfIndex = 0;
        int fieldNameRegIndex = 1;
        int strKeyVarIndex = 2;
        JvmCodeGenUtil.castToJavaString(mv, fieldNameRegIndex, strKeyVarIndex);
        if (fields.isEmpty()) {
            Label defaultCaseLabel = new Label();
            this.createGetDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "get", className);
            mv.visitEnd();
            return;
        }
        mv.visitVarInsn(25, selfIndex);
        mv.visitVarInsn(25, strKeyVarIndex);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(182, className, "get", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "get", className);
        mv.visitEnd();
        this.splitGetMethod(cw, fields, className, jvmCastGen);
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.BOOLEAN, "getBooleanValue", "(Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Boolean;", true, "java/lang/Boolean");
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.FLOAT, "getFloatValue", "(Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Double;", true, "java/lang/Double");
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.INT, "getIntValue", "(Lio/ballerina/runtime/api/values/BString;)Ljava/lang/Long;", true, "java/lang/Long");
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.STRING, "getStringValue", "(Lio/ballerina/runtime/api/values/BString;)Lio/ballerina/runtime/api/values/BString;", true, "io/ballerina/runtime/api/values/BString");
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.BOOLEAN, "getUnboxedBooleanValue", "(Lio/ballerina/runtime/api/values/BString;)Z", false, null);
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.FLOAT, "getUnboxedFloatValue", "(Lio/ballerina/runtime/api/values/BString;)D", false, null);
        this.createBasicTypeGetMethod(cw, fields, className, jvmCastGen, TypeKind.INT, "getUnboxedIntValue", "(Lio/ballerina/runtime/api/values/BString;)J", false, null);
    }

    private void splitGetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int selfRegIndex = 0;
        int strKeyVarIndex = 1;
        int fieldNameRegIndex = 2;
        Label defaultCaseLabel = new Label();
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Object> targetLabels = new ArrayList();
        int i = 0;
        Object getMethod = "get";
        for (BField optionalField : sortedFields) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(1, (String)getMethod, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = sortedFields.size() - bTypesCount;
                if (remainingCases > 500) {
                    remainingCases = 500;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
                getMethod = "get" + ++methodCount;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            Label ifPresentLabel = new Label();
            String fieldName = optionalField.name.value;
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitFieldInsn(180, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(154, ifPresentLabel);
                mv.visitInsn(1);
                mv.visitInsn(176);
            }
            mv.visitLabel(ifPresentLabel);
            mv.visitVarInsn(25, selfRegIndex);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            jvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount == sortedFields.size()) {
                this.createGetDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, strKeyVarIndex);
                mv.visitVarInsn(25, fieldNameRegIndex);
                mv.visitMethodInsn(182, className, (String)getMethod, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv.visitInsn(176);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            this.createGetDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    private void createGetDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
    }

    public void createAndSplitSetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        MethodVisitor mv = cw.visitMethod(4, "putValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "(TK;TV;)TV;", null);
        mv.visitCode();
        int selfIndex = 0;
        int fieldNameRegIndex = 1;
        int valueRegIndex = 2;
        int strKeyVarIndex = 3;
        JvmCodeGenUtil.castToJavaString(mv, fieldNameRegIndex, strKeyVarIndex);
        if (fields.isEmpty()) {
            Label defaultCaseLabel = new Label();
            this.createPutDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex, valueRegIndex);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "putValue", className);
            mv.visitEnd();
            return;
        }
        mv.visitVarInsn(25, selfIndex);
        mv.visitVarInsn(25, strKeyVarIndex);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitVarInsn(25, valueRegIndex);
        mv.visitMethodInsn(182, className, "putValue", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "putValue", className);
        mv.visitEnd();
        this.splitSetMethod(cw, fields, className, jvmCastGen);
    }

    private void splitSetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int selfRegIndex = 0;
        int strKeyVarIndex = 1;
        int fieldNameRegIndex = 2;
        int valueRegIndex = 3;
        Label defaultCaseLabel = new Label();
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Object> targetLabels = new ArrayList();
        int i = 0;
        Object setMethod = "putValue";
        for (BField optionalField : sortedFields) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(4, (String)setMethod, "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = sortedFields.size() - bTypesCount;
                if (remainingCases > 500) {
                    remainingCases = 500;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
                setMethod = "putValue" + ++methodCount;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            String fieldName = optionalField.name.value;
            mv.visitVarInsn(25, selfRegIndex);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            jvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitVarInsn(25, selfRegIndex);
            mv.visitVarInsn(25, valueRegIndex);
            jvmCastGen.addUnboxInsn(mv, optionalField.type);
            mv.visitFieldInsn(181, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitInsn(4);
                mv.visitFieldInsn(181, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
            }
            mv.visitInsn(176);
            ++i;
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount == sortedFields.size()) {
                this.createPutDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex, valueRegIndex);
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, strKeyVarIndex);
                mv.visitVarInsn(25, fieldNameRegIndex);
                mv.visitVarInsn(25, valueRegIndex);
                mv.visitMethodInsn(182, className, (String)setMethod, "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv.visitInsn(176);
            }
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)setMethod, className);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            this.createPutDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex, valueRegIndex);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)setMethod, className);
            mv.visitEnd();
        }
    }

    private void createPutDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int nameRegIndex, int valueRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, nameRegIndex);
        mv.visitVarInsn(25, valueRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "putValue", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
    }

    public void createAndSplitEntrySetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        MethodVisitor mv = cw.visitMethod(1, "entrySet", "()Ljava/util/Set;", "()Ljava/util/Set<Ljava/util/Map$Entry<TK;TV;>;>;", null);
        mv.visitCode();
        int selfIndex = 0;
        int entrySetVarIndex = 1;
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        mv.visitVarInsn(58, entrySetVarIndex);
        if (!fields.isEmpty()) {
            mv.visitVarInsn(25, selfIndex);
            mv.visitVarInsn(25, entrySetVarIndex);
            mv.visitMethodInsn(182, className, "addEntry", "(Ljava/util/LinkedHashSet;)V", false);
            this.splitEntrySetMethod(cw, fields, className, jvmCastGen);
        }
        mv.visitVarInsn(25, entrySetVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "entrySet", "()Ljava/util/Set;", false);
        mv.visitMethodInsn(185, "java/util/Set", "addAll", "(Ljava/util/Collection;)Z", true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, entrySetVarIndex);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "entrySet", className);
        mv.visitEnd();
    }

    private void splitEntrySetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        int selfRegIndex = 0;
        int entrySetVarIndex = 1;
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        Object addEntryMethod = "addEntry";
        for (BField optionalField : fields.values()) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(2, (String)addEntryMethod, "(Ljava/util/LinkedHashSet;)V", null, null);
                mv.visitCode();
                addEntryMethod = "addEntry" + ++methodCount;
            }
            Label ifNotPresent = new Label();
            String fieldName = optionalField.name.value;
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(153, ifNotPresent);
            }
            mv.visitVarInsn(25, entrySetVarIndex);
            mv.visitTypeInsn(187, "java/util/AbstractMap$SimpleEntry");
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)fieldName));
            mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "fromString", "(Ljava/lang/String;)Lio/ballerina/runtime/api/values/BString;", false);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            jvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitMethodInsn(183, "java/util/AbstractMap$SimpleEntry", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", false);
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            mv.visitLabel(ifNotPresent);
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount != fields.size()) {
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, entrySetVarIndex);
                mv.visitMethodInsn(182, className, (String)addEntryMethod, "(Ljava/util/LinkedHashSet;)V", false);
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)addEntryMethod, className);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)addEntryMethod, className);
            mv.visitEnd();
        }
    }

    public void createAndSplitContainsKeyMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "containsKey", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        int selfIndex = 0;
        int fieldNameRegIndex = 1;
        int strKeyVarIndex = 2;
        JvmCodeGenUtil.castToJavaString(mv, fieldNameRegIndex, strKeyVarIndex);
        if (fields.isEmpty()) {
            Label defaultCaseLabel = new Label();
            this.createContainsDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "containsKey", className);
            mv.visitEnd();
            return;
        }
        mv.visitVarInsn(25, selfIndex);
        mv.visitVarInsn(25, strKeyVarIndex);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(182, className, "containsKey", "(Ljava/lang/String;Ljava/lang/Object;)Z", false);
        mv.visitInsn(172);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "containsKey", className);
        mv.visitEnd();
        this.splitContainsKeyMethod(cw, fields, className);
    }

    private void splitContainsKeyMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int selfRegIndex = 0;
        int strKeyVarIndex = 1;
        int fieldNameRegIndex = 2;
        Label defaultCaseLabel = new Label();
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Object> targetLabels = new ArrayList();
        int i = 0;
        Object containsMethod = "containsKey";
        for (BField optionalField : sortedFields) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(1, (String)containsMethod, "(Ljava/lang/String;Ljava/lang/Object;)Z", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = sortedFields.size() - bTypesCount;
                if (remainingCases > 500) {
                    remainingCases = 500;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
                containsMethod = "containsKey" + ++methodCount;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            String fieldName = optionalField.name.value;
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitFieldInsn(180, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
            } else {
                mv.visitLdcInsn((Object)true);
            }
            mv.visitInsn(172);
            ++i;
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount == sortedFields.size()) {
                this.createContainsDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, strKeyVarIndex);
                mv.visitVarInsn(25, fieldNameRegIndex);
                mv.visitMethodInsn(182, className, (String)containsMethod, "(Ljava/lang/String;Ljava/lang/Object;)Z", false);
                mv.visitInsn(172);
            }
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            this.createContainsDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            mv.visitMaxs(i + 10, i + 10);
            mv.visitEnd();
        }
    }

    private void createContainsDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int fieldNameRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "containsKey", "(Ljava/lang/Object;)Z", false);
        mv.visitInsn(172);
    }

    public void createAndSplitGetValuesMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        MethodVisitor mv = cw.visitMethod(1, "values", "()Ljava/util/Collection;", "()Ljava/util/Collection<TV;>;", null);
        mv.visitCode();
        int selfIndex = 0;
        int valuesVarIndex = 1;
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        mv.visitVarInsn(58, valuesVarIndex);
        if (!fields.isEmpty()) {
            mv.visitVarInsn(25, selfIndex);
            mv.visitVarInsn(25, valuesVarIndex);
            mv.visitMethodInsn(182, className, "values", "(Ljava/util/Collection;)V", false);
            this.splitGetValuesMethod(cw, fields, className, jvmCastGen);
        }
        mv.visitVarInsn(25, valuesVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "values", "()Ljava/util/Collection;", false);
        mv.visitMethodInsn(185, "java/util/List", "addAll", "(Ljava/util/Collection;)Z", true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "values", className);
        mv.visitEnd();
    }

    private void splitGetValuesMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        int selfRegIndex = 0;
        int valuesVarIndex = 1;
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        Object valuesMethod = "values";
        for (BField optionalField : fields.values()) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(2, (String)valuesMethod, "(Ljava/util/Collection;)V", null, null);
                mv.visitCode();
                valuesMethod = "values" + ++methodCount;
            }
            Label ifNotPresent = new Label();
            String fieldName = optionalField.name.value;
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(153, ifNotPresent);
            }
            mv.visitVarInsn(25, valuesVarIndex);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
            jvmCastGen.addBoxInsn(mv, optionalField.type);
            mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            mv.visitLabel(ifNotPresent);
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount != fields.size()) {
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, valuesVarIndex);
                mv.visitMethodInsn(182, className, (String)valuesMethod, "(Ljava/util/Collection;)V", false);
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)valuesMethod, className);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)valuesMethod, className);
            mv.visitEnd();
        }
    }

    public void createAndSplitRemoveMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        MethodVisitor mv = cw.visitMethod(1, "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Object;)TV;", null);
        mv.visitCode();
        int selfRegIndex = 0;
        int fieldNameRegIndex = 1;
        int strKeyVarIndex = 2;
        JvmCodeGenUtil.castToJavaString(mv, fieldNameRegIndex, strKeyVarIndex);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "validateFreezeStatus", "()V", false);
        if (fields.isEmpty()) {
            Label defaultCaseLabel = new Label();
            this.createRemoveDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, "remove", className);
            mv.visitEnd();
            return;
        }
        mv.visitVarInsn(25, selfRegIndex);
        mv.visitVarInsn(25, strKeyVarIndex);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(182, className, "remove", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "remove", className);
        mv.visitEnd();
        this.splitRemoveMethod(cw, fields, className, jvmCastGen);
    }

    private void splitRemoveMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen) {
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        int selfRegIndex = 0;
        int strKeyVarIndex = 1;
        int fieldNameRegIndex = 2;
        Label defaultCaseLabel = new Label();
        ArrayList<BField> sortedFields = new ArrayList<BField>(fields.values());
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        List<Object> targetLabels = new ArrayList();
        int i = 0;
        Object removeMethod = "remove";
        for (BField optionalField : sortedFields) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(4, (String)removeMethod, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", null, null);
                mv.visitCode();
                defaultCaseLabel = new Label();
                int remainingCases = sortedFields.size() - bTypesCount;
                if (remainingCases > 500) {
                    remainingCases = 500;
                }
                List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, defaultCaseLabel);
                targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, strKeyVarIndex, sortedFields, bTypesCount, remainingCases, labels, defaultCaseLabel);
                i = 0;
                removeMethod = "remove" + ++methodCount;
            }
            Label targetLabel = (Label)targetLabels.get(i);
            mv.visitLabel(targetLabel);
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                String fieldName = optionalField.name.value;
                mv.visitVarInsn(25, 0);
                mv.visitInsn(3);
                mv.visitFieldInsn(181, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
                jvmCastGen.addBoxInsn(mv, optionalField.type);
                if (this.checkIfValueIsJReferenceType(optionalField.type)) {
                    mv.visitVarInsn(25, 0);
                    mv.visitInsn(1);
                    mv.visitFieldInsn(181, className, fieldName, JvmTypeGen.getTypeDesc(optionalField.type));
                }
                mv.visitInsn(176);
            } else {
                mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
                mv.visitInsn(89);
                mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "()V", false);
                mv.visitInsn(191);
            }
            ++i;
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount == sortedFields.size()) {
                this.createRemoveDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            } else {
                mv.visitLabel(defaultCaseLabel);
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, strKeyVarIndex);
                mv.visitVarInsn(25, fieldNameRegIndex);
                mv.visitMethodInsn(182, className, (String)removeMethod, "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv.visitInsn(176);
            }
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)removeMethod, className);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            this.createRemoveDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)removeMethod, className);
            mv.visitEnd();
        }
    }

    private void createRemoveDefaultCase(MethodVisitor mv, Label defaultCaseLabel, int fieldNameRegIndex) {
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, fieldNameRegIndex);
        mv.visitMethodInsn(183, "io/ballerina/runtime/internal/values/MapValueImpl", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        mv.visitInsn(176);
    }

    public void createAndSplitGetKeysMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        MethodVisitor mv = cw.visitMethod(1, "getKeys", "()[Ljava/lang/Object;", "()[TK;", null);
        mv.visitCode();
        int selfIndex = 0;
        int keysVarIndex = 1;
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        mv.visitVarInsn(58, keysVarIndex);
        if (!fields.isEmpty()) {
            mv.visitVarInsn(25, selfIndex);
            mv.visitVarInsn(25, keysVarIndex);
            mv.visitMethodInsn(182, className, "getKeys", "(Ljava/util/LinkedHashSet;)V", false);
            this.splitGetKeysMethod(cw, fields, className);
        }
        mv.visitVarInsn(25, keysVarIndex);
        mv.visitVarInsn(25, selfIndex);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "keySet", "()Ljava/util/Set;", false);
        mv.visitMethodInsn(185, "java/util/Set", "addAll", "(Ljava/util/Collection;)Z", true);
        mv.visitInsn(87);
        mv.visitVarInsn(25, keysVarIndex);
        mv.visitInsn(89);
        mv.visitMethodInsn(185, "java/util/Set", "size", "()I", true);
        mv.visitTypeInsn(189, "io/ballerina/runtime/api/values/BString");
        mv.visitMethodInsn(185, "java/util/Set", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", true);
        mv.visitInsn(176);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, "getKeys", className);
        mv.visitEnd();
    }

    private void splitGetKeysMethod(ClassWriter cw, Map<String, BField> fields, String className) {
        int selfRegIndex = 0;
        int keysVarIndex = 1;
        int bTypesCount = 0;
        int methodCount = 0;
        MethodVisitor mv = null;
        Object getKeysMethod = "getKeys";
        for (BField optionalField : fields.values()) {
            if (bTypesCount % 500 == 0) {
                mv = cw.visitMethod(2, (String)getKeysMethod, "(Ljava/util/LinkedHashSet;)V", null, null);
                mv.visitCode();
                getKeysMethod = "getKeys" + ++methodCount;
            }
            Label ifNotPresent = new Label();
            String fieldName = optionalField.name.value;
            if (JvmValueGen.isOptionalRecordField(optionalField)) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, JvmValueGen.getFieldIsPresentFlagName(fieldName), JvmTypeGen.getTypeDesc(this.booleanType));
                mv.visitJumpInsn(153, ifNotPresent);
            }
            mv.visitVarInsn(25, keysVarIndex);
            mv.visitLdcInsn((Object)Utils.decodeIdentifier((String)fieldName));
            mv.visitMethodInsn(184, "io/ballerina/runtime/api/utils/StringUtils", "fromString", "(Ljava/lang/String;)Lio/ballerina/runtime/api/values/BString;", false);
            mv.visitMethodInsn(185, "java/util/Set", "add", "(Ljava/lang/Object;)Z", true);
            mv.visitInsn(87);
            mv.visitLabel(ifNotPresent);
            if (++bTypesCount % 500 != 0) continue;
            if (bTypesCount != fields.size()) {
                mv.visitVarInsn(25, selfRegIndex);
                mv.visitVarInsn(25, keysVarIndex);
                mv.visitMethodInsn(182, className, (String)getKeysMethod, "(Ljava/util/LinkedHashSet;)V", false);
            }
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)getKeysMethod, className);
            mv.visitEnd();
        }
        if (methodCount != 0 && bTypesCount % 500 != 0) {
            mv.visitInsn(177);
            JvmCodeGenUtil.visitMaxStackForMethod(mv, (String)getKeysMethod, className);
            mv.visitEnd();
        }
    }

    private boolean checkIfValueIsJReferenceType(BType bType) {
        return switch (bType.getKind()) {
            case TypeKind.INT, TypeKind.BOOLEAN, TypeKind.FLOAT, TypeKind.BYTE -> false;
            case TypeKind.TYPEREFDESC -> this.checkIfValueIsJReferenceType(((BTypeReferenceType)bType).referredType);
            case TypeKind.INTERSECTION -> this.checkIfValueIsJReferenceType(((BIntersectionType)bType).effectiveType);
            default -> true;
        };
    }

    private void createBasicTypeGetMethod(ClassWriter cw, Map<String, BField> fields, String className, JvmCastGen jvmCastGen, TypeKind basicType, String methodName, String methodDesc, boolean boxed, String boxedTypeDesc) {
        int n;
        List<BField> sortedFields = this.getSortedFields(fields, basicType);
        if (sortedFields.isEmpty()) {
            return;
        }
        MethodVisitor mv = cw.visitMethod(1, methodName, methodDesc, null, null);
        mv.visitCode();
        boolean selfRegister = false;
        boolean fieldNameBStringReg = true;
        int fieldNameStringReg = 2;
        JvmCodeGenUtil.castToJavaString(mv, 1, 2);
        Label defaultCaseLabel = new Label();
        List<Label> labels = JvmCreateTypeGen.createLabelsForSwitch(mv, 2, sortedFields, 0, sortedFields.size(), defaultCaseLabel);
        List<Label> targetLabels = JvmCreateTypeGen.createLabelsForEqualCheck(mv, 2, sortedFields, 0, sortedFields.size(), labels, defaultCaseLabel);
        if (boxed) {
            n = 176;
        } else {
            switch (basicType) {
                case INT: {
                    n = 173;
                    break;
                }
                case FLOAT: {
                    n = 175;
                    break;
                }
                case BOOLEAN: {
                    n = 172;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected unboxed type: " + String.valueOf((Object)basicType));
                }
            }
        }
        int returnIns = n;
        for (int i = 0; i < sortedFields.size(); ++i) {
            BField field = sortedFields.get(i);
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            String fieldName = field.name.value;
            mv.visitVarInsn(25, 0);
            BType fieldType = field.type;
            mv.visitFieldInsn(180, className, fieldName, JvmTypeGen.getTypeDesc(fieldType));
            if (boxed) {
                jvmCastGen.addBoxInsn(mv, fieldType);
            }
            mv.visitInsn(returnIns);
        }
        mv.visitLabel(defaultCaseLabel);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, className, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        if (boxed) {
            mv.visitTypeInsn(192, boxedTypeDesc);
        } else {
            BType targetType = switch (basicType) {
                case TypeKind.INT -> this.intType;
                case TypeKind.FLOAT -> this.floatType;
                case TypeKind.BOOLEAN -> this.booleanType;
                default -> throw new IllegalArgumentException("Unexpected unboxed type: " + String.valueOf((Object)basicType));
            };
            jvmCastGen.addUnboxInsn(mv, targetType);
        }
        mv.visitInsn(returnIns);
        JvmCodeGenUtil.visitMaxStackForMethod(mv, methodName, className);
        mv.visitEnd();
    }

    private List<BField> getSortedFields(Map<String, BField> fields, TypeKind basicType) {
        ArrayList<BField> sortedFields = new ArrayList<BField>();
        for (BField field : fields.values()) {
            if (sortedFields.size() >= 500) break;
            if (field.type.getKind() != basicType || JvmValueGen.isOptionalRecordField(field)) continue;
            sortedFields.add(field);
        }
        sortedFields.sort(FIELD_NAME_HASH_COMPARATOR);
        return sortedFields;
    }
}

