/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.tools.diagnostics.Location;
import io.ballerina.types.Env;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.writer.BIRInstructionWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRTypeWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRWriterUtils;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;

public class BIRBinaryWriter {
    private final ConstantPool cp;
    private final BIRNode.BIRPackage birPackage;
    private final Env typeEnv;

    public BIRBinaryWriter(BIRNode.BIRPackage birPackage, Env typeEnv) {
        this.birPackage = birPackage;
        this.typeEnv = typeEnv;
        this.cp = new ConstantPool(typeEnv);
    }

    public byte[] serialize() {
        byte[] byArray;
        ByteBuf birbuf = Unpooled.buffer();
        BIRTypeWriter typeWriter = new BIRTypeWriter(birbuf, this.cp, this.typeEnv);
        birbuf.writeInt(BIRWriterUtils.addPkgCPEntry(this.birPackage.packageID, this.cp));
        this.writeImportModuleDecls(birbuf, this.birPackage.importModules);
        this.writeConstants(birbuf, this.birPackage.constants);
        this.writeTypeDefs(birbuf, typeWriter, this.birPackage.typeDefs);
        this.writeGlobalVars(birbuf, typeWriter, this.birPackage.globalVars);
        this.writeTypeDefBodies(birbuf, typeWriter, this.birPackage.typeDefs);
        this.writeFunctions(birbuf, typeWriter, this.birPackage.functions);
        this.writeAnnotations(birbuf, typeWriter, this.birPackage.annotations);
        this.writeServiceDeclarations(birbuf, this.birPackage.serviceDecls);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(baos);
        try {
            dataOut.write(CompiledBinaryFile.BIRPackageFile.BIR_MAGIC);
            dataOut.writeInt(74);
            dataOut.write(this.cp.serialize());
            dataOut.write(birbuf.nioBuffer().array(), 0, birbuf.nioBuffer().limit());
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BLangCompilerException("failed to serialize the bir", e);
            }
        }
        dataOut.close();
        return byArray;
    }

    private void writeImportModuleDecls(ByteBuf buf, Set<BIRNode.BIRImportModule> birImpModList) {
        buf.writeInt(birImpModList.size());
        birImpModList.forEach(impMod -> {
            PackageID packageID = impMod.packageID;
            buf.writeInt(this.addStringCPEntry(packageID.orgName.getValue()));
            buf.writeInt(this.addStringCPEntry(packageID.pkgName.getValue()));
            buf.writeInt(this.addStringCPEntry(packageID.name.getValue()));
            buf.writeInt(this.addStringCPEntry(packageID.version.getValue()));
        });
    }

    private void writeTypeDefs(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRTypeDefinition> birTypeDefList) {
        buf.writeInt(birTypeDefList.size());
        birTypeDefList.forEach(typeDef -> this.writeType(buf, typeWriter, (BIRNode.BIRTypeDefinition)typeDef));
    }

    private void writeTypeDefBodies(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRTypeDefinition> birTypeDefList) {
        List<BIRNode.BIRTypeDefinition> filtered = birTypeDefList.stream().filter(t -> t.type.tag == 34 || t.type.tag == 12).toList();
        buf.writeInt(filtered.size());
        filtered.forEach(typeDef -> {
            this.writeFunctions(buf, typeWriter, typeDef.attachedFuncs);
            this.writeReferencedTypes(buf, typeDef.referencedTypes);
        });
    }

    private void writeReferencedTypes(ByteBuf buf, List<BType> referencedTypes) {
        buf.writeInt(referencedTypes.size());
        referencedTypes.forEach(type -> BIRWriterUtils.writeType(this.cp, buf, type));
    }

    private void writeGlobalVars(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRGlobalVariableDcl> birGlobalVars) {
        buf.writeInt(birGlobalVars.size());
        for (BIRNode.BIRGlobalVariableDcl birGlobalVar : birGlobalVars) {
            this.writePosition(buf, birGlobalVar.pos);
            buf.writeByte((int)birGlobalVar.kind.getValue());
            buf.writeInt(this.addStringCPEntry(birGlobalVar.name.value));
            buf.writeLong(birGlobalVar.flags);
            buf.writeByte((int)birGlobalVar.origin.value());
            typeWriter.writeMarkdownDocAttachment(buf, birGlobalVar.markdownDocAttachment);
            BIRWriterUtils.writeType(this.cp, buf, birGlobalVar.type);
            BIRWriterUtils.writeAnnotAttachments(this.cp, buf, birGlobalVar.annotAttachments);
        }
    }

    private void writeType(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRTypeDefinition typeDef) {
        this.writePosition(buf, typeDef.pos);
        buf.writeInt(this.addStringCPEntry(typeDef.internalName.value));
        buf.writeInt(this.addStringCPEntry(typeDef.originalName.value));
        buf.writeLong(typeDef.flags);
        buf.writeByte((int)typeDef.origin.value());
        typeWriter.writeMarkdownDocAttachment(buf, typeDef.markdownDocAttachment);
        BIRWriterUtils.writeType(this.cp, buf, typeDef.type);
        boolean hasReferenceType = typeDef.referenceType != null;
        buf.writeBoolean(hasReferenceType);
        BIRWriterUtils.writeAnnotAttachments(this.cp, buf, typeDef.annotAttachments);
    }

    private void writeFunctions(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRFunction> birFunctionList) {
        buf.writeInt(birFunctionList.size());
        birFunctionList.forEach(func -> this.writeFunction(buf, typeWriter, (BIRNode.BIRFunction)func));
    }

    private void writeFunction(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRFunction birFunction) {
        this.writePosition(buf, birFunction.pos);
        buf.writeInt(this.addStringCPEntry(birFunction.name.value));
        buf.writeInt(this.addStringCPEntry(birFunction.originalName.value));
        buf.writeInt(this.addStringCPEntry(birFunction.workerName.value));
        buf.writeLong(birFunction.flags);
        buf.writeByte((int)birFunction.origin.value());
        BIRWriterUtils.writeType(this.cp, buf, birFunction.type);
        this.writePathParameters(buf, birFunction);
        BIRWriterUtils.writeAnnotAttachments(this.cp, buf, birFunction.annotAttachments);
        List<BIRNode.BIRAnnotationAttachment> annotAttachmentsOnExternal = birFunction.annotAttachmentsOnExternal;
        if (annotAttachmentsOnExternal != null) {
            BIRWriterUtils.writeAnnotAttachments(this.cp, buf, annotAttachmentsOnExternal);
        }
        BIRWriterUtils.writeAnnotAttachments(this.cp, buf, birFunction.returnTypeAnnots);
        buf.writeInt(birFunction.requiredParams.size());
        for (BIRNode.BIRParameter parameter : birFunction.requiredParams) {
            buf.writeInt(this.addStringCPEntry(parameter.name.value));
            buf.writeLong(parameter.flags);
            BIRWriterUtils.writeAnnotAttachments(this.cp, buf, parameter.annotAttachments);
        }
        BIRNode.BIRParameter restParam = birFunction.restParam;
        boolean restParamExist = restParam != null;
        buf.writeBoolean(restParamExist);
        if (restParamExist) {
            buf.writeInt(this.addStringCPEntry(restParam.name.value));
            BIRWriterUtils.writeAnnotAttachments(this.cp, buf, restParam.annotAttachments);
        }
        boolean hasReceiverType = birFunction.receiver != null;
        buf.writeBoolean(hasReceiverType);
        if (hasReceiverType) {
            buf.writeByte((int)birFunction.receiver.kind.getValue());
            BIRWriterUtils.writeType(this.cp, buf, birFunction.receiver.type);
            buf.writeInt(this.addStringCPEntry(birFunction.receiver.name.value));
        }
        typeWriter.writeMarkdownDocAttachment(buf, birFunction.markdownDocAttachment);
        this.writeFunctionsGlobalVarDependency(buf, birFunction);
        ByteBuf birbuf = Unpooled.buffer();
        ByteBuf scopebuf = Unpooled.buffer();
        BIRInstructionWriter funcInsWriter = new BIRInstructionWriter(birbuf, scopebuf, this.cp);
        birbuf.writeInt(birFunction.argsCount);
        birbuf.writeBoolean(birFunction.returnVariable != null);
        if (birFunction.returnVariable != null) {
            birbuf.writeByte((int)birFunction.returnVariable.kind.getValue());
            BIRWriterUtils.writeType(this.cp, birbuf, birFunction.returnVariable.type);
            birbuf.writeInt(this.addStringCPEntry(birFunction.returnVariable.name.value));
        }
        birbuf.writeInt(birFunction.parameters.size());
        for (BIRNode.BIRFunctionParameter param : birFunction.parameters) {
            birbuf.writeByte((int)param.kind.getValue());
            BIRWriterUtils.writeType(this.cp, birbuf, param.type);
            birbuf.writeInt(this.addStringCPEntry(param.name.value));
            if (param.kind.equals((Object)VarKind.ARG)) {
                birbuf.writeInt(this.addStringCPEntry(param.metaVarName != null ? param.metaVarName : ""));
            }
            birbuf.writeBoolean(param.hasDefaultExpr);
        }
        birbuf.writeInt(birFunction.localVars.size());
        for (BIRNode.BIRVariableDcl localVar : birFunction.localVars) {
            birbuf.writeByte((int)localVar.kind.getValue());
            BIRWriterUtils.writeType(this.cp, birbuf, localVar.type);
            birbuf.writeInt(this.addStringCPEntry(localVar.name.value));
            if (localVar.kind.equals((Object)VarKind.ARG)) {
                birbuf.writeInt(this.addStringCPEntry(localVar.metaVarName != null ? localVar.metaVarName : ""));
            }
            if (!localVar.kind.equals((Object)VarKind.LOCAL)) continue;
            birbuf.writeInt(this.addStringCPEntry(localVar.metaVarName != null ? localVar.metaVarName : ""));
            birbuf.writeInt(this.addStringCPEntry(localVar.endBB != null ? localVar.endBB.id.value : ""));
            birbuf.writeInt(this.addStringCPEntry(localVar.startBB != null ? localVar.startBB.id.value : ""));
            birbuf.writeInt(localVar.insOffset);
        }
        funcInsWriter.writeBBs(birFunction.basicBlocks);
        funcInsWriter.writeErrorTable(birFunction.errorTable);
        birbuf.writeInt(birFunction.workerChannels.length);
        for (Iterator<BIRNode.BIRVariableDcl> iterator : birFunction.workerChannels) {
            birbuf.writeInt(this.addStringCPEntry(((BIRNode.ChannelDetails)((Object)iterator)).name));
            birbuf.writeBoolean(((BIRNode.ChannelDetails)((Object)iterator)).channelInSameStrand);
            birbuf.writeBoolean(((BIRNode.ChannelDetails)((Object)iterator)).send);
        }
        this.writeScopes(buf, scopebuf, funcInsWriter.getScopeCount());
        int length = birbuf.nioBuffer().limit();
        buf.writeLong((long)length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writePathParameters(ByteBuf buf, BIRNode.BIRFunction birFunction) {
        boolean isResourceFunction = birFunction.resourcePath != null;
        buf.writeBoolean(isResourceFunction);
        if (isResourceFunction) {
            List<BIRNode.BIRVariableDcl> pathParams = birFunction.pathParams;
            buf.writeInt(pathParams.size());
            for (BIRNode.BIRVariableDcl pathParam : pathParams) {
                buf.writeInt(this.addStringCPEntry(pathParam.metaVarName));
                BIRWriterUtils.writeType(this.cp, buf, pathParam.type);
            }
            BIRNode.BIRVariableDcl restPathParam = birFunction.restPathParam;
            buf.writeBoolean(restPathParam != null);
            if (restPathParam != null) {
                buf.writeInt(this.addStringCPEntry(restPathParam.metaVarName));
                BIRWriterUtils.writeType(this.cp, buf, restPathParam.type);
            }
            List<Name> resourcePath = birFunction.resourcePath;
            List<Location> pathSegmentPosList = birFunction.resourcePathSegmentPosList;
            List<BType> pathSegmentTypeList = birFunction.pathSegmentTypeList;
            int pathSegmentCount = resourcePath.size();
            buf.writeInt(pathSegmentCount);
            for (int i = 0; i < pathSegmentCount; ++i) {
                buf.writeInt(this.addStringCPEntry(resourcePath.get((int)i).value));
                this.writePosition(buf, pathSegmentPosList.get(i));
                BIRWriterUtils.writeType(this.cp, buf, pathSegmentTypeList.get(i));
            }
            buf.writeInt(this.addStringCPEntry(birFunction.accessor.value));
        }
    }

    private void writeFunctionsGlobalVarDependency(ByteBuf buf, BIRNode.BIRFunction birFunction) {
        buf.writeInt(birFunction.dependentGlobalVars.size());
        for (BIRNode.BIRVariableDcl bIRVariableDcl : birFunction.dependentGlobalVars) {
            buf.writeInt(this.addStringCPEntry(bIRVariableDcl.name.value));
        }
    }

    private void writeScopes(ByteBuf buf, ByteBuf scopebuf, int scopeCount) {
        int length = scopebuf.nioBuffer().limit();
        buf.writeLong((long)(length + 4));
        buf.writeInt(scopeCount);
        buf.writeBytes(scopebuf.nioBuffer().array(), 0, length);
    }

    private void writeAnnotations(ByteBuf buf, BIRTypeWriter typeWriter, List<BIRNode.BIRAnnotation> birAnnotationList) {
        buf.writeInt(birAnnotationList.size());
        birAnnotationList.forEach(annotation -> this.writeAnnotation(buf, typeWriter, (BIRNode.BIRAnnotation)annotation));
    }

    private void writeAnnotation(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRAnnotation birAnnotation) {
        buf.writeInt(BIRWriterUtils.addPkgCPEntry(birAnnotation.packageID, this.cp));
        buf.writeInt(this.addStringCPEntry(birAnnotation.name.value));
        buf.writeInt(this.addStringCPEntry(birAnnotation.originalName.value));
        buf.writeLong(birAnnotation.flags);
        buf.writeByte((int)birAnnotation.origin.value());
        this.writePosition(buf, birAnnotation.pos);
        buf.writeInt(birAnnotation.attachPoints.size());
        for (AttachPoint attachPoint : birAnnotation.attachPoints) {
            buf.writeInt(this.addStringCPEntry(attachPoint.point.getValue()));
            buf.writeBoolean(attachPoint.source);
        }
        BIRWriterUtils.writeType(this.cp, buf, birAnnotation.annotationType);
        typeWriter.writeMarkdownDocAttachment(buf, birAnnotation.markdownDocAttachment);
        BIRWriterUtils.writeAnnotAttachments(this.cp, buf, birAnnotation.annotAttachments);
    }

    private void writeConstants(ByteBuf buf, List<BIRNode.BIRConstant> birConstList) {
        BIRTypeWriter constTypeWriter = new BIRTypeWriter(buf, this.cp, this.typeEnv);
        buf.writeInt(birConstList.size());
        birConstList.forEach(constant -> this.writeConstant(buf, constTypeWriter, (BIRNode.BIRConstant)constant));
    }

    private void writeConstant(ByteBuf buf, BIRTypeWriter typeWriter, BIRNode.BIRConstant birConstant) {
        buf.writeInt(this.addStringCPEntry(birConstant.name.value));
        buf.writeLong(birConstant.flags);
        buf.writeByte((int)birConstant.origin.value());
        this.writePosition(buf, birConstant.pos);
        typeWriter.writeMarkdownDocAttachment(buf, birConstant.markdownDocAttachment);
        BIRWriterUtils.writeType(this.cp, buf, birConstant.type);
        ByteBuf birbuf = Unpooled.buffer();
        BIRWriterUtils.writeType(this.cp, birbuf, birConstant.constValue.type);
        BIRWriterUtils.writeAnnotAttachments(this.cp, buf, birConstant.annotAttachments);
        BIRWriterUtils.writeConstValue(this.cp, birbuf, birConstant.constValue);
        int length = birbuf.nioBuffer().limit();
        buf.writeLong((long)length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeServiceDeclarations(ByteBuf buf, List<BIRNode.BIRServiceDeclaration> birServiceDeclList) {
        buf.writeInt(birServiceDeclList.size());
        birServiceDeclList.forEach(service -> this.writeServiceDeclaration(buf, (BIRNode.BIRServiceDeclaration)service));
    }

    private void writeServiceDeclaration(ByteBuf buf, BIRNode.BIRServiceDeclaration birServiceDecl) {
        buf.writeInt(this.addStringCPEntry(birServiceDecl.generatedName.value));
        buf.writeInt(this.addStringCPEntry(birServiceDecl.associatedClassName.value));
        buf.writeLong(birServiceDecl.flags);
        buf.writeByte((int)birServiceDecl.origin.value());
        this.writePosition(buf, birServiceDecl.pos);
        buf.writeBoolean(birServiceDecl.type != null);
        if (birServiceDecl.type != null) {
            BIRWriterUtils.writeType(this.cp, buf, birServiceDecl.type);
        }
        buf.writeBoolean(birServiceDecl.attachPoint != null);
        if (birServiceDecl.attachPoint != null) {
            buf.writeInt(birServiceDecl.attachPoint.size());
            for (String pathSegment : birServiceDecl.attachPoint) {
                buf.writeInt(this.addStringCPEntry(pathSegment));
            }
        }
        buf.writeBoolean(birServiceDecl.attachPointLiteral != null);
        if (birServiceDecl.attachPointLiteral != null) {
            buf.writeInt(this.addStringCPEntry(birServiceDecl.attachPointLiteral));
        }
        buf.writeInt(birServiceDecl.listenerTypes.size());
        for (BType listenerType : birServiceDecl.listenerTypes) {
            BIRWriterUtils.writeType(this.cp, buf, listenerType);
        }
    }

    private int addStringCPEntry(String value) {
        return this.cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    private void writePosition(ByteBuf buf, Location pos) {
        BIRWriterUtils.writePosition(pos, buf, this.cp);
    }
}

