/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.ballerina.types.Atom;
import io.ballerina.types.AtomicType;
import io.ballerina.types.BasicTypeBitSet;
import io.ballerina.types.Bdd;
import io.ballerina.types.CellAtomicType;
import io.ballerina.types.CellSemType;
import io.ballerina.types.ComplexSemType;
import io.ballerina.types.EnumerableCharString;
import io.ballerina.types.EnumerableDecimal;
import io.ballerina.types.EnumerableFloat;
import io.ballerina.types.EnumerableString;
import io.ballerina.types.Env;
import io.ballerina.types.FixedLengthArray;
import io.ballerina.types.FunctionAtomicType;
import io.ballerina.types.ListAtomicType;
import io.ballerina.types.MappingAtomicType;
import io.ballerina.types.PredefinedTypeEnv;
import io.ballerina.types.ProperSubtypeData;
import io.ballerina.types.RecAtom;
import io.ballerina.types.SemType;
import io.ballerina.types.TypeAtom;
import io.ballerina.types.subtypedata.BddAllOrNothing;
import io.ballerina.types.subtypedata.BddNode;
import io.ballerina.types.subtypedata.BooleanSubtype;
import io.ballerina.types.subtypedata.CharStringSubtype;
import io.ballerina.types.subtypedata.DecimalSubtype;
import io.ballerina.types.subtypedata.FloatSubtype;
import io.ballerina.types.subtypedata.IntSubtype;
import io.ballerina.types.subtypedata.NonCharStringSubtype;
import io.ballerina.types.subtypedata.Range;
import io.ballerina.types.subtypedata.StringSubtype;
import io.ballerina.types.subtypedata.XmlSubtype;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.bir.writer.BIRWriterUtils;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BEnumSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeDefinitionSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnyType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnydataType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BIntersectionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BJSONType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNeverType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNoType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BPackageType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BParameterizedType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleMember;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeIdSet;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeReferenceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BXMLType;
import org.wso2.ballerinalang.compiler.semantics.model.types.SemNamedType;

public class BIRTypeWriter
extends TypeVisitor {
    private final ByteBuf buff;
    private final ConstantPool cp;
    private final Set<Atom.AtomIdentifier> visitedAtoms = new HashSet<Atom.AtomIdentifier>();
    private final Env typeEnv;
    private final PredefinedTypeEnv predefinedTypeEnv = PredefinedTypeEnv.getInstance();
    private static final byte REC_ATOM_KIND = 0;
    private static final byte INLINED_ATOM_KIND = 1;
    private static final byte TYPE_ATOM_KIND = 2;

    public BIRTypeWriter(ByteBuf buff, ConstantPool cp, Env typeEnv) {
        this.buff = buff;
        this.cp = cp;
        this.typeEnv = typeEnv;
    }

    public void visitType(BType type) {
        this.buff.writeByte(type.tag);
        this.buff.writeInt(this.addStringCPEntry(type.name.getValue()));
        this.buff.writeLong(type.getFlags());
        type.accept(this);
    }

    private void writeTypeCpIndex(BType type) {
        this.buff.writeInt(this.cp.addShapeCPEntry(type));
    }

    @Override
    public void visit(BAnnotationType bAnnotationType) {
        this.throwUnimplementedError(bAnnotationType);
    }

    @Override
    public void visit(BArrayType bArrayType) {
        this.buff.writeByte((int)bArrayType.state.getValue());
        this.buff.writeInt(bArrayType.getSize());
        this.writeTypeCpIndex(bArrayType.getElementType());
    }

    @Override
    public void visit(BAnyType bAnyType) {
    }

    @Override
    public void visit(BErrorType bErrorType) {
        int pkgIndex = BIRWriterUtils.addPkgCPEntry(bErrorType.tsymbol.pkgID, this.cp);
        this.buff.writeInt(pkgIndex);
        this.buff.writeInt(this.addStringCPEntry(bErrorType.tsymbol.name.value));
        this.writeTypeCpIndex(bErrorType.detailType);
        this.writeTypeIds(bErrorType.typeIdSet);
    }

    private void writeTypeIds(BTypeIdSet typeIdSet) {
        this.buff.writeInt(typeIdSet.getPrimary().size());
        for (BTypeIdSet.BTypeId bTypeId : typeIdSet.getPrimary()) {
            this.writeTypeId(bTypeId);
        }
        this.buff.writeInt(typeIdSet.getSecondary().size());
        for (BTypeIdSet.BTypeId bTypeId : typeIdSet.getSecondary()) {
            this.writeTypeId(bTypeId);
        }
    }

    private void writeTypeId(BTypeIdSet.BTypeId bTypeId) {
        int pkgIndex = BIRWriterUtils.addPkgCPEntry(bTypeId.packageID, this.cp);
        this.buff.writeInt(pkgIndex);
        this.buff.writeInt(this.addStringCPEntry(bTypeId.name));
        this.buff.writeBoolean(bTypeId.publicId);
    }

    @Override
    public void visit(BFiniteType bFiniteType) {
        BTypeSymbol tsymbol = bFiniteType.tsymbol;
        this.buff.writeInt(this.addStringCPEntry(tsymbol.name.value));
        this.buff.writeLong(tsymbol.flags);
        this.buff.writeInt(bFiniteType.valueSpace.length);
        for (SemNamedType semNamedType : bFiniteType.valueSpace) {
            this.writeSemNamedType(semNamedType);
        }
    }

    @Override
    public void visit(BInvokableType bInvokableType) {
        boolean isAnyFunction = Symbols.isFlagOn(bInvokableType.getFlags(), 0x8000000000L);
        this.buff.writeBoolean(isAnyFunction);
        if (isAnyFunction) {
            return;
        }
        this.buff.writeInt(bInvokableType.paramTypes.size());
        for (BType params : bInvokableType.paramTypes) {
            this.writeTypeCpIndex(params);
        }
        boolean restTypeExist = bInvokableType.restType != null;
        this.buff.writeBoolean(restTypeExist);
        if (restTypeExist) {
            this.writeTypeCpIndex(bInvokableType.restType);
        }
        this.writeTypeCpIndex(bInvokableType.retType);
        boolean hasTSymbol = bInvokableType.tsymbol != null;
        this.buff.writeBoolean(hasTSymbol);
        if (!hasTSymbol) {
            return;
        }
        BInvokableTypeSymbol invokableTypeSymbol = (BInvokableTypeSymbol)bInvokableType.tsymbol;
        this.buff.writeInt(invokableTypeSymbol.params.size());
        for (BVarSymbol symbol : invokableTypeSymbol.params) {
            this.buff.writeInt(this.addStringCPEntry(symbol.name.value));
            this.buff.writeLong(symbol.flags);
            this.writeMarkdownDocAttachment(this.buff, symbol.markdownDocumentation);
            this.writeTypeCpIndex(symbol.type);
        }
        BVarSymbol restParam = invokableTypeSymbol.restParam;
        boolean restParamExists = restParam != null;
        this.buff.writeBoolean(restParamExists);
        if (restParamExists) {
            this.buff.writeInt(this.addStringCPEntry(restParam.name.value));
            this.buff.writeLong(restParam.flags);
            this.writeMarkdownDocAttachment(this.buff, restParam.markdownDocumentation);
            this.writeTypeCpIndex(restParam.type);
        }
        this.buff.writeInt(invokableTypeSymbol.defaultValues.size());
        invokableTypeSymbol.defaultValues.forEach((k, v) -> {
            this.buff.writeInt(this.addStringCPEntry((String)k));
            this.writeSymbolOfClosure((BInvokableSymbol)v);
        });
    }

    private void writeSymbolOfClosure(BInvokableSymbol invokableSymbol) {
        this.buff.writeInt(this.addStringCPEntry(invokableSymbol.name.value));
        this.buff.writeLong(invokableSymbol.flags);
        this.writeTypeCpIndex(invokableSymbol.type);
        this.writePackageIndex(invokableSymbol.type.tsymbol);
        this.buff.writeInt(invokableSymbol.params.size());
        for (BVarSymbol symbol : invokableSymbol.params) {
            this.buff.writeInt(this.addStringCPEntry(symbol.name.value));
            this.buff.writeLong(symbol.flags);
            this.writeMarkdownDocAttachment(this.buff, symbol.markdownDocumentation);
            this.writeTypeCpIndex(symbol.type);
        }
    }

    @Override
    public void visit(BJSONType bjsonType) {
    }

    @Override
    public void visit(BMapType bMapType) {
        this.writeTypeCpIndex(bMapType.constraint);
    }

    @Override
    public void visit(BStreamType bStreamType) {
        this.writeTypeCpIndex(bStreamType.constraint);
        this.writeTypeCpIndex(bStreamType.completionType);
    }

    @Override
    public void visit(BTypedescType typedescType) {
        this.writeTypeCpIndex(typedescType.constraint);
    }

    @Override
    public void visit(BTypeReferenceType typeReferenceType) {
        BTypeSymbol tsymbol = typeReferenceType.tsymbol;
        this.writePackageIndex(tsymbol);
        this.buff.writeInt(this.addStringCPEntry(typeReferenceType.definitionName));
        this.writeTypeCpIndex(typeReferenceType.referredType);
    }

    @Override
    public void visit(BParameterizedType type) {
        this.writeTypeCpIndex(type.paramValueType);
        this.buff.writeInt(type.paramIndex);
    }

    @Override
    public void visit(BFutureType bFutureType) {
        this.writeTypeCpIndex(bFutureType.constraint);
    }

    @Override
    public void visit(BHandleType bHandleType) {
    }

    @Override
    public void visit(BNeverType bNeverType) {
    }

    @Override
    public void visitNilType(BType bType) {
    }

    @Override
    public void visit(BNoType bNoType) {
    }

    @Override
    public void visit(BAnydataType bAnydataType) {
    }

    @Override
    public void visit(BPackageType bPackageType) {
        this.throwUnimplementedError(bPackageType);
    }

    @Override
    public void visit(BStructureType bStructureType) {
        this.throwUnimplementedError(bStructureType);
    }

    @Override
    public void visit(BTupleType bTupleType) {
        List<BTupleMember> members = bTupleType.getMembers();
        this.buff.writeInt(members.size());
        for (int i = 0; i < members.size(); ++i) {
            BTupleMember memberType = members.get(i);
            this.buff.writeInt(this.addStringCPEntry(Integer.toString(i)));
            this.buff.writeLong(memberType.symbol.flags);
            this.writeTypeCpIndex(memberType.type);
            BIRWriterUtils.writeAnnotAttachments(this.cp, this.buff, BIRWriterUtils.getBIRAnnotAttachments(memberType.symbol.getAnnotations()));
        }
        if (bTupleType.restType != null) {
            this.buff.writeBoolean(true);
            this.writeTypeCpIndex(bTupleType.restType);
        } else {
            this.buff.writeBoolean(false);
        }
    }

    @Override
    public void visit(BUnionType bUnionType) {
        this.buff.writeBoolean(bUnionType.isCyclic);
        BTypeSymbol tsymbol = bUnionType.tsymbol;
        if (bUnionType.isCyclic && tsymbol != null && !tsymbol.name.getValue().isEmpty()) {
            this.buff.writeBoolean(true);
            this.writePackageIndex(tsymbol);
            this.buff.writeInt(this.addStringCPEntry(bUnionType.tsymbol.name.value));
        } else {
            this.buff.writeBoolean(false);
        }
        this.writeMembers(bUnionType.getMemberTypes());
        this.writeMembers(bUnionType.getOriginalMemberTypes());
        if (tsymbol instanceof BEnumSymbol) {
            BEnumSymbol enumSymbol = (BEnumSymbol)tsymbol;
            this.buff.writeBoolean(true);
            this.writeEnumSymbolInfo(enumSymbol);
        } else {
            this.buff.writeBoolean(false);
        }
    }

    private void writeMembers(Set<BType> memberTypes) {
        this.buff.writeInt(memberTypes.size());
        for (BType memberType : memberTypes) {
            this.writeTypeCpIndex(memberType);
        }
    }

    private void writeEnumSymbolInfo(BEnumSymbol symbol) {
        this.writePackageIndex(symbol);
        this.buff.writeInt(this.addStringCPEntry(symbol.name.value));
        this.buff.writeInt(symbol.members.size());
        for (BConstantSymbol member : symbol.members) {
            this.buff.writeInt(this.addStringCPEntry(member.name.value));
        }
    }

    private void writePackageIndex(BTypeSymbol tsymbol) {
        int pkgIndex = BIRWriterUtils.addPkgCPEntry(tsymbol.pkgID, this.cp);
        this.buff.writeInt(pkgIndex);
    }

    @Override
    public void visit(BIntersectionType bIntersectionType) {
        this.writeMembers(bIntersectionType.getConstituentTypes());
        this.writeTypeCpIndex(bIntersectionType.effectiveType);
    }

    @Override
    public void visit(BRecordType bRecordType) {
        BRecordTypeSymbol tsymbol = (BRecordTypeSymbol)bRecordType.tsymbol;
        this.writePackageIndex(tsymbol);
        BTypeDefinitionSymbol typDefSymbol = tsymbol.typeDefinitionSymbol;
        this.buff.writeInt(this.addStringCPEntry(((BSymbol)Objects.requireNonNullElse(typDefSymbol, tsymbol)).name.value));
        this.buff.writeBoolean(bRecordType.sealed);
        this.writeTypeCpIndex(bRecordType.restFieldType);
        this.buff.writeInt(bRecordType.fields.size());
        for (BField field : bRecordType.fields.values()) {
            BVarSymbol symbol = field.symbol;
            this.buff.writeInt(this.addStringCPEntry(symbol.name.value));
            this.buff.writeLong(symbol.flags);
            this.writeMarkdownDocAttachment(this.buff, field.symbol.markdownDocumentation);
            this.writeTypeCpIndex(field.type);
            BIRWriterUtils.writeAnnotAttachments(this.cp, this.buff, BIRWriterUtils.getBIRAnnotAttachments(field.symbol.getAnnotations()));
        }
        this.writeTypeInclusions(bRecordType.typeInclusions);
        this.buff.writeInt(tsymbol.defaultValues.size());
        tsymbol.defaultValues.forEach((k, v) -> {
            this.buff.writeInt(this.addStringCPEntry((String)k));
            this.writeSymbolOfClosure((BInvokableSymbol)v);
        });
    }

    @Override
    public void visit(BObjectType bObjectType) {
        this.writeObjectAndServiceTypes(bObjectType);
        this.writeTypeIds(bObjectType.typeIdSet);
    }

    private void writeObjectAndServiceTypes(BObjectType bObjectType) {
        ArrayList attachedFuncs;
        BTypeSymbol tSymbol = bObjectType.tsymbol;
        this.writePackageIndex(tSymbol);
        BTypeDefinitionSymbol typDefSymbol = ((BObjectTypeSymbol)tSymbol).typeDefinitionSymbol;
        this.buff.writeInt(this.addStringCPEntry(((BSymbol)Objects.requireNonNullElse(typDefSymbol, tSymbol)).name.value));
        this.buff.writeLong(tSymbol.flags);
        this.buff.writeInt(bObjectType.fields.size());
        for (BField field : bObjectType.fields.values()) {
            this.buff.writeInt(this.addStringCPEntry(field.name.value));
            this.buff.writeLong(field.symbol.flags);
            this.buff.writeBoolean(field.symbol.isDefaultable);
            this.writeMarkdownDocAttachment(this.buff, field.symbol.markdownDocumentation);
            this.writeTypeCpIndex(field.type);
        }
        if (tSymbol.kind == SymbolKind.OBJECT) {
            attachedFuncs = new ArrayList(((BObjectTypeSymbol)tSymbol).attachedFuncs);
            if (((BObjectTypeSymbol)tSymbol).generatedInitializerFunc != null) {
                this.buff.writeByte(1);
                this.writeAttachFunction(((BObjectTypeSymbol)tSymbol).generatedInitializerFunc);
            } else {
                this.buff.writeByte(0);
            }
            if (((BObjectTypeSymbol)tSymbol).initializerFunc != null) {
                this.buff.writeByte(1);
                this.writeAttachFunction(((BObjectTypeSymbol)tSymbol).initializerFunc);
            } else {
                this.buff.writeByte(0);
            }
        } else {
            attachedFuncs = new ArrayList();
            this.buff.writeByte(0);
            this.buff.writeByte(0);
        }
        this.buff.writeInt(attachedFuncs.size());
        for (BAttachedFunction attachedFunc : attachedFuncs) {
            this.writeAttachFunction(attachedFunc);
        }
        this.writeTypeInclusions(bObjectType.typeInclusions);
    }

    private void writeAttachFunction(BAttachedFunction attachedFunc) {
        this.buff.writeInt(this.addStringCPEntry(attachedFunc.funcName.value));
        this.buff.writeInt(this.addStringCPEntry(attachedFunc.symbol.getOriginalName().getValue()));
        this.buff.writeLong(attachedFunc.symbol.flags);
        this.writeTypeCpIndex(attachedFunc.type);
    }

    @Override
    public void visit(BXMLType bxmlType) {
        this.writeTypeCpIndex(bxmlType.constraint);
    }

    @Override
    public void visit(BTableType bTableType) {
        this.writeTypeCpIndex(bTableType.constraint);
        this.buff.writeBoolean(!bTableType.fieldNameList.isEmpty());
        if (!bTableType.fieldNameList.isEmpty()) {
            this.buff.writeInt(bTableType.fieldNameList.size());
            for (String fieldName : bTableType.fieldNameList) {
                this.buff.writeInt(this.addStringCPEntry(fieldName));
            }
        }
        this.buff.writeBoolean(bTableType.keyTypeConstraint != null);
        if (bTableType.keyTypeConstraint != null) {
            this.writeTypeCpIndex(bTableType.keyTypeConstraint);
        }
    }

    public void writeMarkdownDocAttachment(ByteBuf buf, MarkdownDocAttachment markdownDocAttachment) {
        ByteBuf birbuf = Unpooled.buffer();
        if (markdownDocAttachment == null) {
            birbuf.writeBoolean(false);
        } else {
            birbuf.writeBoolean(true);
            birbuf.writeInt(markdownDocAttachment.description == null ? -1 : this.addStringCPEntry(markdownDocAttachment.description));
            birbuf.writeInt(markdownDocAttachment.returnValueDescription == null ? -1 : this.addStringCPEntry(markdownDocAttachment.returnValueDescription));
            this.writeParamDocs(birbuf, markdownDocAttachment.parameters);
            if (markdownDocAttachment.deprecatedDocumentation != null) {
                birbuf.writeInt(this.addStringCPEntry(markdownDocAttachment.deprecatedDocumentation));
            } else {
                birbuf.writeInt(-1);
            }
            this.writeParamDocs(birbuf, markdownDocAttachment.deprecatedParams);
        }
        int length = birbuf.nioBuffer().limit();
        buf.writeInt(length);
        buf.writeBytes(birbuf.nioBuffer().array(), 0, length);
    }

    private void writeParamDocs(ByteBuf birBuf, List<MarkdownDocAttachment.Parameter> params) {
        birBuf.writeInt(params.size());
        for (MarkdownDocAttachment.Parameter param : params) {
            birBuf.writeInt(this.addStringCPEntry(param.name));
            birBuf.writeInt(this.addStringCPEntry(param.description));
        }
    }

    private void throwUnimplementedError(BType bType) {
        throw new AssertionError((Object)("Type serialization is not implemented for " + String.valueOf(bType.getClass())));
    }

    private int addStringCPEntry(String value) {
        return this.cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    private void writeTypeInclusions(List<BType> inclusions) {
        this.buff.writeInt(inclusions.size());
        for (BType inclusion : inclusions) {
            this.writeTypeCpIndex(inclusion);
        }
    }

    private void writeNullableString(String nullableString) {
        boolean hasNonNullString = nullableString != null;
        this.buff.writeBoolean(hasNonNullString);
        if (hasNonNullString) {
            this.buff.writeInt(this.addStringCPEntry(nullableString));
        }
    }

    private void writeSemNamedType(SemNamedType semNamedType) {
        this.writeSemType(semNamedType.semType());
        this.writeNullableString(semNamedType.optName().orElse(null));
    }

    private void writeSemType(SemType semType) {
        boolean hasSemType = semType != null;
        this.buff.writeBoolean(hasSemType);
        if (!hasSemType) {
            return;
        }
        boolean isUniformTypeBitSet = semType instanceof BasicTypeBitSet;
        this.buff.writeBoolean(isUniformTypeBitSet);
        this.buff.writeInt(semType.all());
        if (isUniformTypeBitSet) {
            return;
        }
        ComplexSemType complexSemType = (ComplexSemType)semType;
        this.buff.writeInt(complexSemType.some());
        ProperSubtypeData[] subtypeDataList = complexSemType.subtypeDataList();
        this.buff.writeByte(subtypeDataList.length);
        for (ProperSubtypeData psd : subtypeDataList) {
            this.writeProperSubtypeData(psd);
        }
    }

    private void writeProperSubtypeData(ProperSubtypeData psd) {
        if (psd instanceof Bdd) {
            Bdd bdd = (Bdd)psd;
            this.buff.writeByte(1);
            this.writeBdd(bdd);
        } else if (psd instanceof IntSubtype) {
            IntSubtype intSubtype = (IntSubtype)psd;
            this.buff.writeByte(2);
            this.writeIntSubtype(intSubtype);
        } else if (psd instanceof BooleanSubtype) {
            BooleanSubtype booleanSubtype = (BooleanSubtype)psd;
            this.buff.writeByte(3);
            this.buff.writeBoolean(booleanSubtype.value);
        } else if (psd instanceof FloatSubtype) {
            FloatSubtype floatSubtype = (FloatSubtype)psd;
            this.buff.writeByte(4);
            this.writeFloatSubtype(floatSubtype);
        } else if (psd instanceof DecimalSubtype) {
            DecimalSubtype decimalSubtype = (DecimalSubtype)psd;
            this.buff.writeByte(5);
            this.writeDecimalSubtype(decimalSubtype);
        } else if (psd instanceof StringSubtype) {
            StringSubtype stringSubtype = (StringSubtype)psd;
            this.buff.writeByte(6);
            this.writeStringSubtype(stringSubtype);
        } else if (psd instanceof XmlSubtype) {
            XmlSubtype xmlSubtype = (XmlSubtype)psd;
            this.buff.writeByte(7);
            this.buff.writeInt(xmlSubtype.primitives);
            this.writeBdd(xmlSubtype.sequence);
        } else {
            throw new IllegalStateException("Unknown ProperSubtypeData");
        }
    }

    private void writeBdd(Bdd bdd) {
        this.buff.writeBoolean(bdd instanceof BddNode);
        if (bdd instanceof BddNode) {
            BddNode bddNode = (BddNode)bdd;
            this.writeBddNode(bddNode);
        } else {
            BddAllOrNothing bddAllOrNothing = (BddAllOrNothing)bdd;
            this.buff.writeBoolean(bddAllOrNothing.isAll());
        }
    }

    private void writeBddNode(BddNode bddNode) {
        Atom atom = bddNode.atom();
        if (atom instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)atom;
            this.writeRecAtom(recAtom);
        } else {
            this.buff.writeByte(2);
            TypeAtom typeAtom = (TypeAtom)atom;
            this.visitedAtoms.add(typeAtom.getIdentifier());
            this.writeTypeAtom(typeAtom);
        }
        this.writeBdd(bddNode.left());
        this.writeBdd(bddNode.middle());
        this.writeBdd(bddNode.right());
    }

    private void writeRecAtom(RecAtom recAtom) {
        if (this.shouldInline(recAtom)) {
            this.writeInlinedRecAtom(recAtom);
        } else {
            this.buff.writeByte(0);
            int index = this.typeEnv.compactRecIndex(recAtom);
            this.buff.writeInt(index);
            if (!this.predefinedTypeEnv.isPredefinedRecAtom(index)) {
                this.buff.writeInt(recAtom.kind().ordinal());
            }
        }
    }

    private void writeInlinedRecAtom(RecAtom recAtom) {
        this.visitedAtoms.add(recAtom.getIdentifier());
        this.buff.writeByte(1);
        this.buff.writeInt(this.typeEnv.compactRecIndex(recAtom));
        TypeAtom typeAtom = switch (recAtom.kind()) {
            default -> throw new MatchException(null, null);
            case Atom.Kind.LIST_ATOM -> this.typeEnv.listAtom(this.typeEnv.listAtomType((Atom)recAtom));
            case Atom.Kind.FUNCTION_ATOM -> this.typeEnv.functionAtom(this.typeEnv.functionAtomType((Atom)recAtom));
            case Atom.Kind.MAPPING_ATOM -> this.typeEnv.mappingAtom(this.typeEnv.mappingAtomType((Atom)recAtom));
            case Atom.Kind.XML_ATOM, Atom.Kind.DISTINCT_ATOM -> throw new IllegalStateException("Should not happen. Handled before reaching here");
            case Atom.Kind.CELL_ATOM -> throw new IllegalStateException("Cell atom cannot be recursive");
        };
        this.writeTypeAtom(typeAtom);
    }

    private boolean shouldInline(RecAtom recAtom) {
        if (this.predefinedTypeEnv.isPredefinedRecAtom(recAtom.index) || recAtom.kind() == Atom.Kind.XML_ATOM || recAtom.kind() == Atom.Kind.DISTINCT_ATOM) {
            return false;
        }
        return !this.visitedAtoms.contains(recAtom.getIdentifier());
    }

    private void writeTypeAtom(TypeAtom typeAtom) {
        this.buff.writeInt(typeAtom.index());
        this.writeAtomicType(typeAtom.atomicType());
    }

    private void writeAtomicType(AtomicType atomicType) {
        if (atomicType instanceof MappingAtomicType) {
            MappingAtomicType mappingAtomicType = (MappingAtomicType)atomicType;
            this.buff.writeByte(1);
            this.writeMappingAtomicType(mappingAtomicType);
        } else if (atomicType instanceof ListAtomicType) {
            ListAtomicType listAtomicType = (ListAtomicType)atomicType;
            this.buff.writeByte(2);
            this.writeListAtomicType(listAtomicType);
        } else if (atomicType instanceof FunctionAtomicType) {
            FunctionAtomicType functionAtomicType = (FunctionAtomicType)atomicType;
            this.buff.writeByte(3);
            this.writeFunctionAtomicType(functionAtomicType);
        } else if (atomicType instanceof CellAtomicType) {
            CellAtomicType cellAtomicType = (CellAtomicType)atomicType;
            this.buff.writeByte(4);
            this.writeSemType(cellAtomicType.ty());
            this.buff.writeByte(cellAtomicType.mut().ordinal());
        } else {
            throw new UnsupportedOperationException("Unexpected atomic type " + String.valueOf(atomicType));
        }
    }

    private void writeFunctionAtomicType(FunctionAtomicType functionAtomicType) {
        this.writeSemType(functionAtomicType.paramType());
        this.writeSemType(functionAtomicType.retType());
        this.writeSemType(functionAtomicType.qualifiers());
        this.buff.writeBoolean(functionAtomicType.isGeneric());
    }

    private void writeMappingAtomicType(MappingAtomicType mat) {
        String[] names = mat.names();
        this.buff.writeInt(names.length);
        for (String name : names) {
            this.buff.writeInt(this.addStringCPEntry(name));
        }
        CellSemType[] types = mat.types();
        this.buff.writeInt(types.length);
        for (CellSemType type : types) {
            this.writeSemType((SemType)type);
        }
        this.writeSemType((SemType)mat.rest());
    }

    private void writeListAtomicType(ListAtomicType lat) {
        FixedLengthArray fla = lat.members();
        List initial = fla.initial();
        this.buff.writeInt(initial.size());
        for (SemType type : initial) {
            this.writeSemType(type);
        }
        this.buff.writeInt(fla.fixedLength());
        this.writeSemType((SemType)lat.rest());
    }

    private void writeIntSubtype(IntSubtype intSubtype) {
        Range[] ranges = intSubtype.ranges;
        this.buff.writeInt(ranges.length);
        for (Range range : ranges) {
            this.buff.writeLong(range.min);
            this.buff.writeLong(range.max);
        }
    }

    private void writeFloatSubtype(FloatSubtype floatSubtype) {
        this.buff.writeBoolean(floatSubtype.allowed);
        this.buff.writeInt(floatSubtype.values.length);
        for (EnumerableFloat ef : floatSubtype.values) {
            this.buff.writeDouble(ef.value);
        }
    }

    private void writeDecimalSubtype(DecimalSubtype decimalSubtype) {
        this.buff.writeBoolean(decimalSubtype.allowed);
        this.buff.writeInt(decimalSubtype.values.length);
        for (EnumerableDecimal ed : decimalSubtype.values) {
            BigDecimal bigDecimal = ed.value;
            this.buff.writeInt(bigDecimal.scale());
            byte[] unscaledValueBytes = bigDecimal.unscaledValue().toByteArray();
            this.buff.writeInt(unscaledValueBytes.length);
            this.buff.writeBytes(unscaledValueBytes);
        }
    }

    private void writeStringSubtype(StringSubtype stringSubtype) {
        CharStringSubtype charData = stringSubtype.getChar();
        this.buff.writeBoolean(charData.allowed);
        EnumerableCharString[] charValues = charData.values;
        this.buff.writeInt(charValues.length);
        for (EnumerableCharString ecs : charValues) {
            this.buff.writeInt(this.addStringCPEntry(ecs.value));
        }
        NonCharStringSubtype nonCharData = stringSubtype.getNonChar();
        this.buff.writeBoolean(nonCharData.allowed);
        EnumerableString[] nonCharValues = nonCharData.values;
        this.buff.writeInt(nonCharValues.length);
        for (EnumerableString ecs : nonCharValues) {
            this.buff.writeInt(this.addStringCPEntry(ecs.value));
        }
    }
}

