/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.identifier.Utils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.symbols.SymbolOrigin;
import org.ballerinalang.model.tree.AnnotatableNode;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.ClosureGenerator;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.ConstantValueResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BClassSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.SchedulerPolicy;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangClassDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.Flags;

public class AnnotationDesugar {
    public static final String ANNOTATION_DATA = "$annotation_data";
    private static final String ANNOT_FUNC = "$annot_func$";
    public static final String BUILTIN_PKG_KEY = "ballerina/builtin";
    public static final String LANG_ANNOT_PKG_KEY = "ballerina/lang.annotations";
    public static final String DEFAULTABLE_ANN = "DefaultableArgs";
    public static final String DEFAULTABLE_REC = "ArgsData";
    public static final String ARG_NAMES = "args";
    public static final String SERVICE_INTROSPECTION_INFO_ANN = "IntrospectionDocConfig";
    public static final String SERVICE_INTROSPECTION_INFO_REC = "ServiceIntrospectionDocConfig";
    public static final String SERVICE_NAME = "name";
    private static final String DOT = ".";
    private static final String FIELD = "$field$";
    private static final String PARAM = "$param$";
    private static final String RETURNS = "$returns$";
    public static final String STRAND = "strand";
    public static final String THREAD = "thread";
    public static final String STRAND_DATA = "StrandData";
    private BLangSimpleVariable annotationMap;
    private int annotFuncCount = 0;
    private static final CompilerContext.Key<AnnotationDesugar> ANNOTATION_DESUGAR_KEY = new CompilerContext.Key();
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final Types types;
    private final Names names;
    private final SymbolResolver symResolver;
    private final ConstantValueResolver constantValueResolver;
    private final ClosureGenerator closureGenerator;

    public static AnnotationDesugar getInstance(CompilerContext context) {
        AnnotationDesugar annotationDesugar = context.get(ANNOTATION_DESUGAR_KEY);
        if (annotationDesugar == null) {
            annotationDesugar = new AnnotationDesugar(context);
        }
        return annotationDesugar;
    }

    private AnnotationDesugar(CompilerContext context) {
        context.put(ANNOTATION_DESUGAR_KEY, this);
        this.desugar = Desugar.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.types = Types.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.constantValueResolver = ConstantValueResolver.getInstance(context);
        this.closureGenerator = ClosureGenerator.getInstance(context);
    }

    void initializeAnnotationMap(BLangPackage pkgNode) {
        this.annotationMap = this.createGlobalAnnotationMapVar(pkgNode);
    }

    void rewritePackageAnnotations(BLangPackage pkgNode, SymbolEnv env) {
        BLangFunction initFunction = pkgNode.initFunction;
        this.defineTypeAnnotations(pkgNode, env, initFunction);
        this.defineClassAnnotations(pkgNode, env, initFunction);
        this.defineFunctionAnnotations(pkgNode, env, initFunction);
    }

    private void defineClassAnnotations(BLangPackage pkgNode, SymbolEnv env2, BLangFunction initFunction) {
        List<TopLevelNode> topLevelNodes = pkgNode.topLevelNodes;
        int topLevelNodesSize = topLevelNodes.size();
        for (int i = 0; i < topLevelNodesSize; ++i) {
            SymbolEnv classEnv;
            BLangLambdaFunction lambdaFunction;
            SymbolEnv closureEnv;
            TopLevelNode topLevelNode = topLevelNodes.get(i);
            if (topLevelNode.getKind() != NodeKind.CLASS_DEFN) continue;
            BLangBlockFunctionBody initBody = (BLangBlockFunctionBody)initFunction.body;
            boolean normalMode = true;
            BLangClassDefinition classDef = (BLangClassDefinition)topLevelNode;
            if (this.isServiceDeclaration(classDef)) {
                this.addIntrospectionInfoAnnotation(classDef, env2);
            }
            PackageID pkgID = classDef.symbol.pkgID;
            BSymbol owner = classDef.symbol.owner;
            SymbolEnv env = env2;
            Scope scope = initFunction.symbol.scope;
            Location pos = classDef.pos;
            if (classDef.flagSet.contains((Object)Flag.OBJECT_CTOR) && (closureEnv = classDef.oceEnvData.capturedClosureEnv) != null && closureEnv.enclEnv != null && closureEnv.enclEnv.enclInvokable != null) {
                BLangInvokableNode invokableNode = closureEnv.enclEnv.enclInvokable;
                normalMode = false;
                pos = invokableNode.pos;
                scope = invokableNode.symbol.scope;
                owner = invokableNode.symbol;
                pkgID = invokableNode.symbol.pkgID;
                BLangFunction functionWeCreateOce = (BLangFunction)invokableNode;
                if (functionWeCreateOce.body.getKind() == NodeKind.BLOCK_FUNCTION_BODY) {
                    initBody = (BLangBlockFunctionBody)functionWeCreateOce.body;
                    pos = functionWeCreateOce.body.pos;
                }
            }
            if ((lambdaFunction = this.defineAnnotations(classDef, pkgNode, classEnv = SymbolEnv.createClassEnv(classDef, scope, env), pkgID, owner)) == null) continue;
            BType type = classDef.getBType();
            if (Symbols.isFlagOn(type.getFlags(), 0x100000000L)) {
                if (normalMode) {
                    BLangBlockStmt target = (BLangBlockStmt)TreeBuilder.createBlockNode();
                    target.pos = initBody.pos;
                    this.addLambdaToGlobalAnnotMap(classDef.name.value, lambdaFunction, target);
                    int index = this.calculateIndex(initBody.stmts, type.tsymbol);
                    for (BLangStatement stmt : target.stmts) {
                        initBody.stmts.add(index++, stmt);
                    }
                    continue;
                }
                LocationData locationData = new LocationData(pkgID, owner, pos, initBody);
                this.addAnnotationLambdaToGlobalAnnotationMapWithBlockDef(pkgNode, classDef, locationData, lambdaFunction);
                continue;
            }
            this.addInvocationToGlobalAnnotMap(classDef.name.value, lambdaFunction, initBody);
        }
    }

    private void addAnnotationLambdaToGlobalAnnotationMapWithBlockDef(BLangPackage pkgNode, BLangClassDefinition classDef, LocationData location, BLangLambdaFunction lambdaFunction) {
        BLangBlockStmt target = (BLangBlockStmt)TreeBuilder.createBlockNode();
        PackageID pkgID = location.pkgID;
        Location pos = location.pos;
        BSymbol owner = location.owner;
        BLangBlockFunctionBody initBody = location.body;
        target.pos = pos;
        String lamdaName = "$anon" + classDef.name.value + "_lambda_" + lambdaFunction.function.name.value;
        BVarSymbol symbolVar = new BVarSymbol(0L, Names.fromString(lamdaName), pkgID, lambdaFunction.getBType(), owner, pos, SymbolOrigin.VIRTUAL);
        BLangSimpleVariable funcVar = ASTBuilderUtil.createVariable(pos, lamdaName, lambdaFunction.getBType(), lambdaFunction, symbolVar);
        BLangSimpleVariableDef funcVarDef = ASTBuilderUtil.createVariableDef(funcVar.pos, funcVar);
        funcVarDef.setBType(lambdaFunction.getBType());
        target.stmts.add(funcVarDef);
        BLangSimpleVarRef simpleVarRef = ASTBuilderUtil.createVariableRef(funcVar.pos, funcVar.symbol);
        simpleVarRef.pkgSymbol = pkgNode.symbol;
        funcVarDef.parent = initBody;
        lambdaFunction.parent = initBody;
        lambdaFunction.function.parent = initBody;
        BLangIndexBasedAccess indexAccessNode = (BLangIndexBasedAccess)TreeBuilder.createIndexBasedAccessNode();
        indexAccessNode.pos = pos;
        indexAccessNode.indexExpr = ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, Utils.unescapeJava((String)classDef.name.value));
        indexAccessNode.expr = ASTBuilderUtil.createVariableRef(pos, this.annotationMap.symbol);
        indexAccessNode.setBType(((BMapType)this.annotationMap.getBType()).constraint);
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(pos, target);
        assignmentStmt.expr = simpleVarRef;
        assignmentStmt.varRef = indexAccessNode;
        simpleVarRef.parent = initBody;
        assignmentStmt.parent = initBody;
        int index = this.calculateOCEExprIndex(initBody.stmts, classDef.getBType().tsymbol);
        for (BLangStatement stmt : target.stmts) {
            initBody.stmts.add(index++, stmt);
        }
    }

    private boolean isServiceDeclaration(BLangClassDefinition serviceClass) {
        return serviceClass.getFlags().contains((Object)Flag.SERVICE) && serviceClass.isServiceDecl;
    }

    private void addIntrospectionInfoAnnotation(BLangClassDefinition serviceClass, SymbolEnv env) {
        BLangIdentifier identifierNode;
        Location position = serviceClass.pos;
        BLangAnnotationAttachment annoAttachment = (BLangAnnotationAttachment)TreeBuilder.createAnnotAttachmentNode();
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(serviceClass.symbol.getEnclosingSymbol());
        BSymbol annSymbol = this.symResolver.lookupSymbolInAnnotationSpace(this.symTable.pkgEnvMap.get(this.symTable.rootPkgSymbol), Names.fromString(SERVICE_INTROSPECTION_INFO_ANN));
        annSymbol.origin = SymbolOrigin.BUILTIN;
        if (annSymbol instanceof BAnnotationSymbol) {
            BAnnotationSymbol bAnnotationSymbol;
            annoAttachment.annotationSymbol = bAnnotationSymbol = (BAnnotationSymbol)annSymbol;
        }
        annoAttachment.annotationName = identifierNode = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        annoAttachment.annotationName.value = SERVICE_INTROSPECTION_INFO_ANN;
        annoAttachment.pos = position;
        annoAttachment.annotationName.pos = position;
        BLangRecordLiteral literalNode = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        annoAttachment.expr = literalNode;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setValue(LANG_ANNOT_PKG_KEY);
        annoAttachment.pkgAlias = pkgAlias;
        annoAttachment.attachPoints.add(AttachPoint.Point.SERVICE);
        literalNode.pos = position;
        BSymbol annTypeSymbol = this.symResolver.lookupSymbolInMainSpace(pkgEnv, Names.fromString(SERVICE_INTROSPECTION_INFO_REC));
        BStructureTypeSymbol bStructSymbol = (BStructureTypeSymbol)annTypeSymbol.type.tsymbol;
        literalNode.setBType(bStructSymbol.type);
        literalNode.typeChecked = true;
        BLangRecordLiteral.BLangRecordKeyValueField descriptorKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        literalNode.fields.add(descriptorKeyValue);
        BLangLiteral keyLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        keyLiteral.value = SERVICE_NAME;
        keyLiteral.setBType(this.symTable.stringType);
        keyLiteral.typeChecked = true;
        BLangLiteral valueLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        valueLiteral.setBType(this.symTable.stringType);
        valueLiteral.value = this.generateServiceHashCode(serviceClass);
        valueLiteral.pos = position;
        valueLiteral.typeChecked = true;
        descriptorKeyValue.key = new BLangRecordLiteral.BLangRecordKey(keyLiteral);
        BSymbol fieldSymbol = this.symResolver.resolveStructField(position, pkgEnv, Names.fromString(SERVICE_NAME), bStructSymbol);
        if (fieldSymbol instanceof BVarSymbol) {
            BVarSymbol bVarSymbol;
            descriptorKeyValue.key.fieldSymbol = bVarSymbol = (BVarSymbol)fieldSymbol;
        }
        descriptorKeyValue.valueExpr = valueLiteral;
        this.symResolver.populateAnnotationAttachmentSymbol(annoAttachment, env, this.constantValueResolver);
        serviceClass.addAnnotationAttachment(annoAttachment);
        ((BClassSymbol)serviceClass.symbol).addAnnotation(annoAttachment.annotationAttachmentSymbol);
    }

    private String generateServiceHashCode(BLangClassDefinition serviceClass) {
        String serviceName = "service$" + serviceClass.name.getValue();
        PackageID moduleId = serviceClass.symbol.pkgID;
        LineRange lineRange = serviceClass.pos.lineRange();
        return String.format("%d", Objects.hash(serviceName, moduleId, lineRange));
    }

    private BLangLambdaFunction defineAnnotations(BLangClassDefinition classDef, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        boolean isLocalObjectCtor = classDef.flagSet.contains((Object)Flag.OBJECT_CTOR);
        if (!classDef.annAttachments.isEmpty()) {
            Location annotPos = classDef.annAttachments.get((int)0).pos;
            function = this.defineFunction(annotPos, pkgID, owner);
            mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(annotPos, this.symTable.mapType);
            this.addAnnotsToLiteral(classDef.annAttachments, mapLiteral, annotPos, env, isLocalObjectCtor);
        }
        for (BLangSimpleVariable field : classDef.fields) {
            BLangLambdaFunction paramAnnotLambda = this.defineAnnotations(field.annAttachments, pkgNode, env, pkgID, owner, isLocalObjectCtor);
            if (paramAnnotLambda == null) continue;
            if (function == null) {
                function = this.defineFunction(paramAnnotLambda.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(paramAnnotLambda.pos, this.symTable.mapType);
            }
            String fieldName = "$field$." + field.name.value;
            this.addInvocationToLiteral(mapLiteral, fieldName, ((BLangAnnotationAttachment)field.annAttachments.get((int)0)).pos, paramAnnotLambda);
        }
        if (function != null && !mapLiteral.fields.isEmpty()) {
            return this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
        }
        return null;
    }

    private Map<BAnnotationSymbol, List<BLangAnnotationAttachment>> collectAnnotationAttachments(List<BLangAnnotationAttachment> nodeAttachments, SymbolEnv env) {
        HashMap<BAnnotationSymbol, List<BLangAnnotationAttachment>> attachments = new HashMap<BAnnotationSymbol, List<BLangAnnotationAttachment>>();
        for (AnnotationAttachmentNode annotationAttachmentNode : nodeAttachments) {
            final BLangAnnotationAttachment annotationAttachment = (BLangAnnotationAttachment)annotationAttachmentNode;
            this.desugar.rewrite(annotationAttachment, env);
            BAnnotationSymbol annotationSymbol = annotationAttachment.annotationSymbol;
            if (attachments.containsKey(annotationSymbol)) {
                ((List)attachments.get(annotationSymbol)).add(annotationAttachment);
                continue;
            }
            AttachPoint attachPoint = null;
            for (AttachPoint.Point point : annotationAttachment.attachPoints) {
                Optional<AttachPoint> attachPointOptional = annotationSymbol.points.stream().filter(annotAttachPoint -> annotAttachPoint.point == point).findAny();
                if (!attachPointOptional.isPresent()) continue;
                attachPoint = attachPointOptional.get();
                break;
            }
            if (attachPoint == null || attachPoint.source) continue;
            attachments.put(annotationSymbol, (List<BLangAnnotationAttachment>)new ArrayList<BLangAnnotationAttachment>(){
                {
                    this.add(annotationAttachment);
                }
            });
        }
        return attachments;
    }

    void defineStatementAnnotations(List<BLangAnnotationAttachment> attachments, Location location, PackageID pkgID, BSymbol owner, SymbolEnv env) {
        BLangFunction function = this.defineFunction(location, pkgID, owner);
        BLangRecordLiteral mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
        this.addAnnotsToLiteral(attachments, mapLiteral, location, env, false);
    }

    private void defineTypeAnnotations(BLangPackage pkgNode, SymbolEnv env, BLangFunction initFunction) {
        for (BLangTypeDefinition typeDef : pkgNode.typeDefinitions) {
            if (typeDef.isBuiltinTypeDef) continue;
            PackageID pkgID = typeDef.symbol.pkgID;
            BSymbol owner = typeDef.symbol.owner;
            BLangType typeNode = typeDef.typeNode;
            SymbolEnv typeEnv = SymbolEnv.createTypeEnv(typeNode, initFunction.symbol.scope, env);
            BLangLambdaFunction lambdaFunction = typeNode.getKind() == NodeKind.RECORD_TYPE || typeNode.getKind() == NodeKind.OBJECT_TYPE || typeNode.getKind() == NodeKind.TUPLE_TYPE_NODE ? this.defineAnnotations(typeDef, pkgNode, typeEnv, pkgID, owner) : this.defineAnnotations(this.getAnnotationList(typeDef), pkgNode, env, pkgID, owner, false);
            if (lambdaFunction == null) continue;
            this.addInvocationToGlobalAnnotMap(typeDef.name.value, lambdaFunction, initFunction.body);
        }
    }

    private void defineFunctionAnnotations(BLangPackage pkgNode, SymbolEnv env, BLangFunction initFunction) {
        BLangBlockFunctionBody initFnBody = (BLangBlockFunctionBody)initFunction.body;
        BLangFunction[] functions = pkgNode.functions.toArray(new BLangFunction[pkgNode.functions.size()]);
        Optional<BLangStatement> globalAnnotInitStmt = initFnBody.stmts.stream().filter(statement -> statement.getKind() == NodeKind.ASSIGNMENT && ((BLangAssignment)statement).varRef.getKind() == NodeKind.SIMPLE_VARIABLE_REF).filter(statement -> ((BLangSimpleVarRef)((BLangAssignment)statement).varRef).symbol.name.value.equals(ANNOTATION_DATA)).findFirst();
        for (BLangFunction function : functions) {
            int index;
            String identifier;
            BLangLambdaFunction lambdaFunction;
            PackageID pkgID = function.symbol.pkgID;
            BSymbol owner = function.symbol.owner;
            if (function.symbol.name.getValue().equals("main")) {
                this.addVarArgsAnnotation(function, env);
            }
            if (function.flagSet.contains((Object)Flag.WORKER)) {
                this.attachSchedulerPolicy(function);
            }
            if ((lambdaFunction = this.defineAnnotations(function, pkgNode, env, pkgID, owner)) == null) continue;
            BLangBlockStmt target = (BLangBlockStmt)TreeBuilder.createBlockNode();
            target.pos = initFnBody.pos;
            String string = identifier = function.attachedFunction ? function.symbol.name.value : function.name.value;
            if (function.attachedFunction && Symbols.isFlagOn(function.receiver.getBType().getFlags(), 0x100000000L)) {
                this.addLambdaToGlobalAnnotMap(identifier, lambdaFunction, target);
                globalAnnotInitStmt.ifPresent(statement -> this.updateInitOfAnnotGlobalMapWithEmptyRecordLiteral((BLangStatement)statement, identifier, lambdaFunction));
                index = this.calculateIndex(initFnBody.stmts, function.receiver.getBType().tsymbol);
            } else {
                this.addInvocationToGlobalAnnotMap(identifier, lambdaFunction, target, initFunction.symbol);
                globalAnnotInitStmt.ifPresent(statement -> this.updateInitOfAnnotGlobalMapWithEmptyRecordLiteral((BLangStatement)statement, identifier, lambdaFunction));
                index = initFnBody.stmts.size();
            }
            for (BLangStatement stmt : target.stmts) {
                initFnBody.stmts.add(index++, stmt);
            }
        }
    }

    private void updateInitOfAnnotGlobalMapWithEmptyRecordLiteral(BLangStatement globalAnnotInitStmt, String identifier, BLangLambdaFunction expression) {
        BLangAssignment annotMapInitStmt = (BLangAssignment)globalAnnotInitStmt;
        BLangRecordLiteral mapLiteral = (BLangRecordLiteral)annotMapInitStmt.expr;
        this.addAnnotValueToLiteral(mapLiteral, identifier, ASTBuilderUtil.createEmptyRecordLiteral(expression.pos, this.symTable.mapType), expression.pos);
    }

    private void attachSchedulerPolicy(BLangFunction function) {
        for (BLangAnnotationAttachment annotation : function.annAttachments) {
            if (!annotation.annotationName.value.equals(STRAND) || annotation.expr == null) continue;
            List<RecordLiteralNode.RecordField> fields = ((BLangRecordLiteral)annotation.expr).fields;
            for (RecordLiteralNode.RecordField field : fields) {
                Object value;
                if (field.getKind() != NodeKind.RECORD_LITERAL_KEY_VALUE) continue;
                BLangRecordLiteral.BLangRecordKeyValueField keyValue = (BLangRecordLiteral.BLangRecordKeyValueField)field;
                BLangExpression expr = keyValue.key.expr;
                if (expr.getKind() != NodeKind.SIMPLE_VARIABLE_REF) continue;
                BLangIdentifier variableName = ((BLangSimpleVarRef)expr).variableName;
                if (variableName.value.equals(SERVICE_NAME)) {
                    if (keyValue.valueExpr.getKind() != NodeKind.LITERAL) continue;
                    function.symbol.strandName = ((BLangLiteral)keyValue.valueExpr).value.toString();
                    continue;
                }
                if (!variableName.value.equals(THREAD) || keyValue.valueExpr.getKind() != NodeKind.LITERAL || !"any".equals(value = ((BLangLiteral)keyValue.valueExpr).value)) continue;
                function.symbol.schedulerPolicy = SchedulerPolicy.ANY;
            }
        }
    }

    private List<BLangAnnotationAttachment> getAnnotationList(AnnotatableNode node) {
        return node.getAnnotationAttachments().stream().map(annotAttachment -> (BLangAnnotationAttachment)annotAttachment).toList();
    }

    private BLangLambdaFunction defineAnnotations(List<BLangAnnotationAttachment> annAttachments, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner, boolean isLocalObjectCtor) {
        if (annAttachments.isEmpty()) {
            return null;
        }
        Location pos = annAttachments.get((int)0).pos;
        BLangFunction function = this.defineFunction(pos, pkgID, owner);
        BLangRecordLiteral mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(function, function.symbol.scope, env);
        this.addAnnotsToLiteral(annAttachments, mapLiteral, pos, funcEnv, isLocalObjectCtor);
        if (mapLiteral.fields.isEmpty()) {
            return null;
        }
        return this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
    }

    private BLangLambdaFunction defineAnnotations(BLangTypeDefinition typeDef, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        if (!typeDef.annAttachments.isEmpty()) {
            function = this.defineFunction(typeDef.annAttachments.get((int)0).pos, pkgID, owner);
            mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(typeDef.annAttachments, mapLiteral, typeDef.pos, env, false);
        }
        List<BLangSimpleVariable> fields = typeDef.typeNode.getKind() == NodeKind.TUPLE_TYPE_NODE ? ((BLangTupleTypeNode)typeDef.typeNode).members : ((BLangStructureTypeNode)typeDef.typeNode).fields;
        for (BLangSimpleVariable field : fields) {
            BLangLambdaFunction paramAnnotLambda = this.defineAnnotations(field.annAttachments, pkgNode, env, pkgID, owner, false);
            if (paramAnnotLambda == null) continue;
            if (function == null) {
                function = this.defineFunction(paramAnnotLambda.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            }
            this.addInvocationToLiteral(mapLiteral, "$field$." + field.name.value, ((BLangAnnotationAttachment)field.annAttachments.get((int)0)).pos, paramAnnotLambda);
        }
        if (function == null || mapLiteral.fields.isEmpty()) {
            return null;
        }
        return this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
    }

    public BLangLambdaFunction defineFieldAnnotations(List<BLangSimpleVariable> fields, Location pos, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        BLangLambdaFunction lambdaFunction = null;
        boolean annotFunctionDefined = false;
        for (BLangSimpleVariable field : fields) {
            BLangLambdaFunction fieldAnnotLambda = this.defineAnnotations(field.annAttachments, pkgNode, env, pkgID, owner, false);
            if (fieldAnnotLambda == null) continue;
            BInvokableSymbol invokableSymbol = this.closureGenerator.createSimpleVariable(fieldAnnotLambda.function, fieldAnnotLambda, owner.getKind() == SymbolKind.PACKAGE);
            env.scope.define(invokableSymbol.name, invokableSymbol);
            if (!annotFunctionDefined) {
                function = this.defineFunction(fieldAnnotLambda.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
                annotFunctionDefined = true;
            }
            this.addInvocationToLiteral(mapLiteral, "$field$." + field.name.value, ((BLangAnnotationAttachment)field.annAttachments.get((int)0)).pos, invokableSymbol);
        }
        if (annotFunctionDefined) {
            lambdaFunction = this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
        }
        return lambdaFunction;
    }

    private BLangLambdaFunction defineAnnotations(BLangFunction bLangFunction, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangFunction function = null;
        BLangRecordLiteral mapLiteral = null;
        BLangLambdaFunction lambdaFunction = null;
        boolean annotFunctionDefined = false;
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(bLangFunction, bLangFunction.symbol.scope, env);
        if (!bLangFunction.annAttachments.isEmpty()) {
            function = this.defineFunction(((BLangAnnotationAttachment)bLangFunction.annAttachments.get((int)0)).pos, pkgID, owner);
            mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(bLangFunction.annAttachments, mapLiteral, bLangFunction.pos, funcEnv, false);
            annotFunctionDefined = true;
        }
        for (BLangSimpleVariable param : this.getParams(bLangFunction)) {
            BLangLambdaFunction paramAnnotLambda = this.defineAnnotations(param.annAttachments, pkgNode, funcEnv, pkgID, owner, false);
            if (paramAnnotLambda == null) continue;
            if (!annotFunctionDefined) {
                function = this.defineFunction(paramAnnotLambda.pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
                annotFunctionDefined = true;
            }
            this.addInvocationToLiteral(mapLiteral, "$param$." + param.name.value, ((BLangAnnotationAttachment)param.annAttachments.get((int)0)).pos, paramAnnotLambda);
        }
        if (!bLangFunction.returnTypeAnnAttachments.isEmpty()) {
            if (!annotFunctionDefined) {
                function = this.defineFunction(((BLangAnnotationAttachment)bLangFunction.returnTypeAnnAttachments.get((int)0)).pos, pkgID, owner);
                mapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
                annotFunctionDefined = true;
            }
            BLangFunction retFunction = this.defineFunction(function.pos, pkgID, owner);
            BLangRecordLiteral retMapLiteral = ASTBuilderUtil.createEmptyRecordLiteral(function.pos, this.symTable.mapType);
            this.addAnnotsToLiteral(bLangFunction.returnTypeAnnAttachments, retMapLiteral, bLangFunction.pos, funcEnv, false);
            BLangLambdaFunction returnAnnotLambda = this.addReturnAndDefineLambda(retFunction, retMapLiteral, pkgNode, env, pkgID, owner);
            this.addInvocationToLiteral(mapLiteral, RETURNS, ((BLangAnnotationAttachment)bLangFunction.returnTypeAnnAttachments.get((int)0)).pos, returnAnnotLambda);
        }
        if (annotFunctionDefined) {
            if (mapLiteral.fields.isEmpty()) {
                return null;
            }
            lambdaFunction = this.addReturnAndDefineLambda(function, mapLiteral, pkgNode, env, pkgID, owner);
        }
        return lambdaFunction;
    }

    private void addVarArgsAnnotation(BLangFunction mainFunc, SymbolEnv env) {
        BLangIdentifier identifierNode;
        if (mainFunc.symbol.getParameters().isEmpty() && mainFunc.symbol.restParam == null) {
            return;
        }
        Location pos = mainFunc.pos;
        BLangAnnotationAttachment annoAttachment = (BLangAnnotationAttachment)TreeBuilder.createAnnotAttachmentNode();
        mainFunc.addAnnotationAttachment(annoAttachment);
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(mainFunc.symbol.getEnclosingSymbol());
        BSymbol annSymbol = this.symResolver.lookupSymbolInAnnotationSpace(pkgEnv, Names.fromString(DEFAULTABLE_ANN));
        if (annSymbol instanceof BAnnotationSymbol) {
            BAnnotationSymbol bAnnotationSymbol;
            annoAttachment.annotationSymbol = bAnnotationSymbol = (BAnnotationSymbol)annSymbol;
        }
        annoAttachment.annotationName = identifierNode = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        annoAttachment.annotationName.value = DEFAULTABLE_ANN;
        annoAttachment.pos = pos;
        annoAttachment.annotationName.pos = pos;
        BLangRecordLiteral literalNode = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        annoAttachment.expr = literalNode;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setValue(BUILTIN_PKG_KEY);
        annoAttachment.pkgAlias = pkgAlias;
        annoAttachment.attachPoints.add(AttachPoint.Point.FUNCTION);
        literalNode.pos = pos;
        BSymbol annTypeSymbol = this.symResolver.lookupSymbolInMainSpace(pkgEnv, Names.fromString(DEFAULTABLE_REC));
        BStructureTypeSymbol bStructSymbol = (BStructureTypeSymbol)annTypeSymbol.type.tsymbol;
        literalNode.setBType(annTypeSymbol.type);
        literalNode.typeChecked = true;
        BLangRecordLiteral.BLangRecordKeyValueField descriptorKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        literalNode.fields.add(descriptorKeyValue);
        BLangLiteral keyLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        keyLiteral.value = ARG_NAMES;
        keyLiteral.setBType(this.symTable.stringType);
        keyLiteral.typeChecked = true;
        BLangListConstructorExpr.BLangArrayLiteral valueLiteral = (BLangListConstructorExpr.BLangArrayLiteral)TreeBuilder.createArrayLiteralExpressionNode();
        valueLiteral.setBType(new BArrayType(this.symTable.typeEnv(), this.symTable.stringType));
        valueLiteral.typeChecked = true;
        valueLiteral.pos = pos;
        for (BVarSymbol varSymbol : mainFunc.symbol.getParameters()) {
            BLangLiteral str = (BLangLiteral)TreeBuilder.createLiteralExpression();
            str.value = varSymbol.name.value;
            str.setBType(this.symTable.stringType);
            str.typeChecked = true;
            valueLiteral.exprs.add(str);
        }
        if (mainFunc.symbol.restParam != null) {
            BLangLiteral str = (BLangLiteral)TreeBuilder.createLiteralExpression();
            str.value = mainFunc.symbol.restParam.name.value;
            str.setBType(this.symTable.stringType);
            str.typeChecked = true;
            valueLiteral.exprs.add(str);
        }
        descriptorKeyValue.key = new BLangRecordLiteral.BLangRecordKey(keyLiteral);
        BSymbol fieldSymbol = this.symResolver.resolveStructField(mainFunc.pos, pkgEnv, Names.fromString(ARG_NAMES), bStructSymbol);
        if (fieldSymbol instanceof BVarSymbol) {
            BVarSymbol bVarSymbol;
            descriptorKeyValue.key.fieldSymbol = bVarSymbol = (BVarSymbol)fieldSymbol;
        }
        descriptorKeyValue.valueExpr = valueLiteral;
        this.symResolver.populateAnnotationAttachmentSymbol(annoAttachment, env, this.constantValueResolver);
        mainFunc.symbol.getAnnotations().add(annoAttachment.annotationAttachmentSymbol);
    }

    private BLangFunction defineFunction(Location pos, PackageID pkgID, BSymbol owner) {
        String funcName = "$annot_func$_" + this.annotFuncCount++;
        BLangFunction function = ASTBuilderUtil.createFunction(pos, funcName);
        function.setBType(new BInvokableType(this.symTable.typeEnv(), Collections.emptyList(), this.symTable.mapType, null));
        BLangBuiltInRefTypeNode anyMapType = (BLangBuiltInRefTypeNode)TreeBuilder.createBuiltInReferenceTypeNode();
        anyMapType.typeKind = TypeKind.MAP;
        anyMapType.pos = pos;
        BLangValueType anyType = new BLangValueType();
        anyType.typeKind = TypeKind.ANY;
        BLangConstrainedType constrainedType = (BLangConstrainedType)TreeBuilder.createConstrainedTypeNode();
        constrainedType.type = anyMapType;
        constrainedType.constraint = anyType;
        constrainedType.pos = pos;
        function.returnTypeNode = anyMapType;
        function.returnTypeNode.setBType(this.symTable.mapType);
        function.body = ASTBuilderUtil.createBlockFunctionBody(pos, new ArrayList<BLangStatement>());
        BInvokableSymbol functionSymbol = new BInvokableSymbol(256L, Flags.asMask(function.flagSet), new Name(funcName), pkgID, function.getBType(), owner, function.name.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.bodyExist = true;
        functionSymbol.kind = SymbolKind.FUNCTION;
        functionSymbol.retType = function.returnTypeNode.getBType();
        functionSymbol.scope = new Scope(functionSymbol);
        function.symbol = functionSymbol;
        return function;
    }

    private BLangLambdaFunction addReturnAndDefineLambda(BLangFunction function, BLangRecordLiteral mapLiteral, BLangPackage pkgNode, SymbolEnv env, PackageID pkgID, BSymbol owner) {
        BLangReturn returnStmt = ASTBuilderUtil.createReturnStmt(function.pos, (BLangBlockFunctionBody)function.body);
        returnStmt.expr = mapLiteral;
        BInvokableSymbol lambdaFunctionSymbol = this.createInvokableSymbol(function, pkgID, owner);
        BLangLambdaFunction lambdaFunction = this.desugar.createLambdaFunction(function, lambdaFunctionSymbol, env);
        lambdaFunction.capturedClosureEnv = env;
        pkgNode.functions.add(function);
        pkgNode.topLevelNodes.add(function);
        pkgNode.lambdaFunctions.add(lambdaFunction);
        return lambdaFunction;
    }

    private void addAnnotsToLiteral(List<BLangAnnotationAttachment> nodeAttachments, BLangRecordLiteral mapLiteral, Location pos, SymbolEnv env, boolean isLocalObjectCtor) {
        Map<BAnnotationSymbol, List<BLangAnnotationAttachment>> attachments = this.collectAnnotationAttachments(nodeAttachments, env);
        if (attachments.isEmpty()) {
            return;
        }
        for (BAnnotationSymbol annotationSymbol : attachments.keySet()) {
            BType attachedType = annotationSymbol.attachedType;
            if (attachedType == null || this.types.isAssignable(attachedType, this.symTable.trueType)) {
                this.addTrueAnnot(attachments.get(annotationSymbol).get(0), mapLiteral);
                continue;
            }
            if (Types.getImpliedType((BType)attachedType).tag != 20) {
                this.addSingleAnnot(attachments.get(annotationSymbol).get(0), mapLiteral);
                continue;
            }
            this.addAnnotArray(pos, annotationSymbol.bvmAlias(), attachedType, attachments.get(annotationSymbol), mapLiteral, isLocalObjectCtor);
        }
    }

    private BInvokableSymbol createInvokableSymbol(BLangFunction function, PackageID pkgID, BSymbol owner) {
        BInvokableSymbol functionSymbol = Symbols.createFunctionSymbol(Flags.asMask(function.flagSet), new Name(function.name.value), new Name(function.name.originalValue), pkgID, function.getBType(), owner, true, function.pos, SymbolOrigin.VIRTUAL);
        functionSymbol.retType = function.returnTypeNode.getBType();
        functionSymbol.params = function.requiredParams.stream().map(param -> param.symbol).toList();
        functionSymbol.scope = new Scope(functionSymbol);
        functionSymbol.restParam = function.restParam != null ? function.restParam.symbol : null;
        functionSymbol.type = new BInvokableType(this.symTable.typeEnv(), Collections.emptyList(), function.restParam != null ? function.restParam.getBType() : null, new BMapType(this.symTable.typeEnv(), 16, this.symTable.anyType, null), null);
        function.symbol = functionSymbol;
        return functionSymbol;
    }

    private BLangSimpleVariable createGlobalAnnotationMapVar(BLangPackage pkgNode) {
        BLangSimpleVariable annotationMap = ASTBuilderUtil.createVariable(pkgNode.pos, ANNOTATION_DATA, this.symTable.mapType, ASTBuilderUtil.createEmptyRecordLiteral(pkgNode.pos, this.symTable.mapType), null);
        ASTBuilderUtil.defineVariable(annotationMap, pkgNode.symbol, this.names);
        pkgNode.globalVars.add(0, annotationMap);
        pkgNode.topLevelNodes.add(0, annotationMap);
        return annotationMap;
    }

    private void addTrueAnnot(BLangAnnotationAttachment attachment, BLangRecordLiteral recordLiteral) {
        BLangExpression expression = ASTBuilderUtil.wrapToConversionExpr(this.symTable.trueType, ASTBuilderUtil.createLiteral(attachment.pos, this.symTable.booleanType, Boolean.TRUE), this.symTable, this.types);
        this.addAnnotValueToLiteral(recordLiteral, attachment.annotationSymbol.bvmAlias(), expression, attachment.pos);
    }

    private void addSingleAnnot(BLangAnnotationAttachment attachment, BLangRecordLiteral recordLiteral) {
        this.addAnnotValueToLiteral(recordLiteral, attachment.annotationSymbol.bvmAlias(), attachment.expr, attachment.pos);
    }

    private void addAnnotArray(Location pos, String name, BType annotType, List<BLangAnnotationAttachment> attachments, BLangRecordLiteral recordLiteral, boolean isLocalObjectCtor) {
        BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = ASTBuilderUtil.createEmptyArrayLiteral(pos, (BArrayType)annotType);
        attachments.forEach(attachment -> arrayLiteral.exprs.add(attachment.expr));
        this.addAnnotValueToLiteral(recordLiteral, name, arrayLiteral, pos);
    }

    private void addInvocationToGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BLangBlockStmt target, BSymbol owner) {
        BLangSimpleVariable mapVar = this.createMapDefFromGlobalAnnotMap(identifier, lambdaFunction, owner, target);
        this.createPutAllStmt(lambdaFunction.pos, this.getInvocation(lambdaFunction), target, mapVar);
    }

    private void createPutAllStmt(Location pos, BLangExpression expr, BLangBlockStmt target, BLangSimpleVariable mapVar) {
        BInvokableSymbol putAllFuncSymbol = (BInvokableSymbol)this.symTable.langInternalModuleSymbol.scope.lookup((Name)Names.MAP_PUT_ALL).symbol;
        BLangInvocation putAllInvocation = ASTBuilderUtil.createInvocationExpr(pos, putAllFuncSymbol, new ArrayList<BLangSimpleVariable>(), this.symResolver);
        putAllInvocation.argExprs = new ArrayList<BLangExpression>(List.of(ASTBuilderUtil.createVariableRef(pos, mapVar.symbol), expr));
        putAllInvocation.requiredArgs = putAllInvocation.argExprs;
        BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(pos, target);
        expressionStmt.expr = putAllInvocation;
        expressionStmt.expr.pos = pos;
    }

    private BLangSimpleVariable createMapDefFromGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BSymbol owner, BLangBlockStmt target) {
        BLangSimpleVariableDef stmt = ASTBuilderUtil.createVariableDef(lambdaFunction.pos, ASTBuilderUtil.createVariable(lambdaFunction.pos, "$" + Utils.unescapeJava((String)identifier), this.symTable.mapType));
        ASTBuilderUtil.defineVariable(stmt.var, owner, this.names);
        BLangIndexBasedAccess mapAccessExpr = ASTBuilderUtil.createIndexAccessExpr(ASTBuilderUtil.createVariableRef(lambdaFunction.pos, this.annotationMap.symbol), ASTBuilderUtil.createLiteral(lambdaFunction.pos, this.symTable.stringType, Utils.unescapeJava((String)identifier)));
        mapAccessExpr.setBType(this.symTable.anyType);
        stmt.var.expr = ASTBuilderUtil.generateConversionExpr(mapAccessExpr, this.symTable.mapType, this.symResolver);
        target.stmts.add(stmt);
        return stmt.var;
    }

    private void addInvocationToGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BLangFunctionBody target) {
        this.addAnnotValueAssignmentToMap(this.annotationMap, identifier, (BLangBlockFunctionBody)target, (BLangExpression)this.getInvocation(lambdaFunction));
    }

    private void addLambdaToGlobalAnnotMap(String identifier, BLangLambdaFunction lambdaFunction, BLangBlockStmt target) {
        this.addAnnotValueAssignmentToMap(this.annotationMap, identifier, target, (BLangExpression)ASTBuilderUtil.createVariableRef(lambdaFunction.pos, lambdaFunction.function.symbol));
    }

    private void addInvocationToLiteral(BLangRecordLiteral recordLiteral, String identifier, Location pos, BLangLambdaFunction lambdaFunction) {
        BLangInvocation annotFuncInvocation = this.getInvocation(lambdaFunction);
        recordLiteral.fields.add(ASTBuilderUtil.createBLangRecordKeyValue(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, identifier), annotFuncInvocation));
    }

    private void addLambdaToLiteral(BLangRecordLiteral recordLiteral, String identifier, Location pos, BLangLambdaFunction lambdaFunction) {
        recordLiteral.fields.add(ASTBuilderUtil.createBLangRecordKeyValue(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, identifier), ASTBuilderUtil.createVariableRef(lambdaFunction.pos, lambdaFunction.function.symbol)));
    }

    private void addInvocationToLiteral(BLangRecordLiteral recordLiteral, String identifier, Location pos, BInvokableSymbol invokableSymbol) {
        BLangInvocation annotFuncInvocation = this.getInvocation(invokableSymbol);
        recordLiteral.fields.add(ASTBuilderUtil.createBLangRecordKeyValue(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, identifier), annotFuncInvocation));
    }

    private BLangInvocation getInvocation(BInvokableSymbol symbol) {
        BLangInvocation funcInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        funcInvocation.setBType(symbol.retType);
        funcInvocation.symbol = symbol;
        funcInvocation.name = ASTBuilderUtil.createIdentifier(symbol.pos, symbol.name.value);
        funcInvocation.functionPointerInvocation = true;
        return funcInvocation;
    }

    private void addAnnotValueAssignmentToMap(BLangSimpleVariable mapVar, String identifier, BlockNode target, Location targetPos, BLangExpression expression) {
        BLangAssignment assignmentStmt = ASTBuilderUtil.createAssignmentStmt(targetPos, target);
        assignmentStmt.expr = expression;
        BLangIndexBasedAccess indexAccessNode = (BLangIndexBasedAccess)TreeBuilder.createIndexBasedAccessNode();
        indexAccessNode.pos = targetPos;
        indexAccessNode.indexExpr = ASTBuilderUtil.createLiteral(targetPos, this.symTable.stringType, Utils.unescapeJava((String)identifier));
        indexAccessNode.expr = ASTBuilderUtil.createVariableRef(targetPos, mapVar.symbol);
        indexAccessNode.setBType(((BMapType)mapVar.getBType()).constraint);
        assignmentStmt.varRef = indexAccessNode;
    }

    private void addAnnotValueAssignmentToMap(BLangSimpleVariable mapVar, String identifier, BLangBlockFunctionBody target, BLangExpression expression) {
        this.addAnnotValueAssignmentToMap(mapVar, identifier, target, target.pos, expression);
    }

    private void addAnnotValueAssignmentToMap(BLangSimpleVariable mapVar, String identifier, BLangBlockStmt target, BLangExpression expression) {
        this.addAnnotValueAssignmentToMap(mapVar, identifier, target, target.pos, expression);
    }

    private void addAnnotValueToLiteral(BLangRecordLiteral recordLiteral, String identifier, BLangExpression expression, Location pos) {
        recordLiteral.fields.add(ASTBuilderUtil.createBLangRecordKeyValue(ASTBuilderUtil.createLiteral(pos, this.symTable.stringType, identifier), expression));
    }

    private BLangInvocation getInvocation(BLangLambdaFunction lambdaFunction) {
        BLangInvocation funcInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        funcInvocation.setBType(this.symTable.mapType);
        funcInvocation.expr = null;
        BInvokableSymbol lambdaSymbol = lambdaFunction.function.symbol;
        funcInvocation.symbol = lambdaSymbol;
        funcInvocation.name = ASTBuilderUtil.createIdentifier(lambdaFunction.pos, lambdaSymbol.name.value);
        return funcInvocation;
    }

    private int calculateIndex(List<BLangStatement> statements, BTypeSymbol symbol) {
        return this.calculateOCEExprIndex(statements, symbol);
    }

    private int calculateOCEExprIndex(List<BLangStatement> statements, BTypeSymbol symbol) {
        for (int i = 0; i < statements.size(); ++i) {
            BLangStatement stmt = statements.get(i);
            NodeKind stmtKind = stmt.getKind();
            if (stmtKind == NodeKind.RETURN) {
                return i;
            }
            BLangExpression expr = null;
            if (stmtKind == NodeKind.VARIABLE_DEF) {
                BLangSimpleVariable variable = ((BLangSimpleVariableDef)stmt).var;
                expr = variable.expr;
            } else if (stmtKind == NodeKind.ASSIGNMENT) {
                expr = ((BLangAssignment)stmt).expr;
            }
            if (expr == null || !this.desugar.isMappingOrObjectConstructorOrObjInit(expr) || !this.isMappingOrObjectCtorOrObjInitWithSymbol(expr, symbol)) continue;
            return i;
        }
        return statements.size();
    }

    private boolean isMappingOrObjectCtorOrObjInitWithSymbol(BLangExpression expr, BTypeSymbol symbol) {
        if (expr.getKind() == NodeKind.CHECK_EXPR) {
            return this.isMappingOrObjectCtorOrObjInitWithSymbol(((BLangCheckedExpr)expr).expr, symbol);
        }
        if (expr.getKind() == NodeKind.TYPE_CONVERSION_EXPR) {
            return this.isMappingOrObjectCtorOrObjInitWithSymbol(((BLangTypeConversionExpr)expr).expr, symbol);
        }
        return this.hasTypeSymbol(symbol, expr.getBType());
    }

    private boolean hasTypeSymbol(BTypeSymbol symbol, BType type) {
        BType bType = Types.getImpliedType(type);
        if (bType.tag == 21) {
            for (BType memberType : ((BUnionType)bType).getMemberTypes()) {
                if (!this.hasTypeSymbol(symbol, memberType)) continue;
                return true;
            }
        }
        return bType.tsymbol == symbol;
    }

    private List<BLangSimpleVariable> getParams(BLangFunction function) {
        ArrayList<BLangSimpleVariable> params = new ArrayList<BLangSimpleVariable>(function.getParameters());
        if (function.restParam != null) {
            params.add(function.restParam);
        }
        return params;
    }

    public BLangAnnotationAttachment createStrandAnnotationWithThreadAny(Location position, SymbolEnv env) {
        BLangAnnotationAttachment annotAttachment = (BLangAnnotationAttachment)TreeBuilder.createAnnotAttachmentNode();
        annotAttachment.annotationSymbol = this.symResolver.getStrandAnnotationSymbol();
        annotAttachment.annotationName = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        annotAttachment.annotationName.value = STRAND;
        annotAttachment.pos = position;
        annotAttachment.annotationName.pos = position;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setValue(LANG_ANNOT_PKG_KEY);
        annotAttachment.pkgAlias = pkgAlias;
        annotAttachment.attachPoints.add(AttachPoint.Point.WORKER);
        BLangRecordLiteral strandDataRecord = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        annotAttachment.expr = strandDataRecord;
        strandDataRecord.pos = position;
        SymbolEnv pkgEnv = this.symTable.pkgEnvMap.get(this.symTable.rootPkgSymbol);
        BSymbol annTypeSymbol = this.symResolver.lookupSymbolInMainSpace(pkgEnv, Names.fromString(STRAND_DATA));
        BStructureTypeSymbol bStructSymbol = (BStructureTypeSymbol)annTypeSymbol.type.tsymbol;
        strandDataRecord.setBType(bStructSymbol.type);
        strandDataRecord.typeChecked = true;
        BLangRecordLiteral.BLangRecordKeyValueField threadFieldKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        strandDataRecord.fields.add(threadFieldKeyValue);
        BLangLiteral threadKey = (BLangLiteral)TreeBuilder.createLiteralExpression();
        threadKey.value = THREAD;
        threadKey.setBType(this.symTable.stringType);
        threadKey.typeChecked = true;
        BLangLiteral threadValue = (BLangLiteral)TreeBuilder.createLiteralExpression();
        threadValue.setBType(this.symTable.stringType);
        threadValue.value = "any";
        threadValue.pos = position;
        threadValue.typeChecked = true;
        threadFieldKeyValue.key = new BLangRecordLiteral.BLangRecordKey(threadKey);
        BSymbol fieldSymbol = this.symResolver.resolveStructField(position, pkgEnv, Names.fromString(THREAD), bStructSymbol);
        threadFieldKeyValue.key.fieldSymbol = (BVarSymbol)fieldSymbol;
        threadFieldKeyValue.valueExpr = threadValue;
        this.symResolver.populateAnnotationAttachmentSymbol(annotAttachment, env, this.constantValueResolver);
        return annotAttachment;
    }

    private static class LocationData {
        public PackageID pkgID;
        public BSymbol owner;
        public Location pos;
        public BLangBlockFunctionBody body;

        public LocationData(PackageID pkgID, BSymbol owner, Location pos, BLangBlockFunctionBody body) {
            this.pkgID = pkgID;
            this.owner = owner;
            this.pos = pos;
            this.body = body;
        }

        public String toString() {
            return "LocationData{pkgID=" + String.valueOf(this.pkgID) + ", owner=" + String.valueOf(this.owner) + ", pos=" + String.valueOf(this.pos) + ", body=" + String.valueOf(this.body) + "}";
        }
    }
}

