/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.projects.ProjectKind;
import java.util.ArrayList;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.PackageCache;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;
import org.wso2.ballerinalang.compiler.util.Names;

public class Code2CloudDesugar {
    private static final CompilerContext.Key<Code2CloudDesugar> CODE2CLOUD_DESUGAR_KEY = new CompilerContext.Key();
    private final boolean c2cEnabled;
    private final PackageCache packageCache;
    private PackageID c2cPkgID;

    private Code2CloudDesugar(CompilerContext context) {
        context.put(CODE2CLOUD_DESUGAR_KEY, this);
        String cloudOption = CompilerOptions.getInstance(context).get(CompilerOptionName.CLOUD);
        this.c2cEnabled = "k8s".equals(cloudOption) || "docker".equals(cloudOption) || "choreo".equals(cloudOption);
        this.packageCache = PackageCache.getInstance(context);
        BPackageSymbol symbol = PackageCache.getInstance(context).getSymbol(Names.BALLERINA_ORG.value + Names.ORG_NAME_SEPARATOR.value + Names.CLOUD.value);
        if (symbol != null) {
            this.c2cPkgID = symbol.pkgID;
        }
    }

    public static Code2CloudDesugar getInstance(CompilerContext context) {
        Code2CloudDesugar desugar = context.get(CODE2CLOUD_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new Code2CloudDesugar(context);
        }
        return desugar;
    }

    void addCode2CloudModuleImport(BLangPackage pkgNode) {
        if (this.c2cEnabled && pkgNode.moduleContextDataHolder != null && !pkgNode.moduleContextDataHolder.projectKind().equals((Object)ProjectKind.BALA_PROJECT) && this.c2cPkgID != null) {
            BLangImportPackage importDcl = (BLangImportPackage)TreeBuilder.createImportPackageNode();
            ArrayList<BLangIdentifier> pkgNameComps = new ArrayList<BLangIdentifier>();
            pkgNameComps.add(ASTBuilderUtil.createIdentifier(pkgNode.pos, Names.CLOUD.value));
            importDcl.pkgNameComps = pkgNameComps;
            importDcl.pos = pkgNode.symbol.pos;
            importDcl.orgName = ASTBuilderUtil.createIdentifier(pkgNode.pos, Names.BALLERINA_ORG.value);
            importDcl.alias = ASTBuilderUtil.createIdentifier(pkgNode.pos, "_");
            importDcl.version = ASTBuilderUtil.createIdentifier(pkgNode.pos, "");
            importDcl.symbol = this.packageCache.getSymbol(this.c2cPkgID);
            pkgNode.imports.add(importDcl);
            pkgNode.symbol.imports.add(importDcl.symbol);
        }
    }
}

