/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.DeclarativeAuthDesugar;
import org.wso2.ballerinalang.compiler.desugar.TransactionDesugar;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class ServiceDesugar {
    private static final CompilerContext.Key<ServiceDesugar> SERVICE_DESUGAR_KEY = new CompilerContext.Key();
    private static final String START_METHOD = "start";
    private static final String GRACEFUL_STOP = "gracefulStop";
    private static final String ATTACH_METHOD = "attach";
    private static final String LISTENER = "$LISTENER";
    private static final String ROOT_RESOURCE_PATH = "/";
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final DeclarativeAuthDesugar declarativeAuthDesugar;
    private final TransactionDesugar transactionDesugar;
    private final Types types;

    public static ServiceDesugar getInstance(CompilerContext context) {
        ServiceDesugar desugar = context.get(SERVICE_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new ServiceDesugar(context);
        }
        return desugar;
    }

    private ServiceDesugar(CompilerContext context) {
        context.put(SERVICE_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.declarativeAuthDesugar = DeclarativeAuthDesugar.getInstance(context);
        this.transactionDesugar = TransactionDesugar.getInstance(context);
        this.types = Types.getInstance(context);
    }

    void rewriteListeners(List<BLangVariable> variables, SymbolEnv env, BLangFunction startFunction, BLangFunction stopFunction) {
        for (BLangVariable varNode : variables) {
            if (!Symbols.isFlagOn(varNode.symbol.flags, 524288L)) continue;
            this.rewriteListener(varNode, env, startFunction, stopFunction);
        }
    }

    private void rewriteListener(BLangVariable variable, SymbolEnv env, BLangFunction startFunction, BLangFunction stopFunction) {
        this.rewriteListenerLifeCycleFunction(startFunction, variable, env, START_METHOD);
        this.rewriteListenerLifeCycleFunction(stopFunction, variable, env, GRACEFUL_STOP);
    }

    private void rewriteListenerLifeCycleFunction(BLangFunction lifeCycleFunction, BLangVariable variable, SymbolEnv env, String method) {
        Location pos = variable.pos;
        BTypeSymbol listenerTypeSymbol = Types.getImpliedType((BType)this.getListenerType((BType)variable.getBType())).tsymbol;
        Name functionName = Names.fromString(Symbols.getAttachedFuncSymbolName(listenerTypeSymbol.name.value, method));
        BInvokableSymbol methodInvocationSymbol = (BInvokableSymbol)this.symResolver.lookupMemberSymbol(pos, listenerTypeSymbol.scope, env, functionName, 256L);
        BLangSimpleVarRef varRef = ASTBuilderUtil.createVariableRef(pos, variable.symbol);
        this.addMethodInvocation(pos, varRef, methodInvocationSymbol, Collections.emptyList(), (BLangBlockFunctionBody)lifeCycleFunction.body);
    }

    BLangBlockStmt rewriteServiceVariables(List<BLangService> services, SymbolEnv env) {
        BLangBlockStmt attachmentsBlock = (BLangBlockStmt)TreeBuilder.createBlockNode();
        services.forEach(service -> this.rewriteServiceVariable((BLangService)service, env, attachmentsBlock));
        return attachmentsBlock;
    }

    void rewriteServiceVariable(BLangService service, SymbolEnv env, BLangBlockStmt attachments) {
        Location pos = service.pos;
        ASTBuilderUtil.defineVariable(service.serviceVariable, env.enclPkg.symbol, this.names);
        env.enclPkg.globalVars.add(service.serviceVariable);
        int count = 0;
        for (BLangExpression attachExpr : service.attachedExprs) {
            BLangSimpleVarRef listenerVarRef;
            if (attachExpr.getKind() == NodeKind.SIMPLE_VARIABLE_REF) {
                listenerVarRef = (BLangSimpleVarRef)attachExpr;
            } else {
                BLangSimpleVariable listenerVar = ASTBuilderUtil.createVariable(pos, this.generateServiceListenerVarName(service) + count, attachExpr.getBType(), attachExpr, null);
                ASTBuilderUtil.defineVariable(listenerVar, env.enclPkg.symbol, this.names);
                listenerVar.symbol.flags |= 0x80000L;
                env.enclPkg.globalVars.add(listenerVar);
                listenerVarRef = ASTBuilderUtil.createVariableRef(pos, listenerVar.symbol);
            }
            if (this.types.containsErrorType(listenerVarRef.getBType())) {
                BLangSimpleVarRef checkedRef;
                BLangCheckedExpr listenerCheckExpr = ASTBuilderUtil.createCheckExpr(pos, listenerVarRef, this.getListenerType(listenerVarRef.getBType()));
                listenerCheckExpr.equivalentErrorTypeList.add(this.symTable.errorType);
                BLangSimpleVariable listenerWithoutErrors = ASTBuilderUtil.createVariable(pos, this.generateServiceListenerVarName(service) + "$CheckTemp" + count++, this.getListenerTypeWithoutError(listenerVarRef.getBType()), listenerCheckExpr, null);
                ASTBuilderUtil.defineVariable(listenerWithoutErrors, env.enclPkg.symbol, this.names);
                env.enclPkg.globalVars.add(listenerWithoutErrors);
                listenerVarRef = checkedRef = ASTBuilderUtil.createVariableRef(pos, listenerWithoutErrors.symbol);
            }
            BTypeSymbol listenerTypeSymbol = this.getListenerType((BType)listenerVarRef.getBType()).tsymbol;
            Name functionName = Names.fromString(Symbols.getAttachedFuncSymbolName(listenerTypeSymbol.name.value, ATTACH_METHOD));
            BInvokableSymbol methodRef = (BInvokableSymbol)this.symResolver.lookupMemberSymbol(pos, listenerTypeSymbol.scope, env, functionName, 256L);
            ArrayList<BLangExpression> args = new ArrayList<BLangExpression>();
            args.add(ASTBuilderUtil.createVariableRef(pos, service.serviceVariable.symbol));
            if (service.getServiceNameLiteral() == null) {
                if (service.getAbsolutePath().isEmpty()) {
                    BLangLiteral nilLiteral = ASTBuilderUtil.createLiteral(service.getPosition(), this.symTable.nilType, null);
                    args.add(nilLiteral);
                } else {
                    BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = ASTBuilderUtil.createEmptyArrayLiteral(service.getPosition(), this.symTable.arrayStringType);
                    List<IdentifierNode> pathNodes = service.getAbsolutePath();
                    if (pathNodes.size() != 1 || !pathNodes.get(0).getValue().trim().equals(ROOT_RESOURCE_PATH)) {
                        for (IdentifierNode path : pathNodes) {
                            BLangLiteral literal = ASTBuilderUtil.createLiteral(path.getPosition(), this.symTable.stringType, path.getValue());
                            arrayLiteral.exprs.add(literal);
                        }
                    }
                    args.add(arrayLiteral);
                }
            } else {
                args.add((BLangExpression)((Object)service.getServiceNameLiteral()));
            }
            this.addMethodInvocation(pos, listenerVarRef, methodRef, args, attachments);
        }
    }

    private String generateServiceListenerVarName(BLangService service) {
        return LISTENER + service.name.value + "_";
    }

    private BType getListenerTypeWithoutError(BType type) {
        if (Types.getImpliedType((BType)type).tag == 21) {
            LinkedHashSet<BType> members = new LinkedHashSet<BType>();
            for (BType memberType : ((BUnionType)type).getMemberTypes()) {
                if (this.types.isAssignable(memberType, this.symTable.errorType)) continue;
                members.add(memberType);
            }
            return BUnionType.create(this.symTable.typeEnv(), null, members);
        }
        return type;
    }

    private BType getListenerType(BType type) {
        if (Types.getImpliedType((BType)type).tag == 21) {
            for (BType memberType : ((BUnionType)Types.getImpliedType(type)).getMemberTypes()) {
                if (!this.types.checkListenerCompatibility(memberType)) continue;
                return memberType;
            }
        }
        return type;
    }

    private void addMethodInvocation(Location pos, BLangSimpleVarRef varRef, BInvokableSymbol methodRefSymbol, List<BLangExpression> args, BlockNode body) {
        BLangInvocation methodInvocation = ASTBuilderUtil.createInvocationExprForMethod(pos, methodRefSymbol, args, this.symResolver);
        BType listenerType = this.getListenerType(varRef.getBType());
        if (!this.types.isSameTypeIncludingTags(listenerType, varRef.getBType())) {
            BLangTypeConversionExpr castExpr = (BLangTypeConversionExpr)TreeBuilder.createTypeConversionNode();
            castExpr.expr = varRef;
            castExpr.setBType(listenerType);
            castExpr.targetType = castExpr.getBType();
            methodInvocation.expr = castExpr;
        } else {
            methodInvocation.expr = varRef;
        }
        BLangCheckedExpr checkedExpr = ASTBuilderUtil.createCheckExpr(pos, methodInvocation, this.symTable.nilType);
        checkedExpr.equivalentErrorTypeList.add(this.symTable.errorType);
        BLangExpressionStmt expressionStmt = ASTBuilderUtil.createExpressionStmt(pos, body);
        expressionStmt.expr = checkedExpr;
        expressionStmt.expr.pos = pos;
    }

    void engageCustomServiceDesugar(BLangService service, SymbolEnv env) {
        List<BType> expressionTypes = service.attachedExprs.stream().map(expression -> expression.getBType()).toList();
        service.serviceClass.functions.stream().filter(fun -> Symbols.isResource(fun.symbol) || Symbols.isRemote(fun.symbol)).forEach(func -> this.engageCustomResourceDesugar((BLangFunction)func, env, expressionTypes));
    }

    private void engageCustomResourceDesugar(BLangFunction functionNode, SymbolEnv env, List<BType> expressionTypes) {
        if (Symbols.isFlagOn(functionNode.symbol.flags, 0x2000000L)) {
            BLangExpressionStmt stmt = new BLangExpressionStmt(this.transactionDesugar.createBeginParticipantInvocation(functionNode.pos));
            ((BLangBlockFunctionBody)functionNode.body).stmts.add(0, stmt);
        }
        this.declarativeAuthDesugar.desugarFunction(functionNode, env, expressionTypes);
    }
}

