/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.diagnostic;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticCode;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BLangDiagnostic
extends Diagnostic {
    private final Location location;
    private final String msg;
    private final DiagnosticInfo diagnosticInfo;
    private final DiagnosticCode diagnosticCode;
    private final List<DiagnosticProperty<?>> properties;

    public BLangDiagnostic(Location location, String msg, DiagnosticInfo diagnosticInfo, DiagnosticCode diagnosticCode) {
        this(location, msg, diagnosticInfo, diagnosticCode, Collections.emptyList());
    }

    public BLangDiagnostic(Location location, String msg, DiagnosticInfo diagnosticInfo, DiagnosticCode diagnosticCode, List<DiagnosticProperty<?>> properties) {
        this.location = location;
        this.msg = msg;
        this.diagnosticInfo = diagnosticInfo;
        this.diagnosticCode = diagnosticCode;
        this.properties = properties;
    }

    public Location location() {
        return this.location;
    }

    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    public String message() {
        return this.msg;
    }

    public List<DiagnosticProperty<?>> properties() {
        return this.properties;
    }

    public DiagnosticCode getCode() {
        return this.diagnosticCode;
    }

    public int hashCode() {
        int propHash = Arrays.hashCode(this.properties.toArray());
        if (this.diagnosticCode != null) {
            return Arrays.hashCode(new int[]{this.location.hashCode(), this.msg.hashCode(), this.diagnosticInfo.hashCode(), this.diagnosticCode.hashCode(), propHash});
        }
        return Arrays.hashCode(new int[]{this.location.hashCode(), this.msg.hashCode(), this.diagnosticInfo.hashCode(), propHash});
    }

    public boolean equals(Object obj) {
        if (obj instanceof BLangDiagnostic) {
            BLangDiagnostic that = (BLangDiagnostic)((Object)obj);
            if (this.diagnosticCode != null) {
                return this.location.equals((Object)that.location) && this.msg.equals(that.message()) && this.diagnosticInfo.equals((Object)that.diagnosticInfo) && this.properties.equals(that.properties) && this.diagnosticCode.equals((Object)that.diagnosticCode);
            }
            if (that.diagnosticCode != null) {
                return false;
            }
            return this.location.equals((Object)that.location) && this.msg.equals(that.message()) && this.diagnosticInfo.equals((Object)that.diagnosticInfo) && this.properties.equals(that.properties);
        }
        return false;
    }
}

