/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging;

import java.util.Arrays;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.StringConverter;

public class Patten {
    public static final Part LATEST_VERSION_DIR = new Part();
    public static final Part WILDCARD_SOURCE = new Part();
    public static final Part WILDCARD_SOURCE_WITH_TEST = new Part();
    public static final Patten NULL = new Patten(new Part[0]){

        @Override
        public <T> Stream<T> convert(Converter<T> converter, PackageID packageID) {
            return Stream.of(new Object[0]);
        }
    };
    private static final Converter<String> STRING_CONVERTER = new StringConverter();
    private final Part[] parts;

    public Patten(Part ... parts) {
        this.parts = parts;
    }

    public Patten sibling(Part siblingPart) {
        Part[] newParts;
        Part last = this.parts[this.parts.length - 1];
        if (last == LATEST_VERSION_DIR || last == WILDCARD_SOURCE || last == WILDCARD_SOURCE_WITH_TEST) {
            newParts = Arrays.copyOf(this.parts, this.parts.length);
            newParts[newParts.length - 1] = siblingPart;
        } else {
            newParts = Arrays.copyOf(this.parts, this.parts.length + 1);
            String[] newValues = Arrays.copyOf(last.values, last.values.length - 1);
            newParts[newParts.length - 2] = new Part(newValues);
            newParts[newParts.length - 1] = siblingPart;
        }
        return new Patten(newParts);
    }

    public static Part path(String ... path) {
        return new Part(path);
    }

    public <T> Stream<T> convert(Converter<T> converter, PackageID packageID) {
        Stream<Object> aggregate = Stream.of(converter.start());
        for (Part part : this.parts) {
            if (part == LATEST_VERSION_DIR) {
                aggregate = aggregate.flatMap(t -> converter.getLatestVersion(t, packageID));
                continue;
            }
            if (part == WILDCARD_SOURCE) {
                aggregate = aggregate.flatMap(converter::expandBal);
                continue;
            }
            if (part == WILDCARD_SOURCE_WITH_TEST) {
                aggregate = aggregate.flatMap(converter::expandBalWithTest);
                continue;
            }
            aggregate = aggregate.map(t -> this.callReduceForEach(t, part.values, converter));
        }
        return aggregate;
    }

    public <T> Stream<CompilerInput> convertToSources(Converter<T> converter, PackageID id) {
        return this.convert(converter, id).flatMap(t -> converter.finalize(t, id));
    }

    public String toString() {
        return this.convert(STRING_CONVERTER, null).findFirst().orElse("#");
    }

    private <I> I callReduceForEach(I i, String[] values, Converter<I> converter) {
        I j = i;
        for (String value : values) {
            j = converter.combine(j, value);
        }
        return j;
    }

    public static class Part {
        private final String[] values;

        private Part(String[] path) {
            this.values = path;
        }

        private Part() {
            this.values = new String[0];
        }
    }
}

